/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.type;

import com.mapinfo.midev.type.InvalidDateTimeStringException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTimeFieldType;
import org.joda.time.IllegalFieldValueException;

final class MIDateTimeUtils {
    public static final String ISO_8601_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final Map<Integer, String> DATE_TIME_FORMATS = MIDateTimeUtils.createDateTimeMap();

    private MIDateTimeUtils() {
    }

    public static IllegalArgumentException buildException(IllegalFieldValueException e) {
        String value = e.getIllegalValueAsString();
        String upperBound = e.getUpperBound().toString();
        String lowerBound = e.getLowerBound().toString();
        String commonMessage = null;
        DateTimeFieldType type = e.getDateTimeFieldType();
        commonMessage = DateTimeFieldType.dayOfMonth() == type ? "Day value " + value + " is out of the range [" + lowerBound + "," + upperBound + "]." : (DateTimeFieldType.monthOfYear() == type ? "Month value " + value + " is out of the range [" + lowerBound + "," + upperBound + "]." : (DateTimeFieldType.year() == type ? "Year value " + value + " is out of the range [" + lowerBound + "," + upperBound + "]." : (DateTimeFieldType.hourOfDay() == type ? "Hour value " + value + " is out of the range [" + lowerBound + "," + upperBound + "]." : (DateTimeFieldType.minuteOfHour() == type ? "Minute value " + value + " is out of the range [" + lowerBound + "," + upperBound + "]." : (DateTimeFieldType.secondOfMinute() == type ? "Second value " + value + " is out of the range [" + lowerBound + "," + upperBound + "]." : "Unknown error.")))));
        return new IllegalArgumentException(commonMessage);
    }

    public static Date parseISO8601FormattedString(String dateTimeString) {
        if (dateTimeString == null) {
            throw new IllegalArgumentException("DateTimeString cannot be null");
        }
        String format = DATE_TIME_FORMATS.get(dateTimeString.length());
        dateTimeString = dateTimeString.trim();
        if (format == null) {
            throw new InvalidDateTimeStringException("Unexpected pattern (" + dateTimeString + ") found when parsing Date string");
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            return dateFormat.parse(dateTimeString);
        }
        catch (ParseException ex) {
            throw new InvalidDateTimeStringException("Parse exception when trying to parse Date string (" + dateTimeString + ")");
        }
    }

    private static void add(Map<Integer, String> dateFormatMap, int addition, String strFormat) {
        dateFormatMap.put(strFormat.length() + addition, strFormat);
    }

    private static Map<Integer, String> createDateTimeMap() {
        HashMap<Integer, String> dateFormatMap = new HashMap<Integer, String>(13);
        MIDateTimeUtils.add(dateFormatMap, -2, "yyyy-MM-dd'T'HH:mm");
        MIDateTimeUtils.add(dateFormatMap, -2, "yyyy-MM-dd'T'HH:mm:ss");
        MIDateTimeUtils.add(dateFormatMap, -2, ISO_8601_DATE_TIME_FORMAT);
        MIDateTimeUtils.add(dateFormatMap, -4, "yyyy-MM-dd'T'HH:mm:ss'Z'");
        MIDateTimeUtils.add(dateFormatMap, -4, "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        return Collections.unmodifiableMap(dateFormatMap);
    }
}

