/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.type;

import com.mapinfo.midev.type.MIDate;
import com.mapinfo.midev.type.MIDateTime;
import com.mapinfo.midev.type.MIDateTimeUtils;
import com.mapinfo.midev.type.MITime;
import com.mapinfo.midev.util.PrivateAPI;
import com.mapinfo.midev.util.PublicAPI;
import java.io.Serializable;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

@PublicAPI
public final class MIDateTimeZone
implements Comparable<MIDateTimeZone>,
Serializable {
    private final LocalDateTime m_date;
    private final TimeZone m_timeZone;

    public MIDateTimeZone(int year, int month, int day, int hour, int minute, double seconds, TimeZone timezone) {
        int wholeSeconds = (int)Math.floor(seconds);
        int milliSeconds = (int)Math.round((seconds - (double)wholeSeconds) * 1000.0);
        try {
            this.m_date = new DateTime(year, month, day, hour, minute, wholeSeconds, milliSeconds, DateTimeZone.forTimeZone((TimeZone)timezone)).toLocalDateTime();
            this.m_timeZone = timezone;
        }
        catch (IllegalFieldValueException e) {
            throw MIDateTimeUtils.buildException(e);
        }
    }

    public MIDateTimeZone(MIDateTime date, TimeZone timezone) {
        this(date.getYear(), date.getMonth(), date.getDay(), date.getHour(), date.getMinute(), date.getSeconds(), timezone);
    }

    public MIDateTimeZone(MIDate date, MITime time, TimeZone timezone) {
        this(date.getYear(), date.getMonth(), date.getDay(), time.getHour(), time.getMinute(), time.getSeconds(), timezone);
    }

    public MIDateTimeZone(long milliSeconds, TimeZone timezone) {
        this.m_date = new DateTime(milliSeconds, DateTimeZone.forTimeZone((TimeZone)timezone)).toLocalDateTime();
        this.m_timeZone = timezone;
    }

    public long getTimeInMilliSeconds() {
        return DateTimeUtils.getInstantMillis((ReadableInstant)this.m_date.toDateTime(DateTimeZone.forTimeZone((TimeZone)this.m_timeZone)));
    }

    public int getYear() {
        return this.m_date.getYear();
    }

    public int getMonth() {
        return this.m_date.getMonthOfYear();
    }

    public int getDay() {
        return this.m_date.getDayOfMonth();
    }

    public int getHour() {
        return this.m_date.getHourOfDay();
    }

    public int getMinute() {
        return this.m_date.getMinuteOfHour();
    }

    public double getSeconds() {
        return (double)this.m_date.getSecondOfMinute() + (double)this.m_date.getMillisOfSecond() / 1000.0;
    }

    public TimeZone getTimeZone() {
        return this.m_timeZone;
    }

    @Override
    public int compareTo(MIDateTimeZone dateTime) {
        return this.m_date.toDateTime(DateTimeZone.forTimeZone((TimeZone)this.m_timeZone)).compareTo((ReadableInstant)dateTime.m_date.toDateTime(DateTimeZone.forTimeZone((TimeZone)dateTime.m_timeZone)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MIDateTimeZone that = (MIDateTimeZone)o;
        if (this.m_date != null ? !this.m_date.equals((Object)that.m_date) : that.m_date != null) {
            return false;
        }
        return !(this.m_timeZone != null ? this.m_timeZone.getRawOffset() != that.m_timeZone.getRawOffset() : that.m_timeZone != null);
    }

    public int hashCode() {
        int result = this.m_date != null ? this.m_date.hashCode() : 0;
        result = 31 * result + (this.m_timeZone != null ? this.m_timeZone.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMonth()).append('/');
        sb.append(this.getDay()).append('/');
        sb.append(this.getYear()).append(' ');
        sb.append(this.getHour()).append(':');
        sb.append(this.getMinute()).append(':');
        sb.append(this.getSeconds());
        sb.append(' ').append(this.m_timeZone.getDisplayName());
        return sb.toString();
    }

    @PrivateAPI
    public String toISO8601FormattedString() {
        long tms = this.getTimeInMilliSeconds();
        return ISODateTimeFormat.dateTime().withZone(DateTimeZone.forTimeZone((TimeZone)this.m_timeZone)).print(tms);
    }

    @PrivateAPI
    public static MIDateTimeZone fromISO8601FormattedString(String isoDateTimeZone) {
        DateTime dataTime = ISODateTimeFormat.dateTimeParser().withOffsetParsed().parseDateTime(isoDateTimeZone);
        return new MIDateTimeZone(dataTime.getMillis(), dataTime.getZone().toTimeZone());
    }
}

