/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.type;

import com.mapinfo.midev.type.MIDateTimeUtils;
import com.mapinfo.midev.util.PrivateAPI;
import com.mapinfo.midev.util.PublicAPI;
import java.io.Serializable;
import java.util.Date;
import org.joda.time.Chronology;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.ISODateTimeFormat;

@PublicAPI
public class MITime
implements Comparable<MITime>,
Serializable {
    private final LocalTime m_time;

    public MITime(int hour, int minute, double seconds) {
        int wholeSeconds = (int)Math.floor(seconds);
        int milliSeconds = (int)Math.round((seconds - (double)wholeSeconds) * 1000.0);
        try {
            this.m_time = new LocalTime(hour, minute, wholeSeconds, milliSeconds, (Chronology)ISOChronology.getInstanceUTC());
        }
        catch (IllegalFieldValueException e) {
            throw MIDateTimeUtils.buildException(e);
        }
    }

    public MITime(long milliSeconds) {
        this.m_time = new LocalTime(milliSeconds, (Chronology)ISOChronology.getInstanceUTC());
    }

    public MITime(Date time) {
        this.m_time = LocalTime.fromDateFields((Date)time);
    }

    public int getHour() {
        return this.m_time.getHourOfDay();
    }

    public int getMinute() {
        return this.m_time.getMinuteOfHour();
    }

    public long getTimeInMilliSeconds() {
        return this.m_time.getMillisOfDay();
    }

    public double getSeconds() {
        return (double)this.m_time.getSecondOfMinute() + (double)this.m_time.getMillisOfSecond() / 1000.0;
    }

    @Override
    public int compareTo(MITime time) {
        return this.m_time.compareTo((ReadablePartial)time.m_time);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MITime miTime = (MITime)o;
        return this.m_time.equals((Object)miTime.m_time);
    }

    public int hashCode() {
        return this.m_time.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHour()).append(':');
        sb.append(this.getMinute()).append(':');
        sb.append(this.getSeconds());
        return sb.toString();
    }

    @PrivateAPI
    public String toString(String pattern) {
        if (pattern == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern((String)pattern).print((ReadablePartial)this.m_time);
    }

    @PrivateAPI
    public String toISO8601FormattedString() {
        return ISODateTimeFormat.time().print((ReadablePartial)this.m_time);
    }

    @PrivateAPI
    public static MITime fromISO8601FormattedString(String timeString) {
        LocalTime time = ISODateTimeFormat.timeParser().parseLocalTime(timeString);
        return new MITime(time.getHourOfDay(), time.getMinuteOfHour(), (double)time.getSecondOfMinute() + (double)time.getMillisOfSecond() / 1000.0);
    }
}

