/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.util;

import java.util.Collection;
import java.util.Map;

public final class ArgumentValidator {
    private ArgumentValidator() {
    }

    public static void assertNotEmpty(String variableName, Collection variableValue) {
        ArgumentValidator.assertNotNullReference(variableName, variableValue);
        if (variableValue.isEmpty()) {
            throw new IllegalArgumentException(variableName + " cannot be empty.");
        }
    }

    public static void assertNotEmpty(String variableName, Map variableValue) {
        ArgumentValidator.assertNotNullReference(variableName, variableValue);
        if (variableValue.isEmpty()) {
            throw new IllegalArgumentException(variableName + " cannot be empty.");
        }
    }

    public static void assertNotEmptyIterable(String variableName, Iterable<?> variable) {
        ArgumentValidator.assertNotNullReference(variableName, variable);
        if (!variable.iterator().hasNext()) {
            throw new IllegalArgumentException(variableName + " cannot be empty.");
        }
    }

    public static void assertNotEmpty(String variableName, Object ... variable) {
        ArgumentValidator.assertNotNullReference(variableName, variable);
        if (variable.length == 0) {
            throw new IllegalArgumentException(variableName + " cannot be empty.");
        }
    }

    public static void assertNotEmptyString(String variableName, String variableValue) {
        ArgumentValidator.assertNotNullReference(variableName, variableValue);
        if (variableValue.length() == 0) {
            throw new IllegalArgumentException(variableName + " can not be an empty string.");
        }
    }

    public static void assertNotNullReference(String variableName, Object variableObject) {
        if (variableObject == null) {
            throw new IllegalArgumentException("Specified parameter cannot be null: " + variableName + ".");
        }
    }

    public static void assertExpectedType(String variableName, Object variableObject, Class<?> expectedType) {
        ArgumentValidator.assertNotNullReference(variableName, variableObject);
        Class<?> variableClass = variableObject.getClass();
        if (!expectedType.isAssignableFrom(variableClass)) {
            throw new IllegalArgumentException(variableName + " is of an invalid type. It must be of type " + expectedType.toString() + ".");
        }
    }

    public static void assertNotOutOfRangeMinimum(String variableName, double variableValue, double minimum) {
        if (variableValue < minimum) {
            throw new IllegalArgumentException(variableName + " must be greater than or equal to " + minimum + ", but was " + variableValue);
        }
    }

    public static void assertNotOutOfRangeStrictMinimum(String variableName, double variableValue, double minimum) {
        if (variableValue <= minimum) {
            throw new IllegalArgumentException(variableName + " must be greater than " + minimum + ", but was " + variableValue);
        }
    }

    public static void assertNotOutOfRangeMaximum(String variableName, double variableValue, double maximum) {
        if (variableValue > maximum) {
            throw new IllegalArgumentException(variableName + " must be less than or equal to " + maximum + ", but was " + variableValue);
        }
    }

    public static void assertNotOutOfRangeStrictMaximum(String variableName, double variableValue, double maximum) {
        if (variableValue >= maximum) {
            throw new IllegalArgumentException(variableName + " must be less than " + maximum + ", but was " + variableValue);
        }
    }

    public static void assertNotOutOfRange(String variableName, double variableValue, double minimum, double maximum) {
        if (variableValue < minimum || variableValue > maximum) {
            throw new IllegalArgumentException(variableName + " must be in range [" + minimum + ", " + maximum + "]");
        }
    }

    public static void assertNotOutOfRangeStrict(String variableName, double variableValue, double minimum, double maximum) {
        if (variableValue <= minimum || variableValue >= maximum) {
            throw new IllegalArgumentException(variableName + " must be in range (" + minimum + ", " + maximum + ")");
        }
    }

    public static void assertCollectionNullValues(String variableName, Collection variableValue) {
        ArgumentValidator.assertNotNullReference(variableName, variableValue);
        if (variableValue.contains(null)) {
            throw new IllegalArgumentException(variableName + " cannot be null or empty.");
        }
    }
}

