/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.xml;

import com.mapinfo.midev.util.ArgumentValidator;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public final class MapInfoNamespaceContext
implements NamespaceContext {
    private final Map<String, String> m_mappings;

    public MapInfoNamespaceContext(String prefix, String namespace) {
        this(Collections.singletonMap(prefix, namespace));
    }

    public MapInfoNamespaceContext(Map<String, String> mappings) {
        ArgumentValidator.assertNotNullReference("mappings", mappings);
        this.m_mappings = mappings;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new NullPointerException("Null prefix");
        }
        String namespace = this.m_mappings.get(prefix);
        if (namespace != null) {
            return namespace;
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        return "";
    }

    @Override
    public String getPrefix(String namespaceURI) {
        throw new UnsupportedOperationException();
    }

    public Iterator getPrefixes(String namespaceURI) {
        throw new UnsupportedOperationException();
    }
}

