/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.xml.read;

import com.mapinfo.midev.util.ArgumentValidator;

public class Attribute {
    private final String m_localName;
    private final String m_namespaceURI;
    private final String m_namespacePrefix;
    private final String m_value;

    public Attribute(String localName, String namespaceURI, String namespacePrefix, String value) {
        this.m_localName = localName != null && localName.length() == 0 ? null : localName;
        this.m_namespaceURI = namespaceURI == null ? "" : namespaceURI;
        this.m_namespacePrefix = "".equals(namespacePrefix) ? null : namespacePrefix;
        this.m_value = value == null ? "" : value;
        ArgumentValidator.assertNotNullReference("localName", localName);
        if (this.m_namespaceURI.length() == 0 && this.m_namespacePrefix != null) {
            throw new IllegalArgumentException("Prefix is not allowed if namespace URI is not specified.");
        }
    }

    public String getLocalName() {
        return this.m_localName;
    }

    public String getNamespaceURI() {
        return this.m_namespaceURI;
    }

    public String getPrefix() {
        return this.m_namespacePrefix;
    }

    public String getValue() {
        return this.m_value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        if (this.m_localName != null ? !this.m_localName.equals(attribute.m_localName) : attribute.m_localName != null) {
            return false;
        }
        if (this.m_namespacePrefix != null ? !this.m_namespacePrefix.equals(attribute.m_namespacePrefix) : attribute.m_namespacePrefix != null) {
            return false;
        }
        if (this.m_namespaceURI != null ? !this.m_namespaceURI.equals(attribute.m_namespaceURI) : attribute.m_namespaceURI != null) {
            return false;
        }
        return !(this.m_value != null ? !this.m_value.equals(attribute.m_value) : attribute.m_value != null);
    }

    public int hashCode() {
        int result = 17;
        result = 29 * result + (this.m_localName != null ? this.m_localName.hashCode() : 0);
        result = 29 * result + (this.m_namespaceURI != null ? this.m_namespaceURI.hashCode() : 0);
        result = 29 * result + (this.m_namespacePrefix != null ? this.m_namespacePrefix.hashCode() : 0);
        result = 29 * result + (this.m_value != null ? this.m_value.hashCode() : 0);
        return result;
    }
}

