/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.io;

import java.io.EOFException;

public final class LEByteBuffer {
    private static final String BOOL_EOF = "Not enough bytes left in the buffer to read a boolean.";
    private static final String BYTE_EOF = "Not enough bytes left in the buffer to read a byte.";
    private static final String SHORT_EOF = "Not enough bytes left in the buffer to read a short.";
    private static final String CHAR_EOF = "Not enough bytes left in the buffer to read a char.";
    private static final String INT_EOF = "Not enough bytes left in the buffer to read an int/float.";
    private static final String LONG_EOF = "Not enough bytes left in the buffer to read a long/double.";
    private static final String SKIP_EOF = "Not enough bytes left to skip the specified number of bytes.";
    private byte[] m_buf;
    private int m_size;
    private int m_pos;

    public LEByteBuffer() {
    }

    public LEByteBuffer(byte[] byArray) {
        this.setBuffer(byArray);
    }

    public final boolean readBoolean() throws EOFException {
        if (this.m_pos + 1 > this.m_size) {
            throw new EOFException(BOOL_EOF);
        }
        return this.m_buf[this.m_pos++] != 0;
    }

    public final byte readByte() throws EOFException {
        if (this.m_pos + 1 > this.m_size) {
            throw new EOFException(BYTE_EOF);
        }
        return this.m_buf[this.m_pos++];
    }

    public final int readUnsignedByte() throws EOFException {
        if (this.m_pos + 1 > this.m_size) {
            throw new EOFException(BYTE_EOF);
        }
        return this.m_buf[this.m_pos++];
    }

    public final char readChar() throws EOFException {
        if (this.m_pos + 2 > this.m_size) {
            throw new EOFException(CHAR_EOF);
        }
        int n = this.m_pos;
        this.m_pos += 2;
        return (char)(this.m_buf[n] & 0xFF | (this.m_buf[++n] & 0xFF) << 8);
    }

    public final short readShort() throws EOFException {
        if (this.m_pos + 2 > this.m_size) {
            throw new EOFException(SHORT_EOF);
        }
        int n = this.m_pos;
        this.m_pos += 2;
        return (short)(this.m_buf[n] & 0xFF | (this.m_buf[++n] & 0xFF) << 8);
    }

    public final int readUnsignedShort() throws EOFException {
        if (this.m_pos + 2 > this.m_size) {
            throw new EOFException(SHORT_EOF);
        }
        int n = this.m_pos;
        this.m_pos += 2;
        return this.m_buf[n] & 0xFF | (this.m_buf[++n] & 0xFF) << 8;
    }

    public final int readInt() throws EOFException {
        if (this.m_pos + 4 > this.m_size) {
            throw new EOFException(INT_EOF);
        }
        int n = this.m_pos;
        this.m_pos += 4;
        return this.m_buf[n] & 0xFF | (this.m_buf[++n] & 0xFF) << 8 | (this.m_buf[++n] & 0xFF) << 16 | (this.m_buf[++n] & 0xFF) << 24;
    }

    public final long readLong() throws EOFException {
        if (this.m_pos + 8 > this.m_size) {
            throw new EOFException(LONG_EOF);
        }
        int n = this.m_pos;
        this.m_pos += 8;
        return (long)(this.m_buf[n] & 0xFF) | (long)(this.m_buf[++n] & 0xFF) << 8 | (long)(this.m_buf[++n] & 0xFF) << 16 | (long)(this.m_buf[++n] & 0xFF) << 24 | (long)(this.m_buf[++n] & 0xFF) << 32 | (long)(this.m_buf[++n] & 0xFF) << 40 | (long)(this.m_buf[++n] & 0xFF) << 48 | (long)this.m_buf[++n] << 56;
    }

    public final float readFloat() throws EOFException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws EOFException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final void skipBytes(int n) throws EOFException {
        if (this.m_pos + n > this.m_size) {
            throw new EOFException(SKIP_EOF);
        }
        this.m_pos += n;
    }

    public final void reset() {
        this.m_pos = 0;
    }

    public final void setBuffer(byte[] byArray) {
        this.m_buf = byArray;
        this.m_size = byArray.length;
        this.reset();
    }

    static {
        BOOL_EOF = BOOL_EOF;
        BYTE_EOF = BYTE_EOF;
        SHORT_EOF = SHORT_EOF;
        CHAR_EOF = CHAR_EOF;
        INT_EOF = INT_EOF;
        LONG_EOF = LONG_EOF;
        SKIP_EOF = SKIP_EOF;
    }
}

