/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.io;

import java.io.DataOutput;
import java.io.IOException;

public class LittleEndianDataOutput
implements DataOutput {
    protected DataOutput a;

    public LittleEndianDataOutput(DataOutput dataOutput) {
        this.a = dataOutput;
    }

    public void write(int n) throws IOException {
        this.a.write(n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.a.write(byArray, n, n2);
    }

    public void write(byte[] byArray) throws IOException {
        this.a.write(byArray);
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.a.write(bl ? 1 : 0);
    }

    public final void writeByte(int n) throws IOException {
        this.a.write(n);
    }

    public final void writeShort(int n) throws IOException {
        this.a.write(n >>> 0 & 0xFF);
        this.a.write(n >>> 8 & 0xFF);
    }

    public final void writeChar(int n) throws IOException {
        this.a.write(n >>> 0 & 0xFF);
        this.a.write(n >>> 8 & 0xFF);
    }

    public final void writeInt(int n) throws IOException {
        this.a.write(n >>> 0 & 0xFF);
        this.a.write(n >>> 8 & 0xFF);
        this.a.write(n >>> 16 & 0xFF);
        this.a.write(n >>> 24 & 0xFF);
    }

    public final void writeLong(long l) throws IOException {
        this.a.write((int)(l >>> 0) & 0xFF);
        this.a.write((int)(l >>> 8) & 0xFF);
        this.a.write((int)(l >>> 16) & 0xFF);
        this.a.write((int)(l >>> 24) & 0xFF);
        this.a.write((int)(l >>> 32) & 0xFF);
        this.a.write((int)(l >>> 40) & 0xFF);
        this.a.write((int)(l >>> 48) & 0xFF);
        this.a.write((int)(l >>> 56) & 0xFF);
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeBytes(String string) throws IOException {
        this.a.writeBytes(string);
    }

    public final void writeChars(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            this.a.write(c >>> 0 & 0xFF);
            this.a.write(c >>> 8 & 0xFF);
            ++n2;
        }
    }

    public final void writeUTF(String string) throws IOException {
        this.a.writeUTF(string);
    }
}

