/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.util;

import java.io.Serializable;

public class ComplexNumber
implements Serializable {
    protected double a;
    protected double b;

    public ComplexNumber(double d, double d2) {
        this.a = d;
        this.b = d2;
    }

    public ComplexNumber() {
        this(0.0, 0.0);
    }

    public void set(double d, double d2) {
        this.a = d;
        this.b = d2;
    }

    public void set(ComplexNumber complexNumber) {
        this.a = complexNumber.a;
        this.b = complexNumber.b;
    }

    public boolean equals(ComplexNumber complexNumber) {
        return this.a == complexNumber.a && this.b == complexNumber.b;
    }

    public Object clone() {
        return new ComplexNumber(this.a, this.b);
    }

    public double getReal() {
        return this.a;
    }

    public double getImaginary() {
        return this.b;
    }

    public boolean isReal() {
        return this.b == 0.0;
    }

    public ComplexNumber add(double d) {
        this.a += d;
        return this;
    }

    public ComplexNumber add(ComplexNumber complexNumber) {
        this.a += complexNumber.a;
        this.b += complexNumber.b;
        return this;
    }

    public ComplexNumber mult(double d) {
        this.a *= d;
        this.b *= d;
        return this;
    }

    public ComplexNumber mult(ComplexNumber complexNumber) {
        double d = this.a;
        this.a = this.a * complexNumber.a - this.b * complexNumber.b;
        this.b = d * complexNumber.b + this.b * complexNumber.a;
        return this;
    }

    public ComplexNumber div(ComplexNumber complexNumber) {
        double d = this.a;
        if (Math.abs(complexNumber.b) < Math.abs(complexNumber.a)) {
            double d2 = complexNumber.b / complexNumber.a;
            double d3 = complexNumber.a + complexNumber.b * d2;
            this.a = (this.a + this.b * d2) / d3;
            this.b = (this.b - d * d2) / d3;
        } else {
            double d4 = complexNumber.a / complexNumber.b;
            double d5 = complexNumber.b + complexNumber.a * d4;
            this.a = (this.a * d4 + this.b) / d5;
            this.b = (this.b * d4 - d) / d5;
        }
        return this;
    }

    public double norm() {
        return Math.sqrt(this.a * this.a + this.b * this.b);
    }
}

