/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.util;

import com.mapinfo.util.DoublePoint;
import com.mapinfo.util.DoubleRect;
import com.mapinfo.util.MathUtil;
import com.mapinfo.util.PrioritizeDouble;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class GeometryUtilities {
    public static final DoubleRect getBounds(DoublePoint doublePoint, double d, double d2) {
        return new DoubleRect(doublePoint.x - d, doublePoint.y - d2, doublePoint.x + d, doublePoint.y + d2);
    }

    public static final DoubleRect getBounds(DoublePoint doublePoint, double d, double d2, double d3, double d4) {
        while (d < 0.0) {
            d += 360.0;
        }
        d %= 360.0;
        while (d2 < 0.0) {
            d2 += 360.0;
        }
        double d5 = MathUtil.degreesToRadians(d);
        double d6 = MathUtil.degreesToRadians(d2 %= 360.0);
        boolean[] blArray = new boolean[]{d >= d2 && (d < 90.0 || d2 > 0.0) || d < 90.0 && d2 > 0.0, d >= d2 && (d < 180.0 || d2 > 90.0) || d < 180.0 && d2 > 90.0, d >= d2 && (d < 270.0 || d2 > 180.0) || d < 270.0 && d2 > 180.0, d >= d2 && d2 >= 0.0 || d < 360.0 && d2 > 270.0};
        double d7 = blArray[3] && blArray[0] ? doublePoint.x + d3 : Math.max(doublePoint.x + d3 * Math.cos(d5), doublePoint.x + d3 * Math.cos(d6));
        double d8 = blArray[2] && blArray[3] ? doublePoint.y - d4 : Math.min(doublePoint.y + d4 * Math.sin(d5), doublePoint.y + d4 * Math.sin(d6));
        double d9 = blArray[1] && blArray[2] ? doublePoint.x - d3 : Math.min(doublePoint.x + d3 * Math.cos(d5), doublePoint.x + d3 * Math.cos(d6));
        double d10 = blArray[0] && blArray[1] ? doublePoint.y + d4 : Math.max(doublePoint.y + d4 * Math.sin(d5), doublePoint.y + d4 * Math.sin(d6));
        return new DoubleRect(d9, d8, d7, d10);
    }

    public static final DoublePoint calculateCentroid(DoubleRect doubleRect, double[][] dArray) {
        Object object;
        DoublePoint doublePoint = doubleRect.center();
        TreeMap<PrioritizeDouble, DoublePoint> treeMap = new TreeMap<PrioritizeDouble, DoublePoint>();
        TreeMap<PrioritizeDouble, DoublePoint> treeMap2 = new TreeMap<PrioritizeDouble, DoublePoint>();
        int n = 0;
        int n2 = 0;
        while (n2 < dArray.length) {
            object = dArray[n2];
            Object object2 = object[0];
            Object object3 = object[1];
            int n3 = 2;
            while (n3 < ((Object)object).length) {
                DoublePoint doublePoint2;
                Object object4 = object[n3];
                Object object5 = object[n3 + 1];
                if (object2 <= doublePoint.x && doublePoint.x <= object4 || object4 <= doublePoint.x && doublePoint.x <= object2) {
                    doublePoint2 = new DoublePoint(doublePoint.x, GeometryUtilities.findYValueOnLine(object2, (double)object3, (double)object4, (double)object5, doublePoint.x));
                    treeMap2.put(new PrioritizeDouble(++n, doublePoint2.y), doublePoint2);
                }
                if (object3 <= doublePoint.y && doublePoint.y <= object5 || object5 <= doublePoint.y && doublePoint.y <= object3) {
                    doublePoint2 = new DoublePoint(GeometryUtilities.findXValueOnLine(object2, (double)object3, (double)object4, (double)object5, doublePoint.y), doublePoint.y);
                    treeMap.put(new PrioritizeDouble(++n, doublePoint2.x), doublePoint2);
                }
                object2 = object4;
                object3 = object5;
                n3 += 2;
            }
            ++n2;
        }
        object = new ArrayList(n);
        object.addAll(treeMap.values());
        object.addAll(treeMap2.values());
        return GeometryUtilities.a((List)object);
    }

    public static double findXValueOnLine(double d, double d2, double d3, double d4, double d5) {
        if (d == d3) {
            return d;
        }
        double d6 = (d2 - d4) / (d - d3);
        return d + (d5 - d2) / d6;
    }

    public static double findYValueOnLine(double d, double d2, double d3, double d4, double d5) {
        if (d == d3) {
            return d2;
        }
        double d6 = (d2 - d4) / (d - d3);
        return d6 * (d5 - d) + d2;
    }

    private static DoublePoint a(List list) {
        DoublePoint doublePoint = null;
        double d = 0.0;
        int n = 1;
        while (n < list.size()) {
            DoublePoint doublePoint2;
            DoublePoint doublePoint3 = (DoublePoint)list.get(n - 1);
            double d2 = GeometryUtilities.distance(doublePoint3, doublePoint2 = (DoublePoint)list.get(n));
            if (d2 > d) {
                doublePoint = GeometryUtilities.midpoint(doublePoint3, doublePoint2);
                d = d2;
            }
            n += 2;
        }
        return doublePoint;
    }

    public static double distance(DoublePoint doublePoint, DoublePoint doublePoint2) {
        return Math.sqrt(Math.pow(doublePoint2.x - doublePoint.x, 2.0) + Math.pow(doublePoint2.y - doublePoint.y, 2.0));
    }

    public static DoublePoint midpoint(DoublePoint doublePoint, DoublePoint doublePoint2) {
        return GeometryUtilities.midpoint(doublePoint.x, doublePoint.y, doublePoint2.x, doublePoint2.y);
    }

    public static DoublePoint midpoint(double d, double d2, double d3, double d4) {
        return new DoublePoint((d + d3) / 2.0, (d2 + d4) / 2.0);
    }
}

