/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.util;

import com.mapinfo.util.DoublePoint;
import com.mapinfo.util.IntRect;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class IntPoint
implements Cloneable {
    public int x;
    public int y;

    public IntPoint() {
    }

    public IntPoint(int n, int n2) {
        this.set(n, n2);
    }

    public IntPoint(double d, double d2) {
        this.set(d, d2);
    }

    public IntPoint(IntPoint intPoint) {
        this.set(intPoint.x, intPoint.y);
    }

    public IntPoint(DoublePoint doublePoint) {
        this.set(doublePoint.x, doublePoint.y);
    }

    public IntPoint(int n, int n2, IntPoint intPoint) {
        this.set(n + intPoint.x, n2 + intPoint.y);
    }

    public IntPoint(DataInput dataInput) throws IOException {
        this.read(dataInput);
    }

    public IntPoint(DataInput dataInput, IntPoint intPoint) throws IOException {
        this.read(dataInput, intPoint);
    }

    public void set(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void set(double d, double d2) {
        this.x = (int)d;
        this.y = (int)d2;
    }

    public void set(IntPoint intPoint) {
        this.set(intPoint.x, intPoint.y);
    }

    public void set(DoublePoint doublePoint) {
        this.set(doublePoint.x, doublePoint.y);
    }

    public void set(int n, int n2, IntPoint intPoint) {
        this.set(n + intPoint.x, n2 + intPoint.y);
    }

    public void read(DataInput dataInput) throws IOException {
        this.set(dataInput.readInt(), dataInput.readInt());
    }

    public void read(DataInput dataInput, IntPoint intPoint) throws IOException {
        this.read(dataInput, intPoint.x, intPoint.y);
    }

    public void read(DataInput dataInput, int n, int n2) throws IOException {
        this.set(dataInput.readShort() + n, dataInput.readShort() + n2);
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.x);
        dataOutput.writeInt(this.y);
    }

    public void write(DataOutput dataOutput, IntPoint intPoint) throws IOException {
        this.write(dataOutput, intPoint.x, intPoint.y);
    }

    public void write(DataOutput dataOutput, int n, int n2) throws IOException {
        dataOutput.writeShort(this.x - n);
        dataOutput.writeShort(this.y - n2);
    }

    public void offset(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public boolean equals(IntPoint intPoint) {
        return this.x == intPoint.x && this.y == intPoint.y;
    }

    public boolean equals(Object object) {
        return object instanceof IntPoint && this.equals((IntPoint)object);
    }

    public int hashCode() {
        return this.x + this.y;
    }

    public boolean intersects(IntRect intRect) {
        return intRect.intersects(this);
    }

    public boolean within(IntRect intRect) {
        return intRect.contains(this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

