/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.util;

import com.mapinfo.util.DoublePoint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class MathUtil {
    private static final double a = 57.29577951308232;
    private static final double b = Math.PI / 180;
    public static final double TWO_PI = Math.PI * 2;

    private MathUtil() {
    }

    public static double clip(double d, double d2, double d3) {
        if (d < d2) {
            return d2;
        }
        if (d > d3) {
            return d3;
        }
        return d;
    }

    public static int clip(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    public static double degreesToRadians(double d) {
        return d * (Math.PI / 180);
    }

    public static double radiansToDegrees(double d) {
        return d * 57.29577951308232;
    }

    public static double degreesToRadiansClip(double d, double d2, double d3) {
        return MathUtil.degreesToRadians(MathUtil.clip(d, d2, d3));
    }

    public static double radiansToDegreesClip(double d, double d2, double d3) {
        return MathUtil.clip(MathUtil.radiansToDegrees(d), d2, d3);
    }

    public static double round(double d, double d2) {
        if (d2 != 0.0) {
            d += d2 / 2.0;
            d = Math.floor(d / d2) * d2;
        }
        return d;
    }

    public static double cartesianDistance(DoublePoint doublePoint, DoublePoint doublePoint2) {
        return MathUtil.cartesianDistance(doublePoint.x, doublePoint.y, doublePoint2.x, doublePoint2.y);
    }

    public static double cartesianDistance(double d, double d2, double d3, double d4) {
        double d5 = d - d3;
        double d6 = d2 - d4;
        return Math.sqrt(d5 * d5 + d6 * d6);
    }

    public static final double atan4(double d, double d2) {
        double d3 = Math.atan2(d2, d);
        if (d3 < 0.0) {
            d3 += Math.PI * 2;
        }
        return d3;
    }

    public static Rectangle2D transformRect(Rectangle2D rectangle2D, AffineTransform affineTransform) {
        double d = rectangle2D.getMinX();
        double d2 = rectangle2D.getMinY();
        double d3 = rectangle2D.getMaxX();
        double d4 = rectangle2D.getMaxY();
        double[] dArray = new double[]{d, d2, d3, d2, d3, d4, d, d4};
        affineTransform.transform(dArray, 0, dArray, 0, 4);
        d = Math.min(dArray[0], Math.min(dArray[2], Math.min(dArray[4], dArray[6])));
        d2 = Math.min(dArray[1], Math.min(dArray[3], Math.min(dArray[5], dArray[7])));
        d3 = Math.max(dArray[0], Math.max(dArray[2], Math.max(dArray[4], dArray[6])));
        d4 = Math.max(dArray[1], Math.max(dArray[3], Math.max(dArray[5], dArray[7])));
        return new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
    }

    public static double computeAngle(double d, double d2, double d3, double d4) {
        double d5 = 0.0;
        if (d == d3) {
            d5 = d4 > d2 ? 1.5707963267948966 : -1.5707963267948966;
        } else if (d2 == d4) {
            d5 = d3 > d ? 0.0 : Math.PI;
        } else {
            d5 = Math.atan((d4 - d2) / (d3 - d));
            if (d3 < d) {
                d5 += Math.PI;
            }
        }
        return d5;
    }

    public static final boolean equivalent(Number number, Number number2) {
        return number == number2 || number != null && number2 != null && Double.doubleToLongBits(number.doubleValue()) == Double.doubleToLongBits(number2.doubleValue());
    }

    static {
        a = 57.29577951308232;
        b = Math.PI / 180;
        TWO_PI = Math.PI * 2;
    }
}

