/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.util;

import com.mapinfo.util.MimeType;

public class MultiPartImageMimeType {
    private String a;
    private int b;

    private MultiPartImageMimeType() {
    }

    public MultiPartImageMimeType(String string) {
        MimeType mimeType = MimeType.valueOf(string);
        if (!mimeType.getContentType().equals("multipart/image")) {
            throw new IllegalArgumentException("Given mimetype is not a valid multipart MIME type: " + string);
        }
        this.a = mimeType.getValue("imagetype");
        this.b = Integer.parseInt(mimeType.getValue("interval"));
    }

    public MultiPartImageMimeType(String string, int n) {
        this.a = string;
        this.b = n;
    }

    public String toString() {
        return "[MultiPartMimeType: m_imagetype=" + this.a + ", m_interval=" + this.b;
    }

    public String getValue() {
        return "multipart/image;imagetype=" + this.a + ";interval=" + this.b;
    }

    public String getImageType() {
        return this.a;
    }

    public int getInterval() {
        return this.b;
    }

    public void setImageType(String string) {
        this.a = string;
    }

    public void setInterval(int n) {
        this.b = n;
    }

    public static final MultiPartImageMimeType valueOf(String string, int n) {
        return new MultiPartImageMimeType(string, n);
    }

    public static final MultiPartImageMimeType valueOf(String string) {
        return new MultiPartImageMimeType(string);
    }

    public static final boolean isValid(String string) {
        try {
            MultiPartImageMimeType.valueOf(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

