/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.util.io;

import com.mapinfo.util.SystemUtil;
import com.mapinfo.util.cache.AutomaticCache;
import com.mapinfo.util.cache.ObjectDestroyer;
import com.mapinfo.util.cache.UsageCachedObject;
import com.mapinfo.util.io.MIByteBuffer;
import com.mapinfo.util.io.SlicedByteBuffer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.InvalidMarkException;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public final class IOByteBuffer
extends MIByteBuffer {
    private static final String a = "com.mapinfo.iobytebuffer.block.size";
    private static final int b;
    private int c = b;
    private int d = 0;
    private int e = 0;
    private int f = 0;
    private byte[] g = null;
    private int h = -1;
    private int i = -1;
    private int j = 0;
    private boolean k = false;
    private ByteOrder l = ByteOrder.nativeOrder();
    private static final AutomaticCache m;
    private static final ObjectDestroyer n;

    public IOByteBuffer(File file, String string) throws FileNotFoundException, IOException {
        super(file, string);
        this.e = this.d = (int)this.getFileSize();
        this.g = new byte[this.c];
    }

    public final void dispose() throws IOException {
        this.force();
    }

    public final int getBlockSize() {
        return this.c;
    }

    public final void setBlockSize(int n) {
        this.h = -1;
        this.c = n;
    }

    public final void order(ByteOrder byteOrder) {
        this.l = byteOrder;
    }

    public final ByteOrder order() {
        return this.l;
    }

    public final boolean isMapped() {
        return false;
    }

    public final synchronized void expandFile(int n, byte by) throws IOException {
        super.expandFile(n, by);
        this.h = -1;
        this.e = (int)this.getFileSize();
        this.d = (int)this.getFileSize() - this.j;
    }

    protected final void a(RandomAccessFile randomAccessFile) throws IOException {
        if (this.k) {
            randomAccessFile.seek(this.h);
            randomAccessFile.write(this.g);
            this.k = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void force() {
        if (!this.k) return;
        RandomAccessFile randomAccessFile = null;
        try {
            try {
                randomAccessFile = new RandomAccessFile(this.a(), this.getMode());
                this.a(randomAccessFile);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            Object var4_2 = null;
            if (randomAccessFile == null) return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (randomAccessFile == null) throw throwable;
            try {
                randomAccessFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        randomAccessFile.close();
        return;
    }

    public final int capacity() {
        return this.d;
    }

    public final MIByteBuffer clear() {
        this.e = this.d;
        this.f = 0;
        return this;
    }

    public final MIByteBuffer flip() {
        this.e = this.f;
        this.f = 0;
        return this;
    }

    public final boolean hasRemaining() {
        return this.e - this.f > 0;
    }

    public final int limit() {
        return this.e;
    }

    public final MIByteBuffer limit(int n) {
        this.e = n;
        return this;
    }

    public final MIByteBuffer mark() {
        this.i = this.f;
        return this;
    }

    public final int position() {
        return this.f;
    }

    public final MIByteBuffer position(int n) {
        if ((this.i < 0 || this.i < n) && n >= 0 && n < this.d) {
            this.f = n;
        } else {
            if (n < 0) {
                throw new IllegalArgumentException("Position cannot be negative.");
            }
            if (n > this.d) {
                throw new IllegalArgumentException("Position cannot be larger then the capacity.");
            }
        }
        return this;
    }

    public final int remaining() {
        return this.e - this.f;
    }

    public final MIByteBuffer reset() {
        if (this.i < 0) {
            throw new InvalidMarkException();
        }
        this.f = this.i;
        return this;
    }

    public final MIByteBuffer rewind() {
        this.f = 0;
        return this;
    }

    public CharBuffer asCharBuffer() {
        throw new UnsupportedOperationException();
    }

    public DoubleBuffer asDoubleBuffer() {
        throw new UnsupportedOperationException();
    }

    public FloatBuffer asFloatBuffer() {
        throw new UnsupportedOperationException();
    }

    public IntBuffer asIntBuffer() {
        throw new UnsupportedOperationException();
    }

    public LongBuffer asLongBuffer() {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer asReadOnlyBuffer() {
        throw new UnsupportedOperationException();
    }

    public ShortBuffer asShortBuffer() {
        throw new UnsupportedOperationException();
    }

    public MIByteBuffer compact() {
        throw new UnsupportedOperationException();
    }

    public int compareTo(Object object) {
        throw new UnsupportedOperationException();
    }

    public final MIByteBuffer duplicate() throws IOException {
        return new SlicedByteBuffer(this, 0);
    }

    public final MIByteBuffer slice() {
        return new SlicedByteBuffer(this);
    }

    public final boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public final byte get() {
        this.a(1);
        byte by = this.g[this.f++ + this.j - this.h];
        return by;
    }

    public final MIByteBuffer get(byte[] byArray) {
        this.get(byArray, 0, byArray.length);
        return this;
    }

    public final MIByteBuffer get(byte[] byArray, int n, int n2) {
        this.a(n2 - n);
        System.arraycopy(this.g, this.f + this.j - this.h, byArray, n, n2);
        this.f += n2 - n;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte get(int n) {
        int n2 = this.f;
        try {
            this.f = n;
            byte by = this.get();
            Object var5_4 = null;
            this.f = n2;
            return by;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.f = n2;
            throw throwable;
        }
    }

    public final char getChar() {
        this.a(2);
        byte by = this.g[this.f++ + this.j - this.h];
        byte by2 = this.g[this.f++ + this.j - this.h];
        if (this.l == ByteOrder.LITTLE_ENDIAN) {
            return (char)(((by2 & 0xFF) << 8) + ((by & 0xFF) << 0));
        }
        return (char)(((by & 0xFF) << 8) + ((by2 & 0xFF) << 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final char getChar(int n) {
        int n2 = this.f;
        try {
            this.f = n;
            char c = this.getChar();
            Object var5_4 = null;
            this.f = n2;
            return c;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.f = n2;
            throw throwable;
        }
    }

    public final double getDouble() {
        return Double.longBitsToDouble(this.getLong());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double getDouble(int n) {
        int n2 = this.f;
        try {
            this.f = n;
            double d = this.getDouble();
            Object var6_4 = null;
            this.f = n2;
            return d;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.f = n2;
            throw throwable;
        }
    }

    public final float getFloat() {
        return Float.intBitsToFloat(this.getInt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getFloat(int n) {
        int n2 = this.f;
        try {
            this.f = n;
            float f = this.getFloat();
            Object var5_4 = null;
            this.f = n2;
            return f;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.f = n2;
            throw throwable;
        }
    }

    public final int getInt() {
        this.a(4);
        byte by = this.g[this.f++ + this.j - this.h];
        byte by2 = this.g[this.f++ + this.j - this.h];
        byte by3 = this.g[this.f++ + this.j - this.h];
        byte by4 = this.g[this.f++ + this.j - this.h];
        if (this.l == ByteOrder.LITTLE_ENDIAN) {
            return ((by4 & 0xFF) << 24) + ((by3 & 0xFF) << 16) + ((by2 & 0xFF) << 8) + ((by & 0xFF) << 0);
        }
        return ((by & 0xFF) << 24) + ((by2 & 0xFF) << 16) + ((by3 & 0xFF) << 8) + ((by4 & 0xFF) << 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getInt(int n) {
        int n2 = this.f;
        try {
            this.f = n;
            int n3 = this.getInt();
            Object var5_4 = null;
            this.f = n2;
            return n3;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.f = n2;
            throw throwable;
        }
    }

    public final long getLong() {
        int n = this.getInt();
        int n2 = this.getInt();
        if (this.l == ByteOrder.LITTLE_ENDIAN) {
            return ((long)n & 0xFFFFFFFFL) + ((long)n2 << 32);
        }
        return ((long)n2 & 0xFFFFFFFFL) + ((long)n << 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getLong(int n) {
        int n2 = this.f;
        try {
            this.f = n;
            long l = this.getLong();
            Object var6_4 = null;
            this.f = n2;
            return l;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.f = n2;
            throw throwable;
        }
    }

    public final short getShort() {
        this.a(2);
        byte by = this.g[this.f++ + this.j - this.h];
        byte by2 = this.g[this.f++ + this.j - this.h];
        if (this.l == ByteOrder.LITTLE_ENDIAN) {
            return (short)(((by2 & 0xFF) << 8) + ((by & 0xFF) << 0));
        }
        return (short)(((by & 0xFF) << 8) + ((by2 & 0xFF) << 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final short getShort(int n) {
        int n2 = this.f;
        try {
            this.f = n;
            short s = this.getShort();
            Object var5_4 = null;
            this.f = n2;
            return s;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.f = n2;
            throw throwable;
        }
    }

    public final boolean isDirect() {
        return false;
    }

    public final MIByteBuffer put(byte by) {
        this.a(1);
        this.g[this.f++ + this.j - this.h] = by;
        this.k = true;
        return this;
    }

    public final MIByteBuffer put(byte[] byArray) {
        this.put(byArray, 0, byArray.length);
        return this;
    }

    public final MIByteBuffer put(byte[] byArray, int n, int n2) {
        this.a(n2);
        System.arraycopy(byArray, n, this.g, this.f + this.j - this.h, n2);
        this.f += n2 - n;
        return this;
    }

    public final MIByteBuffer put(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() > this.remaining()) {
            throw new BufferOverflowException();
        }
        int n = byteBuffer.remaining();
        this.a(n);
        byteBuffer.get(this.g, this.f + this.j - this.h, n);
        this.f += n;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MIByteBuffer put(int n, byte by) {
        int n2 = this.f;
        try {
            this.f = n;
            this.put(by);
            Object var5_4 = null;
            this.f = n2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.f = n2;
            throw throwable;
        }
        return this;
    }

    public final MIByteBuffer putChar(char c) {
        this.a(2);
        if (this.l == ByteOrder.LITTLE_ENDIAN) {
            this.g[this.f++ + this.j - this.h] = (byte)(c >>> 0 & 0xFF);
            this.g[this.f++ + this.j - this.h] = (byte)(c >>> 8 & 0xFF);
        } else {
            this.g[this.f++ + this.j - this.h] = (byte)(c >>> 8 & 0xFF);
            this.g[this.f++ + this.j - this.h] = (byte)(c >>> 0 & 0xFF);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MIByteBuffer putChar(int n, char c) {
        int n2 = this.f;
        try {
            this.f = n;
            this.putChar(c);
            Object var5_4 = null;
            this.f = n2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.f = n2;
            throw throwable;
        }
        return this;
    }

    public final MIByteBuffer putDouble(double d) {
        this.putLong(Double.doubleToLongBits(d));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MIByteBuffer putDouble(int n, double d) {
        int n2 = this.f;
        try {
            this.f = n;
            this.putDouble(d);
            Object var6_4 = null;
            this.f = n2;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.f = n2;
            throw throwable;
        }
        return this;
    }

    public final MIByteBuffer putFloat(float f) {
        this.putInt(Float.floatToIntBits(f));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MIByteBuffer putFloat(int n, float f) {
        int n2 = this.f;
        try {
            this.f = n;
            this.putFloat(f);
            Object var5_4 = null;
            this.f = n2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.f = n2;
            throw throwable;
        }
        return this;
    }

    public final MIByteBuffer putInt(int n) {
        this.a(4);
        if (this.l == ByteOrder.LITTLE_ENDIAN) {
            this.g[this.f++ + this.j - this.h] = (byte)(n >>> 0 & 0xFF);
            this.g[this.f++ + this.j - this.h] = (byte)(n >>> 8 & 0xFF);
            this.g[this.f++ + this.j - this.h] = (byte)(n >>> 16 & 0xFF);
            this.g[this.f++ + this.j - this.h] = (byte)(n >>> 24 & 0xFF);
        } else {
            this.g[this.f++ + this.j - this.h] = (byte)(n >>> 24 & 0xFF);
            this.g[this.f++ + this.j - this.h] = (byte)(n >>> 16 & 0xFF);
            this.g[this.f++ + this.j - this.h] = (byte)(n >>> 8 & 0xFF);
            this.g[this.f++ + this.j - this.h] = (byte)(n >>> 0 & 0xFF);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MIByteBuffer putInt(int n, int n2) {
        int n3 = this.f;
        try {
            this.f = n;
            this.putInt(n2);
            Object var5_4 = null;
            this.f = n3;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.f = n3;
            throw throwable;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MIByteBuffer putLong(int n, long l) {
        int n2 = this.f;
        try {
            this.f = n;
            this.putLong(l);
            Object var6_4 = null;
            this.f = n2;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.f = n2;
            throw throwable;
        }
        return this;
    }

    public final MIByteBuffer putLong(long l) {
        this.a(8);
        if (this.l == ByteOrder.LITTLE_ENDIAN) {
            this.g[this.f++ + this.j - this.h] = (byte)(l >>> 0 & 0xFFL);
            this.g[this.f++ + this.j - this.h] = (byte)(l >>> 8 & 0xFFL);
            this.g[this.f++ + this.j - this.h] = (byte)(l >>> 16 & 0xFFL);
            this.g[this.f++ + this.j - this.h] = (byte)(l >>> 24 & 0xFFL);
            this.g[this.f++ + this.j - this.h] = (byte)(l >>> 32 & 0xFFL);
            this.g[this.f++ + this.j - this.h] = (byte)(l >>> 40 & 0xFFL);
            this.g[this.f++ + this.j - this.h] = (byte)(l >>> 48 & 0xFFL);
            this.g[this.f++ + this.j - this.h] = (byte)(l >>> 56 & 0xFFL);
        } else {
            this.g[this.f++ + this.j - this.h] = (byte)(l >>> 56 & 0xFFL);
            this.g[this.f++ + this.j - this.h] = (byte)(l >>> 48 & 0xFFL);
            this.g[this.f++ + this.j - this.h] = (byte)(l >>> 40 & 0xFFL);
            this.g[this.f++ + this.j - this.h] = (byte)(l >>> 32 & 0xFFL);
            this.g[this.f++ + this.j - this.h] = (byte)(l >>> 24 & 0xFFL);
            this.g[this.f++ + this.j - this.h] = (byte)(l >>> 16 & 0xFFL);
            this.g[this.f++ + this.j - this.h] = (byte)(l >>> 8 & 0xFFL);
            this.g[this.f++ + this.j - this.h] = (byte)(l >>> 0 & 0xFFL);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MIByteBuffer putShort(int n, short s) {
        int n2 = this.f;
        try {
            this.f = n;
            this.putShort(s);
            Object var5_4 = null;
            this.f = n2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.f = n2;
            throw throwable;
        }
        return this;
    }

    public final MIByteBuffer putShort(short s) {
        this.a(2);
        if (this.l == ByteOrder.LITTLE_ENDIAN) {
            this.g[this.f++ + this.j - this.h] = (byte)(s >>> 0 & 0xFF);
            this.g[this.f++ + this.j - this.h] = (byte)(s >>> 8 & 0xFF);
        } else {
            this.g[this.f++ + this.j - this.h] = (byte)(s >>> 8 & 0xFF);
            this.g[this.f++ + this.j - this.h] = (byte)(s >>> 0 & 0xFF);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void a(int n) {
        if (this.h < 0 || this.f + this.j < this.h || this.h + this.g.length <= this.f + this.j || this.h + this.g.length <= this.f + this.h + n) {
            RandomAccessFile randomAccessFile = null;
            UsageCachedObject usageCachedObject = null;
            try {
                try {
                    usageCachedObject = (UsageCachedObject)m.getObject(this.a());
                    if (usageCachedObject != null) {
                        randomAccessFile = (RandomAccessFile)usageCachedObject.getObject();
                    } else {
                        randomAccessFile = new RandomAccessFile(this.a(), this.getMode());
                        usageCachedObject = new UsageCachedObject(randomAccessFile, IOByteBuffer.n);
                        m.addObject(this.a(), usageCachedObject);
                    }
                    usageCachedObject.addUse();
                    this.a(randomAccessFile);
                    this.h = this.f + this.j - (this.f + this.j) % this.c;
                    if (this.h + this.g.length <= this.f + this.h + n) {
                        this.h = this.f + this.j;
                    }
                    if (this.g == null) {
                        this.g = new byte[Math.max(this.c, n)];
                    } else if (this.g.length < n) {
                        this.g = new byte[n];
                    }
                    if (this.getFileSize() - (long)this.h < (long)this.g.length) {
                        this.g = new byte[(int)(this.getFileSize() - (long)this.h)];
                    }
                    RandomAccessFile randomAccessFile2 = randomAccessFile;
                    synchronized (randomAccessFile2) {
                        randomAccessFile.seek(this.h);
                        randomAccessFile.readFully(this.g);
                    }
                    Object var7_8 = null;
                    if (usageCachedObject != null) {
                        usageCachedObject.removeUse();
                    }
                }
                catch (IOException iOException) {
                    try {
                        throw new RuntimeException(iOException.getClass().getName() + " encountered: " + iOException.getMessage() + "\n   Array start: " + this.h + "\n   File pointer: " + randomAccessFile.getFilePointer() + "\n   File size:   " + this.a().length() + "\n   Block size:  " + this.c, iOException);
                    }
                    catch (IOException iOException2) {
                        throw new RuntimeException(iOException);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (usageCachedObject != null) {
                    usageCachedObject.removeUse();
                }
                throw throwable;
            }
        }
    }

    static {
        a = a;
        b = SystemUtil.getSystemProperty(a, 8192);
        m = new AutomaticCache();
        n = new RAFDestroyer();
    }

    private static final class RAFDestroyer
    implements ObjectDestroyer {
        private RAFDestroyer() {
        }

        public void destroy(Object object) {
            if (object instanceof RandomAccessFile) {
                try {
                    ((RandomAccessFile)object).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

