/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode;

import com.mapinfo.geocode.api.DataType;
import com.mapinfo.geocode.util.GeocodeUtils;
import java.util.HashSet;
import java.util.Set;

public class CountrySupport {
    private Set<DataType> supportedDataTypes = new HashSet<DataType>();
    private Set<String> supportedCountries = new HashSet<String>();

    public CountrySupport() {
    }

    public CountrySupport(CountrySupport other) {
        this.supportedDataTypes.addAll(other.getSupportedDataTypes());
        this.supportedCountries.addAll(other.getSupportedCountries());
    }

    public Set<String> getSupportedCountries() {
        return this.supportedCountries;
    }

    public Set<DataType> getSupportedDataTypes() {
        return this.supportedDataTypes;
    }

    public void setSupportedCountries(Set<String> countries) {
        this.supportedCountries = countries;
    }

    public void setSupportedDataTypes(Set<DataType> types) {
        this.supportedDataTypes = types;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CountrySupport) {
            CountrySupport that = (CountrySupport)obj;
            if (this.getSupportedCountries().size() != that.getSupportedCountries().size()) {
                return false;
            }
            if (this.getSupportedDataTypes().size() != that.getSupportedDataTypes().size()) {
                return false;
            }
            for (String country : this.getSupportedCountries()) {
                if (that.getSupportedCountries().contains(country)) continue;
                return false;
            }
            for (DataType dataType : this.getSupportedDataTypes()) {
                if (that.getSupportedDataTypes().contains((Object)dataType)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("data level:");
        GeocodeUtils.appendNewline(stringBuilder);
        for (DataType type : this.supportedDataTypes) {
            stringBuilder.append((Object)type);
            GeocodeUtils.appendNewline(stringBuilder);
        }
        GeocodeUtils.appendNewline(stringBuilder);
        stringBuilder.append("countries:");
        GeocodeUtils.appendNewline(stringBuilder);
        for (String country : this.supportedCountries) {
            stringBuilder.append(country);
            GeocodeUtils.appendNewline(stringBuilder);
        }
        return stringBuilder.toString();
    }
}

