/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode;

import com.mapinfo.geocode.CountrySupport;
import com.mapinfo.geocode.CountryTokenSplitter;
import com.mapinfo.geocode.ExceptionCode;
import com.mapinfo.geocode.GeocodeCapabilitiesResponse;
import com.mapinfo.geocode.GeocodeConfiguration;
import com.mapinfo.geocode.GeocoderGeoStan;
import com.mapinfo.geocode.GeocoderPreferences;
import com.mapinfo.geocode.GeocoderResponse;
import com.mapinfo.geocode.GeocodingException;
import com.mapinfo.geocode.InternalGeocoder;
import com.mapinfo.geocode.UsaToInternationalCandidateComparator;
import com.mapinfo.geocode.api.Address;
import com.mapinfo.geocode.api.Candidate;
import com.mapinfo.geocode.api.CapabilitiesResponse;
import com.mapinfo.geocode.api.DefaultPreferencesAPI;
import com.mapinfo.geocode.api.Dictionary;
import com.mapinfo.geocode.api.GeocodeType;
import com.mapinfo.geocode.api.GeocodingAPI;
import com.mapinfo.geocode.api.Key;
import com.mapinfo.geocode.api.KeyType;
import com.mapinfo.geocode.api.Preferences;
import com.mapinfo.geocode.api.Response;
import com.mapinfo.geocode.api.USAMatchMode;
import com.mapinfo.geocode.classloader.CustomClassLoader;
import com.mapinfo.geocode.service.Points;
import com.mapinfo.geocode.util.ApplicationConfiguration;
import com.mapinfo.geocode.util.ConfigurationManager;
import com.mapinfo.geocode.util.DataManagerSettingsMapper;
import com.mapinfo.geocode.util.DefaultPreferencesProvider;
import com.mapinfo.geocode.util.ExternalDataManagerSettingsMapper;
import com.mapinfo.geocode.util.GeocodeUtils;
import com.mapinfo.geocode.util.OverridablePreferences;
import com.mapinfo.mapmarker.core.multicountry.MultiCountryBasicSettings;
import com.mapinfo.mapmarker.utils.ISO3166;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.CoordSysConstants;
import com.mapinfo.midev.coordsys.transform.CoordTransform;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.Point;
import com.pb.geocoding.config.JsonConfigurationImpl;
import com.pb.geocoding.config.api.GeocodingConfiguration;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class Geocoder
implements GeocodingAPI,
DefaultPreferencesAPI {
    public static final int MAX_RECORD_SIZE = 500;
    private GeocoderGeoStan geocoderGeoStan;
    private List<Dictionary> geoStanConfiguredDictionaries;
    private static final Logger logger = LoggerFactory.getLogger(Geocoder.class);
    private static final String ISO3_WORLD = "XWG";
    private static final SpatialInfo SPATIAL_INFO = new SpatialInfo(CoordSysConstants.longLatWGS84);
    private static final DirectPosition lowerLeft = new DirectPosition(-179.999, 17.92998);
    private static final DirectPosition upperRight = new DirectPosition(-65.2547, 71.35059);
    private static final Envelope USA_ENVELOPE = new Envelope(lowerLeft, upperRight, SPATIAL_INFO);
    private DataManagerSettingsMapper dataManagerSettingsMapper;
    private Map<String, List<Dictionary>> myDictMap = new HashMap<String, List<Dictionary>>();
    private UsaToInternationalCandidateComparator comparator;
    private String DEFAULT_COUNTRY;
    protected static final ApplicationConfiguration configuration;
    private static final Set countriesSupportingUDs;
    private static final Set geoStanCountries;
    InternalGeocoder internalGeocoder;
    private static final String ERROR_PREFIX_EXCEPTION = "An exception was thrown: ";
    private static final String ERROR_BATCH_SIZE_EXCEEDED = "Batch request exceeded maximum configured batch size";
    private static final int DEFAULT_BATCH_SIZE = 100;
    private int batchSize = 100;

    public Geocoder() throws GeocodingException {
        File settings = new File(Geocoder.getConfigurationLocation().toAbsolutePath().toString(), "JsonDataConfig.json");
        JsonConfigurationImpl config = new JsonConfigurationImpl(settings);
        this.init((GeocodingConfiguration)config);
    }

    public Geocoder(GeocodingConfiguration config) throws GeocodingException {
        this.init(config);
    }

    private void init(GeocodingConfiguration config) throws GeocodingException {
        this.resolveConfiguration(config);
        int oldSize = this.batchSize;
        try {
            this.batchSize = Integer.parseInt((String)config.getConfig("MAXIMUM_BATCH_SIZE"));
            if (this.batchSize < 1) {
                logger.debug("Invalid batch size, batch set to 100");
                this.batchSize = 100;
            }
        }
        catch (Exception e) {
            logger.debug("Exception while fetching Batch Size, batch size not changed", (Throwable)e);
            this.batchSize = oldSize;
        }
        this.initInternalGeocoder(config);
        this.dataManagerSettingsMapper = new DataManagerSettingsMapper();
        this.dataManagerSettingsMapper.init(config);
        ConfigurationManager.setDataManagerSettingsMapper(this.dataManagerSettingsMapper);
        this.initGeocoderGeoStan(null, this.dataManagerSettingsMapper);
        if (this.internalGeocoder != null) {
            this.internalGeocoder.setDataManagerSettingsMapper(this.dataManagerSettingsMapper);
        }
        this.comparator = new UsaToInternationalCandidateComparator(this.dataManagerSettingsMapper.getConfiguredCountries());
        if (this.dataManagerSettingsMapper.getConfiguredCountries().size() == 1) {
            this.DEFAULT_COUNTRY = this.dataManagerSettingsMapper.getConfiguredCountries().iterator().next();
        }
    }

    @Deprecated
    public Geocoder(ExternalDataManagerSettingsMapper dataManagerSettingsMapper) throws GeocodingException {
        this.initInternalGeocoder(null);
        this.dataManagerSettingsMapper = dataManagerSettingsMapper;
        ConfigurationManager.setDataManagerSettingsMapper(dataManagerSettingsMapper);
        Properties initProps = dataManagerSettingsMapper.getInitProps();
        if (initProps != null && initProps.size() > 0) {
            this.initGeocoderGeoStan(initProps, null);
        }
        if (this.internalGeocoder != null) {
            this.internalGeocoder.setDataManagerSettingsMapper(dataManagerSettingsMapper);
        }
        this.comparator = new UsaToInternationalCandidateComparator(dataManagerSettingsMapper.getConfiguredCountries());
    }

    @Override
    public IPoint createPoint(double x, double y, String coordsys) {
        return GeocodeUtils.getPointFromXY(x, y, coordsys);
    }

    @Override
    public String getCoordinateSystemName(CoordSys coordSys) {
        return GeocodeUtils.getSRSName(coordSys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initInternalGeocoder(GeocodingConfiguration config) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            CustomClassLoader.LibraryLoaderStrategy strategy = CustomClassLoader.LibraryLoaderStrategy.LIB_FIRST_FOUND;
            ArrayList<Path> paths = new ArrayList<Path>();
            if (config != null) {
                Map classLoaderConfig;
                String strategyString = (String)config.getConfig("LIBRARY_LOADING_STRATEGY");
                if (EnumUtils.isValidEnum(CustomClassLoader.LibraryLoaderStrategy.class, (String)strategyString)) {
                    strategy = CustomClassLoader.LibraryLoaderStrategy.valueOf(strategyString);
                }
                if ((classLoaderConfig = (Map)config.getConfig("classloader")) != null) {
                    List libPaths = (List)classLoaderConfig.get("libraries");
                    for (String libPath : libPaths) {
                        paths.add(Paths.get(libPath, new String[0]));
                    }
                }
            }
            CustomClassLoader classLoader = CustomClassLoader.getInstance(paths);
            classLoader.loadContext(strategy);
            Class<?> mapMarkerGeocoderClass = classLoader.getClassLoader().loadClass("com.mapinfo.geocode.InternalGeocoder");
            this.internalGeocoder = (InternalGeocoder)mapMarkerGeocoderClass.getDeclaredConstructor(String.class, String.class).newInstance(Geocoder.getConfigurationLocation().toAbsolutePath().toString(), Geocoder.getResourceLocation().toAbsolutePath().toString());
        }
        catch (NoClassDefFoundError e) {
            logger.info("International geocoding is disabled");
            logger.debug("Cannot initialize international geocoding", (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.debug("Cannot initialize international geocoding", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.debug("Cannot initialize international geocoding", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.debug("Cannot initialize international geocoding", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.debug("Cannot initialize international geocoding", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.debug("Cannot initialize international geocoding", (Throwable)e);
        }
        catch (Exception e) {
            logger.debug("Cannot initialize international geocoding", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    private void initGeocoderGeoStan(Properties initProperties, DataManagerSettingsMapper mapper) throws GeocodingException {
        if (this.geocoderGeoStan == null) {
            boolean usaSupported;
            try {
                usaSupported = this.getCapabilities().getSupportedCountries().contains("USA");
            }
            catch (GeocodingException ex) {
                logger.error("Geocoding Exception was thrown during the instantiation of Geocoder from getCapabilites", (Throwable)ex);
                usaSupported = true;
            }
            if (usaSupported) {
                try {
                    if (initProperties == null) {
                        if (mapper.isCountryConfigured("USA")) {
                            this.geocoderGeoStan = new GeocoderGeoStan(mapper);
                        }
                    } else {
                        this.geocoderGeoStan = new GeocoderGeoStan(initProperties);
                    }
                    if (this.geocoderGeoStan != null) {
                        this.geoStanConfiguredDictionaries = this.geocoderGeoStan.getConfiguredDictionaries();
                    }
                }
                catch (GeocodingException geocodingException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public Response geocode(GeocodeType type, Address address, Preferences preferences) throws GeocodingException {
        if (address == null) {
            return new GeocoderResponse();
        }
        address.setCountry(GeocodeUtils.getISO3Country(address.getCountry()));
        String country = this.getCountryWithWorldFallback(address.getCountry(), preferences);
        this.trackOriginalCountry(address, country);
        address.setCountry(country);
        if (StringUtils.isEmpty((CharSequence)address.getCountry()) && this.dataManagerSettingsMapper.getConfiguredCountries().size() == 1) {
            address.setCountry(this.DEFAULT_COUNTRY);
        }
        address.setCountry(this.getCountryFromMatchMode(address.getCountry(), preferences));
        if (StringUtils.isEmpty((CharSequence)address.getCountry()) && this.findCountryInAddress(address, preferences)) {
            Response testResponse = null;
            if (Geocoder.inUsa(address.getCountry())) {
                testResponse = this.geocodeGeoStan(type, address, preferences);
            } else if (this.internalGeocoder != null) {
                testResponse = this.internalGeocoder.geocodeInternational(type, address, preferences, this);
            }
            if (testResponse == null || testResponse.getTotalMatches() > 0) {
                return testResponse;
            }
            address.setCountry(null);
        }
        if (Geocoder.inUsa(address.getCountry())) {
            return this.geocodeGeoStan(type, address, preferences);
        }
        if (StringUtils.isEmpty((CharSequence)address.getCountry())) {
            return this.geocodeNoCountry(type, address, preferences);
        }
        Set<String> availableCountries = this.dataManagerSettingsMapper.getConfiguredCountries();
        if (!availableCountries.contains(address.getCountry().toUpperCase())) {
            return this.geocodeNoCountry(type, address, preferences);
        }
        if (this.internalGeocoder != null) {
            return this.internalGeocoder.geocodeInternational(type, address, preferences, this);
        }
        throw new GeocodingException("Data not available", ExceptionCode.COUNTRY_NOT_SUPPORTED);
    }

    @Override
    public List<Response> geocodeMultiple(GeocodeType type, List<Address> addressList, Preferences preferences) throws GeocodingException {
        boolean requestExceededBatchSize;
        ArrayList<Response> responseList = new ArrayList<Response>();
        if (addressList == null) {
            return responseList;
        }
        this.checkValidDictionarySearchFormat(preferences);
        boolean bl = requestExceededBatchSize = addressList.size() > this.batchSize;
        if (requestExceededBatchSize) {
            addressList = addressList.subList(0, this.batchSize);
        }
        for (Address address : addressList) {
            try {
                responseList.add(this.geocode(type, address, preferences));
            }
            catch (GeocodingException ex) {
                GeocoderResponse errResp = new GeocoderResponse();
                errResp.getCustomValues().put("ERROR", ERROR_PREFIX_EXCEPTION + ex.getLocalizedMessage());
                responseList.add(errResp);
            }
        }
        if (requestExceededBatchSize) {
            GeocoderResponse errResp = new GeocoderResponse();
            errResp.getCustomValues().put("ERROR", ERROR_BATCH_SIZE_EXCEEDED);
            responseList.add(errResp);
        }
        return responseList;
    }

    @Override
    public Response reverseGeocode(double x, double y, String csys, String country, Preferences preferences) throws GeocodingException {
        country = GeocodeUtils.getISO3Country(country);
        return this.reverseGeocode(this.createPoint(x, y, csys), country, preferences);
    }

    @Override
    public Response reverseGeocode(IPoint point, String country, Preferences preferences) throws GeocodingException {
        Response response;
        IPoint xformDest;
        if (point == null) {
            return new GeocoderResponse();
        }
        if (preferences == null) {
            preferences = DefaultPreferencesProvider.getInstance().getDefaultPreferences();
        }
        if (country != null && ("null".equalsIgnoreCase(country) || country.trim().length() == 0)) {
            country = null;
        }
        if ((country = GeocodeUtils.getISO3Country(country)) == null && USA_ENVELOPE.contains((xformDest = this.convertCoordSys(point)).getDirectPosition()) && (response = this.reverseGeocodeGeoStan(xformDest, preferences)) != null && !response.getCandidates().isEmpty()) {
            return response;
        }
        Response rsLocal = null;
        if (Geocoder.inUsa(country)) {
            rsLocal = this.reverseGeocodeGeoStan(point, preferences);
            if ((rsLocal == null || rsLocal.getTotalMatches() == 0) && this.internalGeocoder != null && this.dataManagerSettingsMapper.isCountryConfigured(ISO3_WORLD) && (this.shouldFallbackToWorld(preferences) || preferences.isFallbackToPostal() || preferences.isFallbackToGeographic())) {
                return this.internalGeocoder.reverseGeocodeInternational(point, ISO3_WORLD, preferences, this);
            }
        } else if (this.internalGeocoder != null) {
            boolean isConfigured = this.dataManagerSettingsMapper.isCountryConfigured(country);
            if (isConfigured || StringUtils.isEmpty((CharSequence)country)) {
                rsLocal = this.internalGeocoder.reverseGeocodeInternational(point, country, preferences, this);
            }
            if (!ISO3_WORLD.equalsIgnoreCase(country) && (rsLocal == null || rsLocal.getTotalMatches() == 0) && this.dataManagerSettingsMapper.isCountryConfigured(ISO3_WORLD) && (this.shouldFallbackToWorld(preferences) || preferences.isFallbackToGeographic() || preferences.isFallbackToPostal())) {
                rsLocal = this.internalGeocoder.reverseGeocodeInternational(point, ISO3_WORLD, preferences, this);
            }
            if (rsLocal == null) {
                rsLocal = this.internalGeocoder.reverseGeocodeInternational(point, country, preferences, this);
            }
        }
        if (rsLocal == null && this.internalGeocoder == null && this.geocoderGeoStan == null) {
            throw new GeocodingException("Data not available", ExceptionCode.COUNTRY_NOT_SUPPORTED);
        }
        if (rsLocal == null) {
            return new GeocoderResponse();
        }
        return rsLocal;
    }

    @Override
    public List<Response> reverseGeocodeMultiple(List<Points> locationList, Preferences preferences) throws GeocodingException {
        boolean requestExceededBatchSize;
        ArrayList<Response> responseList = new ArrayList<Response>();
        if (locationList == null) {
            return responseList;
        }
        this.checkValidDictionarySearchFormat(preferences);
        boolean bl = requestExceededBatchSize = locationList.size() > this.batchSize;
        if (requestExceededBatchSize) {
            locationList = locationList.subList(0, this.batchSize);
        }
        for (Points location : locationList) {
            if (location == null) {
                responseList.add(new GeocoderResponse());
                continue;
            }
            try {
                responseList.add(this.reverseGeocode(location.getPoint(), location.getCountry(), preferences));
            }
            catch (GeocodingException ex) {
                GeocoderResponse errResp = new GeocoderResponse();
                errResp.getCustomValues().put("ERROR", ERROR_PREFIX_EXCEPTION + ex.getLocalizedMessage());
                responseList.add(errResp);
            }
        }
        if (requestExceededBatchSize) {
            GeocoderResponse errResp = new GeocoderResponse();
            errResp.getCustomValues().put("ERROR", ERROR_BATCH_SIZE_EXCEEDED);
            responseList.add(errResp);
        }
        return responseList;
    }

    @Override
    public List<Dictionary> getConfiguredDictionaries(String country) throws GeocodingException {
        if (country == null) {
            return this.getConfiguredDictionaries();
        }
        country = GeocodeUtils.getISO3Country(country);
        return this.getUpdatedDictionaries(country.toUpperCase());
    }

    @Override
    public List<Dictionary> getConfiguredDictionaries() throws GeocodingException {
        ArrayList<Dictionary> dictionaries = new ArrayList<Dictionary>();
        if (this.geocoderGeoStan != null) {
            dictionaries.addAll(this.getUpdatedDictionaries("USA"));
        }
        for (String country : ConfigurationManager.getDictionaryMap().keySet()) {
            if ("USA".equalsIgnoreCase(country)) continue;
            dictionaries.addAll(this.getUpdatedDictionaries(country));
        }
        return dictionaries;
    }

    private List<Dictionary> getUpdatedDictionaries(String country) throws GeocodingException {
        if (this.myDictMap.containsKey(country)) {
            return this.myDictMap.get(country);
        }
        GeocodeConfiguration config = GeocodeConfiguration.getInstance();
        boolean countryFilter = false;
        String localCountry = country;
        if (config != null) {
            boolean bl = countryFilter = (country = config.getPrimaryCountry(country)) != null && !country.equalsIgnoreCase(localCountry);
        }
        if (Geocoder.inUsa(country)) {
            if (this.geocoderGeoStan == null) {
                throw new GeocodingException("Data not available", ExceptionCode.COUNTRY_NOT_SUPPORTED);
            }
            List<Dictionary> dictionaryList = this.geocoderGeoStan.getConfiguredDictionaries();
            if (countryFilter) {
                dictionaryList = this.filterSubSupportedCountry(localCountry, dictionaryList);
                this.myDictMap.put(localCountry, dictionaryList);
            } else {
                dictionaryList = this.addSubSupportedCountries(geoStanCountries, dictionaryList);
                this.myDictMap.put(country, dictionaryList);
            }
            return dictionaryList;
        }
        List<Dictionary> dictionaryList = ConfigurationManager.getDictionaryMap().get(country);
        if (dictionaryList == null) {
            dictionaryList = new ArrayList<Dictionary>();
        }
        if (countryFilter) {
            dictionaryList = this.filterSubSupportedCountry(localCountry, dictionaryList);
        }
        if (!countriesSupportingUDs.contains(country)) {
            if (countryFilter) {
                this.myDictMap.put(localCountry, dictionaryList);
            } else {
                this.myDictMap.put(country, dictionaryList);
            }
            return dictionaryList;
        }
        if (this.internalGeocoder != null) {
            this.internalGeocoder.getUpdatedDictionaries(country, dictionaryList, countryFilter, localCountry, this.myDictMap);
        }
        return dictionaryList;
    }

    private List<Dictionary> addSubSupportedCountries(Set<String> countries, List<Dictionary> dictionaryList) {
        ArrayList<Dictionary> dictionaries = new ArrayList<Dictionary>();
        for (Dictionary dictionary : dictionaryList) {
            Set<CountrySupport> supports = dictionary.getCountrySupportInformation();
            if (supports != null) {
                for (CountrySupport support : supports) {
                    support.setSupportedCountries(countries);
                }
            }
            dictionary.setCountrySupportInformation(supports);
            dictionaries.add(dictionary);
        }
        return dictionaries;
    }

    private List<Dictionary> filterSubSupportedCountry(String country, List<Dictionary> dictionaryList) {
        ArrayList<Dictionary> dictionaries = new ArrayList<Dictionary>();
        for (Dictionary dictionary : dictionaryList) {
            Set<CountrySupport> supports = dictionary.getCountrySupportInformation();
            if (supports != null) {
                for (CountrySupport support : supports) {
                    HashSet<String> countries = new HashSet<String>(1);
                    countries.add(country);
                    support.setSupportedCountries(countries);
                }
            }
            dictionary.setCountrySupportInformation(supports);
            dictionaries.add(dictionary);
        }
        return dictionaries;
    }

    @Override
    public CapabilitiesResponse getCapabilities() throws GeocodingException {
        return new GeocodeCapabilitiesResponse(this.internalGeocoder);
    }

    @Override
    public CapabilitiesResponse getCapabilities(String country, String operation) throws GeocodingException {
        country = GeocodeUtils.getISO3Country(country);
        return new GeocodeCapabilitiesResponse(this.internalGeocoder, country, operation);
    }

    @Override
    public CapabilitiesResponse getCapabilities(String country) throws GeocodingException {
        country = GeocodeUtils.getISO3Country(country);
        return new GeocodeCapabilitiesResponse(this.internalGeocoder, country, null);
    }

    private IPoint convertCoordSys(IPoint point) {
        DirectPosition xformDest = new DirectPosition(point.getDirectPosition());
        CoordSys sys = CoordSysConstants.longLatWGS84;
        if (point.getSpatialInfo() != null) {
            sys = point.getCoordSys();
        }
        if (!CoordSysConstants.longLatWGS84.equivalent(sys) && !CoordSysConstants.longLatNAD83.equivalent(sys)) {
            CoordTransform xform = new CoordTransform(sys, CoordSysConstants.longLatNAD83);
            xform.transform(point.getDirectPosition(), xformDest);
        }
        return new Point(SPATIAL_INFO, xformDest);
    }

    private Response geocodeGeoStan(GeocodeType type, Address address, Preferences preferences) throws GeocodingException {
        if (this.geocoderGeoStan == null) {
            throw new GeocodingException("Data not available", ExceptionCode.COUNTRY_NOT_SUPPORTED);
        }
        if (preferences == null) {
            preferences = this.getLocalOverrides(preferences, address.getCountry());
        } else {
            String dbOrder = this.buildGeoStanDbOrder(preferences = this.getLocalOverrides(preferences, address.getCountry()));
            if (dbOrder != null && !dbOrder.isEmpty()) {
                preferences.addCustomPreference("FIND_DB_ORDER", dbOrder);
            }
        }
        if (this.geocoderGeoStan.isPoolOpen()) {
            return this.geocoderGeoStan.geocode(type, address, preferences);
        }
        throw new GeocodingException("The GeoStan pool is closed.", ExceptionCode.GEOSTAN_FATAL_EXCEPTION);
    }

    private String buildGeoStanDbOrder(Preferences preferences) {
        if (preferences.getCustomPreferences().containsKey("FIND_DB_ORDER") || preferences.getCustomPreferences().containsKey("USA.FIND_DB_ORDER")) {
            return null;
        }
        List<String> dictList = preferences.getPreferredDictionaryOrder();
        if (dictList != null && !dictList.isEmpty()) {
            boolean countryStarted = StringUtils.isNumeric((CharSequence)dictList.get(0));
            StringBuilder orderString = new StringBuilder();
            for (String dictIdx : dictList) {
                if (!countryStarted) {
                    if (!dictIdx.equalsIgnoreCase("USA")) continue;
                    countryStarted = true;
                    continue;
                }
                if (!StringUtils.isNumeric((CharSequence)dictIdx)) break;
                if (orderString.length() != 0) {
                    orderString.append(';');
                }
                orderString.append(dictIdx);
            }
            if (!orderString.toString().isEmpty()) {
                return orderString.toString();
            }
        }
        String value = null;
        String testKey = "USA.KEY_CUSTOM_DICTIONARY_USAGE";
        if (preferences.getCustomPreferences().containsKey("KEY_CUSTOM_DICTIONARY_USAGE")) {
            value = preferences.getCustomPreferences().get("KEY_CUSTOM_DICTIONARY_USAGE");
        } else if (preferences.getCustomPreferences().containsKey(testKey)) {
            value = preferences.getCustomPreferences().get(testKey);
        }
        if (value != null) {
            int numDicts = this.geoStanConfiguredDictionaries.size();
            StringBuilder customIdxString = new StringBuilder();
            StringBuilder standardIdxString = new StringBuilder();
            for (int i = 0; i < numDicts; ++i) {
                if (this.geoStanConfiguredDictionaries.get(i).isCustomDictionary()) {
                    if (customIdxString.length() > 0) {
                        customIdxString.append(";");
                    }
                    customIdxString.append(i);
                    continue;
                }
                if (standardIdxString.length() > 0) {
                    standardIdxString.append(";");
                }
                standardIdxString.append(i);
            }
            if ("USE_STANDARD_DICTIONARIES_ONLY".equalsIgnoreCase(value)) {
                if (standardIdxString.length() > 0) {
                    return standardIdxString.toString();
                }
            } else if ("USE_CUSTOM_DICTIONARIES_ONLY".equalsIgnoreCase(value)) {
                if (customIdxString.length() > 0) {
                    return customIdxString.toString();
                }
            } else {
                if ("PREFER_STANDARD_DICTIONARIES".equalsIgnoreCase(value)) {
                    if (customIdxString.length() > 0) {
                        if (standardIdxString.length() > 0) {
                            standardIdxString.append(";");
                        }
                        standardIdxString.append((CharSequence)customIdxString);
                    }
                    return standardIdxString.toString();
                }
                if ("PREFER_CUSTOM_DICTIONARIES".equalsIgnoreCase(value)) {
                    if (standardIdxString.length() > 0) {
                        if (customIdxString.length() > 0) {
                            customIdxString.append(";");
                        }
                        customIdxString.append((CharSequence)standardIdxString);
                    }
                    return customIdxString.toString();
                }
            }
        }
        return null;
    }

    private Response reverseGeocodeGeoStan(IPoint point, Preferences preferences) throws GeocodingException {
        if (preferences == null) {
            preferences = this.getLocalOverrides(preferences, "USA");
        } else {
            String dbOrder = this.buildGeoStanDbOrder(preferences = this.getLocalOverrides(preferences, "USA"));
            if (dbOrder != null && !dbOrder.isEmpty()) {
                GeocoderPreferences copy = new GeocoderPreferences(preferences);
                copy.addCustomPreference("FIND_DB_ORDER", dbOrder);
                preferences = copy;
            }
        }
        if (this.geocoderGeoStan == null && !preferences.isFallbackToGeographic() && !preferences.isFallbackToPostal()) {
            throw new GeocodingException("Data not available", ExceptionCode.COUNTRY_NOT_SUPPORTED);
        }
        if (this.geocoderGeoStan != null && this.geocoderGeoStan.isPoolOpen()) {
            return this.geocoderGeoStan.reverseGeocode(point, preferences);
        }
        if (!preferences.isFallbackToGeographic() && !preferences.isFallbackToPostal()) {
            throw new GeocodingException("The GeoStan pool is closed.", ExceptionCode.GEOSTAN_FATAL_EXCEPTION);
        }
        return null;
    }

    protected Preferences getLocalOverrides(Preferences original, String country) {
        if (original == null) {
            original = DefaultPreferencesProvider.getInstance().getDefaultPreferences();
        }
        OverridablePreferences overridablePreferences = new OverridablePreferences(original);
        return overridablePreferences.buildPreferenceOverridesForCountry(country);
    }

    public static Path getConfigurationLocation() {
        return Paths.get(configuration.getConfigLocation(), new String[0]);
    }

    public static Path getResourceLocation() {
        return Paths.get(configuration.getResLocation(), new String[0]);
    }

    protected void checkValidDictionarySearchFormat(Preferences preferences) throws GeocodingException {
        if (preferences == null || preferences.getPreferredDictionaryOrder() == null || preferences.getPreferredDictionaryOrder().isEmpty()) {
            return;
        }
        String first = preferences.getPreferredDictionaryOrder().get(0);
        if (ISO3_WORLD.equalsIgnoreCase(first) || ISO3166.findCountryByISO3((String)first) != null) {
            return;
        }
        throw new GeocodingException("No country mapping for preferred dictionary order found: " + first, ExceptionCode.REQUIRED_PARAMETER_MISSING);
    }

    protected static boolean inUsa(String country) {
        return country != null && geoStanCountries.contains(country.toUpperCase());
    }

    private boolean shouldFallbackToWorld(Preferences preferences) {
        Map<String, String> customOptions;
        boolean shouldFallbackToWorld = false;
        if (null != preferences && null != (customOptions = preferences.getCustomPreferences())) {
            shouldFallbackToWorld = this.dataManagerSettingsMapper.isCountryConfigured(ISO3_WORLD) && "True".equalsIgnoreCase(customOptions.get("FALLBACK_TO_WORLD"));
        }
        return shouldFallbackToWorld;
    }

    private String getCountryWithWorldFallback(String country, Preferences preferences) {
        boolean isCountryConfigured = true;
        isCountryConfigured = "USA".equalsIgnoreCase(country) ? this.geocoderGeoStan != null : this.dataManagerSettingsMapper.isCountryConfigured(country);
        if (!isCountryConfigured && this.shouldFallbackToWorld(preferences)) {
            country = ISO3_WORLD;
        }
        return country;
    }

    protected void trackOriginalCountry(Address address, String country) {
        if (ISO3_WORLD.equals(country) && !ISO3_WORLD.equals(address.getCountry())) {
            HashMap<String, String> customFields = address.getCustomFields() != null ? address.getCustomFields() : new HashMap<String, String>();
            customFields.put("ALTERNATE_COUNTRY", address.getCountry());
            address.setCustomFields(customFields);
        }
    }

    @Override
    public Preferences getDefaultPreferences() {
        return DefaultPreferencesProvider.getInstance().getDefaultPreferences();
    }

    protected Response geocodeNoCountry(GeocodeType type, Address address, Preferences preferences) throws GeocodingException {
        Properties properties;
        boolean noInputPrefs;
        boolean bl = noInputPrefs = preferences == null;
        if (noInputPrefs) {
            preferences = this.getDefaultPreferences();
        }
        GeocoderPreferences workingPreferences = new GeocoderPreferences(preferences);
        workingPreferences.setFallbackToPostal(false);
        if (this.internalGeocoder != null) {
            properties = this.dataManagerSettingsMapper.getCountryPropMap().get("CORE_SETTINGS");
            MultiCountryBasicSettings settings = new MultiCountryBasicSettings(properties);
            if (!noInputPrefs) {
                settings.adjustForOverrides(workingPreferences.getCustomPreferences());
            }
            if (!settings.isCountryFallbackEnabled()) {
                ISO3166 iso;
                String test = settings.getDefaultGeocoderCountryCode();
                if (StringUtils.isEmpty((CharSequence)address.getCountry())) {
                    if (settings.isReplaceNullInputCountryWithDefault()) {
                        if ("USA".equalsIgnoreCase(test)) {
                            return this.geocodeGeoStan(type, address, workingPreferences);
                        }
                        return this.internalGeocoder.geocodeInternational(type, address, workingPreferences, this);
                    }
                } else if (settings.isUseDefaultForAnyUnavailableCountry()) {
                    if ("USA".equalsIgnoreCase(test)) {
                        return this.geocodeGeoStan(type, address, workingPreferences);
                    }
                    return this.internalGeocoder.geocodeInternational(type, address, workingPreferences, this);
                }
                if ((iso = ISO3166.findCountryByISO3((String)address.getCountry())) != null) {
                    return this.internalGeocoder.geocodeInternational(type, address, workingPreferences, this);
                }
                return new GeocoderResponse();
            }
            if (settings.getExcludedCountriesSet().contains("USA")) {
                return this.internalGeocoder.geocodeInternational(type, address, workingPreferences, this);
            }
        } else {
            boolean countryFallbackEnabled;
            properties = this.dataManagerSettingsMapper.getCountryPropMap().get("CORE_SETTINGS");
            if (properties != null ? !(countryFallbackEnabled = "true".equalsIgnoreCase(properties.getProperty("COUNTRY_FALLBACK_ENABLED", "false"))) : !this.dataManagerSettingsMapper.isCountryConfigured(address.getCountry())) {
                throw new GeocodingException("Data not available", ExceptionCode.COUNTRY_NOT_SUPPORTED);
            }
        }
        Response usaResponse = null;
        if (this.geocoderGeoStan != null) {
            try {
                usaResponse = this.geocodeGeoStan(type, address, workingPreferences);
            }
            catch (GeocodingException countryFallbackEnabled) {
                // empty catch block
            }
        }
        if (usaResponse == null || usaResponse.getCandidates().size() == 0 && this.internalGeocoder != null) {
            workingPreferences.getReturnFieldsDescriptor().getKeysOfCustomFieldsToReturn().add("CITYRANK");
            return this.internalGeocoder.geocodeInternational(type, address, workingPreferences, this);
        }
        workingPreferences.getReturnFieldsDescriptor().getKeysOfCustomFieldsToReturn().add("CITYRANK");
        Response intlResponse = null;
        if (this.internalGeocoder != null) {
            intlResponse = this.internalGeocoder.geocodeInternational(type, address, workingPreferences, this);
        }
        if (intlResponse == null || intlResponse.getCandidates().size() == 0) {
            return usaResponse;
        }
        return this.mergeAllCandidates(usaResponse, intlResponse, workingPreferences);
    }

    protected Response mergeAllCandidates(Response usaCandidateResponse, Response intlCandidateResponse, Preferences preferences) throws GeocodingException {
        int intlIndex = 0;
        Candidate usaCand = usaCandidateResponse.getCandidates().get(0);
        Candidate intlCand = intlCandidateResponse.getCandidates().get(intlIndex);
        int totalSize = preferences.getMaxReturnedCandidates();
        if (totalSize == 1) {
            if (this.comparator.compare(usaCand, intlCand) >= 0) {
                return intlCandidateResponse;
            }
            return usaCandidateResponse;
        }
        int usaIndex = 0;
        ArrayList<Candidate> mergedList = new ArrayList<Candidate>();
        while (intlIndex < intlCandidateResponse.getCandidates().size() && (totalSize < 0 || mergedList.size() < totalSize)) {
            if (this.comparator.compare(usaCand, intlCand) >= 0) {
                mergedList.add(intlCand);
                if (++intlIndex == intlCandidateResponse.getCandidates().size()) break;
                intlCand = intlCandidateResponse.getCandidates().get(intlIndex);
                continue;
            }
            mergedList.add(usaCand);
            if (++usaIndex == usaCandidateResponse.getCandidates().size()) break;
            usaCand = usaCandidateResponse.getCandidates().get(usaIndex);
        }
        while (totalSize < 0 || mergedList.size() < totalSize) {
            if (usaIndex < usaCandidateResponse.getCandidates().size()) {
                mergedList.add(usaCandidateResponse.getCandidates().get(usaIndex));
                ++usaIndex;
                continue;
            }
            if (intlIndex >= intlCandidateResponse.getCandidates().size()) break;
            mergedList.add(intlCandidateResponse.getCandidates().get(intlIndex));
            ++intlIndex;
        }
        GeocoderResponse response = new GeocoderResponse();
        response.setCandidates(mergedList);
        response.setTotalMatches(usaCandidateResponse.getTotalMatches() + intlCandidateResponse.getTotalMatches());
        response.setTotalPossibleCandidates(usaCandidateResponse.getTotalPossibleCandidates() + intlCandidateResponse.getTotalPossibleCandidates());
        return response;
    }

    protected boolean findCountryInAddress(Address address, Preferences preferences) {
        String post = address.getAddressLastLine();
        if (StringUtils.isEmpty((CharSequence)address.getMainAddressLine()) && StringUtils.isEmpty((CharSequence)post)) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)address.getAreaName1()) && StringUtils.isEmpty((CharSequence)address.getAreaName2()) && StringUtils.isEmpty((CharSequence)address.getAreaName3()) && StringUtils.isEmpty((CharSequence)address.getAreaName4()) && StringUtils.isEmpty((CharSequence)address.getPostCode1())) {
            CountryTokenSplitter cs = null;
            if (this.internalGeocoder != null) {
                Properties properties = this.dataManagerSettingsMapper.getCountryPropMap().get("CORE_SETTINGS");
                MultiCountryBasicSettings settings = new MultiCountryBasicSettings(properties);
                if (preferences != null) {
                    settings.adjustForOverrides(preferences.getCustomPreferences());
                }
                if (!StringUtils.isEmpty((CharSequence)post)) {
                    if (settings.isCheckLastLineForCountryCode()) {
                        cs = new CountryTokenSplitter(post);
                    }
                } else if (settings.isCheckSingleLineForCountryCode()) {
                    cs = new CountryTokenSplitter(address.getMainAddressLine());
                }
                if (cs != null && cs.foundCountry) {
                    String countryName = cs.countryCode;
                    address.setCountry(countryName);
                    return true;
                }
            } else {
                cs = new CountryTokenSplitter(address.getMainAddressLine());
                if (cs.foundCountry) {
                    String countryName = cs.countryCode;
                    address.setCountry(countryName);
                    return true;
                }
            }
        }
        return false;
    }

    public InternalGeocoder getInternalGeocoder() {
        return this.internalGeocoder;
    }

    protected void resolveConfiguration(GeocodingConfiguration config) throws GeocodingException {
        if (config == null) {
            throw new GeocodingException("Invalid configuration", ExceptionCode.INVALID_CONFIGURATION);
        }
        try {
            if (!this.isValidPath(configuration.getConfigLocation())) {
                configuration.setConfigLocation((String)config.getConfig("config.location"));
            }
            if (!this.isValidPath(configuration.getResLocation())) {
                configuration.setResLocation((String)config.getConfig("res.location"));
            }
        }
        catch (Exception e) {
            throw new GeocodingException("Invalid configuration", ExceptionCode.INVALID_CONFIGURATION);
        }
    }

    private boolean isValidPath(String path) {
        File file;
        return StringUtils.isNotEmpty((CharSequence)path) && (file = Paths.get(path, new String[0]).toFile()).exists();
    }

    @Override
    public Response keyLookup(KeyType type, Key key, Preferences preferences) throws GeocodingException {
        Response response = new GeocoderResponse();
        if (key != null) {
            String country = GeocodeUtils.getISO3Country(key.getCountry());
            key.setCountry(country);
            if (!StringUtils.isEmpty((CharSequence)country) && country.equalsIgnoreCase("USA")) {
                if (this.geocoderGeoStan == null) {
                    throw new GeocodingException("Data not available", ExceptionCode.COUNTRY_NOT_SUPPORTED);
                }
                response = this.geocoderGeoStan.keyLookup(type, key.getValue(), preferences);
            } else {
                response = this.internalGeocoder.keyLookup(type, key, preferences);
            }
        }
        return response;
    }

    @Override
    public List<Response> keyLookupMultiple(KeyType type, List<Key> keys, Preferences preferences) throws GeocodingException {
        ArrayList<Response> responses = new ArrayList<Response>();
        if (type == null) {
            throw new GeocodingException("Invalid key type", ExceptionCode.INVALID_CLIENT_INPUT);
        }
        for (Key key : keys) {
            Response response = new GeocoderResponse();
            try {
                response = this.keyLookup(type, key, preferences);
            }
            catch (GeocodingException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            responses.add(response);
        }
        return responses;
    }

    protected String getCountryFromMatchMode(String country, Preferences preferences) {
        if ((StringUtils.isEmpty((CharSequence)country) || ISO3_WORLD.equalsIgnoreCase(country)) && preferences != null && USAMatchMode.CASS.equals(preferences.getMatchMode())) {
            return "USA";
        }
        return country;
    }

    static {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("propertiesBeans.xml");
        configuration = (ApplicationConfiguration)context.getBean("applicationConfigurationBean");
        HashSet<String> temps = new HashSet<String>();
        temps.add("AUS");
        temps.add("CAN");
        temps.add("CHE");
        temps.add("DEU");
        temps.add("ESP");
        temps.add("AND");
        temps.add("FIN");
        temps.add("FRA");
        temps.add("REU");
        temps.add("MYT");
        temps.add("GLP");
        temps.add("GUF");
        temps.add("MTQ");
        temps.add("MCO");
        temps.add("GBR");
        temps.add("NZL");
        temps.add("POL");
        temps.add("PRT");
        temps.add("SWE");
        temps.add("USA");
        countriesSupportingUDs = Collections.unmodifiableSet(temps);
        temps = new HashSet();
        temps.add("USA");
        temps.add("PRI");
        temps.add("GUM");
        temps.add("ASM");
        temps.add("MNP");
        temps.add("PLW");
        temps.add("VIR");
        geoStanCountries = Collections.unmodifiableSet(temps);
    }
}

