/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode;

import com.google.common.base.Objects;
import com.mapinfo.geocode.GeocodeMatchFields;
import com.mapinfo.geocode.ReturnFields;
import com.mapinfo.geocode.api.BoundingBox;
import com.mapinfo.geocode.api.DefaultMatchMode;
import com.mapinfo.geocode.api.DistanceUnit;
import com.mapinfo.geocode.api.FieldsMatching;
import com.mapinfo.geocode.api.MatchMode;
import com.mapinfo.geocode.api.Preferences;
import com.mapinfo.geocode.api.ReturnFieldsDescriptor;
import com.mapinfo.midev.geometry.IPoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GeocoderPreferences
implements Preferences {
    static final boolean DEFAULT_RETURN_CLOSE_CANDIDATES_ONLY = true;
    public static final boolean DEFAULT_FALL_BACK_TO_GEOGRAPHIC = true;
    public static final boolean DEFAULT_FALL_BACK_TO_POSTAL = true;
    public static final int DEFAULT_MAX_RETURN_CANDIDATES = 1;
    public static final int DEFAULT_MAX_RETURN_RANGES = 1;
    public static final int DEFAULT_STREET_OFFSET = 7;
    public static final int DEFAULT_CORNER_OFFSET = 7;
    public static final int DEFAULT_DISTANCE = 150;
    public static final MatchMode DEFAULT_MATCHMODE = DefaultMatchMode.UNSPECIFIED;
    public static final Locale DEFAULT_LOCALE = Locale.getDefault();
    public static final DistanceUnit DEFAULT_STREET_OFFSET_UNITS = DistanceUnit.METERS;
    public static final DistanceUnit DEFAULT_CORNER_OFFSET_UNITS = DistanceUnit.METERS;
    public static final DistanceUnit DEFAULT_DISTANCE_UNITS = DistanceUnit.METERS;
    public static final String DEFAULT_CLIENT_COORD_SYS_NAME = "epsg:4326";
    public static final String FALLBACK_TO_WORLD = "FALLBACK_TO_WORLD";
    private int maxReturnCandidates = 1;
    private int maxReturnRanges = 1;
    private boolean fallbackToGeographic = true;
    private boolean fallbackToPostal = true;
    private FieldsMatching matchingFields = new GeocodeMatchFields();
    private MatchMode matchMode = DEFAULT_MATCHMODE;
    private Locale clientLocale = DEFAULT_LOCALE;
    private double streetOffset = 7.0;
    private double cornerOffset = 7.0;
    private double distance = 150.0;
    private DistanceUnit streetOffsetUnits = DEFAULT_STREET_OFFSET_UNITS;
    private DistanceUnit cornerOffsetUnits = DEFAULT_CORNER_OFFSET_UNITS;
    private DistanceUnit LinearUnits = DEFAULT_DISTANCE_UNITS;
    private final List<String> preferredDictionaryOrder = new ArrayList<String>();
    private String clientCoordSysName = "epsg:4326";
    private int maxReturnedRangeUnits = 1;
    private boolean returnAllCandidateInfo;
    private ReturnFieldsDescriptor returnFieldsDescriptor = new ReturnFields();
    private Map<String, String> customPreferences = new HashMap<String, String>();
    private BoundingBox boundingBox;
    private IPoint origin;

    public GeocoderPreferences() {
    }

    public GeocoderPreferences(Preferences copyFrom) {
        Map<String, String> custom;
        List<String> order;
        ReturnFieldsDescriptor returnFields;
        this.setMaxReturnedCandidates(copyFrom.getMaxReturnedCandidates());
        this.setMaxReturnedRanges(copyFrom.getMaxReturnedRanges());
        this.setMaxReturnedRangeUnits(copyFrom.getMaxReturnedRangeUnits());
        this.setReturnAllCandidateInfo(copyFrom.isReturnAllCandidateInfo());
        this.setFallbackToPostal(copyFrom.isFallbackToPostal());
        this.setFallbackToGeographic(copyFrom.isFallbackToGeographic());
        this.setStreetOffset(copyFrom.getStreetOffset());
        this.setCornerOffset(copyFrom.getCornerOffset());
        this.setDistance(copyFrom.getDistance());
        this.setStreetOffsetUnits(copyFrom.getStreetOffsetUnits());
        this.setCornerOffsetUnits(copyFrom.getCornerOffsetUnits());
        this.setDistanceUnits(copyFrom.getDistanceUnits());
        this.setBoundingBox(copyFrom.getBoundingBox());
        this.setClientCoordSysName(copyFrom.getClientCoordSysName());
        this.setMatchMode(copyFrom.getMatchMode());
        this.setClientLocale(copyFrom.getClientLocale());
        this.setPoint(copyFrom.getPoint());
        FieldsMatching fields = copyFrom.getMustMatchFields();
        if (fields != null) {
            this.matchingFields = new GeocodeMatchFields(fields);
        }
        if ((returnFields = copyFrom.getReturnFieldsDescriptor()) != null) {
            this.returnFieldsDescriptor = new ReturnFields(copyFrom.getReturnFieldsDescriptor());
        }
        if ((order = copyFrom.getPreferredDictionaryOrder()) != null && !order.isEmpty()) {
            this.preferredDictionaryOrder.addAll(order);
        }
        if ((custom = copyFrom.getCustomPreferences()) != null && !custom.isEmpty()) {
            this.customPreferences.putAll(custom);
        }
    }

    @Override
    public Locale getClientLocale() {
        return this.clientLocale;
    }

    @Override
    public String getClientCoordSysName() {
        return this.clientCoordSysName;
    }

    @Override
    public int getMaxReturnedRangeUnits() {
        return this.maxReturnedRangeUnits;
    }

    @Override
    public double getStreetOffset() {
        return this.streetOffset;
    }

    @Override
    public double getCornerOffset() {
        return this.cornerOffset;
    }

    @Override
    public DistanceUnit getStreetOffsetUnits() {
        return this.streetOffsetUnits;
    }

    @Override
    public DistanceUnit getCornerOffsetUnits() {
        return this.cornerOffsetUnits;
    }

    @Override
    public boolean isReturnAllCandidateInfo() {
        return this.returnAllCandidateInfo;
    }

    @Override
    public void setClientLocale(Locale locale) {
        this.clientLocale = locale;
    }

    @Override
    public void setClientCoordSysName(String name) {
        this.clientCoordSysName = name;
    }

    @Override
    public void setMaxReturnedRangeUnits(int count) {
        this.maxReturnedRangeUnits = count;
    }

    @Override
    public void setStreetOffset(double offset) {
        this.streetOffset = offset;
    }

    @Override
    public void setCornerOffset(double offset) {
        this.cornerOffset = offset;
    }

    @Override
    public void setStreetOffsetUnits(DistanceUnit units) {
        this.streetOffsetUnits = units;
    }

    @Override
    public void setCornerOffsetUnits(DistanceUnit units) {
        this.cornerOffsetUnits = units;
    }

    @Override
    public void setReturnAllCandidateInfo(boolean bAll) {
        this.returnAllCandidateInfo = bAll;
    }

    @Override
    public ReturnFieldsDescriptor getReturnFieldsDescriptor() {
        return this.returnFieldsDescriptor;
    }

    @Override
    public void setReturnFieldsDescriptor(ReturnFieldsDescriptor descriptor) {
        this.returnFieldsDescriptor = descriptor;
    }

    @Override
    public List<String> getPreferredDictionaryOrder() {
        return this.preferredDictionaryOrder;
    }

    @Override
    public void setPreferredDictionaryOrder(List<String> orderedList) {
        this.preferredDictionaryOrder.clear();
        if (orderedList != null) {
            this.preferredDictionaryOrder.addAll(orderedList);
        }
    }

    @Override
    public Map<String, String> getCustomPreferences() {
        return this.customPreferences;
    }

    @Override
    public void addCustomPreference(String key, String value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            this.customPreferences.remove(key);
            return;
        }
        this.customPreferences.put(key, value);
    }

    @Override
    public void setCustomPreferences(Map<String, String> customPreferences) {
        this.customPreferences = customPreferences;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("clientLocale", (Object)this.clientLocale).add("streetOffset", this.streetOffset).add("cornerOffset", this.cornerOffset).add("streetOffsetUnits", (Object)this.streetOffsetUnits).add("cornerOffsetUnits", (Object)this.cornerOffsetUnits).add("preferredDictionaryOrder", this.preferredDictionaryOrder).add("clientCoordSysName", (Object)this.clientCoordSysName).add("maxReturnedRangeUnits", this.maxReturnedRangeUnits).add("returnAllCandidateInfo", this.returnAllCandidateInfo).add("returnFieldsDescriptor", (Object)this.returnFieldsDescriptor).add("customPreferences", this.customPreferences).add("maxReturnCandidates", this.maxReturnCandidates).toString();
    }

    @Override
    public int getMaxReturnedRanges() {
        return this.maxReturnRanges;
    }

    @Override
    public boolean isFallbackToGeographic() {
        return this.fallbackToGeographic;
    }

    @Override
    public boolean isFallbackToPostal() {
        return this.fallbackToPostal;
    }

    @Override
    public int getMaxReturnedCandidates() {
        return this.maxReturnCandidates;
    }

    @Override
    public FieldsMatching getMustMatchFields() {
        return this.matchingFields;
    }

    @Override
    public void setMustMatchFields(FieldsMatching mustMatchFields) {
        this.matchingFields = mustMatchFields;
    }

    @Override
    public void setMaxReturnedRanges(int count) {
        this.maxReturnRanges = count;
    }

    @Override
    public void setFallbackToGeographic(boolean bFallback) {
        this.fallbackToGeographic = bFallback;
    }

    @Override
    public void setFallbackToPostal(boolean bFallback) {
        this.fallbackToPostal = bFallback;
    }

    @Override
    public void setMaxReturnedCandidates(int max) {
        this.maxReturnCandidates = max;
    }

    @Override
    public MatchMode getMatchMode() {
        return this.matchMode;
    }

    @Override
    public void setMatchMode(MatchMode mode) {
        this.matchMode = mode;
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public void setPoint(IPoint point) {
        this.origin = point;
    }

    @Override
    public IPoint getPoint() {
        return this.origin;
    }

    @Override
    public void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    @Override
    public double getDistance() {
        return this.distance;
    }

    @Override
    public void setDistance(double distance) {
        this.distance = distance;
    }

    @Override
    public DistanceUnit getDistanceUnits() {
        return this.LinearUnits;
    }

    @Override
    public void setDistanceUnits(DistanceUnit LinearUnits) {
        this.LinearUnits = LinearUnits;
    }

    @Override
    public String getClientLocaleString() {
        Locale locale = this.getClientLocale();
        if (locale != null) {
            return this.getClientLocale().toString();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeocoderPreferences)) {
            return false;
        }
        GeocoderPreferences that = (GeocoderPreferences)o;
        if (this.maxReturnCandidates != that.maxReturnCandidates) {
            return false;
        }
        if (this.maxReturnRanges != that.maxReturnRanges) {
            return false;
        }
        if (this.isFallbackToGeographic() != that.isFallbackToGeographic()) {
            return false;
        }
        if (this.isFallbackToPostal() != that.isFallbackToPostal()) {
            return false;
        }
        if (Double.compare(that.getStreetOffset(), this.getStreetOffset()) != 0) {
            return false;
        }
        if (Double.compare(that.getCornerOffset(), this.getCornerOffset()) != 0) {
            return false;
        }
        if (Double.compare(that.getDistance(), this.getDistance()) != 0) {
            return false;
        }
        if (this.getMaxReturnedRangeUnits() != that.getMaxReturnedRangeUnits()) {
            return false;
        }
        if (this.isReturnAllCandidateInfo() != that.isReturnAllCandidateInfo()) {
            return false;
        }
        if (this.matchingFields != null ? !this.matchingFields.equals(that.matchingFields) : that.matchingFields != null) {
            return false;
        }
        if (this.getMatchMode() != null ? !this.getMatchMode().equals(that.getMatchMode()) : that.getMatchMode() != null) {
            return false;
        }
        if (this.getClientLocale() != null ? !this.getClientLocale().equals(that.getClientLocale()) : that.getClientLocale() != null) {
            return false;
        }
        if (this.getStreetOffsetUnits() != that.getStreetOffsetUnits()) {
            return false;
        }
        if (this.getCornerOffsetUnits() != that.getCornerOffsetUnits()) {
            return false;
        }
        if (this.LinearUnits != that.LinearUnits) {
            return false;
        }
        if (this.getPreferredDictionaryOrder() != null ? !this.getPreferredDictionaryOrder().equals(that.getPreferredDictionaryOrder()) : that.getPreferredDictionaryOrder() != null) {
            return false;
        }
        if (this.getClientCoordSysName() != null ? !this.getClientCoordSysName().equals(that.getClientCoordSysName()) : that.getClientCoordSysName() != null) {
            return false;
        }
        if (this.getReturnFieldsDescriptor() != null ? !this.getReturnFieldsDescriptor().equals(that.getReturnFieldsDescriptor()) : that.getReturnFieldsDescriptor() != null) {
            return false;
        }
        if (this.getCustomPreferences() != null ? !this.getCustomPreferences().equals(that.getCustomPreferences()) : that.getCustomPreferences() != null) {
            return false;
        }
        if (this.getBoundingBox() != null ? !this.getBoundingBox().equals(that.getBoundingBox()) : that.getBoundingBox() != null) {
            return false;
        }
        return !(this.origin == null ? that.origin != null : !this.origin.equals(that.origin));
    }

    public int hashCode() {
        int result = this.maxReturnCandidates;
        result = 31 * result + this.maxReturnRanges;
        result = 31 * result + (this.isFallbackToGeographic() ? 1 : 0);
        result = 31 * result + (this.isFallbackToPostal() ? 1 : 0);
        result = 31 * result + (this.matchingFields != null ? this.matchingFields.hashCode() : 0);
        result = 31 * result + (this.getMatchMode() != null ? this.getMatchMode().hashCode() : 0);
        result = 31 * result + (this.getClientLocale() != null ? this.getClientLocale().hashCode() : 0);
        long temp = Double.doubleToLongBits(this.getStreetOffset());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.getCornerOffset());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.getDistance());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.getStreetOffsetUnits() != null ? this.getStreetOffsetUnits().hashCode() : 0);
        result = 31 * result + (this.getCornerOffsetUnits() != null ? this.getCornerOffsetUnits().hashCode() : 0);
        result = 31 * result + (this.LinearUnits != null ? this.LinearUnits.hashCode() : 0);
        result = 31 * result + (this.getPreferredDictionaryOrder() != null ? this.getPreferredDictionaryOrder().hashCode() : 0);
        result = 31 * result + (this.getClientCoordSysName() != null ? this.getClientCoordSysName().hashCode() : 0);
        result = 31 * result + this.getMaxReturnedRangeUnits();
        result = 31 * result + (this.isReturnAllCandidateInfo() ? 1 : 0);
        result = 31 * result + (this.getReturnFieldsDescriptor() != null ? this.getReturnFieldsDescriptor().hashCode() : 0);
        result = 31 * result + (this.getCustomPreferences() != null ? this.getCustomPreferences().hashCode() : 0);
        result = 31 * result + (this.getBoundingBox() != null ? this.getBoundingBox().hashCode() : 0);
        result = 31 * result + (this.origin != null ? this.origin.hashCode() : 0);
        return result;
    }
}

