/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode;

import com.google.common.base.Objects;
import com.mapinfo.geocode.Pair;
import com.mapinfo.geocode.api.InputParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InputParameter
implements InputParam {
    private String m_name;
    private String m_desc;
    private String m_type;
    private String m_defaultValue;
    private List<Pair<String, String>> m_allowedValuesWithDescriptions;
    private String m_lowBoundary;
    private String m_highBoundary;

    public InputParameter() {
    }

    public InputParameter(InputParam copy) {
        if (copy != null) {
            this.m_name = copy.getName();
            this.m_desc = copy.getDescription();
            this.m_type = copy.getType();
            this.m_defaultValue = copy.getDefaultValue();
            this.m_lowBoundary = copy.getLowBoundary();
            this.m_highBoundary = copy.getHighBoundary();
            List<Pair<String, String>> list = copy.getAllowedValuesWithDescriptions();
            if (list != null) {
                this.m_allowedValuesWithDescriptions = new ArrayList<Pair<String, String>>();
                for (Pair<String, String> pair : list) {
                    this.m_allowedValuesWithDescriptions.add(new Pair<String, String>(pair.getVal1(), pair.getVal2()));
                }
            }
        }
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public String getDescription() {
        return this.m_desc;
    }

    @Override
    public void setDescription(String desc) {
        this.m_desc = desc;
    }

    @Override
    public String getType() {
        return this.m_type;
    }

    @Override
    public void setType(String type) {
        this.m_type = type;
    }

    @Override
    public String getDefaultValue() {
        return this.m_defaultValue;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.m_defaultValue = defaultValue;
    }

    @Override
    public List<Pair<String, String>> getAllowedValuesWithDescriptions() {
        if (this.m_allowedValuesWithDescriptions == null) {
            return Collections.emptyList();
        }
        return this.m_allowedValuesWithDescriptions;
    }

    @Override
    public void setAllowedValuesWithDescriptions(List<Pair<String, String>> values) {
        this.m_allowedValuesWithDescriptions = values;
    }

    @Override
    public String getLowBoundary() {
        return this.m_lowBoundary;
    }

    @Override
    public void setLowBoundary(String lowBoundary) {
        this.m_lowBoundary = lowBoundary;
    }

    @Override
    public String getHighBoundary() {
        return this.m_highBoundary;
    }

    @Override
    public void setHighBoundary(String highBoundary) {
        this.m_highBoundary = highBoundary;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("m_name", (Object)this.m_name).add("m_desc", (Object)this.m_desc).add("m_type", (Object)this.m_type).add("m_defaultValue", (Object)this.m_defaultValue).add("m_allowedValuesWithDescriptions", this.m_allowedValuesWithDescriptions).add("m_lowBoundary", (Object)this.m_lowBoundary).add("m_highBoundary", (Object)this.m_highBoundary).toString();
    }
}

