/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode;

import com.mapinfo.geocode.CountrySupport;
import com.mapinfo.geocode.ExceptionCode;
import com.mapinfo.geocode.Geocoder;
import com.mapinfo.geocode.GeocoderDictionary;
import com.mapinfo.geocode.GeocoderResponse;
import com.mapinfo.geocode.GeocodingException;
import com.mapinfo.geocode.adapter.MapMarkerAdapter;
import com.mapinfo.geocode.api.Address;
import com.mapinfo.geocode.api.Dictionary;
import com.mapinfo.geocode.api.DistanceUnit;
import com.mapinfo.geocode.api.GeocodeType;
import com.mapinfo.geocode.api.Key;
import com.mapinfo.geocode.api.KeyType;
import com.mapinfo.geocode.api.Preferences;
import com.mapinfo.geocode.api.Response;
import com.mapinfo.geocode.util.ConfigurationManager;
import com.mapinfo.geocode.util.CountryBoundaryManager;
import com.mapinfo.geocode.util.DataManagerSettingsMapper;
import com.mapinfo.geocode.util.DefaultPreferencesProvider;
import com.mapinfo.geocode.util.OverridablePreferences;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.common.DictionarySearchOrder;
import com.mapinfo.mapmarker.common.IDictionarySearchOrder;
import com.mapinfo.mapmarker.user.ClientGeocodeResponse;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.MMJEngine;
import com.mapinfo.mapmarker.user.MapMarkerException;
import com.mapinfo.mapmarker.user.MapMarkerFatalException;
import com.mapinfo.mapmarker.user.MapMarkerJavaAPI;
import com.mapinfo.mapmarker.user.ReverseGeocodeAPI;
import com.mapinfo.mapmarker.user.ReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.user.ReverseGeocodeResponse;
import com.mapinfo.mapmarker.utils.MMCustomConfiguration;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalGeocoder {
    private static final Logger logger = LoggerFactory.getLogger(InternalGeocoder.class);
    private static MapMarkerJavaAPI geocoder;
    private final Set<DistanceUnit> metricUnits;
    DataManagerSettingsMapper dataManagerSettingsMapper;
    private static final int GEOCODE_TYPE_PID = 206;
    public static final String KEY_GNAF_PID = "GNAF_PID";

    public InternalGeocoder(String config, String res) {
        MMCustomConfiguration.setResLocation((String)res);
        MMCustomConfiguration.setConfigLocation((String)(config + "/"));
        HashSet<DistanceUnit> tempSet = new HashSet<DistanceUnit>();
        tempSet.add(DistanceUnit.METERS);
        tempSet.add(DistanceUnit.KILOMETERS);
        this.metricUnits = Collections.unmodifiableSet(tempSet);
        geocoder = new MMJEngine();
    }

    public void setDataManagerSettingsMapper(DataManagerSettingsMapper dataManagerSettingsMapper) {
        this.dataManagerSettingsMapper = dataManagerSettingsMapper;
    }

    public Response reverseGeocodeInternational(IPoint point, String country, Preferences preferences, Geocoder gga) throws GeocodingException {
        if (preferences == null) {
            preferences = DefaultPreferencesProvider.getInstance().getDefaultPreferences();
        }
        ReverseGeocodeAPI reverseGeocoder = (ReverseGeocodeAPI)geocoder;
        OverridablePreferences overridablePreferences = new OverridablePreferences(preferences);
        try {
            if (StringUtilities.isEmpty((String)country)) {
                ReverseGeocodeLocation reverseGeocodeLocation = MapMarkerAdapter.convertToMapMarkerLocation(point, preferences);
                return this.internalReverseGeocodeNoCountry(reverseGeocodeLocation, overridablePreferences, preferences, gga);
            }
            preferences = overridablePreferences.buildPreferenceOverridesForCountry(country);
            if (!this.dataManagerSettingsMapper.isCountryConfigured("XWG")) {
                preferences.addCustomPreference("XWG_NOT_CONFIGURED", "true");
            }
            ReverseGeocodeLocation reverseGeocodeLocation = MapMarkerAdapter.convertToMapMarkerLocation(point, preferences);
            ReverseGeocodeConstraints reverseGeocodeConstraints = MapMarkerAdapter.convertToMapMarkerReverseGeocodeConstraints(preferences, country);
            IDictionarySearchOrder order = this.convertDictionarySearchOrder(preferences, country, gga.getConfiguredDictionaries(country));
            if (order != null) {
                reverseGeocodeConstraints.setDictionarySearchOrder(order);
            }
            ReverseGeocodeResponse reverseGeocodeResponse = reverseGeocoder.reverseGeocode(country, reverseGeocodeLocation, (IReverseGeocodeConstraints)reverseGeocodeConstraints);
            boolean bConvert = preferences.getDistanceUnits() != null && !this.metricUnits.contains((Object)preferences.getDistanceUnits());
            return new GeocoderResponse(reverseGeocodeResponse, bConvert, preferences);
        }
        catch (MapMarkerFatalException ex) {
            if (ex.getCode() == 2306 && StringUtilities.equalStringsIgnoreCase((String)"XWG", (String)country)) {
                return new GeocoderResponse();
            }
            logger.error("Error reverse geocoding location {}, country {} ", new Object[]{point.toString(), country, ex});
            throw new GeocodingException(ex.getMessage(), ExceptionCode.MAPMARKER_FATAL_EXCEPTION, ex);
        }
        catch (MapMarkerException ex) {
            logger.error("Error reverse geocoding location {}, country {} ", new Object[]{point.toString(), country, ex});
            throw new GeocodingException(ex.getMessage(), ExceptionCode.MAPMARKER_EXCEPTION, ex);
        }
    }

    protected GeocoderResponse internalReverseGeocodeNoCountry(ReverseGeocodeLocation location, OverridablePreferences preferences, Preferences originalPreferences, Geocoder gga) throws MapMarkerException, MapMarkerFatalException, GeocodingException {
        ReverseGeocodeResponse response;
        ReverseGeocodeConstraints constraints;
        ReverseGeocodeAPI reverseGeocoder = (ReverseGeocodeAPI)geocoder;
        List<String> countries = CountryBoundaryManager.findCountriesContainingPoint(location);
        Preferences localizedPreferences = null;
        Length defaultLength = location.getDistanceAsLength();
        boolean fallbackGeo = false;
        boolean fallbackPostal = false;
        if (!this.dataManagerSettingsMapper.isCountryConfigured("XWG")) {
            preferences.addCustomPreference("XWG_NOT_CONFIGURED", "true");
        }
        for (String country : countries) {
            boolean distanceChanged;
            if (!this.dataManagerSettingsMapper.isCountryConfigured(country)) continue;
            localizedPreferences = preferences.buildPreferenceOverridesForCountry(country);
            boolean bl = distanceChanged = preferences.hasDistanceOverrideForCountry(country) || preferences.hasDistanceUnitsOverrideForCountry(country) && !defaultLength.getUnit().equals((Object)localizedPreferences.getDistanceUnits().getLinearUnit());
            if (localizedPreferences.isFallbackToPostal()) {
                fallbackPostal = true;
                localizedPreferences.setFallbackToPostal(false);
            }
            if (localizedPreferences.isFallbackToGeographic()) {
                fallbackGeo = true;
                localizedPreferences.setFallbackToGeographic(false);
            }
            if (distanceChanged) {
                double len = defaultLength.getValue();
                LinearUnit unit = defaultLength.getUnit();
                if (localizedPreferences.getDistance() < 0.0) {
                    String warnMsg = "Negative rev geo search distance not allowed: " + localizedPreferences.getDistance() + ", capping it to 0.0";
                    logger.warn(warnMsg);
                    len = 0.0;
                } else {
                    len = localizedPreferences.getDistance();
                }
                unit = localizedPreferences.getDistanceUnits().getLinearUnit();
                Length length = new Length(len, unit);
                if (length.getValue(LinearUnit.MILE) > 1.0) {
                    Length maxRevGeoDistance = new Length(1.0, LinearUnit.MILE);
                    String warnMsg = "Rev geo search distance out of range - " + localizedPreferences.getDistance() + " " + localizedPreferences.getDistanceUnits().toString() + ".  Capping to max search distance.";
                    logger.warn(warnMsg);
                    length = maxRevGeoDistance;
                }
                location.setDistance(length);
            }
            constraints = MapMarkerAdapter.convertToMapMarkerReverseGeocodeConstraints(localizedPreferences, country);
            this.adjustForCountryCustomKeys(constraints, localizedPreferences, country);
            IDictionarySearchOrder order = this.convertDictionarySearchOrder(localizedPreferences, country, gga.getConfiguredDictionaries(country));
            constraints.setDictionarySearchOrder(order);
            response = reverseGeocoder.reverseGeocode(country, location, (IReverseGeocodeConstraints)constraints);
            if (response != null && response.candidateCount() > 0) {
                boolean bConvert = localizedPreferences.getDistanceUnits() != null && !this.metricUnits.contains((Object)localizedPreferences.getDistanceUnits());
                return new GeocoderResponse(response, bConvert, localizedPreferences);
            }
            if (!distanceChanged) continue;
            location.setDistance(defaultLength);
        }
        if ((fallbackGeo || fallbackPostal || countries.size() == 0) && this.dataManagerSettingsMapper.isCountryConfigured("XWG")) {
            localizedPreferences = preferences.buildPreferenceOverridesForCountry("XWG");
            if (countries.size() > 0) {
                localizedPreferences.setFallbackToPostal(fallbackPostal);
                localizedPreferences.setFallbackToGeographic(fallbackGeo);
            } else {
                localizedPreferences.setFallbackToPostal(preferences.isFallbackToPostal());
                localizedPreferences.setFallbackToGeographic(preferences.isFallbackToGeographic());
            }
            constraints = MapMarkerAdapter.convertToMapMarkerReverseGeocodeConstraints(localizedPreferences, "XWG");
            response = reverseGeocoder.reverseGeocode("XWG", location, (IReverseGeocodeConstraints)constraints);
            if (response != null && response.candidateCount() > 0) {
                boolean bConvert = localizedPreferences.getDistanceUnits() != null && !this.metricUnits.contains((Object)localizedPreferences.getDistanceUnits());
                return new GeocoderResponse(response, bConvert, localizedPreferences);
            }
        }
        return new GeocoderResponse(new ReverseGeocodeResponse(null), false, originalPreferences);
    }

    public Response geocodeInternational(GeocodeType type, Address address, Preferences preferences, Geocoder gga) throws GeocodingException {
        String country;
        com.mapinfo.mapmarker.common.Address mmAddress = MapMarkerAdapter.convertToMapMarkerAddress(address);
        if (preferences != null && address != null && !StringUtilities.isEmpty((String)(country = address.getCountry()))) {
            OverridablePreferences overridablePreferences = new OverridablePreferences(preferences);
            preferences = overridablePreferences.buildPreferenceOverridesForCountry(country);
        }
        IGeocodeConstraints constraints = MapMarkerAdapter.convertToMapMarkerConstraints(preferences, address);
        IDictionarySearchOrder order = this.convertDictionarySearchOrder(preferences, address.getCountry(), gga.getConfiguredDictionaries(address.getCountry()));
        if (order != null) {
            constraints.setDictionarySearchOrder(order);
        }
        constraints.setCustomString("GG_AVAILABLE_COUNTRIES", this.compressSetToString(this.dataManagerSettingsMapper.getConfiguredCountries()));
        constraints.setCustomString("GG_AVAILABLE_CHARSETS", ConfigurationManager.getCharsetCountriesAsString());
        int mmType = MapMarkerAdapter.convertToMapMarkerGeocodeType(type);
        try {
            ClientGeocodeResponse response = geocoder.geocode(mmType, mmAddress, constraints);
            return new GeocoderResponse(response, preferences);
        }
        catch (MapMarkerFatalException ex) {
            logger.error("Error geocoding address: {}, {} ", new Object[]{type, address.toString(), ex});
            throw new GeocodingException(ex.getMessage(), ExceptionCode.MAPMARKER_FATAL_EXCEPTION, ex);
        }
        catch (MapMarkerException ex) {
            if (ex.getCode() == 2306) {
                StringBuilder sb = new StringBuilder(ex.getMessage());
                sb.append("  Either country was not provided, or data for input country is not available.");
                GeocodingException betterEx = new GeocodingException(sb.toString(), ExceptionCode.MAPMARKER_EXCEPTION, ex);
                logger.error("Error geocoding address: {}, {} ", new Object[]{type, address.toString(), betterEx});
                throw betterEx;
            }
            logger.error("Error geocoding address: {}, {} ", new Object[]{type, address.toString(), ex});
            throw new GeocodingException(ex.getMessage(), ExceptionCode.MAPMARKER_EXCEPTION, ex);
        }
    }

    protected void mergeDictionaries(IDictionarySearchOrder order, List<Dictionary> dictionaryList, String country) {
        if (dictionaryList.isEmpty()) {
            Set<CountrySupport> supportSet = this.buildSimpleCountrySupport(country);
            for (int i = 0; i < order.getDictionaryCount(); ++i) {
                GeocoderDictionary dictionary = new GeocoderDictionary();
                dictionary.setSource("NOT_SUPPLIED");
                dictionary.setVintage("NOT_SUPPLIED");
                dictionary.setDescription(order.getDictionaryDescription(i + 1));
                dictionary.setCustomDictionary(order.isUserDictionary(i + 1));
                dictionary.setPath("NOT_SUPPLIED");
                dictionary.setCountrySupportInformation(supportSet);
                dictionaryList.add(dictionary);
            }
            return;
        }
        for (int zeroBasedIndex = 0; zeroBasedIndex < order.getDictionaryCount(); ++zeroBasedIndex) {
            String desc = order.getDictionaryDescription(zeroBasedIndex + 1);
            boolean foundMatch = false;
            for (int i = 0; !foundMatch && i < dictionaryList.size(); ++i) {
                Dictionary testDict = dictionaryList.get(i);
                String testDesc = testDict.getDescription();
                if (!this.dictionaryDescriptionsMatch(desc, testDesc)) continue;
                foundMatch = true;
                if (testDict.getSource() == null) {
                    testDict.setSource("NOT_SUPPLIED");
                }
                if (testDict.getVintage() == null) {
                    testDict.setVintage("NOT_SUPPLIED");
                }
                if (testDict.getPath() == null) {
                    testDict.setPath("NOT_SUPPLIED");
                }
                if (testDict.getCountrySupportInformation() == null || testDict.getCountrySupportInformation().isEmpty()) {
                    testDict.setCountrySupportInformation(this.buildSimpleCountrySupport(country));
                }
                testDict.setCustomDictionary(order.isUserDictionary(zeroBasedIndex + 1));
            }
            if (foundMatch) continue;
            GeocoderDictionary dictionary = new GeocoderDictionary();
            dictionary.setSource("NOT_SUPPLIED");
            dictionary.setVintage("NOT_SUPPLIED");
            dictionary.setDescription(order.getDictionaryDescription(zeroBasedIndex + 1));
            dictionary.setCustomDictionary(order.isUserDictionary(zeroBasedIndex + 1));
            dictionary.setPath("NOT_SUPPLIED");
            dictionary.setCountrySupportInformation(this.buildSimpleCountrySupport(country));
            dictionaryList.add(zeroBasedIndex, dictionary);
        }
    }

    protected boolean dictionaryDescriptionsMatch(String geocoderDesc, String fileDesc) {
        if (geocoderDesc == null) {
            return fileDesc == null;
        }
        if (fileDesc == null) {
            return false;
        }
        String geoUpper = geocoderDesc.toUpperCase();
        String fileUpper = fileDesc.toUpperCase();
        return fileUpper.endsWith(geoUpper) || geoUpper.endsWith(fileUpper) || fileUpper.contains(geoUpper) || geoUpper.contains(fileUpper);
    }

    protected void adjustForCountryCustomKeys(ReverseGeocodeConstraints constraints, Preferences preferences, String country) {
        if (preferences == null || constraints == null) {
            return;
        }
        Map<String, String> custom = preferences.getCustomPreferences();
        if (custom == null || custom.isEmpty()) {
            return;
        }
        String prefix = country + ".";
        for (String key : custom.keySet()) {
            if (!key.toUpperCase().startsWith(prefix)) continue;
            constraints.setCustomString(key.substring(prefix.length()), custom.get(key));
        }
    }

    protected IDictionarySearchOrder convertDictionarySearchOrder(Preferences preferences, String country, List<Dictionary> configuredOrder) {
        if (preferences == null || configuredOrder == null) {
            return null;
        }
        List<String> list = preferences.getPreferredDictionaryOrder();
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<Integer> adjustedCountryIndexList = new ArrayList<Integer>(configuredOrder.size());
        boolean countryStarted = StringUtils.isNumeric((CharSequence)list.get(0));
        for (String item : list) {
            if (!countryStarted) {
                if (!item.equalsIgnoreCase(country)) continue;
                countryStarted = true;
                continue;
            }
            if (!StringUtils.isNumeric((CharSequence)item)) break;
            adjustedCountryIndexList.add(Integer.valueOf(item) + 1);
        }
        if (adjustedCountryIndexList.size() == 0) {
            return null;
        }
        DictionarySearchOrder order = new DictionarySearchOrder(configuredOrder.size());
        for (int i = 0; i < configuredOrder.size(); ++i) {
            Dictionary dictionary = configuredOrder.get(i);
            order.addDictionary(i + 1, false, dictionary.getDescription(), i + 1, dictionary.isCustomDictionary());
        }
        int currentIndex = 1;
        Iterator iterator = adjustedCountryIndexList.iterator();
        while (iterator.hasNext()) {
            int cfgIdx = (Integer)iterator.next();
            order.setDictionaryAvailableForSearch(cfgIdx, true);
            order.setSearchOrderForDictionary(cfgIdx, currentIndex);
            ++currentIndex;
        }
        return order;
    }

    private String compressSetToString(Set<String> set) {
        StringBuilder sb = new StringBuilder();
        if (set != null) {
            for (String value : set) {
                sb.append(value);
                sb.append(' ');
            }
        }
        return sb.toString();
    }

    protected Set<CountrySupport> buildSimpleCountrySupport(String country) {
        CountrySupport support = new CountrySupport();
        HashSet<String> countries = new HashSet<String>(1);
        countries.add(country);
        support.setSupportedCountries(countries);
        HashSet<CountrySupport> countrySupports = new HashSet<CountrySupport>(1);
        countrySupports.add(support);
        return countrySupports;
    }

    public void getUpdatedDictionaries(String country, List<Dictionary> dictionaryList, boolean countryFilter, String localCountry, Map<String, List<Dictionary>> myDictMap) {
        try {
            IDictionarySearchOrder order = geocoder.getDictionaryInformation(country, null);
            if (order != null) {
                this.mergeDictionaries(order, dictionaryList, country);
            }
            if (countryFilter) {
                myDictMap.put(localCountry, dictionaryList);
            } else {
                myDictMap.put(country, dictionaryList);
            }
        }
        catch (MapMarkerFatalException mapMarkerFatalException) {
        }
        catch (MapMarkerException mapMarkerException) {
            // empty catch block
        }
    }

    public MapMarkerJavaAPI getMapMarkerAPI() {
        return geocoder;
    }

    public Response keyLookup(KeyType keyType, Key key, Preferences preferences) throws GeocodingException {
        GeocoderResponse response = new GeocoderResponse();
        if (keyType == null) {
            throw new GeocodingException("Invalid key type", ExceptionCode.INVALID_CLIENT_INPUT);
        }
        if (KeyType.GNAF_PID == keyType) {
            String country = key.getCountry();
            if (StringUtils.isEmpty((CharSequence)country)) {
                key.setCountry("AUS");
            } else if (!country.equalsIgnoreCase("AUS")) {
                throw new GeocodingException("Invalid country input", ExceptionCode.INVALID_CLIENT_INPUT);
            }
            if (StringUtils.isEmpty((CharSequence)key.getValue())) {
                throw new GeocodingException("Invalid key value", ExceptionCode.INVALID_CLIENT_INPUT);
            }
            com.mapinfo.mapmarker.common.Address mapmarkerAddress = MapMarkerAdapter.createMapMarkerAddress(key, KEY_GNAF_PID);
            IGeocodeConstraints geocodeConstraints = MapMarkerAdapter.convertToMapMarkerConstraints(preferences, null);
            try {
                ClientGeocodeResponse geocodeResponse = geocoder.geocode(206, mapmarkerAddress, geocodeConstraints);
                response = new GeocoderResponse(geocodeResponse, preferences);
            }
            catch (MapMarkerException ex) {
                if (ex.getCode() == 2306) {
                    StringBuilder sb = new StringBuilder(ex.getMessage());
                    sb.append("  Either country was not provided, or data for input country is not available.");
                    GeocodingException betterEx = new GeocodingException(sb.toString(), ExceptionCode.MAPMARKER_EXCEPTION, ex);
                    logger.error("Error during GNAF PID Lookup:  {} ", (Object)key.getValue(), (Object)betterEx);
                    throw betterEx;
                }
                logger.error("Error during GNAF PID Lookup:  {} ", (Object)key.getValue(), (Object)ex);
                throw new GeocodingException(ex.getMessage(), ExceptionCode.MAPMARKER_EXCEPTION, ex);
            }
            catch (MapMarkerFatalException ex) {
                logger.error("Error during GNAF PID Lookup:  {} ", (Object)key.getValue(), (Object)ex);
                throw new GeocodingException(ex.getMessage(), ExceptionCode.MAPMARKER_FATAL_EXCEPTION, ex);
            }
        }
        return response;
    }
}

