/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode;

import com.google.common.base.Objects;
import com.mapinfo.geocode.api.ReturnFieldsDescriptor;
import java.util.HashSet;
import java.util.Set;

public class ReturnFields
implements ReturnFieldsDescriptor {
    private boolean returnAllCustomFields = false;
    private boolean returnMatchDescriptor = false;
    private boolean returnStreetAddressFields = false;
    private boolean returnUnitInformation = false;
    private final Set<String> returnedCustomFieldKeys = new HashSet<String>();

    public ReturnFields() {
    }

    public ReturnFields(ReturnFieldsDescriptor descriptor) {
        this.returnAllCustomFields = descriptor.isReturnAllCustomFields();
        this.returnStreetAddressFields = descriptor.isReturnStreetAddressFields();
        this.returnUnitInformation = descriptor.isReturnUnitInformation();
        this.returnMatchDescriptor = descriptor.isReturnMatchDescriptor();
        Set<String> keys = descriptor.getKeysOfCustomFieldsToReturn();
        if (keys != null) {
            this.returnedCustomFieldKeys.clear();
            this.returnedCustomFieldKeys.addAll(keys);
        }
    }

    @Override
    public boolean isReturnAllCustomFields() {
        return this.returnAllCustomFields;
    }

    @Override
    public Set<String> getKeysOfCustomFieldsToReturn() {
        return this.returnedCustomFieldKeys;
    }

    @Override
    public boolean isReturnMatchDescriptor() {
        return this.returnMatchDescriptor;
    }

    @Override
    public boolean isReturnStreetAddressFields() {
        return this.returnStreetAddressFields;
    }

    @Override
    public boolean isReturnUnitInformation() {
        return this.returnUnitInformation;
    }

    @Override
    public void setReturnAllCustomFields(boolean bReturn) {
        this.returnAllCustomFields = bReturn;
    }

    @Override
    public void setKeysOfCustomFieldsToReturn(Set<String> keys) {
        this.returnedCustomFieldKeys.clear();
        if (keys != null && !keys.isEmpty()) {
            this.returnedCustomFieldKeys.addAll(keys);
        }
    }

    @Override
    public void setReturnMatchDescriptor(boolean bReturn) {
        this.returnMatchDescriptor = bReturn;
    }

    @Override
    public void setReturnStreetAddressFields(boolean bReturn) {
        this.returnStreetAddressFields = bReturn;
    }

    @Override
    public void setReturnUnitInformation(boolean bReturn) {
        this.returnUnitInformation = bReturn;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("returnAllCustomFields", this.returnAllCustomFields).add("returnMatchDescriptor", this.returnMatchDescriptor).add("returnStreetAddressFields", this.returnStreetAddressFields).add("returnUnitInformation", this.returnUnitInformation).add("returnedCustomFieldKeys", this.returnedCustomFieldKeys).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReturnFields that = (ReturnFields)o;
        if (this.returnAllCustomFields != that.returnAllCustomFields) {
            return false;
        }
        if (this.returnMatchDescriptor != that.returnMatchDescriptor) {
            return false;
        }
        if (this.returnStreetAddressFields != that.returnStreetAddressFields) {
            return false;
        }
        if (this.returnUnitInformation != that.returnUnitInformation) {
            return false;
        }
        return !(this.returnedCustomFieldKeys != null ? !this.returnedCustomFieldKeys.equals(that.returnedCustomFieldKeys) : that.returnedCustomFieldKeys != null);
    }

    public int hashCode() {
        int result = this.returnAllCustomFields ? 1 : 0;
        result = 31 * result + (this.returnMatchDescriptor ? 1 : 0);
        result = 31 * result + (this.returnStreetAddressFields ? 1 : 0);
        result = 31 * result + (this.returnUnitInformation ? 1 : 0);
        result = 31 * result + (this.returnedCustomFieldKeys != null ? this.returnedCustomFieldKeys.hashCode() : 0);
        return result;
    }
}

