/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.adapter;

import com.mapinfo.geocode.ExceptionCode;
import com.mapinfo.geocode.GeocodeConfiguration;
import com.mapinfo.geocode.Geocoder;
import com.mapinfo.geocode.GeocodingException;
import com.mapinfo.geocode.api.Address;
import com.mapinfo.geocode.api.DefaultMatchMode;
import com.mapinfo.geocode.api.DistanceUnit;
import com.mapinfo.geocode.api.FieldsMatching;
import com.mapinfo.geocode.api.GeocodeType;
import com.mapinfo.geocode.api.Key;
import com.mapinfo.geocode.api.MatchMode;
import com.mapinfo.geocode.api.Preferences;
import com.mapinfo.geocode.api.StandardMatchMode;
import com.mapinfo.geocode.util.DefaultPreferencesProvider;
import com.mapinfo.geocode.util.GeocodeUtils;
import com.mapinfo.geocode.util.OverridablePreferences;
import com.mapinfo.mapmarker.DictionaryUsagePreference;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.user.GeocodeConstraints;
import com.mapinfo.mapmarker.user.ReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapMarkerAdapter {
    private static final String DEFAULT_COORDSYS = "EPSG:4326";
    public static final String USE_CENTERLINE_OFFSET = "USE_CENTERLINE_OFFSET";
    public static final String CENTERLINE_OFFSET = "CENTERLINE_OFFSET";
    public static final String CENTERLINE_OFFSET_UNIT = "CENTERLINE_OFFSET_UNIT";
    public static final String USE_ADDRESS_POINT_INTERPOLATION = "USE_ADDRESS_POINT_INTERPOLATION";
    public static final String PREFER_POBOX_OVER_STREET = "PREFER_POBOX_OVER_STREET";

    private MapMarkerAdapter() {
    }

    public static com.mapinfo.mapmarker.common.Address convertToMapMarkerAddress(Address geocoderAddress) {
        if (geocoderAddress == null) {
            return null;
        }
        AddressImpl address = new AddressImpl();
        String tmp = geocoderAddress.getMainAddressLine();
        if (tmp == null || tmp.isEmpty()) {
            tmp = geocoderAddress.getStreetName();
        }
        address.setMainAddress(tmp);
        address.setPostAddress(geocoderAddress.getAddressLastLine());
        address.setAreaName1(geocoderAddress.getAreaName1());
        address.setAreaName2(geocoderAddress.getAreaName2());
        address.setAreaName3(geocoderAddress.getAreaName3());
        address.setAreaName4(geocoderAddress.getAreaName4());
        address.setPlaceName(geocoderAddress.getPlaceName());
        address.setPostCode1(geocoderAddress.getPostCode1());
        address.setPostCode2(geocoderAddress.getPostCode2());
        address.setPostCode1(geocoderAddress.getPostCode1());
        tmp = geocoderAddress.getAddressNumber();
        if (tmp != null && !tmp.isEmpty()) {
            address.setAddressNumber(geocoderAddress.getAddressNumber());
        }
        if ((tmp = geocoderAddress.getUnitType()) != null && !tmp.isEmpty()) {
            address.setUnitType(geocoderAddress.getUnitType());
        }
        if ((tmp = geocoderAddress.getUnitValue()) != null && !tmp.isEmpty()) {
            address.setUnitValue(geocoderAddress.getUnitValue());
        }
        address.setCountry(geocoderAddress.getCountry());
        Map<String, String> custom = geocoderAddress.getCustomFields();
        if (custom != null && !custom.isEmpty()) {
            HashMap<String, String> newMap = GeocodeUtils.castHashMap(address.getAdditionalFields(), String.class, String.class);
            for (String key : custom.keySet()) {
                newMap.put(key, custom.get(key));
            }
        }
        return address;
    }

    public static IGeocodeConstraints convertToMapMarkerConstraints(Preferences preferences, Address address) throws GeocodingException {
        if (preferences == null) {
            String country;
            preferences = DefaultPreferencesProvider.getInstance().getDefaultPreferences();
            if (address != null && (country = address.getCountry()) != null) {
                OverridablePreferences overridablePreferences = new OverridablePreferences(preferences);
                preferences = overridablePreferences.buildPreferenceOverridesForCountry(country);
            }
        }
        GeocodeConstraints constraints = new GeocodeConstraints();
        constraints.setMaxCandidates(preferences.getMaxReturnedCandidates());
        constraints.setMaxRanges(preferences.getMaxReturnedRanges());
        constraints.setMaxRangeUnits(preferences.getMaxReturnedRangeUnits());
        constraints.setMaxRangeUnits(1);
        constraints.setClientLocale(preferences.getClientLocale());
        constraints.setStreetOffset(preferences.getStreetOffset());
        constraints.setCornerOffset(preferences.getCornerOffset());
        FieldsMatching customFieldsMatching = null;
        if (preferences.getMatchMode() == DefaultMatchMode.UNSPECIFIED && address != null) {
            try {
                customFieldsMatching = GeocodeConfiguration.getInstance().getCustomMatching(address.getCountry());
            }
            catch (GeocodingException geocodingException) {
                // empty catch block
            }
        }
        if (customFieldsMatching != null) {
            constraints.setMatchMode(GeocodeConstraints.MATCH_MODE_NONE);
            MapMarkerAdapter.convertMustMatchFields(constraints, customFieldsMatching);
        } else {
            constraints.setMatchMode(MapMarkerAdapter.convertToMapMarkerMatchMode(preferences.getMatchMode()));
            MapMarkerAdapter.convertMustMatchFields(constraints, preferences.getMustMatchFields());
        }
        constraints.setCornerOffsetUnits(MapMarkerAdapter.convertToMapMarkerUnits(preferences.getCornerOffsetUnits()));
        constraints.setStreetOffsetUnits(MapMarkerAdapter.convertToMapMarkerUnits(preferences.getStreetOffsetUnits()));
        constraints.setFallbackToPostal(preferences.isFallbackToPostal());
        constraints.setFallbackToGeographic(preferences.isFallbackToGeographic());
        constraints.setReturnCloseCandidatesOnly(true);
        try {
            constraints.setClientCoordinateSystem(preferences.getClientCoordSysName());
        }
        catch (Exception e) {
            throw new GeocodingException(e.getMessage(), ExceptionCode.INVALID_CLIENT_INPUT);
        }
        constraints.setReturnParsedInputAddress(true);
        Map<String, String> customPreferences = preferences.getCustomPreferences();
        if (customPreferences != null) {
            for (Map.Entry<String, String> entry : customPreferences.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (USE_ADDRESS_POINT_INTERPOLATION.equalsIgnoreCase(key)) {
                    constraints.setUseAddressPointInterpolation(MapMarkerAdapter.getBool(value));
                    continue;
                }
                if (PREFER_POBOX_OVER_STREET.equalsIgnoreCase(key)) {
                    constraints.setCustomString("PreferPOBoxOverStreet", value);
                    continue;
                }
                if (USE_CENTERLINE_OFFSET.equalsIgnoreCase(key)) {
                    constraints.setUseCenterlineOffset(MapMarkerAdapter.getBool(value));
                    if (!constraints.getUseCenterlineOffset()) continue;
                    constraints.setCenterlineOffset(MapMarkerAdapter.getDouble(customPreferences.get(CENTERLINE_OFFSET)));
                    constraints.setCenterlineOffsetUnit("m");
                    String unit = customPreferences.get(CENTERLINE_OFFSET_UNIT);
                    if ((unit == null || !"feet".equalsIgnoreCase(unit)) && !"foot".equalsIgnoreCase(unit) && !"ft".equalsIgnoreCase(unit)) continue;
                    constraints.setCenterlineOffsetUnit("ft");
                    continue;
                }
                if ("KEY_CUSTOM_DICTIONARY_USAGE".equalsIgnoreCase(key)) {
                    if ("PREFER_CUSTOM_DICTIONARIES".equalsIgnoreCase(value)) {
                        constraints.setDictionaryUsage(DictionaryUsagePreference.PREFER_UD);
                        continue;
                    }
                    if ("PREFER_STANDARD_DICTIONARIES".equalsIgnoreCase(value)) {
                        constraints.setDictionaryUsage(DictionaryUsagePreference.PREFER_AD);
                        continue;
                    }
                    if ("USE_CUSTOM_DICTIONARIES_ONLY".equalsIgnoreCase(value)) {
                        constraints.setDictionaryUsage(DictionaryUsagePreference.UD_ONLY);
                        continue;
                    }
                    if ("USE_STANDARD_DICTIONARIES_ONLY".equalsIgnoreCase(value)) {
                        constraints.setDictionaryUsage(DictionaryUsagePreference.AD_ONLY);
                        continue;
                    }
                    constraints.setDictionaryUsage(DictionaryUsagePreference.AD_AND_UD);
                    continue;
                }
                constraints.setCustomString(key, value);
            }
        }
        return constraints;
    }

    private static boolean getBool(String value) {
        if (value == null) {
            return false;
        }
        try {
            return Boolean.valueOf(value);
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private static double getDouble(String value) {
        if (value == null) {
            return 0.0;
        }
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException ex) {
            return 0.0;
        }
    }

    public static String convertToMapMarkerUnits(DistanceUnit sgiUnit) {
        String mapmarkerUnit = "";
        switch (sgiUnit) {
            case FEET: {
                mapmarkerUnit = "ft";
                break;
            }
            case METERS: {
                mapmarkerUnit = "m";
                break;
            }
            case MILES: {
                mapmarkerUnit = "mi";
                break;
            }
            case KILOMETERS: {
                mapmarkerUnit = "km";
                break;
            }
        }
        return mapmarkerUnit;
    }

    private static Length buildLength(double value, DistanceUnit unit) {
        if (unit != null) {
            return new Length(value, unit.getLinearUnit());
        }
        return new Length(value, LinearUnit.METER);
    }

    private static LinearUnit buildUnit(DistanceUnit unit) {
        if (unit != null) {
            unit.getLinearUnit();
        }
        return LinearUnit.METER;
    }

    private static void convertMustMatchFields(GeocodeConstraints constraints, FieldsMatching mustMatchFields) {
        if (mustMatchFields == null) {
            return;
        }
        if (mustMatchFields.isMatchOnInputFields()) {
            constraints.setMustMatchInput(mustMatchFields.isMatchOnInputFields());
        } else {
            constraints.setMustMatchAddressNumber(mustMatchFields.isMatchOnAddressNumber());
            constraints.setMustMatchPostalCode(mustMatchFields.isMatchOnPostCode1() || mustMatchFields.isMatchOnPostCode2());
            constraints.setMustMatchArea1(mustMatchFields.isMatchOnAreaName1());
            constraints.setMustMatchArea2(mustMatchFields.isMatchOnAreaName2());
            constraints.setMustMatchArea3(mustMatchFields.isMatchOnAreaName3());
            constraints.setMustMatchArea4(mustMatchFields.isMatchOnAreaName4());
            constraints.setMustMatchMainAddress(mustMatchFields.isMatchOnAllStreetFields() || mustMatchFields.isMatchOnStreetName());
        }
    }

    private static String convertToMapMarkerMatchMode(MatchMode matchMode) {
        if (matchMode != null) {
            if (matchMode instanceof StandardMatchMode) {
                switch ((StandardMatchMode)matchMode) {
                    case RELAXED: {
                        return "RelaxedMode";
                    }
                    case EXACT: {
                        return "ExactMode";
                    }
                    case STANDARD: {
                        return "DefaultMode";
                    }
                    case CUSTOM: {
                        return GeocodeConstraints.MATCH_MODE_NONE;
                    }
                }
            }
            if (matchMode == DefaultMatchMode.UNSPECIFIED) {
                return "DefaultMode";
            }
        }
        return null;
    }

    public static int convertToMapMarkerGeocodeType(GeocodeType type) throws GeocodingException {
        if (type != null) {
            switch (type) {
                case ADDRESS: {
                    return 0;
                }
                case POSTAL: {
                    return 1;
                }
                case GEOGRAPHIC: {
                    return 4;
                }
            }
            throw new GeocodingException("Geocoding type is invalid", ExceptionCode.INVALID_CLIENT_INPUT);
        }
        return 0;
    }

    public static ReverseGeocodeConstraints convertToMapMarkerReverseGeocodeConstraints(Preferences preferences, String country) {
        if (preferences == null) {
            preferences = DefaultPreferencesProvider.getInstance().getDefaultPreferences();
            if (country != null) {
                OverridablePreferences overridablePreferences = new OverridablePreferences(preferences);
                preferences = overridablePreferences.buildPreferenceOverridesForCountry(country);
            }
        }
        ReverseGeocodeConstraints constraints = new ReverseGeocodeConstraints();
        constraints.setFallbackToGeographic(preferences.isFallbackToGeographic());
        constraints.setFallbackToPostal(preferences.isFallbackToPostal());
        constraints.setMaxRangeUnits(preferences.getMaxReturnedRangeUnits());
        constraints.setClientLocale(preferences.getClientLocale());
        if (preferences.getClientLocale() != null) {
            constraints.setSortCandidatesUsingLocale(true);
        }
        constraints.setCornerOffset(MapMarkerAdapter.buildLength(preferences.getCornerOffset(), preferences.getCornerOffsetUnits()));
        constraints.setStreetOffset(MapMarkerAdapter.buildLength(preferences.getStreetOffset(), preferences.getStreetOffsetUnits()));
        Map<String, String> customPreferences = preferences.getCustomPreferences();
        if (customPreferences != null) {
            for (String key : customPreferences.keySet()) {
                constraints.setCustomString(key, customPreferences.get(key));
            }
        }
        return constraints;
    }

    public static ReverseGeocodeLocation convertToMapMarkerLocation(IPoint point, Preferences preference) throws GeocodingException {
        ReverseGeocodeLocation location = new ReverseGeocodeLocation(point.getDirectPosition());
        Logger logger = LoggerFactory.getLogger(Geocoder.class);
        if (null == point.getSpatialInfo()) {
            location.setCoordSys(CoordSysFactory.getDefaultCoordSysFactory().getCoordSys(DEFAULT_COORDSYS));
        } else {
            location.setCoordSys(point.getCoordSys());
        }
        if (null != preference) {
            Length length;
            if (preference.getDistance() < 0.0) {
                String warnMsg = "Negative rev geo search distance not allowed: " + preference.getDistance() + ", capping it to 0.0";
                logger.warn(warnMsg);
                preference.setDistance(0.0);
            }
            if ((length = MapMarkerAdapter.buildLength(preference.getDistance(), preference.getDistanceUnits())).getValue(LinearUnit.MILE) > 1.0) {
                Length maxRevGeoDistance = new Length(1.0, LinearUnit.MILE);
                String warnMsg = "Rev geo search distance out of range - " + preference.getDistance() + " " + preference.getDistanceUnits().toString() + ". Hence capping it to " + maxRevGeoDistance.getValue(MapMarkerAdapter.buildUnit(preference.getDistanceUnits())) + " " + preference.getDistanceUnits().toString();
                logger.warn(warnMsg);
                length = maxRevGeoDistance;
            }
            location.setDistance(length);
        }
        return location;
    }

    public static com.mapinfo.mapmarker.common.Address createMapMarkerAddress(Key key, String gnafKey) {
        AddressImpl mapmarkerAddress = new AddressImpl();
        if (key != null) {
            mapmarkerAddress.setCountry(key.getCountry());
            HashMap additionalFields = mapmarkerAddress.getAdditionalFields();
            additionalFields.put(gnafKey, key.getValue());
        }
        return mapmarkerAddress;
    }
}

