/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.api;

import com.google.common.base.Objects;
import com.mapinfo.geocode.ExceptionCode;
import com.mapinfo.geocode.GeocodeAddress;
import com.mapinfo.geocode.GeocodeConfiguration;
import com.mapinfo.geocode.GeocodeMatchFields;
import com.mapinfo.geocode.GeocodingException;
import com.mapinfo.geocode.api.Address;
import com.mapinfo.geocode.api.CandidateRange;
import com.mapinfo.geocode.api.DistanceUnit;
import com.mapinfo.geocode.api.FieldsMatching;
import com.mapinfo.geocode.api.GeoSerialize;
import com.mapinfo.geocode.api.Preferences;
import com.mapinfo.geocode.api.ReturnFieldsDescriptor;
import com.mapinfo.geocode.util.ConfigurationManager;
import com.mapinfo.geocode.util.GeocodeUtils;
import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.ICandidateRangeIterator;
import com.mapinfo.mapmarker.common.ParsedInputAddress;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.midev.coordsys.CoordSysConstants;
import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.Point;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class Candidate
implements GeoSerialize {
    public static final String REVERSE_GEOCODE_DISTANCE = "REVERSE_GEOCODE_DISTANCE";
    public static final String REVERSE_GEOCODE_DISTANCE_UNIT = "REVERSE_GEOCODE_DISTANCE_UNIT";
    private static final SpatialInfo SPATIAL_INFO = new SpatialInfo(CoordSysConstants.longLatWGS84);
    private static final String COORD_SYS_NAME = "epsg:4326";
    protected static final String PB_KEY = "PB_KEY";
    protected final Address address = new GeocodeAddress();
    protected String formattedStreetAddress;
    protected String formattedLocationAddress;
    protected IPoint point;
    protected String identifier;
    protected String precisionCode;
    private String sourceDictionary;
    protected int precisionLevel;
    protected FieldsMatching matchedFields;
    protected final List<CandidateRange> ranges = new ArrayList<CandidateRange>();

    public Candidate() {
    }

    public Candidate(CandidateAddress mmCand) throws GeocodingException {
        this(mmCand, null, null);
    }

    @Deprecated
    public Candidate(CandidateAddress mmCand, Preferences preferences) throws GeocodingException {
        this(mmCand, preferences, null);
    }

    public Candidate(CandidateAddress mmCand, Preferences preferences, ParsedInputAddress parsedAddress) throws GeocodingException {
        if (mmCand == null) {
            throw new GeocodingException("Null candidate passed to constructor", ExceptionCode.REQUIRED_PARAMETER_MISSING);
        }
        ReturnFieldsDescriptor returnFieldsDescriptor = null;
        if (preferences != null && !preferences.isReturnAllCandidateInfo()) {
            returnFieldsDescriptor = preferences.getReturnFieldsDescriptor();
        }
        boolean returnMatchDescriptor = returnFieldsDescriptor == null || returnFieldsDescriptor.isReturnMatchDescriptor();
        boolean returnStreetFields = returnFieldsDescriptor == null || returnFieldsDescriptor.isReturnStreetAddressFields();
        boolean returnUnitFields = returnFieldsDescriptor == null || returnFieldsDescriptor.isReturnUnitInformation();
        this.formattedStreetAddress = mmCand.getFormattedStreetAddress();
        if (this.formattedStreetAddress != null) {
            this.address.setMainAddressLine(this.formattedStreetAddress);
        }
        this.formattedLocationAddress = mmCand.getFormattedLocationAddress();
        if (this.formattedLocationAddress != null) {
            this.address.setAddressLastLine(this.formattedLocationAddress);
        }
        this.sourceDictionary = String.valueOf(mmCand.getConfiguredDictionaryNumber() - 1);
        this.copyAddressInformation(mmCand, returnStreetFields);
        this.copyAdditionalFields(mmCand, returnFieldsDescriptor, this.sourceDictionary);
        if (returnMatchDescriptor) {
            this.copyMatchingInformation(mmCand);
        }
        if (this.needToCopyRanges(mmCand)) {
            this.copyRangeInformation(mmCand, parsedAddress);
            if (returnUnitFields) {
                if (mmCand.getUnitType() != null) {
                    this.address.setUnitType(mmCand.getUnitType());
                }
                if (mmCand.getUnitValue() != null) {
                    this.address.setUnitValue(mmCand.getUnitValue());
                }
            } else {
                this.address.setUnitType(null);
                this.address.setUnitValue(null);
            }
        } else {
            this.address.setUnitType(null);
            this.address.setUnitValue(null);
        }
        this.precisionCode = mmCand.getPrecisionCode();
        this.identifier = mmCand.getSegmentID();
        this.precisionLevel = mmCand.getLocationPrecision();
        SpatialInfo si = SPATIAL_INFO;
        if (!COORD_SYS_NAME.equalsIgnoreCase(mmCand.getCoordSysString())) {
            si = new SpatialInfo(CoordSysFactory.getDefaultCoordSysFactory().getCoordSys(mmCand.getCoordSysString()));
        }
        this.point = new Point(si, mmCand.getLocationPoint());
    }

    public Candidate(ReverseGeocodeCandidateAddress mmCand) throws GeocodingException {
        this(mmCand, null);
    }

    public Candidate(ReverseGeocodeCandidateAddress mmCand, Preferences preferences) throws GeocodingException {
        if (mmCand == null) {
            throw new GeocodingException("Null candidate passed to constructor", ExceptionCode.REQUIRED_PARAMETER_MISSING);
        }
        this.formattedStreetAddress = mmCand.getFormattedStreetAddress();
        if (this.formattedStreetAddress != null) {
            this.address.setMainAddressLine(this.formattedStreetAddress);
        }
        this.formattedLocationAddress = mmCand.getFormattedLocationAddress();
        if (this.formattedLocationAddress != null) {
            this.address.setAddressLastLine(this.formattedLocationAddress);
        }
        this.precisionCode = mmCand.getPrecisionCode();
        this.precisionLevel = mmCand.getLocationPrecision();
        ReturnFieldsDescriptor returnFieldsDescriptor = null;
        if (preferences != null && !preferences.isReturnAllCandidateInfo()) {
            returnFieldsDescriptor = preferences.getReturnFieldsDescriptor();
        }
        boolean returnStreetFields = returnFieldsDescriptor == null || returnFieldsDescriptor.isReturnStreetAddressFields();
        boolean returnUnitFields = returnFieldsDescriptor == null || returnFieldsDescriptor.isReturnUnitInformation();
        this.copyAddressInformation(mmCand, returnStreetFields);
        this.sourceDictionary = String.valueOf(mmCand.getConfiguredDictionaryNumber() - 1);
        this.copyAdditionalFields(mmCand, returnFieldsDescriptor, this.sourceDictionary);
        SpatialInfo si = SPATIAL_INFO;
        if (!COORD_SYS_NAME.equalsIgnoreCase(mmCand.getCoordSysString())) {
            si = new SpatialInfo(CoordSysFactory.getDefaultCoordSysFactory().getCoordSys(mmCand.getCoordSysString()));
        }
        this.point = new Point(si, mmCand.getLocationPoint());
        Length pointDist = mmCand.getLength();
        this.address.addCustomField(REVERSE_GEOCODE_DISTANCE, String.valueOf(pointDist.getValue(LinearUnit.METER)));
        this.address.addCustomField(REVERSE_GEOCODE_DISTANCE_UNIT, DistanceUnit.METERS.toString());
        this.address.setUnitType(null);
        this.address.setUnitValue(null);
        int rangeCt = mmCand.getNumberOfCandidateRanges();
        if (rangeCt > 0) {
            ICandidateRangeIterator it = mmCand.rangeIterator();
            while (it.hasNext()) {
                this.ranges.add(new CandidateRange(it.next(), null));
            }
        }
    }

    void copyAddressInformation(Object mmAddress, boolean copyAddressFields) {
        com.mapinfo.mapmarker.common.Address mmCand = (com.mapinfo.mapmarker.common.Address)mmAddress;
        if (mmCand.getPlaceName() != null) {
            this.address.setPlaceName(mmCand.getPlaceName());
        }
        if (mmCand.getAreaName1() != null) {
            this.address.setAreaName1(mmCand.getAreaName1());
        }
        if (mmCand.getAreaName2() != null) {
            this.address.setAreaName2(mmCand.getAreaName2());
        }
        if (mmCand.getAreaName3() != null) {
            this.address.setAreaName3(mmCand.getAreaName3());
        }
        if (mmCand.getAreaName4() != null) {
            this.address.setAreaName4(mmCand.getAreaName4());
        }
        if (mmCand.getPostCode1() != null) {
            this.address.setPostCode1(mmCand.getPostCode1());
        }
        if (mmCand.getPostCode2() != null) {
            this.address.setPostCode2(mmCand.getPostCode2());
        }
        if (mmCand.getCountry() != null) {
            this.address.setCountry(mmCand.getCountry());
        }
        if (mmCand.getAddressNumber() != null) {
            this.address.setAddressNumber(mmCand.getAddressNumber());
        }
        if (mmCand.getMainAddress() != null) {
            this.address.setStreetName(mmCand.getMainAddress());
        }
        if (copyAddressFields) {
            Map<String, String> map = this.address.getCustomFields();
            this.addIfNotEmpty(map, "ADDRESS_ID", mmCand.getAddressID());
            this.addIfNotEmpty(map, "PRE_ADDRESS", mmCand.getPreAddress());
            this.addIfNotEmpty(map, "POST_ADDRESS", mmCand.getPostAddress());
            this.addIfNotEmpty(map, "PRE_DIRECTIONAL", mmCand.getPreDirectional());
            this.addIfNotEmpty(map, "POST_DIRECTIONAL", mmCand.getPostDirectional());
            this.addIfNotEmpty(map, "THOROUGHFARE_TYPE", mmCand.getPreThoroughfareType());
            this.addIfNotEmpty(map, "THOROUGHFARE_TYPE", mmCand.getPostThoroughfareType());
            this.addIfNotEmpty(map, "MAIN_ADDRESS", mmCand.getMainAddress());
        }
    }

    protected void addIfNotEmpty(Map<String, String> map, String key, String value) {
        if (value != null && value.length() > 0) {
            map.put(key, value);
        }
    }

    void copyAdditionalFields(Object mmAddress, ReturnFieldsDescriptor returnFieldsDescriptor, String sourceDictionary) {
        com.mapinfo.mapmarker.common.Address mmCand = (com.mapinfo.mapmarker.common.Address)mmAddress;
        HashMap rawMap = mmCand.getAdditionalFields();
        boolean limitedFields = returnFieldsDescriptor != null && !returnFieldsDescriptor.isReturnAllCustomFields();
        Set<String> selectedFields = limitedFields ? returnFieldsDescriptor.getKeysOfCustomFieldsToReturn() : null;
        boolean isLanguage = false;
        if (rawMap != null) {
            HashMap<String, String> addFlds = GeocodeUtils.castHashMap(rawMap, String.class, String.class);
            for (Map.Entry<String, String> entry : addFlds.entrySet()) {
                if ("LANGUAGE".equals(entry.getKey())) {
                    isLanguage = true;
                }
                if (selectedFields != null && !selectedFields.contains(entry.getKey())) continue;
                this.address.getCustomFields().put(entry.getKey(), entry.getValue());
            }
        }
        if (!isLanguage && (selectedFields == null || selectedFields.contains("LANGUAGE"))) {
            String country = mmCand.getCountry();
            try {
                GeocodeConfiguration configuration = GeocodeConfiguration.getInstance();
                if (configuration != null) {
                    country = configuration.getPrimaryCountry(country);
                }
            }
            catch (Exception configuration) {
                // empty catch block
            }
            String language = ConfigurationManager.getPrimaryLanguage(country, sourceDictionary);
            this.addIfNotEmpty(this.address.getCustomFields(), "LANGUAGE", language);
        }
        Map<String, String> map = this.address.getCustomFields();
        this.addIfNotEmpty(map, "GENERIC_FIELD_1", mmCand.getGenericField1());
        this.addIfNotEmpty(map, "GENERIC_FIELD_2", mmCand.getGenericField2());
        this.addIfNotEmpty(map, "GENERIC_FIELD_3", mmCand.getGenericField3());
        this.addIfNotEmpty(map, "GENERIC_FIELD_4", mmCand.getGenericField4());
        this.addIfNotEmpty(map, PB_KEY, map.get("PBKEY"));
        map.remove("PBKEY");
    }

    void copyRangeInformation(CandidateAddress mmCand, ParsedInputAddress parsedAddress) throws GeocodingException {
        if (null != mmCand.getRangeAt(0)) {
            this.ranges.add(new CandidateRange(mmCand.getRangeAt(0), parsedAddress));
        }
    }

    void copyMatchingInformation(CandidateAddress mmCand) {
        this.matchedFields = new GeocodeMatchFields();
        this.matchedFields.setMatchOnAddressNumber(mmCand.doesAddressNumberMatch());
        this.matchedFields.setMatchOnPostCode1(mmCand.doesPostalCode1Match());
        this.matchedFields.setMatchOnPostCode2(mmCand.doesPostalCode2Match());
        this.matchedFields.setMatchOnAreaName1(mmCand.doesAreaName1Match());
        this.matchedFields.setMatchOnAreaName2(mmCand.doesAreaName2Match());
        this.matchedFields.setMatchOnAreaName3(mmCand.doesAreaName3Match());
        this.matchedFields.setMatchOnAreaName4(mmCand.doesAreaName4Match());
        this.matchedFields.setMatchOnStreetName(mmCand.doesStreetNameMatch());
        this.matchedFields.setMatchOnStreetType(mmCand.doesThoroughfareTypeMatch());
        if (mmCand.getPreDirectional() != null) {
            this.matchedFields.setMatchOnStreetDirectional(mmCand.doesPreDirectionalMatch());
        } else if (mmCand.getPostDirectional() != null) {
            this.matchedFields.setMatchOnStreetDirectional(mmCand.doesPostDirectionalMatch());
        } else {
            this.matchedFields.setMatchOnStreetDirectional(mmCand.doesPostDirectionalMatch() || mmCand.doesPreDirectionalMatch());
        }
        this.matchedFields.setMatchOnAllStreetFields(this.matchedFields.isMatchOnStreetDirectional() && this.matchedFields.isMatchOnStreetType() && this.matchedFields.isMatchOnStreetName() && mmCand.doStreetPrefixAndSuffixMatch());
        this.matchedFields.setMatchOnPlaceName(mmCand.doesPlaceNameMatch());
    }

    public String getFormattedStreetAddress() {
        return this.formattedStreetAddress;
    }

    public String getFormattedLocationAddress() {
        return this.formattedLocationAddress;
    }

    public String getPlaceName() {
        return this.address.getPlaceName();
    }

    public String getAreaName1() {
        return this.address.getAreaName1();
    }

    public String getAreaName2() {
        return this.address.getAreaName2();
    }

    public String getAreaName3() {
        return this.address.getAreaName3();
    }

    public String getAreaName4() {
        return this.address.getAreaName4();
    }

    public String getPostCode1() {
        return this.address.getPostCode1();
    }

    public String getPostCode2() {
        return this.address.getPostCode2();
    }

    public String getCountry() {
        return this.address.getCountry();
    }

    public String getAddressNumber() {
        return this.address.getAddressNumber();
    }

    public String getStreetName() {
        return this.address.getStreetName();
    }

    public String getUnitType() {
        return this.address.getUnitType();
    }

    public String getUnitValue() {
        return this.address.getUnitValue();
    }

    public Set<String> getCustomFieldKeys() {
        return this.address.getCustomFields().keySet();
    }

    public String getCustomFieldValue(String key) {
        return this.address.getCustomFields().get(key);
    }

    public IPoint getPoint() {
        return this.point;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getPrecisionCode() {
        return this.precisionCode;
    }

    public String getSourceDictionary() {
        return this.sourceDictionary;
    }

    public int getPrecisionLevel() {
        return this.precisionLevel;
    }

    public FieldsMatching getMatchedFields() {
        return this.matchedFields;
    }

    public List<CandidateRange> getRanges() {
        return this.ranges;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setFormattedStreetAddress(String formattedStreetAddress) {
        this.formattedStreetAddress = formattedStreetAddress;
    }

    public void setFormattedLocationAddress(String formattedLocationAddress) {
        this.formattedLocationAddress = formattedLocationAddress;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setPrecisionCode(String precisionCode) {
        this.precisionCode = precisionCode;
    }

    public void setSourceDictionary(String sourceDictionary) {
        this.sourceDictionary = sourceDictionary;
    }

    public void setPrecisionLevel(int precisionLevel) {
        this.precisionLevel = precisionLevel;
    }

    public void setPoint(IPoint point) {
        this.point = point;
    }

    public void setMatchedFields(FieldsMatching matchedFields) {
        this.matchedFields = matchedFields;
    }

    private boolean needToCopyRanges(CandidateAddress mmCand) {
        String resultCode = mmCand.getAdditionalFieldForKey("RESULT_CODE");
        if (!StringUtils.isEmpty((CharSequence)resultCode)) {
            return resultCode.startsWith("S8") || resultCode.startsWith("S7") || resultCode.startsWith("S5") || resultCode.startsWith("SC");
        }
        return true;
    }

    @Override
    public Map<String, Object> convertToMap() {
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        retVal.put("address", ((GeoSerialize)((Object)this.address)).convertToMap());
        retVal.put("formattedStreetAddress", this.formattedStreetAddress);
        retVal.put("formattedLocationAddress", this.formattedLocationAddress);
        retVal.put("point", this.point == null ? "null" : this.point.toString());
        retVal.put("identifier", this.identifier);
        retVal.put("precisionCode", this.precisionCode);
        retVal.put("sourceDictionary", this.sourceDictionary);
        retVal.put("precisionLevel", String.valueOf(this.precisionLevel));
        retVal.put("matchedFields", this.matchedFields == null ? "null" : ((GeoSerialize)((Object)this.matchedFields)).convertToMap());
        ArrayList<Map<String, Object>> arrayOfRanges = new ArrayList<Map<String, Object>>();
        for (CandidateRange range : this.ranges) {
            arrayOfRanges.add(range.convertToMap());
        }
        retVal.put("ranges", arrayOfRanges);
        return retVal;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("address", (Object)this.address).add("formattedStreetAddress", (Object)this.formattedStreetAddress).add("formattedLocationAddress", (Object)this.formattedLocationAddress).add("point", (Object)this.point).add("identifier", (Object)this.identifier).add("precisionCode", (Object)this.precisionCode).add("sourceDictionary", (Object)this.sourceDictionary).add("precisionLevel", this.precisionLevel).add("matchedFields", (Object)this.matchedFields).add("ranges", this.ranges).toString();
    }

    public double getX() {
        return this.getPoint().getX();
    }

    public double getY() {
        return this.getPoint().getY();
    }

    public String getCoordinateSystemName() {
        return GeocodeUtils.getSRSName(this.getPoint().getCoordSys());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Candidate)) {
            return false;
        }
        Candidate candidate = (Candidate)o;
        if (this.getPrecisionLevel() != candidate.getPrecisionLevel()) {
            return false;
        }
        if (this.getAddress() != null ? !this.getAddress().equals(candidate.getAddress()) : candidate.getAddress() != null) {
            return false;
        }
        if (this.getFormattedStreetAddress() != null ? !this.getFormattedStreetAddress().equals(candidate.getFormattedStreetAddress()) : candidate.getFormattedStreetAddress() != null) {
            return false;
        }
        if (this.getFormattedLocationAddress() != null ? !this.getFormattedLocationAddress().equals(candidate.getFormattedLocationAddress()) : candidate.getFormattedLocationAddress() != null) {
            return false;
        }
        if (this.getPoint() != null ? !this.getPoint().equals(candidate.getPoint()) : candidate.getPoint() != null) {
            return false;
        }
        if (this.getIdentifier() != null ? !this.getIdentifier().equals(candidate.getIdentifier()) : candidate.getIdentifier() != null) {
            return false;
        }
        if (this.getPrecisionCode() != null ? !this.getPrecisionCode().equals(candidate.getPrecisionCode()) : candidate.getPrecisionCode() != null) {
            return false;
        }
        if (this.getSourceDictionary() != null ? !this.getSourceDictionary().equals(candidate.getSourceDictionary()) : candidate.getSourceDictionary() != null) {
            return false;
        }
        if (this.getMatchedFields() != null ? !this.getMatchedFields().equals(candidate.getMatchedFields()) : candidate.getMatchedFields() != null) {
            return false;
        }
        return !(this.getRanges() == null ? candidate.getRanges() != null : !this.getRanges().equals(candidate.getRanges()));
    }

    public int hashCode() {
        int result = this.getAddress() != null ? this.getAddress().hashCode() : 0;
        result = 31 * result + (this.getFormattedStreetAddress() != null ? this.getFormattedStreetAddress().hashCode() : 0);
        result = 31 * result + (this.getFormattedLocationAddress() != null ? this.getFormattedLocationAddress().hashCode() : 0);
        result = 31 * result + (this.getPoint() != null ? this.getPoint().hashCode() : 0);
        result = 31 * result + (this.getIdentifier() != null ? this.getIdentifier().hashCode() : 0);
        result = 31 * result + (this.getPrecisionCode() != null ? this.getPrecisionCode().hashCode() : 0);
        result = 31 * result + (this.getSourceDictionary() != null ? this.getSourceDictionary().hashCode() : 0);
        result = 31 * result + this.getPrecisionLevel();
        result = 31 * result + (this.getMatchedFields() != null ? this.getMatchedFields().hashCode() : 0);
        result = 31 * result + (this.getRanges() != null ? this.getRanges().hashCode() : 0);
        return result;
    }
}

