/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.api;

import com.mapinfo.midev.unit.LinearUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum DistanceUnit {
    FEET("Feet"),
    METERS("Meters"),
    MILES("Miles"),
    KILOMETERS("Kilometers");

    private final String value;
    private static final Map<String, DistanceUnit> lookupMap;

    private DistanceUnit(String v) {
        this.value = v;
    }

    public String value() {
        return this.value;
    }

    public static DistanceUnit fromValue(String v) {
        DistanceUnit unit;
        if (v != null && (unit = lookupMap.get(v.toLowerCase())) != null) {
            return unit;
        }
        throw new IllegalArgumentException(v);
    }

    public static DistanceUnit fromValueWithDefault(String v) {
        DistanceUnit unit;
        if (v != null && (unit = lookupMap.get(v.toLowerCase())) != null) {
            return unit;
        }
        return METERS;
    }

    public LinearUnit getLinearUnit() {
        switch (lookupMap.get(this.value.toLowerCase())) {
            case FEET: {
                return LinearUnit.FOOT;
            }
            case METERS: {
                return LinearUnit.METER;
            }
            case MILES: {
                return LinearUnit.MILE;
            }
            case KILOMETERS: {
                return LinearUnit.KILOMETER;
            }
        }
        return LinearUnit.METER;
    }

    static {
        HashMap<String, DistanceUnit> tmpMap = new HashMap<String, DistanceUnit>();
        tmpMap.put("foot", FEET);
        tmpMap.put("feet", FEET);
        tmpMap.put("ft", FEET);
        tmpMap.put("mile", MILES);
        tmpMap.put("miles", MILES);
        tmpMap.put("mi", MILES);
        tmpMap.put("meter", METERS);
        tmpMap.put("meters", METERS);
        tmpMap.put("m", METERS);
        tmpMap.put("kilometer", KILOMETERS);
        tmpMap.put("kilometers", KILOMETERS);
        tmpMap.put("km", KILOMETERS);
        lookupMap = Collections.unmodifiableMap(tmpMap);
    }
}

