/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.geostan;

import com.centrus.geostan.FindProps;
import com.centrus.geostan.GeoStan;
import com.centrus.geostan.GeoStanException;
import com.centrus.geostan.InitProps;
import com.centrus.geostan.StatusProps;
import com.mapinfo.geocode.ExceptionCode;
import com.mapinfo.geocode.GeocodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoStanObject {
    private static final Logger logger = LoggerFactory.getLogger(GeoStanObject.class);
    private long gsID = 0L;
    private final GeoStan gsHandle;
    private final FindProps m_findProps;
    private StringBuilder messages = new StringBuilder();

    public GeoStanObject(InitProps props) throws GeocodingException {
        StatusProps statusProps = new StatusProps();
        this.gsHandle = new GeoStan();
        this.m_findProps = new FindProps();
        statusProps.clear();
        InitProps initProps = new InitProps(props);
        try {
            this.gsHandle.init(initProps, statusProps);
            this.gsID = this.gsHandle.getGsId();
            if (this.gsID == 0L) {
                logger.debug("Failure to initialize GeoStan, gsID: {}", (Object)this.gsID);
                throw new GeocodingException("Failed to initialize GeoStan core library", ExceptionCode.GEOSTAN_FATAL_EXCEPTION);
            }
            this.checkStatusProps(initProps, statusProps);
        }
        catch (GeoStanException gse) {
            logger.debug("Failure to initialize GeoStan, gsID: {}, message: {}", (Object)this.gsID, (Object)gse.getMessage());
            throw new GeocodingException("Exception during GeoStan initialization", ExceptionCode.GEOSTAN_FATAL_EXCEPTION, gse);
        }
        finally {
            this.updateMessages();
        }
    }

    private void checkStatusProps(InitProps initProps, StatusProps statusProps) throws GeocodingException, GeoStanException {
        String errorStatus = "";
        if (initProps.contains(14) && initProps.getBool(14)) {
            if (statusProps.contains(2022) && !statusProps.getBool(2022)) {
                errorStatus = "DPV security key failed to verify\n";
                logger.warn("{} for key : {}", (Object)errorStatus, (Object)19);
            } else if (statusProps.contains(2018) && !statusProps.getBool(2023)) {
                errorStatus = "DPV data failed to initialize\n";
                logger.warn("{} for data path : {}", (Object)errorStatus, (Object)18);
            }
        }
        if (initProps.contains(15) && initProps.getBool(15)) {
            if (statusProps.contains(2025) && !statusProps.getBool(2025)) {
                errorStatus = errorStatus + "LACSLink security key failed to verify\n";
                logger.warn("LACSLink security key failed to verify for key : {}", (Object)21);
            } else if (statusProps.contains(2026) && !statusProps.getBool(2026)) {
                errorStatus = errorStatus + "LACSLink data failed to initialize\n";
                logger.warn("LACSLink data failed to initialize with data path : {}", (Object)20);
            }
        }
        if (initProps.contains(23) && initProps.getBool(23) && statusProps.contains(2031) && !statusProps.getBool(2031)) {
            errorStatus = errorStatus + "SuiteLink data failed to initialize\n";
            logger.warn("SuiteLink data failed to initialize for data path : {}", (Object)24);
        }
        if (initProps.contains(10) && initProps.getBool(10) && !statusProps.getBool(2018)) {
            errorStatus = errorStatus + "APN data failed to initialize\n";
            logger.warn("APN data failed to initialize for data path : {}", (Object)initProps.getAsStr(2));
        }
        if (initProps.contains(11) && initProps.getBool(11) && !statusProps.getBool(2019)) {
            errorStatus = errorStatus + "Elevation data failed to initialize\n";
            logger.warn("Elevation data failed to initialize for data path : {}", (Object)initProps.getAsStr(2));
        }
        if (initProps.contains(26) && initProps.getBool(26) && !statusProps.getBool(2035)) {
            errorStatus = errorStatus + "PBKey Zip data failed to initialize\n";
            logger.warn("PBKey Zip data failed to initialize for data path: {}", (Object)initProps.getAsStr(2));
        }
        if (statusProps.getBool(2034)) {
            logger.debug("Loaded Expanded Centroid data from data path: {}", (Object)initProps.getAsStr(2));
        }
        if (!errorStatus.isEmpty()) {
            throw new GeocodingException(errorStatus, ExceptionCode.GEOSTAN_FATAL_EXCEPTION);
        }
    }

    public GeoStan getGsHandle() {
        return this.gsHandle;
    }

    public FindProps getFindProps() {
        return this.m_findProps;
    }

    public String getMessages() {
        return this.messages.toString();
    }

    public void updateMessages() {
        try {
            this.messages.append(this.gsHandle.readMessages());
        }
        catch (GeoStanException gse) {
            logger.debug("Suppressing exception while updating messages in GeoStanObject", (Throwable)gse);
        }
    }

    public void deleteMessages() {
        this.messages = new StringBuilder();
    }

    protected void finalize() {
        logger.debug("GeoStanObject with gsID {} being reclaimed, messages : {}", (Object)this.gsID, (Object)this.messages.toString());
    }
}

