/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.interactive;

import com.mapinfo.geocode.ExceptionCode;
import com.mapinfo.geocode.GeocodingException;
import com.mapinfo.geocode.adapter.MapMarkerAdapter;
import com.mapinfo.geocode.api.Address;
import com.mapinfo.geocode.api.BoundingBox;
import com.mapinfo.geocode.api.DistanceUnit;
import com.mapinfo.geocode.api.FieldsMatching;
import com.mapinfo.geocode.api.InteractiveMatchMode;
import com.mapinfo.geocode.api.MatchMode;
import com.mapinfo.geocode.api.Preferences;
import com.mapinfo.geocode.api.Response;
import com.mapinfo.geocode.interactive.InteractiveResponse;
import com.mapinfo.geocode.util.DefaultPreferencesProvider;
import com.mapinfo.geocode.util.GeocodeUtils;
import com.mapinfo.mapmarker.autosuggest.IDictionarySearchPriority;
import com.mapinfo.mapmarker.autosuggest.api.AutoSuggestAPI;
import com.mapinfo.mapmarker.autosuggest.api.AutoSuggestConstraints;
import com.mapinfo.mapmarker.autosuggest.api.AutoSuggestEngine;
import com.mapinfo.mapmarker.autosuggest.api.AutoSuggestFactorySettingsProvider;
import com.mapinfo.mapmarker.autosuggest.api.IAutoSuggestConstraints;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedCandidates;
import com.mapinfo.mapmarker.autosuggest.exception.SuggestFailureException;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import com.mapinfo.midev.geometry.DirectPosition;
import com.pb.geocoding.config.api.GeocodingConfiguration;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InteractiveGeocoderAdapter {
    private static final Logger logger = LoggerFactory.getLogger(InteractiveGeocoderAdapter.class);
    AutoSuggestAPI autoSuggestAPI = new AutoSuggestEngine();
    AutoSuggestFactorySettingsProvider provider;

    public Response suggest(Address address, Preferences preferences) throws GeocodingException {
        ISuggestedCandidates candidate = null;
        try {
            candidate = this.autoSuggestAPI.suggest(this.makeAddress(address), this.makeConstraints(preferences));
        }
        catch (SuggestFailureException e) {
            logger.debug("An exception occurred while requesting address", (Throwable)e);
            throw new GeocodingException("An exception occurred while requesting address", ExceptionCode.INTERNAL_ERROR);
        }
        return new InteractiveResponse(candidate, preferences);
    }

    public Response findNearest(Preferences preferences) throws GeocodingException {
        ISuggestedCandidates candidate = null;
        try {
            candidate = this.autoSuggestAPI.findNearestPOIs(this.makeConstraints(preferences));
        }
        catch (SuggestFailureException e) {
            logger.debug("An exception occurred while requesting address", (Throwable)e);
            throw new GeocodingException("An exception occurred while requesting address", ExceptionCode.INTERNAL_ERROR);
        }
        return new InteractiveResponse(candidate, preferences);
    }

    public void configure(GeocodingConfiguration configuration) throws GeocodingException {
        try {
            Map countryPrperties = configuration.getCountryPropertiesInteractive();
            this.provider = AutoSuggestFactorySettingsProvider.getInstance();
            for (String country : countryPrperties.keySet()) {
                this.provider.setDataSettingsForCountry(country, (Properties)countryPrperties.get(country));
            }
        }
        catch (Exception e) {
            logger.debug("Cannot initialize interactive geocoding", (Throwable)e);
            throw new GeocodingException("Cannot initialize interactive geocoding", ExceptionCode.INVALID_CONFIGURATION);
        }
    }

    protected com.mapinfo.mapmarker.common.Address makeAddress(Address address) {
        String value;
        com.mapinfo.mapmarker.common.Address address1 = MapMarkerAdapter.convertToMapMarkerAddress(address);
        if (address.getCustomFields() != null && StringUtils.isNotEmpty((CharSequence)(value = address.getCustomFields().get("CATEGORY")))) {
            address1.setGenericField3(value);
        }
        return address1;
    }

    protected IAutoSuggestConstraints makeConstraints(Preferences preferences) {
        Map<String, String> custom;
        if (preferences == null) {
            preferences = DefaultPreferencesProvider.getInstance().getDefaultInteractivePreferences();
        }
        AutoSuggestConstraints constraints = new AutoSuggestConstraints();
        constraints.setSearchType(this.searchType(preferences));
        preferences.getClientCoordSysName();
        CoordSys coordSys = CoordSysFactory.getDefaultCoordSysFactory().getCoordSys(preferences.getClientCoordSysName());
        constraints.setCoordSys(coordSys);
        constraints.setSearchDistance(preferences.getDistance());
        int maxCandidates = preferences.getMaxReturnedCandidates() == 0 ? 10 : preferences.getMaxReturnedCandidates();
        constraints.setMaxCandidates(maxCandidates);
        constraints.setFuzzyMatchMode(this.convertMatchMode(preferences.getMatchMode()));
        constraints.setUnits(this.convertDistanceUnits(preferences.getDistanceUnits()));
        constraints.setBoundingBox(this.convertBoundingBox(preferences.getBoundingBox()));
        constraints.setOrigin(this.makeOriginPoint(preferences));
        constraints.setCompressAreaResults(this.isCompressedArea(preferences));
        constraints.setLocale(preferences.getClientLocale());
        constraints.setDictionarySearchPriority(this.getPriority(preferences));
        FieldsMatching fieldsMatching = preferences.getMustMatchFields();
        if (fieldsMatching != null) {
            constraints.setMatchOnAddressNumber(fieldsMatching.isMatchOnAddressNumber());
        }
        if ((custom = preferences.getCustomPreferences()) != null) {
            for (String key : custom.keySet()) {
                constraints.setCustomString(key, custom.get(key));
            }
        }
        return constraints;
    }

    protected com.mapinfo.mapmarker.autosuggest.api.BoundingBox convertBoundingBox(BoundingBox boundingBox) {
        double south = 0.0;
        double west = 0.0;
        double north = 0.0;
        double east = 0.0;
        if (boundingBox != null) {
            if (boundingBox.getSouthWestXY() != null && boundingBox.getNorthEastXY().size() > 1) {
                west = boundingBox.getSouthWestXY().get(0);
                south = boundingBox.getSouthWestXY().get(1);
            }
            if (boundingBox.getNorthEastXY() != null && boundingBox.getSouthWestXY().size() > 1) {
                east = boundingBox.getNorthEastXY().get(0);
                north = boundingBox.getNorthEastXY().get(1);
            }
            return new com.mapinfo.mapmarker.autosuggest.api.BoundingBox(west, south, east, north);
        }
        return null;
    }

    protected DirectPosition makeOriginPoint(Preferences preferences) {
        if (preferences.getPoint() != null) {
            return preferences.getPoint().getDirectPosition();
        }
        BoundingBox boundingBox = preferences.getBoundingBox();
        if (boundingBox != null) {
            if (boundingBox.getNorthEastXY() != null && boundingBox.getSouthWestXY() != null) {
                return null;
            }
            if (boundingBox.getNorthEastXY() != null && boundingBox.getNorthEastXY().size() > 1) {
                return GeocodeUtils.getPointFromXY(boundingBox.getNorthEastXY().get(0), boundingBox.getNorthEastXY().get(1), preferences.getClientCoordSysName()).getDirectPosition();
            }
            if (boundingBox.getSouthWestXY() != null && boundingBox.getSouthWestXY().size() > 1) {
                return GeocodeUtils.getPointFromXY(boundingBox.getSouthWestXY().get(0), boundingBox.getSouthWestXY().get(1), preferences.getClientCoordSysName()).getDirectPosition();
            }
        }
        return null;
    }

    protected IAutoSuggestConstraints.FuzzyMatchMode convertMatchMode(MatchMode matchMode) {
        IAutoSuggestConstraints.FuzzyMatchMode mode = IAutoSuggestConstraints.FuzzyMatchMode.NONE;
        if (matchMode != null) {
            if (InteractiveMatchMode.RELAXED.name().equals(matchMode.name())) {
                mode = IAutoSuggestConstraints.FuzzyMatchMode.SOFT_MATCH;
            } else if (InteractiveMatchMode.CLOSE.name().equals(matchMode.name())) {
                mode = IAutoSuggestConstraints.FuzzyMatchMode.HARD_MATCH;
            }
        }
        return mode;
    }

    protected IAutoSuggestConstraints.DistanceUnits convertDistanceUnits(DistanceUnit unit) {
        IAutoSuggestConstraints.DistanceUnits unitNew;
        if (unit == null) {
            return IAutoSuggestConstraints.DistanceUnits.METERS;
        }
        switch (unit) {
            case FEET: {
                unitNew = IAutoSuggestConstraints.DistanceUnits.FEET;
                break;
            }
            case METERS: {
                unitNew = IAutoSuggestConstraints.DistanceUnits.METERS;
                break;
            }
            case KILOMETERS: {
                unitNew = IAutoSuggestConstraints.DistanceUnits.KILOMETERS;
                break;
            }
            case MILES: {
                unitNew = IAutoSuggestConstraints.DistanceUnits.MILES;
                break;
            }
            default: {
                unitNew = IAutoSuggestConstraints.DistanceUnits.METERS;
            }
        }
        return unitNew;
    }

    protected int searchType(Preferences preferences) {
        String val;
        if (preferences.getCustomPreferences() != null && StringUtils.isNotEmpty((CharSequence)(val = preferences.getCustomPreferences().get("SEARCH_TYPE")))) {
            if ("ADDRESS_COMPLETION".equals(val)) {
                return 124;
            }
            if ("POINT_OF_INTEREST_NAME_COMPLETION".equals(val)) {
                return 1;
            }
            if ("POINT_OF_INTEREST_CATEGORY_COMPLETION".equals(val)) {
                return 2;
            }
            if ("POSTAL_COMPLETION".equals(val)) {
                return 4;
            }
            if ("CITY_COMPLETION".equals(val)) {
                return 8;
            }
            if ("STREET_NAME_COMPLETION".equals(val)) {
                return 16;
            }
            if ("GEOGRAPHIC_COMPLETION".equals(val)) {
                return 32;
            }
            if ("STATE_PROVINCE_COMPLETION".equals(val)) {
                return 64;
            }
            if ("ADDRESS_COMPLETION".equals(val)) {
                return 124;
            }
            if ("POINT_OF_INTEREST_COMPLETION".equals(val)) {
                return 3;
            }
            if ("ALL".equals(val)) {
                return 65535;
            }
        }
        return 124;
    }

    protected IDictionarySearchPriority getPriority(Preferences preferences) {
        Map<String, String> customPreferences = preferences.getCustomPreferences();
        IDictionarySearchPriority priority = null;
        if (customPreferences != null && this.provider != null) {
            priority = this.provider.getDictionarySearchPriority();
            String value = customPreferences.get("KEY_CUSTOM_DICTIONARY_USAGE");
            if (value != null) {
                priority = this.provider.getDictionarySearchPriority();
                if ("PREFER_CUSTOM_DICTIONARIES".equalsIgnoreCase(value)) {
                    priority.setDictionaryUsagePreference(IDictionarySearchPriority.DictionaryUsagePreference.PREFER_UD);
                } else if ("PREFER_STANDARD_DICTIONARIES".equalsIgnoreCase(value)) {
                    priority.setDictionaryUsagePreference(IDictionarySearchPriority.DictionaryUsagePreference.PREFER_STD);
                } else if ("USE_CUSTOM_DICTIONARIES_ONLY".equalsIgnoreCase(value)) {
                    priority.setDictionaryUsagePreference(IDictionarySearchPriority.DictionaryUsagePreference.UD_ONLY);
                } else if ("USE_STANDARD_DICTIONARIES_ONLY".equalsIgnoreCase(value)) {
                    priority.setDictionaryUsagePreference(IDictionarySearchPriority.DictionaryUsagePreference.STD_ONLY);
                } else {
                    priority.setDictionaryUsagePreference(IDictionarySearchPriority.DictionaryUsagePreference.NONE);
                }
            }
        }
        return priority;
    }

    protected boolean isCompressedArea(Preferences preferences) {
        if (preferences != null && preferences.getCustomPreferences() != null) {
            String val = preferences.getCustomPreferences().get("COMPRESSED_AREA_RESULT");
            try {
                return Boolean.valueOf(val);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

