/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.interactive;

import com.mapinfo.geocode.GeocodingException;
import com.mapinfo.geocode.api.Candidate;
import com.mapinfo.geocode.api.Preferences;
import com.mapinfo.geocode.api.Response;
import com.mapinfo.geocode.interactive.InteractiveCandidate;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedCandidate;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedCandidates;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InteractiveResponse
implements Response {
    int totalMathes = 0;
    Map<String, String> custom;
    List<Candidate> listCandidate;

    public InteractiveResponse(ISuggestedCandidates candidates, Preferences preferences) throws GeocodingException {
        if (candidates != null) {
            this.totalMathes = candidates.getCount();
            this.loadCandidates(candidates, preferences);
            this.loadCustomFields(candidates);
        }
    }

    private void loadCandidates(ISuggestedCandidates candidates, Preferences preferences) throws GeocodingException {
        this.listCandidate = new ArrayList<Candidate>();
        for (int i = 0; i <= candidates.getCount() - 1; ++i) {
            ISuggestedCandidate candidate = candidates.getCandidateAt(i);
            this.listCandidate.add(new InteractiveCandidate(candidate, preferences));
        }
    }

    private void loadCustomFields(ISuggestedCandidates candidates) {
        this.custom = new HashMap<String, String>();
        if (candidates.getAdditionalFieldKeys() != null) {
            for (String key : candidates.getAdditionalFieldKeys()) {
                this.custom.put(key, candidates.getAdditionFieldValue(key));
            }
        }
    }

    @Override
    public List<Candidate> getCandidates() {
        return this.listCandidate;
    }

    @Override
    public int getTotalPossibleCandidates() {
        return this.totalMathes;
    }

    @Override
    public int getTotalMatches() {
        return this.totalMathes;
    }

    @Override
    public Map<String, String> getCustomValues() {
        return this.custom;
    }

    @Override
    public Set<String> getCustomFieldKeys() {
        return this.custom.keySet();
    }

    @Override
    public String getCustomFieldValue(String key) {
        return this.custom.get(key);
    }
}

