/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.service;

import com.mapinfo.geocode.ExceptionCode;
import com.mapinfo.geocode.GeocodeCapabilitiesResponse;
import com.mapinfo.geocode.GeocodingException;
import com.mapinfo.geocode.api.Address;
import com.mapinfo.geocode.api.DefaultPreferencesAPI;
import com.mapinfo.geocode.api.Dictionary;
import com.mapinfo.geocode.api.GeocodeType;
import com.mapinfo.geocode.api.GeocodingAPI;
import com.mapinfo.geocode.api.InteractiveGeocodingAPI;
import com.mapinfo.geocode.api.Key;
import com.mapinfo.geocode.api.Preferences;
import com.mapinfo.geocode.api.Response;
import com.mapinfo.geocode.service.CapabilitiesRequest;
import com.mapinfo.geocode.service.ConfiguredDictionaryRequest;
import com.mapinfo.geocode.service.ConfiguredDictionaryResponse;
import com.mapinfo.geocode.service.FindNearestRequest;
import com.mapinfo.geocode.service.GeocodeRequest;
import com.mapinfo.geocode.service.GeocodeServiceResponse;
import com.mapinfo.geocode.service.InteractiveRequest;
import com.mapinfo.geocode.service.KeyLookupRequest;
import com.mapinfo.geocode.service.Points;
import com.mapinfo.geocode.service.ReverseGeocodeRequest;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GeocodeServiceAPI {
    @Autowired
    private GeocodingAPI geocoder;
    @Autowired
    private DefaultPreferencesAPI defaultPreferencesAPI;
    @Autowired
    private InteractiveGeocodingAPI interactiveGeocodingAPI;

    public GeocodeServiceResponse keyLookup(KeyLookupRequest request) throws GeocodingException {
        Key key = request.getKeys().get(0);
        Preferences preferences = request.getPreferences();
        Response response = this.geocoder.keyLookup(request.getType(), key, preferences);
        return new GeocodeServiceResponse(response);
    }

    public List<GeocodeServiceResponse> keyLookupMultiple(KeyLookupRequest request) throws GeocodingException {
        List<Key> keys = request.getKeys();
        if (keys.isEmpty()) {
            throw new GeocodingException("Key information missing", ExceptionCode.INVALID_CLIENT_INPUT);
        }
        List<Response> list = this.geocoder.keyLookupMultiple(request.getType(), keys, request.getPreferences());
        ArrayList<GeocodeServiceResponse> responses = new ArrayList<GeocodeServiceResponse>();
        for (Response response : list) {
            responses.add(new GeocodeServiceResponse(response));
        }
        return responses;
    }

    public GeocodeServiceResponse geocode(GeocodeRequest request) throws GeocodingException {
        GeocodeType geocodeType = request.getType();
        Address address = request.getAddresses().get(0);
        Preferences preferences = request.getPreferences();
        Response response = this.geocoder.geocode(geocodeType, address, preferences);
        return new GeocodeServiceResponse(response);
    }

    public List<GeocodeServiceResponse> geocodeMultiple(GeocodeRequest request) throws GeocodingException {
        List<Address> addresses = request.getAddresses();
        if (addresses.isEmpty()) {
            throw new GeocodingException("Address information missing", ExceptionCode.INVALID_CLIENT_INPUT);
        }
        List<Response> list = this.geocoder.geocodeMultiple(request.getType(), addresses, request.getPreferences());
        ArrayList<GeocodeServiceResponse> responses = new ArrayList<GeocodeServiceResponse>();
        for (Response response : list) {
            responses.add(new GeocodeServiceResponse(response));
        }
        return responses;
    }

    public GeocodeServiceResponse reverseGeocode(ReverseGeocodeRequest request) throws GeocodingException {
        List<Points> locations = request.getPoints();
        if (locations.size() == 0) {
            throw new GeocodingException("Location information missing", ExceptionCode.INVALID_CLIENT_INPUT);
        }
        Points geoLocation = locations.get(0);
        Response response = this.geocoder.reverseGeocode(geoLocation.getPoint(), geoLocation.getCountry(), request.getPreferences());
        return new GeocodeServiceResponse(response);
    }

    public List<GeocodeServiceResponse> reverseGeocodeMultiple(ReverseGeocodeRequest request) throws GeocodingException {
        List<Points> locations = request.getPoints();
        if (locations.isEmpty()) {
            throw new GeocodingException("Locations information missing", ExceptionCode.INVALID_CLIENT_INPUT);
        }
        List<Response> list = this.geocoder.reverseGeocodeMultiple(locations, request.getPreferences());
        ArrayList<GeocodeServiceResponse> responses = new ArrayList<GeocodeServiceResponse>();
        for (Response response : list) {
            responses.add(new GeocodeServiceResponse(response));
        }
        return responses;
    }

    public GeocodeCapabilitiesResponse getCapabilities(CapabilitiesRequest request) throws GeocodingException {
        if (request != null) {
            return (GeocodeCapabilitiesResponse)this.geocoder.getCapabilities(request.getCountry(), request.getOperationToDescribe());
        }
        return (GeocodeCapabilitiesResponse)this.geocoder.getCapabilities();
    }

    public ConfiguredDictionaryResponse getConfiguredDictionaries(ConfiguredDictionaryRequest request) throws GeocodingException {
        String country;
        List<Dictionary> dicts = null;
        if (request != null && (country = request.getCountry()) != null && !country.isEmpty()) {
            dicts = this.geocoder.getConfiguredDictionaries(country);
        }
        if (dicts == null) {
            dicts = this.geocoder.getConfiguredDictionaries();
        }
        ConfiguredDictionaryResponse response = new ConfiguredDictionaryResponse();
        response.setDictionaryList(dicts);
        return response;
    }

    public GeocodeServiceResponse interactive(InteractiveRequest request) throws GeocodingException {
        Response response = this.interactiveGeocodingAPI.suggest(request.getAddress(), request.getPreferences());
        return new GeocodeServiceResponse(response);
    }

    public GeocodeServiceResponse findNearest(FindNearestRequest request) throws GeocodingException {
        Response response = this.interactiveGeocodingAPI.findNearest(request.getPoint(), request.getPreferences());
        return new GeocodeServiceResponse(response);
    }

    public Preferences getDefaultPreferences() {
        return this.defaultPreferencesAPI.getDefaultPreferences();
    }
}

