/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.service;

import com.mapinfo.geocode.ExceptionCode;
import com.mapinfo.geocode.GeocodingException;
import com.mapinfo.geocode.api.Candidate;
import com.mapinfo.geocode.api.Response;
import com.mapinfo.geocode.util.GeocodeUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GeocodeServiceResponse {
    private List<Candidate> candidates;
    private int totalPossibleCandidates;
    private int totalMatches;
    private Map<String, String> customValues = new HashMap<String, String>();

    public GeocodeServiceResponse(Response internalResponse) throws GeocodingException {
        if (internalResponse == null) {
            throw new GeocodingException("internal response null", ExceptionCode.REQUIRED_PARAMETER_MISSING);
        }
        this.totalPossibleCandidates = internalResponse.getTotalPossibleCandidates();
        this.totalMatches = internalResponse.getTotalMatches();
        this.candidates = internalResponse.getCandidates();
        Map<String, String> internalCustomValues = internalResponse.getCustomValues();
        if (internalCustomValues != null && !internalCustomValues.isEmpty()) {
            this.customValues.putAll(internalCustomValues);
        }
    }

    public List<Candidate> getCandidates() {
        if (this.candidates == null) {
            return Collections.emptyList();
        }
        return this.candidates;
    }

    public int getTotalPossibleCandidates() {
        return this.totalPossibleCandidates;
    }

    public int getTotalMatches() {
        return this.totalMatches;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Total candidates found: ");
        stringBuilder.append(this.totalPossibleCandidates);
        GeocodeUtils.appendNewline(stringBuilder);
        stringBuilder.append("Total candidates returned: ");
        stringBuilder.append(this.candidates == null ? 0 : this.candidates.size());
        GeocodeUtils.appendNewline(stringBuilder);
        stringBuilder.append("Total close candidates found: ");
        stringBuilder.append(this.totalMatches);
        GeocodeUtils.appendNewline(stringBuilder);
        GeocodeUtils.appendNewline(stringBuilder);
        if (this.candidates != null) {
            int i = 0;
            for (Candidate candidate : this.candidates) {
                stringBuilder.append("Candidate ");
                stringBuilder.append(i);
                ++i;
                stringBuilder.append(":");
                GeocodeUtils.appendNewline(stringBuilder);
                stringBuilder.append(candidate.toString());
                GeocodeUtils.appendNewline(stringBuilder);
                GeocodeUtils.appendNewline(stringBuilder);
            }
        }
        return stringBuilder.toString();
    }

    public Map<String, String> getCustomValues() {
        return this.customValues;
    }

    public Set<String> getCustomFieldKeys() {
        return this.customValues.keySet();
    }

    public String getCustomFieldValue(String key) {
        return this.customValues.get(key);
    }
}

