/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.util;

import com.mapinfo.geocode.ExceptionCode;
import com.mapinfo.geocode.GeocodingException;
import com.mapinfo.mapmarker.common.dp.index.spatial.IPersistenceDecorator;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.DiskRGIndex;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.SpatialIndexValueEnvelopeDecorator;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.SpatialIndexValuePersistenceDecorator;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.CoordSysConstants;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.index.rtree.IEnvelopeDecorator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountryBoundaryManager {
    private static final Logger logger = LoggerFactory.getLogger(CountryBoundaryManager.class);
    private static final SpatialInfo SPATIAL_INFO = new SpatialInfo(CoordSysConstants.longLatWGS84);
    private static Map<String, Envelope> countryBoundsMap;
    private static CountryBoundaryManager theInstance;

    private CountryBoundaryManager(Map<String, Properties> countryDataMgrFileMap) {
        CountryBoundaryManager.readAllBoundaryDataFiles(countryDataMgrFileMap);
    }

    public static void initialize(Map<String, Properties> countryDataMgrFileMap) {
        if (theInstance != null) {
            return;
        }
        theInstance = new CountryBoundaryManager(countryDataMgrFileMap);
    }

    public static List<String> findCountriesContainingPoint(ReverseGeocodeLocation point) throws GeocodingException {
        if (theInstance == null) {
            throw new GeocodingException("Country boundaries not initialized", ExceptionCode.INTERNAL_ERROR);
        }
        DirectPosition position = new DirectPosition(point.getPositionPoint());
        CoordSys coordSys = point.getCoordSysObject();
        if (coordSys != null && !coordSys.equivalent(CoordSysConstants.longLatWGS84) && !coordSys.equivalent(CoordSysConstants.longLatNAD83)) {
            position = CoordConvertor.transformPointToWGS84((CoordSys)coordSys, (DirectPosition)position);
        }
        ArrayList<String> found = new ArrayList<String>();
        for (Map.Entry<String, Envelope> entry : countryBoundsMap.entrySet()) {
            if (!entry.getValue().contains(position)) continue;
            found.add(entry.getKey());
        }
        return found;
    }

    private static void readAllBoundaryDataFiles(Map<String, Properties> countryDataMgrFileMap) {
        countryBoundsMap = new HashMap<String, Envelope>();
        for (Map.Entry<String, Properties> entry : countryDataMgrFileMap.entrySet()) {
            try {
                Properties property = entry.getValue();
                Envelope mbr = CountryBoundaryManager.calculateMBR(property);
                if (mbr.isEmpty()) continue;
                countryBoundsMap.put(entry.getKey(), mbr);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static Envelope calculateMBR(Properties property) {
        int dictCount = 0;
        String StrDictCount = (String)property.get("DICTIONARY_COUNT");
        try {
            if (StrDictCount != null) {
                dictCount = Integer.valueOf(StrDictCount);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ArrayList<Envelope> boundsList = new ArrayList<Envelope>();
        for (int i = 1; i <= dictCount; ++i) {
            String dictionaryPath = (String)property.get("DICTIONARY_PATH" + i);
            File dataDir = new File(dictionaryPath);
            String[] streetRGIndexFiles = dataDir.list(new StreetRGIndexFilenameFilter());
            if (streetRGIndexFiles == null || streetRGIndexFiles.length <= 0) continue;
            Envelope finalBounds = null;
            for (String spxFileName : streetRGIndexFiles) {
                File rgIndexFile = new File(StringUtilities.appendToPath((String)dictionaryPath, (String)spxFileName));
                String dataFileBaseName = spxFileName.substring(0, spxFileName.length() - 1 - "spx".length());
                try {
                    Envelope bounds = new DiskRGIndex(rgIndexFile, (IPersistenceDecorator)new SpatialIndexValuePersistenceDecorator(dataFileBaseName), (IEnvelopeDecorator)new SpatialIndexValueEnvelopeDecorator()).getBounds();
                    if (finalBounds == null) {
                        finalBounds = new Envelope(bounds);
                        continue;
                    }
                    finalBounds.extend(bounds);
                }
                catch (FileNotFoundException FNFEx) {
                    logger.error(FNFEx.getMessage(), (Throwable)FNFEx);
                }
            }
            boundsList.add(finalBounds);
        }
        if (boundsList.size() == 1) {
            return (Envelope)boundsList.get(0);
        }
        if (boundsList.isEmpty()) {
            return new Envelope(SPATIAL_INFO);
        }
        Envelope combinedDictionaryEnvelope = null;
        for (Envelope dictionaryEnvelope : boundsList) {
            if (combinedDictionaryEnvelope == null) {
                combinedDictionaryEnvelope = new Envelope(dictionaryEnvelope);
                continue;
            }
            combinedDictionaryEnvelope.extend(dictionaryEnvelope);
        }
        return combinedDictionaryEnvelope;
    }

    private static class StreetRGIndexFilenameFilter
    implements FilenameFilter {
        private StreetRGIndexFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String filename) {
            return filename != null && filename.endsWith(".spx");
        }
    }
}

