/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.util;

import com.mapinfo.geocode.CountryNames;
import com.mapinfo.geocode.util.ConfigurationManager;
import com.mapinfo.mapmarker.utils.ISO3166;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.CoordSysConstants;
import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeocodeUtils {
    private static final Logger logger = LoggerFactory.getLogger(GeocodeUtils.class);
    private static final String newline = System.getProperty("line.separator");
    private static String[] dataTypes = new String[]{"POINT", "STREET", "AREA_NAME_4", "AREA_NAME_3", "POST_CODE_1", "POST_CODE_2", "AREA_NAME_2", "AREA_NAME_1"};
    public static final String DEFAULT_CSYS_NAME = "epsg:4326";

    private GeocodeUtils() {
    }

    public static void appendNonNullValues(StringBuilder stringBuilder, String label, String value) {
        if (stringBuilder == null || value == null || value.length() == 0) {
            return;
        }
        stringBuilder.append(label);
        stringBuilder.append(" : ");
        stringBuilder.append(value);
        stringBuilder.append(newline);
    }

    public static void appendNewline(StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            return;
        }
        stringBuilder.append(newline);
    }

    public static boolean canParseInt(String integer) {
        try {
            Integer.parseInt(integer);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean canParseDouble(String doubleVal) {
        try {
            Double.parseDouble(doubleVal);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean canParseLong(String longVal) {
        try {
            Long.parseLong(longVal);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static <K, V> HashMap<K, V> castHashMap(HashMap<?, ?> map, Class<K> kClass, Class<V> vClass) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            kClass.cast(entry.getKey());
            vClass.cast(entry.getValue());
        }
        return map;
    }

    public static void orderByDictionaryType(String country, Properties properties) {
        if (country == null || properties == null || "XWG".equalsIgnoreCase(country) || "USA".equalsIgnoreCase(country)) {
            return;
        }
        String dictionaryCount = properties.getProperty("DICTIONARY_COUNT", "0");
        try {
            int i;
            ArrayList<PriorityPath> priorityList = new ArrayList<PriorityPath>();
            int tempCount = Integer.valueOf(dictionaryCount);
            for (i = 1; i <= tempCount; ++i) {
                String path = properties.getProperty("DICTIONARY_PATH" + i, "");
                File dataDir = new File(path);
                int priority = GeocodeUtils.getDictionaryOrderPriority(dataDir);
                priorityList.add(new PriorityPath(priority, path));
            }
            Collections.sort(priorityList);
            for (i = 0; i <= priorityList.size() - 1; ++i) {
                properties.setProperty("DICTIONARY_PATH" + (i + 1), ((PriorityPath)priorityList.get((int)i)).path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static int getDataTypeIndex(String value) {
        for (int i = 0; i <= dataTypes.length - 1; ++i) {
            if (value == null || !value.trim().equalsIgnoreCase(dataTypes[i])) continue;
            return i;
        }
        return -1;
    }

    private static int getDictionaryOrderPriority(File dataDir) {
        int priority = dataTypes.length - 1;
        File file = Paths.get(dataDir.getAbsolutePath() + "/" + "dictionarydesc.properties", new String[0]).toFile();
        Properties properties = new Properties();
        if (file.exists()) {
            try (FileInputStream inputStream = new FileInputStream(file);){
                properties.load(inputStream);
                String dataType = properties.getProperty("dataType");
                int index = GeocodeUtils.getDataTypeIndex(dataType);
                priority = index > -1 ? index : dataTypes.length - 1;
            }
            catch (IOException e) {
                logger.debug(String.format("Invalid dataset dir: %s", dataDir), (Throwable)e);
            }
        }
        return priority;
    }

    public static String getISO3Country(String country) {
        if (StringUtils.isEmpty((CharSequence)country)) {
            return country;
        }
        if (GeocodeUtils.isClass("com.mapinfo.mapmarker.utils.ISO3166")) {
            ISO3166 iso = ISO3166.findCountryByISO3((String)country);
            if (iso != null) {
                return iso.getISO3Country();
            }
            iso = ISO3166.findCountryByName((String)country);
            if (iso != null) {
                return iso.getISO3Country();
            }
            if (country.length() == 2 && (iso = ISO3166.findCountryByISO2((String)country)) != null) {
                return iso.getISO3Country();
            }
        }
        country = ConfigurationManager.getISO3CountryFromDatabase(country);
        return country;
    }

    public static String getCountryName(String country) {
        block2: {
            String name;
            Iterator<String> iterator;
            Set<String> alternateNames;
            ISO3166 iso;
            country = GeocodeUtils.getISO3Country(country);
            if (GeocodeUtils.isClass("com.mapinfo.mapmarker.utils.ISO3166") && (iso = ISO3166.findCountryByISO3((String)country)) != null) {
                return iso.getDisplayCountry();
            }
            CountryNames countryNames = ConfigurationManager.getCountryNames(country);
            if (countryNames != null && StringUtils.isNotEmpty((CharSequence)countryNames.getDisplayName())) {
                return countryNames.getDisplayName();
            }
            if (countryNames == null || (alternateNames = countryNames.getAltNames()) == null || !(iterator = alternateNames.iterator()).hasNext()) break block2;
            country = name = iterator.next();
        }
        return country;
    }

    public static String getSRSName(CoordSys coordSys) {
        return coordSys == null ? null : CoordSysUtilities.getSRSName((CoordSys)coordSys);
    }

    public static IPoint getPointFromXY(double x, double y, String coordsys) {
        SpatialInfo spatialInfo = new SpatialInfo(CoordSysConstants.longLatWGS84);
        if (!StringUtils.isEmpty((CharSequence)coordsys) && !DEFAULT_CSYS_NAME.equalsIgnoreCase(coordsys)) {
            spatialInfo = new SpatialInfo(CoordSysFactory.getDefaultCoordSysFactory().getCoordSys(coordsys));
        }
        return new Point(spatialInfo, new DirectPosition(x, y));
    }

    public static IPoint getPointFromDirectPosition(DirectPosition position, String coordsys) {
        SpatialInfo spatialInfo = new SpatialInfo(CoordSysConstants.longLatWGS84);
        if (!StringUtils.isEmpty((CharSequence)coordsys) && !DEFAULT_CSYS_NAME.equalsIgnoreCase(coordsys)) {
            spatialInfo = new SpatialInfo(CoordSysFactory.getDefaultCoordSysFactory().getCoordSys(coordsys));
        }
        return new Point(spatialInfo, position);
    }

    public static boolean isClass(String className) {
        try {
            Class.forName(className, false, GeocodeUtils.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static class PriorityPath
    implements Comparable<PriorityPath> {
        int priority;
        String path;

        public PriorityPath(int priority, String path) {
            this.priority = priority;
            this.path = path;
        }

        @Override
        public int compareTo(PriorityPath priorityPath) {
            if (this.priority > priorityPath.priority) {
                return 1;
            }
            if (this.priority < priorityPath.priority) {
                return -1;
            }
            return 0;
        }
    }
}

