/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.util;

import com.mapinfo.geocode.Geocoder;
import com.mapinfo.geocode.GeocoderPreferences;
import com.mapinfo.geocode.ReturnFields;
import com.mapinfo.geocode.api.DistanceUnit;
import com.mapinfo.geocode.api.Preferences;
import com.mapinfo.geocode.api.StandardMatchMode;
import com.mapinfo.geocode.api.USAMatchMode;
import com.mapinfo.geocode.interactive.InteractivePreferences;
import com.mapinfo.geocode.util.OverridablePreferences;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeocoderPreferencesFactory {
    private static final Logger logger = LoggerFactory.getLogger(GeocoderPreferencesFactory.class);
    private static final Preferences DEFAULT_PREFERENCES;
    private static final Preferences DEFAULT_PREFERENCES_INTERACTIVE;
    public static final String DEFAULT_PREFERENCES_FILE_NAME = "geocodePreferences.xml";
    public static final String DEFAULT_INTERACTIVE_PREFERENCES_FILE_NAME = "interactivePreferences.xml";

    private GeocoderPreferencesFactory() {
    }

    public static Preferences fromFile(File preferencesXmlFile) {
        Preferences preferences = null;
        if (preferencesXmlFile != null && preferencesXmlFile.exists()) {
            try {
                XMLConfiguration xmlConfiguration = new XMLConfiguration(preferencesXmlFile);
                preferences = GeocoderPreferencesFactory.readPreferences(xmlConfiguration);
            }
            catch (ConfigurationException ce) {
                logger.error("Configuration Exception while attempting to parse the xml preferences configuration file {}" + preferencesXmlFile.getAbsolutePath());
            }
        }
        return preferences;
    }

    public static GeocoderPreferences getDefaultPreferences() {
        if (DEFAULT_PREFERENCES == null) {
            return new GeocoderPreferences();
        }
        return new GeocoderPreferences(DEFAULT_PREFERENCES);
    }

    public static InteractivePreferences getDefaultInteractuvePreferences() {
        if (DEFAULT_PREFERENCES_INTERACTIVE == null) {
            return new InteractivePreferences();
        }
        return new InteractivePreferences(DEFAULT_PREFERENCES_INTERACTIVE);
    }

    private static Preferences readPreferences(XMLConfiguration configuration) {
        String[] pairs;
        GeocoderPreferences preferences = new GeocoderPreferences();
        String value = configuration.getString("maxCandidatesToReturn");
        if (StringUtils.isNotEmpty((String)value)) {
            try {
                preferences.setMaxReturnedCandidates(Integer.valueOf(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (StringUtils.isNotEmpty((String)(value = configuration.getString("maxCandidateRangesToReturn")))) {
            try {
                preferences.setMaxReturnedRanges(Integer.valueOf(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (StringUtils.isNotEmpty((String)(value = configuration.getString("maxCandidateRangeUnitsToReturn")))) {
            try {
                preferences.setMaxReturnedRangeUnits(Integer.valueOf(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (StringUtils.isNotEmpty((String)(value = configuration.getString("cornerOffset")))) {
            try {
                preferences.setCornerOffset(Double.valueOf(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (StringUtils.isNotEmpty((String)(value = configuration.getString("streetOffset")))) {
            try {
                preferences.setStreetOffset(Double.valueOf(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (StringUtils.isNotEmpty((String)(value = configuration.getString("reverseGeocodeSearchDistance")))) {
            try {
                preferences.setDistance(Double.valueOf(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (StringUtils.isNotEmpty((String)(value = configuration.getString("cornerOffsetUnits")))) {
            try {
                preferences.setCornerOffsetUnits(DistanceUnit.fromValue(value));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (StringUtils.isNotEmpty((String)(value = configuration.getString("streetOffsetUnits")))) {
            try {
                preferences.setStreetOffsetUnits(DistanceUnit.fromValue(value));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (StringUtils.isNotEmpty((String)(value = configuration.getString("reverseGeocodeSearchDistanceUnits")))) {
            try {
                preferences.setDistanceUnits(DistanceUnit.fromValue(value));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (StringUtils.isNotEmpty((String)(value = configuration.getString("fallbackToGeographicCentroidOnNoStreetCloseMatch")))) {
            preferences.setFallbackToGeographic(Boolean.parseBoolean(value));
        }
        if (StringUtils.isNotEmpty((String)(value = configuration.getString("fallbackToPostalCentroidOnNoStreetCloseMatch")))) {
            preferences.setFallbackToPostal(Boolean.parseBoolean(value));
        }
        if (StringUtils.isNotEmpty((String)(value = configuration.getString("returnAllCandidateInfo")))) {
            preferences.setReturnAllCandidateInfo(Boolean.parseBoolean(value));
        }
        if (StringUtils.isNotEmpty((String)(value = configuration.getString("returnedPointCoordinateSystem")))) {
            try {
                preferences.setClientCoordSysName(value);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
        }
        if (StringUtils.isNotEmpty((String)(value = configuration.getString("clientLocale")))) {
            try {
                preferences.setClientLocale(new Locale(value));
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
        }
        if (StringUtils.isNotEmpty((String)(value = configuration.getString("matchMode")))) {
            String mode = value.toUpperCase();
            if (StandardMatchMode.STANDARD.name().equals(mode)) {
                preferences.setMatchMode(StandardMatchMode.STANDARD);
            } else if (StandardMatchMode.RELAXED.name().equals(mode)) {
                preferences.setMatchMode(StandardMatchMode.RELAXED);
            } else if (StandardMatchMode.EXACT.name().equals(mode)) {
                preferences.setMatchMode(StandardMatchMode.EXACT);
            } else if (StandardMatchMode.CUSTOM.name().equals(mode)) {
                preferences.setMatchMode(StandardMatchMode.CUSTOM);
            } else if (USAMatchMode.CASS.name().equals(mode)) {
                preferences.setMatchMode(USAMatchMode.CASS);
            } else if (USAMatchMode.INTERACTIVE.name().equals(mode)) {
                preferences.setMatchMode(USAMatchMode.INTERACTIVE);
            }
        }
        if ((pairs = configuration.getStringArray("customKeyValuePair")) != null) {
            for (String pair : pairs) {
                int idx = pair.indexOf(61);
                if (idx <= 0) continue;
                String key = pair.substring(0, idx);
                String val = pair.substring(idx + 1);
                preferences.addCustomPreference(key, val);
            }
        }
        if (!preferences.isReturnAllCandidateInfo()) {
            String[] dictionaryOrder;
            String[] keys;
            ReturnFields returnFields = new ReturnFields();
            preferences.setReturnFieldsDescriptor(returnFields);
            value = configuration.getString("returnMatchDescriptor");
            if (value != null) {
                returnFields.setReturnMatchDescriptor(Boolean.parseBoolean(value));
            }
            if ((value = configuration.getString("returnIndividualStreetAddressFields")) != null) {
                returnFields.setReturnStreetAddressFields(Boolean.parseBoolean(value));
            }
            if ((value = configuration.getString("returnIndividualUnitInformation")) != null) {
                returnFields.setReturnUnitInformation(Boolean.parseBoolean(value));
            }
            if ((value = configuration.getString("returnAllAvailableCustomFields")) != null) {
                returnFields.setReturnAllCustomFields(Boolean.parseBoolean(value));
            }
            if (!returnFields.isReturnAllCustomFields() && (keys = configuration.getStringArray("returnedCustomFieldKey")) != null) {
                HashSet<String> keyList = new HashSet<String>();
                for (String key : keys) {
                    keyList.add(key);
                }
                if (!keyList.isEmpty()) {
                    returnFields.setKeysOfCustomFieldsToReturn(keyList);
                }
            }
            if ((dictionaryOrder = configuration.getStringArray("preferredDictionaryOrders")) != null) {
                preferences.setPreferredDictionaryOrder(Arrays.asList(dictionaryOrder));
            }
        }
        return preferences;
    }

    public static Map<String, String> getAdjustedCustomPreferencesForCountry(Preferences preferences, String country) {
        HashMap<String, String> adjustedPrefs = new HashMap<String, String>();
        if (preferences == null) {
            return adjustedPrefs;
        }
        Map<String, String> customPrefs = preferences.getCustomPreferences();
        if (customPrefs == null) {
            return adjustedPrefs;
        }
        OverridablePreferences overridablePreferences = new OverridablePreferences(preferences);
        return overridablePreferences.buildPreferenceOverridesForCountry(country).getCustomPreferences();
    }

    static {
        File preferencesXmlFile = new File(Geocoder.getConfigurationLocation().toAbsolutePath().toString(), DEFAULT_PREFERENCES_FILE_NAME);
        DEFAULT_PREFERENCES = GeocoderPreferencesFactory.fromFile(preferencesXmlFile);
        File interactivePreferencesXmlFile = new File(Geocoder.getConfigurationLocation().toAbsolutePath().toString(), DEFAULT_INTERACTIVE_PREFERENCES_FILE_NAME);
        DEFAULT_PREFERENCES_INTERACTIVE = GeocoderPreferencesFactory.fromFile(interactivePreferencesXmlFile);
    }
}

