/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.geocode.util;

import com.mapinfo.geocode.GeocodeMatchFields;
import com.mapinfo.geocode.GeocoderPreferences;
import com.mapinfo.geocode.ReturnFields;
import com.mapinfo.geocode.api.DistanceUnit;
import com.mapinfo.geocode.api.FieldsMatching;
import com.mapinfo.geocode.api.MatchMode;
import com.mapinfo.geocode.api.Preferences;
import com.mapinfo.geocode.api.ReturnFieldsDescriptor;
import com.mapinfo.geocode.api.StandardMatchMode;
import com.mapinfo.geocode.api.USAMatchMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public class OverridablePreferences
extends GeocoderPreferences {
    public static final String OVERRIDE_CLIENT_COORDSYS_NAME = ".clientCoordSysName";
    public static final String OVERRIDE_CLIENT_LOCALE = ".clientLocale";
    public static final String OVERRIDE_CORNER_OFFSET = ".cornerOffset";
    public static final String OVERRIDE_CORNER_OFFSET_UNITS = ".cornerOffsetUnits";
    public static final String OVERRIDE_DISTANCE = ".distance";
    public static final String OVERRIDE_DISTANCE_UNITS = ".distanceUnits";
    public static final String OVERRIDE_FALLBACK_TO_GEOGRAPHIC = ".fallbackToGeographic";
    public static final String OVERRIDE_FALLBACK_TO_POSTAL = ".fallbackToPostal";
    public static final String OVERRIDE_MATCH_MODE = ".matchMode";
    public static final String OVERRIDE_MAX_RETURNED_CANDIDATES = ".maxReturnedCandidates";
    public static final String OVERRIDE_MAX_RETURNED_RANGE_UNITS = ".maxReturnedRangeUnits";
    public static final String OVERRIDE_MAX_RETURNED_RANGES = ".maxReturnedRanges";
    public static final String OVERRIDE_RETURN_ALL_CANDIDATE_INFO = ".returnAllCandidateInfo";
    public static final String OVERRIDE_STREET_OFFSET = ".streetOffset";
    public static final String OVERRIDE_STREET_OFFSET_UNITS = ".streetOffsetUnits";
    public static final String OVERRIDE_MUST_MATCH_ADDRESS_NUMBER = ".matchOnAddressNumber";
    public static final String OVERRIDE_MUST_MATCH_ALL_STREET_FIELDS = ".matchOnAllStreetFields";
    public static final String OVERRIDE_MUST_MATCH_INPUT_FIELDS = ".matchOnInputFields";
    public static final String OVERRIDE_MUST_MATCH_AREA_NAME1 = ".matchOnAreaName1";
    public static final String OVERRIDE_MUST_MATCH_AREA_NAME2 = ".matchOnAreaName2";
    public static final String OVERRIDE_MUST_MATCH_AREA_NAME3 = ".matchOnAreaName3";
    public static final String OVERRIDE_MUST_MATCH_AREA_NAME4 = ".matchOnAreaName4";
    public static final String OVERRIDE_MUST_MATCH_PLACE_NAME = ".matchOnPlaceName";
    public static final String OVERRIDE_MUST_MATCH_POST_CODE1 = ".matchOnPostCode1";
    public static final String OVERRIDE_MUST_MATCH_POST_CODE2 = ".matchOnPostCode2";
    public static final String OVERRIDE_MUST_MATCH_STREET_NAME = ".matchOnStreetName";
    public static final String OVERRIDE_RETURN_ALL_CUSTOM_FIELDS = ".returnAllCustomFields";
    public static final String OVERRIDE_RETURN_CUSTOM_FIELD_KEYS = ".returnedCustomFieldKeys";
    public static final String OVERRIDE_RETURN_MATCH_DESCRIPTOR = ".returnMatchDescriptor";
    public static final String OVERRIDE_RETURN_STREET_ADDRESS_FIELDS = ".returnStreetAddressFields";
    public static final String OVERRIDE_RETURN_UNIT_INFORMATION = ".returnUnitInformation";
    private static final List<String> keyIndexes;
    private static final int SET_CLIENT_CSYSNAME = 0;
    private static final int SET_CLIENT_LOCALE = 1;
    private static final int SET_CORNER_OFFSET = 2;
    private static final int SET_CORNER_OFFSET_UNITS = 3;
    private static final int SET_DISTANCE = 4;
    private static final int SET_DISTANCE_UNITS = 5;
    private static final int SET_FALLBACK_GEO = 6;
    private static final int SET_FALLBACK_POSTAL = 7;
    private static final int SET_MATCH_MODE = 8;
    private static final int SET_MAX_CANDS = 9;
    private static final int SET_MAX_RANGE_UNITS = 10;
    private static final int SET_MAX_RANGES = 11;
    private static final int SET_RETURN_ALL_INFO = 12;
    private static final int SET_STREET_OFFSET = 13;
    private static final int SET_STREET_OFFSET_UNITS = 14;
    private static final int SET_MUST_MATCH_ADDRESS_NUMBER = 15;
    private static final int SET_MUST_MATCH_ALL_STREET_FIELDS = 16;
    private static final int SET_MUST_MATCH_AREA_NAME1 = 17;
    private static final int SET_MUST_MATCH_AREA_NAME2 = 18;
    private static final int SET_MUST_MATCH_AREA_NAME3 = 19;
    private static final int SET_MUST_MATCH_AREA_NAME4 = 20;
    private static final int SET_MUST_MATCH_PLACE_NAME = 21;
    private static final int SET_MUST_MATCH_POST_CODE1 = 22;
    private static final int SET_MUST_MATCH_POST_CODE2 = 23;
    private static final int SET_MUST_MATCH_STREET_NAME = 24;
    private static final int SET_MUST_MATCH_INPUT = 25;
    private static final int SET_RETURN_ALL_CUSTOM_FIELDS = 26;
    private static final int SET_RETURN_CUSTOM_FIELD_KEYS = 27;
    private static final int SET_RETURN_MATCH_DESCRIPTOR = 28;
    private static final int SET_RETURN_STREET_ADDRESS_FIELDS = 29;
    private static final int SET_RETURN_UNIT_INFORMATION = 30;

    public OverridablePreferences(Preferences defaults) {
        super(defaults);
    }

    public boolean hasClientLocaleOverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_CLIENT_LOCALE) != null;
    }

    public boolean hasClientCoordsysNameOverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_CLIENT_COORDSYS_NAME) != null;
    }

    public boolean hasCornerOffsetOverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_CORNER_OFFSET) != null;
    }

    public boolean hasCornerOffsetUnitsOverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_CORNER_OFFSET_UNITS) != null;
    }

    public boolean hasDistanceOverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_DISTANCE) != null;
    }

    public boolean hasDistanceUnitsOverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_DISTANCE_UNITS) != null;
    }

    public boolean hasFallbackToGeographicOverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_FALLBACK_TO_GEOGRAPHIC) != null;
    }

    public boolean hasFallbackToPostalOverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_FALLBACK_TO_POSTAL) != null;
    }

    public boolean hasMustMatchStreetNameOverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MUST_MATCH_STREET_NAME) != null;
    }

    public boolean hasMustMatchAllStreetFieldsOverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MUST_MATCH_ALL_STREET_FIELDS) != null;
    }

    public boolean hasMustMatchInputFieldsOverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MUST_MATCH_INPUT_FIELDS) != null;
    }

    public boolean hasMustMatchAreaName1OverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MUST_MATCH_AREA_NAME1) != null;
    }

    public boolean hasMustMatchAreaName2OverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MUST_MATCH_AREA_NAME2) != null;
    }

    public boolean hasMustMatchAreaName3OverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MUST_MATCH_AREA_NAME3) != null;
    }

    public boolean hasMustMatchAreaName4OverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MUST_MATCH_AREA_NAME4) != null;
    }

    public boolean hasMustMatchPostCode1OverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MUST_MATCH_POST_CODE1) != null;
    }

    public boolean hasMustMatchPostCode2OverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MUST_MATCH_POST_CODE2) != null;
    }

    public boolean hasMustMatchPlaceNameOverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MUST_MATCH_PLACE_NAME) != null;
    }

    public boolean hasMustMatchAddressNumberOverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MUST_MATCH_ADDRESS_NUMBER) != null;
    }

    public boolean hasMaxReturnedCandidatesOverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MAX_RETURNED_CANDIDATES) != null;
    }

    public boolean hasMaxReturnedRangesOverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MAX_RETURNED_RANGES) != null;
    }

    public boolean hasMaxReturnedRangeUnitsOverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MAX_RETURNED_RANGE_UNITS) != null;
    }

    public boolean hasReturnAllCandidateInfoOverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_RETURN_ALL_CANDIDATE_INFO) != null;
    }

    public boolean hasReturnAllCustomFieldsOverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_RETURN_ALL_CUSTOM_FIELDS) != null;
    }

    public boolean hasReturnMatchDescriptorOverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_RETURN_MATCH_DESCRIPTOR) != null;
    }

    public boolean hasReturnStreetAddressFieldsOverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_RETURN_STREET_ADDRESS_FIELDS) != null;
    }

    public boolean hasReturnUnitInformationOverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_RETURN_UNIT_INFORMATION) != null;
    }

    public boolean hasReturnCustomFieldKeysOverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_RETURN_CUSTOM_FIELD_KEYS) != null;
    }

    public boolean hasStreetOffsetOverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_STREET_OFFSET) != null;
    }

    public boolean hasStreetOffsetUnitsOverrideForCountry(String country) {
        return country != null && this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_STREET_OFFSET_UNITS) != null;
    }

    public Locale getClientLocale(String country) {
        String ret;
        if (!StringUtils.isEmpty((CharSequence)country) && (ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_CLIENT_LOCALE)) != null) {
            return OverridablePreferences.getOverrideLocale(ret);
        }
        return this.getClientLocale();
    }

    public String getClientCoordSysName(String country) {
        String ret;
        if (!StringUtils.isEmpty((CharSequence)country) && (ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_CLIENT_COORDSYS_NAME)) != null) {
            return ret;
        }
        return this.getClientCoordSysName();
    }

    public int getMaxReturnedRangeUnits(String country) {
        String ret;
        if (!StringUtils.isEmpty((CharSequence)country) && (ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MAX_RETURNED_RANGE_UNITS)) != null) {
            return Integer.valueOf(ret);
        }
        return this.getMaxReturnedRangeUnits();
    }

    public double getDistance(String country) {
        String ret;
        if (!StringUtils.isEmpty((CharSequence)country) && (ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_DISTANCE)) != null) {
            return Double.valueOf(ret);
        }
        return this.getDistance();
    }

    public double getStreetOffset(String country) {
        String ret;
        if (!StringUtils.isEmpty((CharSequence)country) && (ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_STREET_OFFSET)) != null) {
            return Double.valueOf(ret);
        }
        return this.getStreetOffset();
    }

    public double getCornerOffset(String country) {
        String ret;
        if (!StringUtils.isEmpty((CharSequence)country) && (ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_CORNER_OFFSET)) != null) {
            return Double.valueOf(ret);
        }
        return this.getCornerOffset();
    }

    public DistanceUnit getDistanceUnits(String country) {
        String ret;
        if (!StringUtils.isEmpty((CharSequence)country) && (ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_DISTANCE_UNITS)) != null) {
            return DistanceUnit.fromValue(ret);
        }
        return this.getDistanceUnits();
    }

    public DistanceUnit getStreetOffsetUnits(String country) {
        String ret;
        if (!StringUtils.isEmpty((CharSequence)country) && (ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_STREET_OFFSET_UNITS)) != null) {
            return DistanceUnit.fromValue(ret);
        }
        return this.getStreetOffsetUnits();
    }

    public DistanceUnit getCornerOffsetUnits(String country) {
        String ret;
        if (!StringUtils.isEmpty((CharSequence)country) && (ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_CORNER_OFFSET_UNITS)) != null) {
            return DistanceUnit.fromValue(ret);
        }
        return this.getCornerOffsetUnits();
    }

    public boolean isReturnAllCandidateInfo(String country) {
        String ret;
        if (!StringUtils.isEmpty((CharSequence)country) && (ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_RETURN_ALL_CANDIDATE_INFO)) != null) {
            return Boolean.valueOf(ret);
        }
        return this.isReturnAllCandidateInfo();
    }

    public ReturnFieldsDescriptor getReturnFieldsDescriptor(String country) {
        ReturnFieldsDescriptor descriptor = this.getReturnFieldsDescriptor();
        if (!StringUtils.isEmpty((CharSequence)country)) {
            String ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_RETURN_ALL_CUSTOM_FIELDS);
            if (ret != null) {
                descriptor.setReturnAllCustomFields(Boolean.valueOf(ret));
            }
            if ((ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_RETURN_MATCH_DESCRIPTOR)) != null) {
                descriptor.setReturnMatchDescriptor(Boolean.valueOf(ret));
            }
            if ((ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_RETURN_STREET_ADDRESS_FIELDS)) != null) {
                descriptor.setReturnStreetAddressFields(Boolean.valueOf(ret));
            }
            if ((ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_RETURN_UNIT_INFORMATION)) != null) {
                descriptor.setReturnUnitInformation(Boolean.valueOf(ret));
            }
            if ((ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_RETURN_CUSTOM_FIELD_KEYS)) != null) {
                StringTokenizer st = new StringTokenizer(ret, " ,|;\t");
                HashSet<String> keys = new HashSet<String>();
                while (st.hasMoreTokens()) {
                    keys.add(st.nextToken());
                }
                if (!keys.isEmpty()) {
                    descriptor.setKeysOfCustomFieldsToReturn(keys);
                }
            }
        }
        return descriptor;
    }

    public void setClientLocale(Locale locale, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_CLIENT_LOCALE, OverridablePreferences.getOverrideLocaleString(locale));
        } else {
            this.setClientLocale(locale);
        }
    }

    public void setClientCoordSysName(String name, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_CLIENT_COORDSYS_NAME, name);
        } else {
            this.setClientCoordSysName(name);
        }
    }

    public void setMaxReturnedRangeUnits(int count, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_MAX_RETURNED_RANGE_UNITS, String.valueOf(count));
        } else {
            this.setMaxReturnedRangeUnits(count);
        }
    }

    public void setDistance(double distance, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_DISTANCE, String.valueOf(distance));
        } else {
            this.setDistance(distance);
        }
    }

    public void setStreetOffset(double offset, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_STREET_OFFSET, String.valueOf(offset));
        } else {
            this.setStreetOffset(offset);
        }
    }

    public void setCornerOffset(double offset, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_CORNER_OFFSET, String.valueOf(offset));
        } else {
            this.setCornerOffset(offset);
        }
    }

    public void setDistanceUnits(DistanceUnit units, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_DISTANCE_UNITS, units.value());
        } else {
            this.setDistanceUnits(units);
        }
    }

    public void setStreetOffsetUnits(DistanceUnit units, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_STREET_OFFSET_UNITS, units.value());
        } else {
            this.setStreetOffsetUnits(units);
        }
    }

    public void setCornerOffsetUnits(DistanceUnit units, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_CORNER_OFFSET_UNITS, units.value());
        } else {
            this.setCornerOffsetUnits(units);
        }
    }

    public void setReturnAllCandidateInfo(boolean bAll, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_RETURN_ALL_CANDIDATE_INFO, String.valueOf(bAll));
        } else {
            this.setReturnAllCandidateInfo(bAll);
        }
    }

    public void setReturnAllCustomFields(boolean bReturn, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_RETURN_ALL_CUSTOM_FIELDS, String.valueOf(bReturn));
        } else {
            ReturnFieldsDescriptor rfd = this.getReturnFieldsDescriptor();
            if (rfd == null) {
                rfd = new ReturnFields();
                this.setReturnFieldsDescriptor(rfd);
            }
            rfd.setReturnAllCustomFields(bReturn);
        }
    }

    public void setReturnMatchDescriptor(boolean bReturn, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_RETURN_MATCH_DESCRIPTOR, String.valueOf(bReturn));
        } else {
            ReturnFieldsDescriptor rfd = this.getReturnFieldsDescriptor();
            if (rfd == null) {
                rfd = new ReturnFields();
                this.setReturnFieldsDescriptor(rfd);
            }
            rfd.setReturnMatchDescriptor(bReturn);
        }
    }

    public void setSetReturnStreetAddressFields(boolean bReturn, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_RETURN_STREET_ADDRESS_FIELDS, String.valueOf(bReturn));
        } else {
            ReturnFieldsDescriptor rfd = this.getReturnFieldsDescriptor();
            if (rfd == null) {
                rfd = new ReturnFields();
                this.setReturnFieldsDescriptor(rfd);
            }
            rfd.setReturnStreetAddressFields(bReturn);
        }
    }

    public void setReturnUnitInformation(boolean bReturn, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_RETURN_UNIT_INFORMATION, String.valueOf(bReturn));
        } else {
            ReturnFieldsDescriptor rfd = this.getReturnFieldsDescriptor();
            if (rfd == null) {
                rfd = new ReturnFields();
                this.setReturnFieldsDescriptor(rfd);
            }
            rfd.setReturnUnitInformation(bReturn);
        }
    }

    public void setReturnCustomFieldKeys(Set<String> keys, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String key : keys) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(key);
            }
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_RETURN_CUSTOM_FIELD_KEYS, stringBuilder.toString());
        } else {
            ReturnFieldsDescriptor rfd = this.getReturnFieldsDescriptor();
            if (rfd == null) {
                rfd = new ReturnFields();
                this.setReturnFieldsDescriptor(rfd);
            }
            rfd.setKeysOfCustomFieldsToReturn(keys);
        }
    }

    public int getMaxReturnedRanges(String country) {
        String ret;
        if (!StringUtils.isEmpty((CharSequence)country) && (ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MAX_RETURNED_RANGES)) != null) {
            return Integer.valueOf(ret);
        }
        return this.getMaxReturnedRanges();
    }

    public boolean isFallbackToGeographic(String country) {
        String ret;
        if (!StringUtils.isEmpty((CharSequence)country) && (ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_FALLBACK_TO_GEOGRAPHIC)) != null) {
            return Boolean.valueOf(ret);
        }
        return this.isFallbackToGeographic();
    }

    public boolean isFallbackToPostal(String country) {
        String ret;
        if (!StringUtils.isEmpty((CharSequence)country) && (ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_FALLBACK_TO_POSTAL)) != null) {
            return Boolean.valueOf(ret);
        }
        return this.isFallbackToPostal();
    }

    public int getMaxReturnedCandidates(String country) {
        String ret;
        if (!StringUtils.isEmpty((CharSequence)country) && (ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MAX_RETURNED_CANDIDATES)) != null) {
            return Integer.valueOf(ret);
        }
        return this.getMaxReturnedCandidates();
    }

    public FieldsMatching getMustMatchFields(String country) {
        FieldsMatching fieldsMatching = this.getMustMatchFields();
        if (fieldsMatching == null) {
            fieldsMatching = new GeocodeMatchFields();
            this.setMustMatchFields(fieldsMatching);
        }
        if (!StringUtils.isEmpty((CharSequence)country)) {
            String ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MUST_MATCH_ADDRESS_NUMBER);
            if (ret != null) {
                fieldsMatching.setMatchOnAddressNumber(Boolean.valueOf(ret));
            }
            if ((ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MUST_MATCH_ALL_STREET_FIELDS)) != null) {
                fieldsMatching.setMatchOnAllStreetFields(Boolean.valueOf(ret));
            }
            if ((ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MUST_MATCH_AREA_NAME1)) != null) {
                fieldsMatching.setMatchOnAreaName1(Boolean.valueOf(ret));
            }
            if ((ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MUST_MATCH_AREA_NAME2)) != null) {
                fieldsMatching.setMatchOnAreaName2(Boolean.valueOf(ret));
            }
            if ((ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MUST_MATCH_AREA_NAME3)) != null) {
                fieldsMatching.setMatchOnAreaName3(Boolean.valueOf(ret));
            }
            if ((ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MUST_MATCH_AREA_NAME4)) != null) {
                fieldsMatching.setMatchOnAreaName4(Boolean.valueOf(ret));
            }
            if ((ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MUST_MATCH_PLACE_NAME)) != null) {
                fieldsMatching.setMatchOnPlaceName(Boolean.valueOf(ret));
            }
            if ((ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MUST_MATCH_POST_CODE1)) != null) {
                fieldsMatching.setMatchOnPostCode1(Boolean.valueOf(ret));
            }
            if ((ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MUST_MATCH_POST_CODE2)) != null) {
                fieldsMatching.setMatchOnPostCode2(Boolean.valueOf(ret));
            }
            if ((ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MUST_MATCH_STREET_NAME)) != null) {
                fieldsMatching.setMatchOnStreetName(Boolean.valueOf(ret));
            }
            if ((ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MUST_MATCH_INPUT_FIELDS)) != null) {
                fieldsMatching.setMatchOnInputFields(Boolean.valueOf(ret));
            }
        }
        return fieldsMatching;
    }

    public MatchMode getMatchMode(String country) {
        String ret;
        if (!StringUtils.isEmpty((CharSequence)country) && (ret = this.getCustomPreferences().get(country.toUpperCase() + OVERRIDE_MATCH_MODE)) != null) {
            if ("USA".equalsIgnoreCase(country)) {
                return USAMatchMode.valueOf(ret);
            }
            return StandardMatchMode.valueOf(ret);
        }
        return this.getMatchMode();
    }

    public String getClientLocaleString(String country) {
        Locale locale = this.getClientLocale(country);
        if (locale != null) {
            return locale.toString();
        }
        return this.getClientLocaleString();
    }

    public void setMaxReturnedRanges(int count, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_MAX_RETURNED_RANGES, String.valueOf(count));
        } else {
            this.setMaxReturnedRanges(count);
        }
    }

    public void setFallbackToGeographic(boolean bFallback, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_FALLBACK_TO_GEOGRAPHIC, String.valueOf(bFallback));
        } else {
            this.setFallbackToGeographic(bFallback);
        }
    }

    public void setFallbackToPostal(boolean bFallback, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_FALLBACK_TO_POSTAL, String.valueOf(bFallback));
        } else {
            this.setFallbackToPostal(bFallback);
        }
    }

    public void setMaxReturnedCandidates(int max, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_MAX_RETURNED_CANDIDATES, String.valueOf(max));
        } else {
            this.setMaxReturnedCandidates(max);
        }
    }

    public void setMustMatchPlaceName(boolean mustMatch, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_MUST_MATCH_PLACE_NAME, String.valueOf(mustMatch));
        } else {
            FieldsMatching fieldsMatching = this.getMustMatchFields();
            if (fieldsMatching == null) {
                fieldsMatching = new GeocodeMatchFields();
                this.setMustMatchFields(fieldsMatching);
            }
            fieldsMatching.setMatchOnPlaceName(mustMatch);
        }
    }

    public void setMustMatchAddressNumber(boolean mustMatch, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_MUST_MATCH_ADDRESS_NUMBER, String.valueOf(mustMatch));
        } else {
            FieldsMatching fieldsMatching = this.getMustMatchFields();
            if (fieldsMatching == null) {
                fieldsMatching = new GeocodeMatchFields();
                this.setMustMatchFields(fieldsMatching);
            }
            fieldsMatching.setMatchOnAddressNumber(mustMatch);
        }
    }

    public void setMustMatchStreetName(boolean mustMatch, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_MUST_MATCH_STREET_NAME, String.valueOf(mustMatch));
        } else {
            FieldsMatching fieldsMatching = this.getMustMatchFields();
            if (fieldsMatching == null) {
                fieldsMatching = new GeocodeMatchFields();
                this.setMustMatchFields(fieldsMatching);
            }
            fieldsMatching.setMatchOnStreetName(mustMatch);
        }
    }

    public void setMustMatchAreaName1(boolean mustMatch, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_MUST_MATCH_AREA_NAME1, String.valueOf(mustMatch));
        } else {
            FieldsMatching fieldsMatching = this.getMustMatchFields();
            if (fieldsMatching == null) {
                fieldsMatching = new GeocodeMatchFields();
                this.setMustMatchFields(fieldsMatching);
            }
            fieldsMatching.setMatchOnAreaName1(mustMatch);
        }
    }

    public void setMustMatchAreaName2(boolean mustMatch, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_MUST_MATCH_AREA_NAME2, String.valueOf(mustMatch));
        } else {
            FieldsMatching fieldsMatching = this.getMustMatchFields();
            if (fieldsMatching == null) {
                fieldsMatching = new GeocodeMatchFields();
                this.setMustMatchFields(fieldsMatching);
            }
            fieldsMatching.setMatchOnAreaName2(mustMatch);
        }
    }

    public void setMustMatchAreaName3(boolean mustMatch, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_MUST_MATCH_AREA_NAME3, String.valueOf(mustMatch));
        } else {
            FieldsMatching fieldsMatching = this.getMustMatchFields();
            if (fieldsMatching == null) {
                fieldsMatching = new GeocodeMatchFields();
                this.setMustMatchFields(fieldsMatching);
            }
            fieldsMatching.setMatchOnAreaName3(mustMatch);
        }
    }

    public void setMustMatchAreaName4(boolean mustMatch, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_MUST_MATCH_AREA_NAME4, String.valueOf(mustMatch));
        } else {
            FieldsMatching fieldsMatching = this.getMustMatchFields();
            if (fieldsMatching == null) {
                fieldsMatching = new GeocodeMatchFields();
                this.setMustMatchFields(fieldsMatching);
            }
            fieldsMatching.setMatchOnAreaName4(mustMatch);
        }
    }

    public void setMustMatchPostCode1(boolean mustMatch, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_MUST_MATCH_POST_CODE1, String.valueOf(mustMatch));
        } else {
            FieldsMatching fieldsMatching = this.getMustMatchFields();
            if (fieldsMatching == null) {
                fieldsMatching = new GeocodeMatchFields();
                this.setMustMatchFields(fieldsMatching);
            }
            fieldsMatching.setMatchOnPostCode1(mustMatch);
        }
    }

    public void setMustMatchPostCode2(boolean mustMatch, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_MUST_MATCH_POST_CODE2, String.valueOf(mustMatch));
        } else {
            FieldsMatching fieldsMatching = this.getMustMatchFields();
            if (fieldsMatching == null) {
                fieldsMatching = new GeocodeMatchFields();
                this.setMustMatchFields(fieldsMatching);
            }
            fieldsMatching.setMatchOnPostCode2(mustMatch);
        }
    }

    public void setMustMatchAllStreetFields(boolean mustMatch, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_MUST_MATCH_ALL_STREET_FIELDS, String.valueOf(mustMatch));
        } else {
            FieldsMatching fieldsMatching = this.getMustMatchFields();
            if (fieldsMatching == null) {
                fieldsMatching = new GeocodeMatchFields();
                this.setMustMatchFields(fieldsMatching);
            }
            fieldsMatching.setMatchOnAllStreetFields(mustMatch);
        }
    }

    public void setMustMatchInputFields(boolean mustMatch, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_MUST_MATCH_INPUT_FIELDS, String.valueOf(mustMatch));
        } else {
            FieldsMatching fieldsMatching = this.getMustMatchFields();
            if (fieldsMatching == null) {
                fieldsMatching = new GeocodeMatchFields();
                this.setMustMatchFields(fieldsMatching);
            }
            fieldsMatching.setMatchOnInputFields(mustMatch);
        }
    }

    public void setMatchMode(MatchMode mode, String country) {
        if (!StringUtils.isEmpty((CharSequence)country)) {
            this.getCustomPreferences().put(country.toUpperCase() + OVERRIDE_MATCH_MODE, mode.name());
        } else {
            this.setMatchMode(mode);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Preferences)) {
            return false;
        }
        GeocoderPreferences that = (GeocoderPreferences)o;
        if (Double.compare(this.getCornerOffset(), that.getCornerOffset()) != 0) {
            return false;
        }
        if (Double.compare(this.getDistance(), that.getDistance()) != 0) {
            return false;
        }
        if (this.isFallbackToGeographic() != that.isFallbackToGeographic()) {
            return false;
        }
        if (this.isFallbackToPostal() != that.isFallbackToPostal()) {
            return false;
        }
        if (this.getMaxReturnedCandidates() != that.getMaxReturnedCandidates()) {
            return false;
        }
        if (this.getMaxReturnedRanges() != that.getMaxReturnedRanges()) {
            return false;
        }
        if (this.getMaxReturnedRangeUnits() != that.getMaxReturnedRangeUnits()) {
            return false;
        }
        if (this.isReturnAllCandidateInfo() != that.isReturnAllCandidateInfo()) {
            return false;
        }
        if (Double.compare(this.getStreetOffset(), that.getStreetOffset()) != 0) {
            return false;
        }
        if (this.getClientCoordSysName() != null ? !this.getClientCoordSysName().equals(that.getClientCoordSysName()) : that.getClientCoordSysName() != null) {
            return false;
        }
        if (this.getClientLocale() != null ? !this.getClientLocale().equals(that.getClientLocale()) : that.getClientLocale() != null) {
            return false;
        }
        if (this.getCornerOffsetUnits() != that.getCornerOffsetUnits()) {
            return false;
        }
        if (this.getCustomPreferences() != null ? !this.getCustomPreferences().equals(that.getCustomPreferences()) : that.getCustomPreferences() != null) {
            return false;
        }
        if (this.getDistanceUnits() != that.getDistanceUnits()) {
            return false;
        }
        if (this.getMatchMode() != null ? !this.getMatchMode().equals(that.getMatchMode()) : that.getMatchMode() != null) {
            return false;
        }
        if (this.getMustMatchFields() != null ? !this.getMustMatchFields().equals(that.getMustMatchFields()) : that.getMustMatchFields() != null) {
            return false;
        }
        if (this.getPreferredDictionaryOrder() != null ? !this.getPreferredDictionaryOrder().equals(that.getPreferredDictionaryOrder()) : that.getPreferredDictionaryOrder() != null) {
            return false;
        }
        if (this.getReturnFieldsDescriptor() != null ? !this.getReturnFieldsDescriptor().equals(that.getReturnFieldsDescriptor()) : that.getReturnFieldsDescriptor() != null) {
            return false;
        }
        return this.getStreetOffsetUnits() == that.getStreetOffsetUnits();
    }

    public boolean hasOverridesForCountry(String country) {
        if (StringUtils.isEmpty((CharSequence)country) || country.length() != 3) {
            return false;
        }
        country = country.toUpperCase();
        Map<String, String> custom = this.getCustomPreferences();
        if (custom == null || custom.isEmpty()) {
            return false;
        }
        for (String key : custom.keySet()) {
            if (key.length() < 5 || key.charAt(3) != '.' || !key.startsWith(country)) continue;
            return true;
        }
        return false;
    }

    public Map<String, String> getOverridesForCountry(String country) {
        HashMap<String, String> map = null;
        if (StringUtils.isEmpty((CharSequence)country) || country.length() != 3) {
            return map;
        }
        country = country.toUpperCase();
        Map<String, String> custom = this.getCustomPreferences();
        if (custom == null || custom.isEmpty()) {
            return map;
        }
        for (String key : custom.keySet()) {
            if (key.length() < 5 || key.charAt(3) != '.' || !key.startsWith(country)) continue;
            if (map == null) {
                map = new HashMap<String, String>();
            }
            map.put(key, custom.get(key));
        }
        return map;
    }

    public static String getValueAsString(Preferences preferences, String key) {
        if (preferences == null || key == null) {
            return null;
        }
        int idx = keyIndexes.indexOf(key);
        switch (idx) {
            case 0: {
                return preferences.getClientCoordSysName();
            }
            case 1: {
                return preferences.getClientLocale().toString();
            }
            case 2: {
                return String.valueOf(preferences.getCornerOffset());
            }
            case 3: {
                return preferences.getCornerOffsetUnits().name();
            }
            case 4: {
                return String.valueOf(preferences.getDistance());
            }
            case 5: {
                return preferences.getDistanceUnits().name();
            }
            case 6: {
                return String.valueOf(preferences.isFallbackToGeographic());
            }
            case 7: {
                return String.valueOf(preferences.isFallbackToPostal());
            }
            case 8: {
                return preferences.getMatchMode().name();
            }
            case 9: {
                return String.valueOf(preferences.getMaxReturnedCandidates());
            }
            case 10: {
                return String.valueOf(preferences.getMaxReturnedRangeUnits());
            }
            case 11: {
                return String.valueOf(preferences.getMaxReturnedRanges());
            }
            case 12: {
                return String.valueOf(preferences.isReturnAllCandidateInfo());
            }
            case 13: {
                return String.valueOf(preferences.getStreetOffset());
            }
            case 14: {
                return preferences.getStreetOffsetUnits().name();
            }
            case 15: {
                return String.valueOf(preferences.getMustMatchFields().isMatchOnAddressNumber());
            }
            case 16: {
                return String.valueOf(preferences.getMustMatchFields().isMatchOnAllStreetFields());
            }
            case 17: {
                return String.valueOf(preferences.getMustMatchFields().isMatchOnAreaName1());
            }
            case 18: {
                return String.valueOf(preferences.getMustMatchFields().isMatchOnAreaName2());
            }
            case 19: {
                return String.valueOf(preferences.getMustMatchFields().isMatchOnAreaName3());
            }
            case 20: {
                return String.valueOf(preferences.getMustMatchFields().isMatchOnAreaName4());
            }
            case 21: {
                return String.valueOf(preferences.getMustMatchFields().isMatchOnPlaceName());
            }
            case 22: {
                return String.valueOf(preferences.getMustMatchFields().isMatchOnPostCode1());
            }
            case 23: {
                return String.valueOf(preferences.getMustMatchFields().isMatchOnPostCode2());
            }
            case 24: {
                return String.valueOf(preferences.getMustMatchFields().isMatchOnStreetName());
            }
            case 25: {
                return String.valueOf(preferences.getMustMatchFields().isMatchOnInputFields());
            }
            case 26: {
                return String.valueOf(preferences.getReturnFieldsDescriptor().isReturnAllCustomFields());
            }
            case 28: {
                return String.valueOf(preferences.getReturnFieldsDescriptor().isReturnMatchDescriptor());
            }
            case 29: {
                return String.valueOf(preferences.getReturnFieldsDescriptor().isReturnStreetAddressFields());
            }
            case 30: {
                return String.valueOf(preferences.getReturnFieldsDescriptor().isReturnUnitInformation());
            }
            case 27: {
                Set<String> keys = preferences.getReturnFieldsDescriptor().getKeysOfCustomFieldsToReturn();
                if (keys == null) {
                    return null;
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (String customKey : keys) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(customKey);
                }
                return stringBuilder.toString();
            }
        }
        return null;
    }

    public Preferences buildPreferenceOverridesForCountry(String country) {
        Map<String, String> custom;
        GeocoderPreferences preferencesCopy = new GeocoderPreferences(this);
        if (StringUtils.isEmpty((CharSequence)country)) {
            return preferencesCopy;
        }
        if (country != null) {
            country = country.toUpperCase();
        }
        if ((custom = preferencesCopy.getCustomPreferences()) == null || custom.isEmpty()) {
            return preferencesCopy;
        }
        HashSet<String> deleteKeys = new HashSet<String>();
        HashMap<String, String> addCustoms = new HashMap<String, String>();
        block33: for (String key : custom.keySet()) {
            if (key.length() > 4 && key.charAt(3) == '.') {
                deleteKeys.add(key);
            }
            if (country == null || !key.startsWith(country)) continue;
            String partial = key.substring(3);
            String value = custom.get(key);
            int idx = keyIndexes.indexOf(partial);
            switch (idx) {
                case 0: {
                    preferencesCopy.setClientCoordSysName(value);
                    continue block33;
                }
                case 1: {
                    preferencesCopy.setClientLocale(FlatLocale.getLocale(value));
                    continue block33;
                }
                case 2: {
                    preferencesCopy.setCornerOffset(Double.valueOf(value));
                    continue block33;
                }
                case 3: {
                    preferencesCopy.setCornerOffsetUnits(DistanceUnit.fromValue(value));
                    continue block33;
                }
                case 4: {
                    preferencesCopy.setDistance(Double.valueOf(value));
                    continue block33;
                }
                case 5: {
                    preferencesCopy.setDistanceUnits(DistanceUnit.fromValue(value));
                    continue block33;
                }
                case 6: {
                    preferencesCopy.setFallbackToGeographic(Boolean.valueOf(value));
                    continue block33;
                }
                case 7: {
                    preferencesCopy.setFallbackToPostal(Boolean.valueOf(value));
                    continue block33;
                }
                case 24: {
                    preferencesCopy.getMustMatchFields().setMatchOnStreetName(Boolean.valueOf(value));
                    continue block33;
                }
                case 15: {
                    preferencesCopy.getMustMatchFields().setMatchOnAddressNumber(Boolean.valueOf(value));
                    continue block33;
                }
                case 16: {
                    preferencesCopy.getMustMatchFields().setMatchOnAllStreetFields(Boolean.valueOf(value));
                    continue block33;
                }
                case 17: {
                    preferencesCopy.getMustMatchFields().setMatchOnAreaName1(Boolean.valueOf(value));
                    continue block33;
                }
                case 18: {
                    preferencesCopy.getMustMatchFields().setMatchOnAreaName2(Boolean.valueOf(value));
                    continue block33;
                }
                case 19: {
                    preferencesCopy.getMustMatchFields().setMatchOnAreaName3(Boolean.valueOf(value));
                    continue block33;
                }
                case 20: {
                    preferencesCopy.getMustMatchFields().setMatchOnAreaName4(Boolean.valueOf(value));
                    continue block33;
                }
                case 21: {
                    preferencesCopy.getMustMatchFields().setMatchOnPlaceName(Boolean.valueOf(value));
                    continue block33;
                }
                case 22: {
                    preferencesCopy.getMustMatchFields().setMatchOnPostCode1(Boolean.valueOf(value));
                    continue block33;
                }
                case 23: {
                    preferencesCopy.getMustMatchFields().setMatchOnPostCode2(Boolean.valueOf(value));
                    continue block33;
                }
                case 25: {
                    preferencesCopy.getMustMatchFields().setMatchOnInputFields(Boolean.valueOf(value));
                    continue block33;
                }
                case 8: {
                    Enum mode = USAMatchMode.valueOf(value);
                    if (mode != USAMatchMode.CASS && mode != USAMatchMode.INTERACTIVE) {
                        mode = StandardMatchMode.valueOf(value);
                    }
                    preferencesCopy.setMatchMode((MatchMode)((Object)mode));
                    continue block33;
                }
                case 9: {
                    preferencesCopy.setMaxReturnedCandidates(Integer.valueOf(value));
                    continue block33;
                }
                case 10: {
                    preferencesCopy.setMaxReturnedRangeUnits(Integer.valueOf(value));
                    continue block33;
                }
                case 11: {
                    preferencesCopy.setMaxReturnedRanges(Integer.valueOf(value));
                    continue block33;
                }
                case 12: {
                    preferencesCopy.setReturnAllCandidateInfo(Boolean.valueOf(value));
                    continue block33;
                }
                case 26: {
                    preferencesCopy.getReturnFieldsDescriptor().setReturnAllCustomFields(Boolean.valueOf(value));
                    continue block33;
                }
                case 29: {
                    preferencesCopy.getReturnFieldsDescriptor().setReturnStreetAddressFields(Boolean.valueOf(value));
                    continue block33;
                }
                case 28: {
                    preferencesCopy.getReturnFieldsDescriptor().setReturnMatchDescriptor(Boolean.valueOf(value));
                    continue block33;
                }
                case 30: {
                    preferencesCopy.getReturnFieldsDescriptor().setReturnUnitInformation(Boolean.valueOf(value));
                    continue block33;
                }
                case 27: {
                    StringTokenizer st = new StringTokenizer(value, " ,|;\t");
                    HashSet<String> keys = new HashSet<String>();
                    while (st.hasMoreTokens()) {
                        keys.add(st.nextToken());
                    }
                    preferencesCopy.getReturnFieldsDescriptor().setKeysOfCustomFieldsToReturn(keys);
                    continue block33;
                }
                case 13: {
                    preferencesCopy.setStreetOffset(Double.valueOf(value));
                    continue block33;
                }
                case 14: {
                    preferencesCopy.setStreetOffsetUnits(DistanceUnit.fromValue(value));
                    continue block33;
                }
            }
            addCustoms.put(key.substring(4), value);
        }
        for (String key : addCustoms.keySet()) {
            preferencesCopy.addCustomPreference(key, (String)addCustoms.get(key));
        }
        for (String key : deleteKeys) {
            custom.remove(key);
        }
        return preferencesCopy;
    }

    public static String getOverrideLocaleString(Locale locale) {
        return FlatLocale.getString(locale);
    }

    public static Locale getOverrideLocale(String string) {
        return FlatLocale.getLocale(string);
    }

    static {
        ArrayList<String> temp = new ArrayList<String>();
        temp.add(OVERRIDE_CLIENT_COORDSYS_NAME);
        temp.add(OVERRIDE_CLIENT_LOCALE);
        temp.add(OVERRIDE_CORNER_OFFSET);
        temp.add(OVERRIDE_CORNER_OFFSET_UNITS);
        temp.add(OVERRIDE_DISTANCE);
        temp.add(OVERRIDE_DISTANCE_UNITS);
        temp.add(OVERRIDE_FALLBACK_TO_GEOGRAPHIC);
        temp.add(OVERRIDE_FALLBACK_TO_POSTAL);
        temp.add(OVERRIDE_MATCH_MODE);
        temp.add(OVERRIDE_MAX_RETURNED_CANDIDATES);
        temp.add(OVERRIDE_MAX_RETURNED_RANGE_UNITS);
        temp.add(OVERRIDE_MAX_RETURNED_RANGES);
        temp.add(OVERRIDE_RETURN_ALL_CANDIDATE_INFO);
        temp.add(OVERRIDE_STREET_OFFSET);
        temp.add(OVERRIDE_STREET_OFFSET_UNITS);
        temp.add(OVERRIDE_MUST_MATCH_ADDRESS_NUMBER);
        temp.add(OVERRIDE_MUST_MATCH_ALL_STREET_FIELDS);
        temp.add(OVERRIDE_MUST_MATCH_AREA_NAME1);
        temp.add(OVERRIDE_MUST_MATCH_AREA_NAME2);
        temp.add(OVERRIDE_MUST_MATCH_AREA_NAME3);
        temp.add(OVERRIDE_MUST_MATCH_AREA_NAME4);
        temp.add(OVERRIDE_MUST_MATCH_PLACE_NAME);
        temp.add(OVERRIDE_MUST_MATCH_POST_CODE1);
        temp.add(OVERRIDE_MUST_MATCH_POST_CODE2);
        temp.add(OVERRIDE_MUST_MATCH_STREET_NAME);
        temp.add(OVERRIDE_MUST_MATCH_INPUT_FIELDS);
        temp.add(OVERRIDE_RETURN_ALL_CUSTOM_FIELDS);
        temp.add(OVERRIDE_RETURN_CUSTOM_FIELD_KEYS);
        temp.add(OVERRIDE_RETURN_MATCH_DESCRIPTOR);
        temp.add(OVERRIDE_RETURN_STREET_ADDRESS_FIELDS);
        temp.add(OVERRIDE_RETURN_UNIT_INFORMATION);
        keyIndexes = Collections.unmodifiableList(temp);
    }

    private static class FlatLocale {
        private FlatLocale() {
        }

        public static String getString(Locale locale) {
            if (locale == null) {
                return null;
            }
            String language = locale.getLanguage();
            String country = locale.getCountry();
            String variant = locale.getVariant();
            StringBuilder stringBuilder = new StringBuilder(language);
            if (country != null) {
                stringBuilder.append(';');
                stringBuilder.append(country);
                if (variant != null) {
                    stringBuilder.append(';');
                    stringBuilder.append(variant);
                }
                stringBuilder.append(';');
            }
            return stringBuilder.toString();
        }

        public static Locale getLocale(String str) {
            if (str == null) {
                return null;
            }
            StringTokenizer st = new StringTokenizer(str, ";");
            String language = st.hasMoreTokens() ? st.nextToken() : "";
            String country = st.hasMoreTokens() ? st.nextToken() : "";
            String variant = st.hasMoreTokens() ? st.nextToken() : "";
            return new Locale(language, country, variant);
        }
    }
}

