/*
 * Decompiled with CFR 0.152.
 */
import com.mapinfo.mapmarker.CHE.CHE_GeocodeConstraints;
import com.mapinfo.mapmarker.CHE.CHE_UserCandidateAddress;
import com.mapinfo.mapmarker.CHE.CHE_UserInputAddress;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.user.ClientGeocodeResponse;
import com.mapinfo.mapmarker.user.InputAddress;
import com.mapinfo.mapmarker.user.MMJClient;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;

public class MMJE_CHE_Sample
extends JFrame
implements ActionListener {
    private final String TITLE = "MapMarker Switzerland/ Liechtenstein Server 4.0";
    private final Dimension SIZE = new Dimension(800, 650);
    private JTextField m_street = null;
    private JTextField m_town = null;
    private JComboBox m_country = null;
    private JTextField m_postCode = null;
    private JTextField m_postaddress = null;
    private JTextField m_URL = null;
    private JButton m_closeButton = null;
    private JButton m_geocodeButton = null;
    private JButton m_postalButton = null;
    private JButton m_testButton = null;
    private JButton m_geographicButton = null;
    private JButton m_browseButton = null;
    private JCheckBox m_closeMatch = null;
    private JCheckBox m_mmNumber = null;
    private JCheckBox m_mmStreet = null;
    private JCheckBox m_mmZip = null;
    private JCheckBox m_mmTown = null;
    private JCheckBox m_mmInput = null;
    private JCheckBox m_fallToZip = null;
    private JCheckBox m_fallToGeo = null;
    private JComboBox m_maxCands = null;
    private JTable m_candidates = null;
    private JLabel m_serverAvail = null;
    private JLabel m_lblCandCount = null;
    private JLabel m_lblTotalCands = null;
    private JLabel m_lblTotalClose = null;
    private Font m_font = null;

    public MMJE_CHE_Sample() {
        this.init();
        String urlString = null;
        Properties p = new Properties();
        try {
            InputStream stream = ClassLoader.getSystemResourceAsStream("mmjsample.properties");
            DataInputStream dis = new DataInputStream(stream);
            p.load(dis);
            urlString = p.getProperty("connectionUrl");
        }
        catch (IOException ioe) {
            System.out.println("unable to load mmjsample.properties file.");
        }
        this.loadComponents();
        this.m_URL.setText(urlString);
    }

    private void init() {
        this.getContentPane().setLayout(null);
        this.setTitle("MapMarker Switzerland/ Liechtenstein Server 4.0");
        this.setSize(this.SIZE);
        this.setResizable(true);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dim2 = this.getSize();
        this.setLocation(dim.width / 2 - dim2.width / 2, dim.height / 2 - dim2.height / 2);
        this.m_font = new Font("System", 0, 12);
    }

    private void loadComponents() {
        Container pane = this.getContentPane();
        JLabel lblStreet = new JLabel("Street Address Line:");
        lblStreet.setFont(this.m_font);
        int maxSize = new Double(lblStreet.getMaximumSize().getWidth()).intValue();
        lblStreet.setBounds(5, 1, maxSize, 20);
        int ht = lblStreet.getHeight();
        pane.add(lblStreet);
        this.m_street = new JTextField("", 15);
        this.m_street.setBounds(5, ht, 200, 20);
        pane.add(this.m_street);
        JLabel lblPostcode = new JLabel("Postcode:");
        lblPostcode.setFont(this.m_font);
        maxSize = new Double(lblPostcode.getMaximumSize().getWidth()).intValue();
        lblPostcode.setBounds(5, this.m_street.getY() + this.m_street.getHeight(), maxSize, 20);
        ht = lblPostcode.getHeight();
        pane.add(lblPostcode);
        this.m_postCode = new JTextField("", 15);
        this.m_postCode.setBounds(5, ht + this.m_street.getY() + this.m_street.getHeight(), 200, 20);
        pane.add(this.m_postCode);
        JLabel lblTown = new JLabel("Town:");
        lblTown.setFont(this.m_font);
        maxSize = new Double(lblTown.getMaximumSize().getWidth()).intValue();
        lblTown.setBounds(5, this.m_postCode.getY() + this.m_postCode.getHeight(), maxSize, 20);
        ht = lblTown.getHeight();
        pane.add(lblTown);
        this.m_town = new JTextField("", 15);
        this.m_town.setBounds(5, ht + this.m_postCode.getY() + this.m_postCode.getHeight(), 200, 20);
        pane.add(this.m_town);
        JLabel countryLabel = new JLabel("Country:");
        countryLabel.setFont(this.m_font);
        maxSize = new Double(countryLabel.getMaximumSize().getWidth()).intValue();
        countryLabel.setBounds(5, this.m_town.getY() + this.m_town.getHeight(), maxSize, 20);
        ht = countryLabel.getHeight();
        pane.add(countryLabel);
        this.m_country = new JComboBox<String>(new String[]{"CHE", "LIE"});
        this.m_country.setBackground(Color.WHITE);
        this.m_country.setBounds(5, ht + this.m_town.getY() + this.m_town.getHeight(), 200, 20);
        pane.add(this.m_country);
        JPanel pnlPref = new JPanel();
        pnlPref.setLayout(null);
        TitledBorder etchedPref = BorderFactory.createTitledBorder("Preferences");
        pnlPref.setBorder(etchedPref);
        pnlPref.setBounds(this.getWidth() / 2, 5, this.getWidth() / 2 - 8, 120);
        this.m_closeMatch = new JCheckBox("Close Match Only", false);
        this.m_closeMatch.setFont(this.m_font);
        maxSize = new Double(this.m_closeMatch.getMaximumSize().getWidth()).intValue();
        this.m_closeMatch.setBounds(20, 12, maxSize, 20);
        pnlPref.add(this.m_closeMatch);
        this.m_fallToZip = new JCheckBox("Fall Back to Postal Code", false);
        this.m_fallToZip.setFont(this.m_font);
        maxSize = new Double(this.m_fallToZip.getMaximumSize().getWidth()).intValue();
        this.m_fallToZip.setBounds(20, 31, maxSize, 20);
        pnlPref.add(this.m_fallToZip);
        this.m_fallToGeo = new JCheckBox("Fall Back to Geographic Area", false);
        this.m_fallToGeo.setFont(this.m_font);
        maxSize = new Double(this.m_fallToGeo.getMaximumSize().getWidth()).intValue();
        this.m_fallToGeo.setBounds(20, 50, maxSize, 20);
        pnlPref.add(this.m_fallToGeo);
        JLabel lblMaxCands = new JLabel("Max Candidates:");
        lblMaxCands.setFont(this.m_font);
        maxSize = new Double(lblMaxCands.getMaximumSize().getWidth()).intValue();
        lblMaxCands.setBounds(20, 89, maxSize, 20);
        pnlPref.add(lblMaxCands);
        this.m_maxCands = new JComboBox();
        this.m_maxCands.addItem("ALL");
        for (int i = 0; i < 50; ++i) {
            this.m_maxCands.addItem(String.valueOf(i + 1));
        }
        this.m_maxCands.setSelectedIndex(3);
        this.m_maxCands.setBounds(lblMaxCands.getX() + lblMaxCands.getWidth() + 5, 89, 50, 20);
        pnlPref.add(this.m_maxCands);
        pane.add(pnlPref);
        JPanel pnlMustMatch = new JPanel();
        pnlMustMatch.setLayout(null);
        TitledBorder bdrMustMatch = BorderFactory.createTitledBorder("Must Match Options");
        pnlMustMatch.setBorder(bdrMustMatch);
        pnlMustMatch.setBounds(this.getWidth() / 2, pnlPref.getHeight() + 5, this.getWidth() / 2 - 8, 70);
        this.m_mmNumber = new JCheckBox("Number", false);
        this.m_mmNumber.setFont(this.m_font);
        maxSize = new Double(this.m_mmNumber.getMaximumSize().getWidth()).intValue();
        this.m_mmNumber.setBounds(20, 20, maxSize, 20);
        pnlMustMatch.add(this.m_mmNumber);
        this.m_mmStreet = new JCheckBox("Street", true);
        this.m_mmStreet.setFont(this.m_font);
        maxSize = new Double(this.m_mmStreet.getMaximumSize().getWidth()).intValue();
        this.m_mmStreet.setBounds(20, 40, maxSize, 20);
        pnlMustMatch.add(this.m_mmStreet);
        this.m_mmZip = new JCheckBox("PostCode", false);
        this.m_mmZip.setFont(this.m_font);
        maxSize = new Double(this.m_mmZip.getMaximumSize().getWidth()).intValue();
        this.m_mmZip.setBounds(100, 20, maxSize, 20);
        pnlMustMatch.add(this.m_mmZip);
        this.m_mmTown = new JCheckBox("Town", true);
        this.m_mmTown.setFont(this.m_font);
        maxSize = new Double(this.m_mmTown.getMaximumSize().getWidth()).intValue();
        this.m_mmTown.setBounds(100, 40, maxSize, 20);
        pnlMustMatch.add(this.m_mmTown);
        this.m_mmInput = new JCheckBox("Input", false);
        this.m_mmInput.setFont(this.m_font);
        maxSize = new Double(this.m_mmInput.getMaximumSize().getWidth()).intValue();
        this.m_mmInput.setBounds(175, 20, maxSize, 20);
        pnlMustMatch.add(this.m_mmInput);
        pane.add(pnlMustMatch);
        JPanel pnlURL = new JPanel();
        pnlURL.setLayout(null);
        TitledBorder bdrURL = BorderFactory.createTitledBorder("MapMarker Server URL");
        pnlURL.setBorder(bdrURL);
        pnlURL.setBounds(0, pnlMustMatch.getY() + pnlMustMatch.getHeight() + 70, this.getWidth() - 8, 75);
        this.m_URL = new JTextField("http://localhost:8080/mapmarker20/servlet/mapmarker", 15);
        this.m_URL.setBounds(5, 20, pnlURL.getWidth() - 8, 20);
        pnlURL.add(this.m_URL);
        this.m_serverAvail = new JLabel("Server: UNKNOWN");
        this.m_serverAvail.setFont(this.m_font);
        maxSize = new Double(this.m_serverAvail.getMaximumSize().getWidth()).intValue();
        this.m_serverAvail.setBounds(5, 50, maxSize, 20);
        pnlURL.add(this.m_serverAvail);
        this.m_testButton = new JButton("Test");
        this.m_testButton.setHorizontalAlignment(0);
        this.m_testButton.setFont(this.m_font);
        this.m_testButton.setMnemonic('T');
        this.m_testButton.setBounds(pnlURL.getWidth() - 100, 45, 80, 25);
        this.m_testButton.addActionListener(this);
        this.m_testButton.setEnabled(true);
        pnlURL.add(this.m_testButton);
        pane.add(pnlURL);
        JPanel pnlCand = new JPanel();
        pnlCand.setLayout(new BorderLayout());
        TitledBorder bdrCand = BorderFactory.createTitledBorder("Candidates");
        pnlCand.setBorder(bdrCand);
        pnlCand.setBounds(0, pnlURL.getY() + pnlURL.getHeight(), this.getWidth() - 8, 180);
        CandidateTableModel model = new CandidateTableModel();
        this.m_candidates = new JTable(model);
        this.m_candidates.setAutoResizeMode(0);
        this.m_candidates.updateUI();
        pnlCand.add((Component)this.m_candidates.getTableHeader(), "North");
        JScrollPane scrollPane = new JScrollPane(this.m_candidates);
        pnlCand.add((Component)scrollPane, "Center");
        pane.add(pnlCand);
        JPanel pnlStats = new JPanel();
        pnlStats.setLayout(null);
        TitledBorder bdrStats = BorderFactory.createTitledBorder("Candidates Statistics");
        pnlStats.setBorder(bdrStats);
        pnlStats.setBounds(0, 500, this.getWidth() - 8, 75);
        this.m_lblTotalCands = new JLabel("Total Possible Candidates: 0   ");
        this.m_lblTotalCands.setFont(this.m_font);
        maxSize = new Double(this.m_lblTotalCands.getMaximumSize().getWidth()).intValue();
        this.m_lblTotalCands.setBounds(10, 20, maxSize + 5, 20);
        pnlStats.add(this.m_lblTotalCands);
        this.m_lblTotalClose = new JLabel("Total Close Match Candidates: 0   ");
        this.m_lblTotalClose.setFont(this.m_font);
        maxSize = new Double(this.m_lblTotalClose.getMaximumSize().getWidth()).intValue();
        this.m_lblTotalClose.setBounds(10, 40, maxSize + 5, 20);
        pnlStats.add(this.m_lblTotalClose);
        this.m_lblCandCount = new JLabel("Total Returned Candidates: 0   ");
        this.m_lblCandCount.setFont(this.m_font);
        maxSize = new Double(this.m_lblCandCount.getMaximumSize().getWidth()).intValue();
        this.m_lblCandCount.setBounds(325, 20, maxSize + 5, 20);
        pnlStats.add(this.m_lblCandCount);
        pane.add(pnlStats);
        JPanel panel = new JPanel();
        panel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        panel.setLayout(null);
        Border etched = BorderFactory.createEtchedBorder();
        panel.setBorder(etched);
        panel.setBounds(0, this.getHeight() - 80, this.getWidth() - 8, 50);
        this.m_geocodeButton = new JButton("Geocode Address");
        this.m_geocodeButton.setFont(this.m_font);
        this.m_geocodeButton.setMnemonic('A');
        this.m_geocodeButton.setBounds(5, 10, 140, 30);
        this.m_geocodeButton.addActionListener(this);
        panel.add(this.m_geocodeButton);
        this.m_postalButton = new JButton("Geocode Postal");
        this.m_postalButton.setFont(this.m_font);
        this.m_postalButton.setMnemonic('P');
        this.m_postalButton.setBounds(150, 10, 140, 30);
        this.m_postalButton.addActionListener(this);
        panel.add(this.m_postalButton);
        this.m_geographicButton = new JButton("Geocode Geography");
        this.m_geographicButton.setFont(this.m_font);
        this.m_geographicButton.setMnemonic('G');
        this.m_geographicButton.setBounds(295, 10, 150, 30);
        this.m_geographicButton.addActionListener(this);
        panel.add(this.m_geographicButton);
        this.m_browseButton = new JButton("Browse");
        this.m_browseButton.setFont(this.m_font);
        this.m_browseButton.setMnemonic('B');
        this.m_browseButton.setBounds(450, 10, 80, 30);
        this.m_browseButton.addActionListener(this);
        panel.add(this.m_browseButton);
        this.m_closeButton = new JButton("Close");
        this.m_closeButton.setFont(this.m_font);
        this.m_closeButton.setMnemonic('C');
        this.m_closeButton.setBounds(535, 10, 85, 30);
        this.m_closeButton.addActionListener(this);
        panel.add(this.m_closeButton);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        pane.add(panel);
        this.m_postCode.setNextFocusableComponent(this.m_town);
        this.m_town.setNextFocusableComponent(this.m_closeMatch);
        this.m_closeMatch.setNextFocusableComponent(this.m_fallToZip);
        this.m_fallToZip.setNextFocusableComponent(this.m_fallToGeo);
        this.m_fallToGeo.setNextFocusableComponent(this.m_maxCands);
        this.m_maxCands.setNextFocusableComponent(this.m_mmNumber);
        this.m_mmNumber.setNextFocusableComponent(this.m_mmStreet);
        this.m_mmStreet.setNextFocusableComponent(this.m_mmZip);
        this.m_mmZip.setNextFocusableComponent(this.m_mmTown);
        this.m_mmTown.setNextFocusableComponent(this.m_mmInput);
        this.m_mmInput.setNextFocusableComponent(this.m_URL);
        this.m_URL.setNextFocusableComponent(this.m_testButton);
        this.m_testButton.setNextFocusableComponent(this.m_geocodeButton);
        this.m_geocodeButton.setNextFocusableComponent(this.m_postalButton);
        this.m_postalButton.setNextFocusableComponent(this.m_geographicButton);
        this.m_geographicButton.setNextFocusableComponent(this.m_browseButton);
        this.m_browseButton.setNextFocusableComponent(this.m_closeButton);
        this.m_closeButton.setNextFocusableComponent(this.m_street);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try {
            Object source = evt.getSource();
            if (source == this.m_closeButton) {
                System.exit(0);
            }
            if (source == this.m_geocodeButton) {
                this.geocodeAddress();
            }
            if (source == this.m_testButton) {
                this.testServer();
            }
            if (source == this.m_postalButton) {
                this.geocodePostal();
            }
            if (source == this.m_geographicButton) {
                this.geocodeGeographic();
            }
            if (source == this.m_browseButton) {
                this.geocodeBrowse();
            }
        }
        catch (MMJE_CHE_SampleException mse) {
            mse.displayError();
        }
    }

    private void testServer() throws MMJE_CHE_SampleException {
        try {
            if (MMJClient.ping((String)this.m_URL.getText())) {
                this.m_serverAvail.setText("Server: VALID");
            } else {
                this.m_serverAvail.setText("Server: INVALID");
            }
            this.m_serverAvail.updateUI();
        }
        catch (Exception e) {
            throw new MMJE_CHE_SampleException(e.getMessage());
        }
    }

    private void geocodeAddress() throws MMJE_CHE_SampleException {
        try {
            String url = this.m_URL.getText();
            String street = this.m_street.getText();
            String town = null;
            String postAddress = null;
            String province = null;
            String postcode = null;
            String country = null;
            if (this.m_postaddress != null) {
                postAddress = this.m_postaddress.getText();
            }
            town = this.m_town.getText();
            postcode = this.m_postCode.getText();
            country = (String)this.m_country.getSelectedItem();
            if (!(postAddress != null && postAddress.trim().length() != 0 || town != null && town.trim().length() != 0 || postcode != null && postcode.trim().length() != 0)) {
                throw new MMJE_CHE_SampleException("Post address/Town/PostCode not given");
            }
            if (url == null || url.trim().length() == 0) {
                throw new MMJE_CHE_SampleException("URL not given");
            }
            if (street == null || street.trim().length() == 0) {
                throw new MMJE_CHE_SampleException("Street address not given");
            }
            CHE_GeocodeConstraints geoCon = new CHE_GeocodeConstraints();
            String maxCands = (String)this.m_maxCands.getSelectedItem();
            maxCands = maxCands.equalsIgnoreCase("ALL") ? "-1" : (String)this.m_maxCands.getSelectedItem();
            geoCon.setMustMatchInput(this.m_mmInput.isSelected());
            geoCon.setMustMatchAddressNumber(this.m_mmNumber.isSelected());
            geoCon.setMustMatchMainAddress(this.m_mmStreet.isSelected());
            geoCon.setMustMatchPostalCode(this.m_mmZip.isSelected());
            geoCon.setMustMatchArea3(this.m_mmTown.isSelected());
            geoCon.setMaxCandidates(new Integer(maxCands));
            geoCon.setReturnCloseCandidatesOnly(this.m_closeMatch.isSelected());
            geoCon.setFallbackToPostal(this.m_fallToZip.isSelected());
            geoCon.setFallbackToGeographic(this.m_fallToGeo.isSelected());
            geoCon.setClientCoordinateSystem("epsg:4326");
            geoCon.setClientLocale(Locale.US);
            geoCon.setCornerOffset(7.0);
            geoCon.setCornerOffsetUnits("m");
            geoCon.setStreetOffset(7.0);
            geoCon.setStreetOffsetUnits("m");
            CHE_UserInputAddress inpAddr = new CHE_UserInputAddress(country);
            ClientGeocodeResponse geoRes = null;
            CandidateTableModel tm = (CandidateTableModel)this.m_candidates.getModel();
            tm.clearData();
            this.m_candidates.updateUI();
            inpAddr.setStreet(street);
            if (postAddress != null && postAddress.length() != 0) {
                inpAddr.setPostAddress(postAddress);
            }
            if (town != null) {
                inpAddr.setTown(town);
            }
            if (postcode != null) {
                inpAddr.setPostcode(postcode);
            }
            if (province != null) {
                inpAddr.setProvince(province);
            }
            inpAddr.setCountry(country);
            geoRes = MMJClient.geocode((int)0, (InputAddress)inpAddr, (IGeocodeConstraints)geoCon, (String)url);
            if (geoRes == null) {
                throw new MMJE_CHE_SampleException("Null returned from Geocode Address");
            }
            this.fillTableWithCandidates(geoRes, tm);
        }
        catch (Exception e) {
            throw new MMJE_CHE_SampleException(e.getMessage());
        }
    }

    private void geocodePostal() throws MMJE_CHE_SampleException {
        try {
            String url = this.m_URL.getText();
            String postcode = this.m_postCode.getText();
            String country = (String)this.m_country.getSelectedItem();
            CHE_GeocodeConstraints geoCon = new CHE_GeocodeConstraints();
            String maxCands = (String)this.m_maxCands.getSelectedItem();
            maxCands = maxCands.equalsIgnoreCase("ALL") ? "-1" : (String)this.m_maxCands.getSelectedItem();
            geoCon.setMustMatchInput(this.m_mmInput.isSelected());
            geoCon.setMustMatchPostalCode(this.m_mmZip.isSelected());
            geoCon.setMaxCandidates(new Integer(maxCands));
            geoCon.setReturnCloseCandidatesOnly(this.m_closeMatch.isSelected());
            geoCon.setClientCoordinateSystem("epsg:4326");
            geoCon.setClientLocale(Locale.US);
            CandidateTableModel tm = (CandidateTableModel)this.m_candidates.getModel();
            tm.clearData();
            this.m_candidates.updateUI();
            CHE_UserInputAddress inpAddr = new CHE_UserInputAddress(country);
            if (postcode != null) {
                inpAddr.setPostcode(postcode);
            }
            ClientGeocodeResponse geoRes = null;
            geoRes = MMJClient.geocode((int)1, (InputAddress)inpAddr, (IGeocodeConstraints)geoCon, (String)url);
            if (geoRes == null) {
                throw new MMJE_CHE_SampleException("Null returned from Geocode Address");
            }
            this.fillTableWithCandidates(geoRes, tm);
        }
        catch (Exception e) {
            throw new MMJE_CHE_SampleException(e.getMessage());
        }
    }

    private void geocodeGeographic() throws MMJE_CHE_SampleException {
        try {
            String url = this.m_URL.getText();
            String town = this.m_town.getText();
            String country = (String)this.m_country.getSelectedItem();
            CHE_GeocodeConstraints geoCon = new CHE_GeocodeConstraints();
            String maxCands = (String)this.m_maxCands.getSelectedItem();
            maxCands = maxCands.equalsIgnoreCase("ALL") ? "-1" : (String)this.m_maxCands.getSelectedItem();
            geoCon.setMustMatchInput(this.m_mmInput.isSelected());
            geoCon.setMustMatchArea3(this.m_mmTown.isSelected());
            geoCon.setMaxCandidates(new Integer(maxCands));
            geoCon.setReturnCloseCandidatesOnly(this.m_closeMatch.isSelected());
            geoCon.setClientCoordinateSystem("epsg:4326");
            geoCon.setClientLocale(Locale.US);
            CandidateTableModel tm = (CandidateTableModel)this.m_candidates.getModel();
            tm.clearData();
            this.m_candidates.updateUI();
            CHE_UserInputAddress inpAddr = new CHE_UserInputAddress(country);
            if (town != null) {
                inpAddr.setTown(town);
            }
            ClientGeocodeResponse geoRes = null;
            geoRes = MMJClient.geocode((int)4, (InputAddress)inpAddr, (IGeocodeConstraints)geoCon, (String)url);
            if (geoRes == null) {
                throw new MMJE_CHE_SampleException("Null returned from Geocode Address");
            }
            this.fillTableWithCandidates(geoRes, tm);
        }
        catch (Exception e) {
            throw new MMJE_CHE_SampleException(e.getMessage());
        }
    }

    private void geocodeBrowse() throws MMJE_CHE_SampleException {
        try {
            String url = this.m_URL.getText();
            String street = this.m_street.getText();
            String town = null;
            String postAddress = null;
            String province = null;
            String postcode = null;
            String country = null;
            if (this.m_postaddress != null) {
                postAddress = this.m_postaddress.getText();
            }
            town = this.m_town.getText();
            postcode = this.m_postCode.getText();
            country = (String)this.m_country.getSelectedItem();
            if (!(postAddress != null && postAddress.trim().length() != 0 || town != null && town.trim().length() != 0 || postcode != null && postcode.trim().length() != 0)) {
                throw new MMJE_CHE_SampleException("Post address/Town/PostCode not given");
            }
            if (url == null || url.trim().length() == 0) {
                throw new MMJE_CHE_SampleException("URL not given");
            }
            if (street == null || street.trim().length() == 0) {
                throw new MMJE_CHE_SampleException("Street address not given");
            }
            CHE_GeocodeConstraints geoCon = new CHE_GeocodeConstraints();
            String maxCands = (String)this.m_maxCands.getSelectedItem();
            maxCands = maxCands.equalsIgnoreCase("ALL") ? "-1" : (String)this.m_maxCands.getSelectedItem();
            geoCon.setMustMatchInput(this.m_mmInput.isSelected());
            geoCon.setMustMatchAddressNumber(this.m_mmNumber.isSelected());
            geoCon.setMustMatchMainAddress(this.m_mmStreet.isSelected());
            geoCon.setMustMatchPostalCode(this.m_mmZip.isSelected());
            geoCon.setMustMatchArea3(this.m_mmTown.isSelected());
            geoCon.setMaxCandidates(new Integer(maxCands));
            geoCon.setReturnCloseCandidatesOnly(this.m_closeMatch.isSelected());
            geoCon.setFallbackToPostal(this.m_fallToZip.isSelected());
            geoCon.setFallbackToGeographic(this.m_fallToGeo.isSelected());
            geoCon.setClientCoordinateSystem("epsg:4326");
            geoCon.setClientLocale(Locale.US);
            geoCon.setCornerOffset(7.0);
            geoCon.setCornerOffsetUnits("m");
            geoCon.setStreetOffset(7.0);
            geoCon.setStreetOffsetUnits("m");
            geoCon.setCustomString("KEY_GEOBASE_FOR_AREA3", new Boolean(true).toString());
            CHE_UserInputAddress inpAddr = new CHE_UserInputAddress(country);
            ClientGeocodeResponse geoRes = null;
            CandidateTableModel tm = (CandidateTableModel)this.m_candidates.getModel();
            tm.clearData();
            this.m_candidates.updateUI();
            inpAddr.setStreet(street);
            if (postAddress != null && postAddress.length() != 0) {
                inpAddr.setPostAddress(postAddress);
            }
            if (town != null) {
                inpAddr.setTown(town);
            }
            if (postcode != null) {
                inpAddr.setPostcode(postcode);
            }
            if (province != null) {
                inpAddr.setProvince(province);
            }
            inpAddr.setCountry(country);
            geoRes = MMJClient.geocode((int)6, (InputAddress)inpAddr, (IGeocodeConstraints)geoCon, (String)url);
            if (geoRes == null) {
                throw new MMJE_CHE_SampleException("Null returned from Geocode Address");
            }
            this.fillTableWithCandidatesBrowse(geoRes, tm);
        }
        catch (Exception e) {
            throw new MMJE_CHE_SampleException(e.getMessage());
        }
    }

    private void fillTableWithCandidates(ClientGeocodeResponse geoRes, CandidateTableModel tm) throws Exception {
        int candCount = geoRes.candidateCount();
        if (candCount > 0) {
            for (int i = 0; i < candCount; ++i) {
                ArrayList<String> data = new ArrayList<String>();
                CHE_UserCandidateAddress candAddr = new CHE_UserCandidateAddress((Address)geoRes.candidateAt(i));
                data.add(String.valueOf(candAddr.isCloseMatch()).toUpperCase().substring(0, 1));
                data.add(candAddr.getStreet());
                data.add(candAddr.getHouseNumber());
                data.add(candAddr.getPostcode());
                data.add(candAddr.getLocality());
                data.add(candAddr.getTown());
                data.add(candAddr.getProvince());
                data.add(candAddr.getRegion());
                data.add(candAddr.getPrecisionCode());
                data.add(String.valueOf(candAddr.getLocation().x));
                data.add(String.valueOf(candAddr.getLocation().y));
                data.add(candAddr.getCountry());
                tm.addRow(data);
                this.m_candidates.updateUI();
            }
        }
        this.m_lblCandCount.setText("Total Returned Candidates: " + geoRes.candidateCount());
        this.m_lblTotalCands.setText("Total Possible Candidates: " + geoRes.totalPossibleCandidates());
        this.m_lblTotalClose.setText("Total Close Match Candidates: " + geoRes.totalPossibleCloseMatchCandidates());
    }

    private void fillTableWithCandidatesBrowse(ClientGeocodeResponse geoRes, CandidateTableModel tm) throws Exception {
        int candCount = geoRes.candidateCount();
        if (candCount > 0) {
            for (int i = 0; i < candCount; ++i) {
                ArrayList<String> data = new ArrayList<String>();
                CHE_UserCandidateAddress candAddr = new CHE_UserCandidateAddress((Address)geoRes.candidateAt(i));
                data.add(null);
                data.add(1, candAddr.getStreet());
                data.add(null);
                data.add(3, candAddr.getPostcode());
                data.add(4, candAddr.getLocality());
                data.add(5, candAddr.getTown());
                data.add(6, candAddr.getProvince());
                data.add(7, candAddr.getRegion());
                data.add(null);
                data.add(null);
                data.add(null);
                data.add(11, candAddr.getCountry());
                tm.addRow(data);
                this.m_candidates.updateUI();
            }
        }
        this.m_lblCandCount.setText("Total Returned Candidates: " + geoRes.candidateCount());
        this.m_lblTotalCands.setText("Total Possible Candidates: " + geoRes.totalPossibleCandidates());
        this.m_lblTotalClose.setText("Total Close Match Candidates: " + geoRes.totalPossibleCloseMatchCandidates());
    }

    public static void main(String[] args) {
        MMJE_CHE_Sample mmjs = new MMJE_CHE_Sample();
        mmjs.show();
    }

    class CandidateTableModel
    extends AbstractTableModel {
        private ArrayList m_columnList = new ArrayList();
        private ArrayList m_data = new ArrayList();

        CandidateTableModel() {
            this.m_columnList.add("CloseMatch");
            this.m_columnList.add("Street");
            this.m_columnList.add("HNR");
            this.m_columnList.add("PostCode");
            this.m_columnList.add("Locality");
            this.m_columnList.add("Town");
            this.m_columnList.add("Province");
            this.m_columnList.add("Region");
            this.m_columnList.add("ResultCode");
            this.m_columnList.add("Long");
            this.m_columnList.add("Lat");
            this.m_columnList.add("Country");
        }

        @Override
        public String getColumnName(int i) {
            return (String)this.m_columnList.get(i);
        }

        @Override
        public int getRowCount() {
            return this.m_data.size();
        }

        @Override
        public int getColumnCount() {
            if (this.m_columnList == null) {
                return 0;
            }
            return this.m_columnList.size();
        }

        public void addRow(ArrayList rowData) {
            if (this.m_data != null) {
                this.m_data.add(rowData);
            }
        }

        public void clearData() {
            this.m_data.clear();
        }

        @Override
        public Object getValueAt(int r, int c) {
            if (this.m_data == null) {
                return null;
            }
            if (this.m_data.size() <= r) {
                return "";
            }
            ArrayList element = (ArrayList)this.m_data.get(r);
            if (element == null) {
                return "";
            }
            if (element.size() <= c) {
                return "";
            }
            return element.get(c);
        }
    }

    class MMJE_CHE_SampleException
    extends Exception {
        MMJE_CHE_SampleException() {
        }

        MMJE_CHE_SampleException(String msg) {
            super(msg);
        }

        void displayError() {
            JOptionPane.showMessageDialog(null, this.getMessage(), "Application Error", 0);
        }
    }
}

