/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS;

import com.mapinfo.mapmarker.AUS.AUS_Geocoder;
import com.mapinfo.mapmarker.AUS.AUS_Handler;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_DataManager;
import com.mapinfo.mapmarker.AUS.licensing.AUSLicenseFilter;
import com.mapinfo.mapmarker.AUS.singleline.AUSSingleLineParser;
import com.mapinfo.mapmarker.GeocodableAddressCreationException;
import com.mapinfo.mapmarker.GeocodableAddressFactory;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataManagerInitializationException;
import com.mapinfo.mapmarker.core.IGeocoder;
import com.mapinfo.mapmarker.core.singleline.IGeocoderFactory;
import com.mapinfo.mapmarker.core.singleline.ISingleLineParser;
import com.mapinfo.mapmarker.core.singleline.SingleLineGeocoder;
import com.mapinfo.mapmarker.utils.MMJLog;

public class AUSGeocodableAddressFactory
extends GeocodableAddressFactory {
    public IGeocoder createSpecificGeocodableAddress(Address address, IGeocodeConstraints constraints) throws GeocodableAddressCreationException {
        AUSGeocodingFactory factory = new AUSGeocodingFactory();
        return SingleLineGeocoder.getGeocoder((IGeocoderFactory)factory, (ISingleLineParser)new AUSSingleLineParser(), (Address)address, (IGeocodeConstraints)constraints);
    }

    protected void resetSpecificDataManager() throws MMInternalFatalException {
        try {
            AUS_DataManager.reset();
        }
        catch (MMJEDataManagerInitializationException MMJEDMIEx) {
            throw new FatalDataAccessException(2306, (Throwable)MMJEDMIEx);
        }
    }

    protected String[] getLicenseInformation() {
        try {
            AUSLicenseFilter licenseFilter = new AUSLicenseFilter();
            return licenseFilter.getLicenseInformation();
        }
        catch (MapMarkerInternalException e) {
            MMJLog.getLog().debug("Error building license information list.", (Throwable)e);
            return new String[0];
        }
    }

    private static class AUSGeocodingFactory
    implements IGeocoderFactory {
        private AUSGeocodingFactory() {
        }

        public IGeocoder createGeocoder(Address address, IGeocodeConstraints constraints) throws GeocodableAddressCreationException {
            return new AUS_Geocoder(AUS_Handler.buildHandler(address));
        }
    }
}

