/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS;

import com.mapinfo.mapmarker.AUS.AUS_POBoxMatcher;
import com.mapinfo.mapmarker.AUS.AUS_ParsedAddress;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_DataManager;
import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MMGeneralGeocoderException;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.core.IPOBoxHandler;
import com.mapinfo.mapmarker.core.address.IAddressGeocoder;
import com.mapinfo.mapmarker.core.address.ICoreAddressGeocoder;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class AUS_AddressGeocoder
implements IAddressGeocoder {
    public GeocodeResult geocode(IConstraints preferences, ResourceBundle bundle) throws MMInternalFatalException, MapMarkerInternalException {
        boolean geocodedPOBox;
        IHandler handler;
        GeocodeResult geocodeResult;
        int debugLevel;
        block16: {
            debugLevel = DebugLevel.getDebugLevel((int)1);
            geocodeResult = new GeocodeResult();
            handler = preferences.getHandler();
            geocodedPOBox = false;
            try {
                if (handler.isParsedIntersection()) {
                    ((ICoreAddressGeocoder)handler).getStreetGeocoder().geocodeIntersection(preferences, debugLevel, geocodeResult);
                    break block16;
                }
                if (handler.getParsedAddress() != null) {
                    AUS_ParsedAddress pa = (AUS_ParsedAddress)handler.getParsedAddress();
                    if (Boolean.valueOf(pa.getAdditionalFieldForKey(AddressImpl.POB_IN_MAIN_ADDRESS_FIELD)).booleanValue()) {
                        this.geocodeAsPOBox(preferences, geocodeResult, pa.getAddressNumber());
                        geocodedPOBox = true;
                    } else if (((IPOBoxHandler)handler).isDualAddress() && Boolean.valueOf(preferences.getCustomString("PreferPOBoxOverStreet")).booleanValue()) {
                        this.geocodeAsPOBox(preferences, geocodeResult, pa.getPOBoxNumber());
                        geocodedPOBox = true;
                        if (geocodeResult.getNumberCloseCandidates() <= 0) {
                            this.geocodeAsStreet(preferences, geocodeResult, pa, debugLevel);
                        }
                    } else if (((IPOBoxHandler)handler).isDualAddress()) {
                        String number = (String)pa.getAdditionalFields().remove(AddressImpl.KEY_POBOX_NUMBER);
                        this.geocodeAsStreet(preferences, geocodeResult, pa, debugLevel);
                        if (handler.getGeocodeResult().getNumberCloseCandidates() <= 0) {
                            this.geocodeAsPOBox(preferences, geocodeResult, number);
                            geocodedPOBox = true;
                        }
                    } else {
                        this.geocodeAsStreet(preferences, geocodeResult, pa, debugLevel);
                    }
                    break block16;
                }
                if (debugLevel >= 1) {
                    MMJLog.getLog().debug(bundle.getString("err_Parser_no_parse"));
                }
                throw new MMGeneralGeocoderException(2304);
            }
            catch (MapMarkerInternalException e) {
                geocodeResult = new GeocodeResult();
                if (debugLevel < 1) break block16;
                MMJLog.getLog().debug("Exception thrown on geocode", (Throwable)e);
            }
        }
        if (debugLevel >= 1) {
            MMJLog.getLog().debug(geocodeResult.toString());
        }
        if (!geocodedPOBox && geocodeResult.getNumberCloseCandidates() > 1) {
            List sortedMatchResults = null;
            sortedMatchResults = geocodeResult.getIntersectionStatus() ? ((ICoreAddressGeocoder)handler).getMatcher().filterIntersectionCloseMatches(handler.getParsedAddressArray(), handler.getMatchResults()) : ((ICoreAddressGeocoder)handler).getMatcher().filterCloseMatches(handler.getParsedAddressArray(), handler.getMatchResults());
            this.countCandidates(sortedMatchResults, geocodeResult);
            this.countCloseMatches(sortedMatchResults, geocodeResult);
            handler.setGeocodeResult(geocodeResult);
            handler.setMatchResults(sortedMatchResults);
            if (debugLevel >= 1) {
                MMJLog.getLog().debug(geocodeResult.toString());
            }
        }
        return geocodeResult;
    }

    private void geocodeAsStreet(IConstraints preferences, GeocodeResult geocodeResult, AUS_ParsedAddress pa, int debugLevel) throws MapMarkerInternalException, MMInternalFatalException {
        if (StringUtilities.isEmpty((String)pa.getMainAddress()) && !StringUtilities.isEmpty((String)pa.getPlaceName())) {
            preferences.setCustomObject((Object)"search.placename.only", (Object)true);
        }
        ((ICoreAddressGeocoder)preferences.getHandler()).getStreetGeocoder().geocodeSingleAddress(preferences, debugLevel, geocodeResult);
    }

    private void geocodeAsPOBox(IConstraints preferences, GeocodeResult gResult, String number) throws MapMarkerInternalException {
        IHandler handler = preferences.getHandler();
        AUS_ParsedAddress pa = (AUS_ParsedAddress)handler.getParsedAddress();
        pa.setPOBoxInfo(number);
        AUS_DataManager dataMgr = (AUS_DataManager)handler.getDataManager();
        List matchResults = dataMgr.getPostOfficeCandidates(handler.getParsedAddress(), preferences);
        AUS_POBoxMatcher.matchPOBox(matchResults, handler.getParsedAddress(), preferences);
        this.countCloseMatches(matchResults, gResult);
        this.countCandidates(matchResults, gResult);
        gResult.setUniqueMatchFound((double)gResult.getNumberCloseCandidates() == 1.0);
        handler.setGeocodeResult(gResult);
        handler.setMatchResults(matchResults);
    }

    private void countCandidates(List candidateList, GeocodeResult geocodeResult) {
        if (candidateList == null || candidateList.isEmpty()) {
            geocodeResult.setNumberCandidates(0);
            return;
        }
        geocodeResult.setNumberCandidates(candidateList.size());
    }

    private void countCloseMatches(List candidateList, GeocodeResult geocodeResult) {
        int closeMatchCount = 0;
        if (candidateList == null || candidateList.isEmpty()) {
            geocodeResult.setNumberCloseCandidates(0);
            return;
        }
        Iterator candidateIterator = candidateList.iterator();
        boolean done = false;
        while (candidateIterator.hasNext() && !done) {
            ICandidate candidate = (ICandidate)candidateIterator.next();
            if (candidate.isCloseMatch()) {
                ++closeMatchCount;
                continue;
            }
            done = true;
        }
        geocodeResult.setNumberCloseCandidates(closeMatchCount);
    }
}

