/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS;

import com.mapinfo.mapmarker.AUS.AUS_IConstraints;
import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.dp.DataManagerSettingsProvider;
import java.util.Properties;

public class AUS_Constraints
extends Constraints
implements AUS_IConstraints {
    private static final boolean m_bDefaultStreetFrontage;
    private boolean m_bReturnStreetFrontagePoints;
    private boolean m_bReturnGNAFOriginal;
    private boolean m_bPostalCodeOverride;
    private boolean m_bStreetTypeAbbrevs;
    private boolean m_bStrictFirstPass = false;
    private boolean m_bFoundSacs = false;

    public AUS_Constraints() {
    }

    public AUS_Constraints(IConstraints constraints) {
        super(constraints);
        if (constraints instanceof AUS_Constraints) {
            this.m_bReturnStreetFrontagePoints = ((AUS_Constraints)constraints).m_bReturnStreetFrontagePoints;
            this.m_bReturnGNAFOriginal = ((AUS_Constraints)constraints).m_bReturnGNAFOriginal;
            this.m_bPostalCodeOverride = ((AUS_Constraints)constraints).m_bPostalCodeOverride;
            this.m_bStreetTypeAbbrevs = ((AUS_Constraints)constraints).m_bStreetTypeAbbrevs;
            this.m_bStrictFirstPass = ((AUS_Constraints)constraints).m_bStrictFirstPass;
            this.m_bFoundSacs = ((AUS_Constraints)constraints).m_bFoundSacs;
        }
    }

    public static AUS_IConstraints convertFromConstraints(IConstraints inConstraints) {
        if (inConstraints instanceof AUS_IConstraints) {
            return (AUS_IConstraints)inConstraints;
        }
        AUS_Constraints constraints = new AUS_Constraints(inConstraints);
        String tmp = constraints.getCustomString("KEY_STREET_FRONTAGE");
        if (tmp == null) {
            constraints.setReturnStreetFrontagePoints(m_bDefaultStreetFrontage);
        } else {
            constraints.setReturnStreetFrontagePoints("true".equalsIgnoreCase(tmp));
        }
        tmp = constraints.getCustomString("KEY_GNAF_ORIGINAL");
        constraints.setReturnGNAFOriginal("true".equalsIgnoreCase(tmp));
        constraints.setPostalCodeOveride("true".equalsIgnoreCase(constraints.getCustomString("KEY_POSTAL_CODE_OVERRIDE")));
        constraints.setReturnStreetTypeAbbrevs("true".equalsIgnoreCase(constraints.getCustomString("KEY_RETURN_STREET_TYPE_ABBREVS")));
        constraints.setHandler(inConstraints.getHandler());
        return constraints;
    }

    void setReturnStreetFrontagePoints(boolean flag) {
        this.m_bReturnStreetFrontagePoints = flag;
    }

    @Override
    public boolean returnStreetFrontagePoints() {
        return this.m_bReturnStreetFrontagePoints;
    }

    private void setReturnGNAFOriginal(boolean flag) {
        this.m_bReturnGNAFOriginal = flag;
    }

    @Override
    public boolean returnGNAFOriginal() {
        return this.m_bReturnGNAFOriginal;
    }

    public void setPostalCodeOveride(boolean flag) {
        this.m_bPostalCodeOverride = flag;
    }

    @Override
    public boolean usePostalCodeOverride() {
        return this.m_bPostalCodeOverride;
    }

    public void setReturnStreetTypeAbbrevs(boolean flag) {
        this.m_bStreetTypeAbbrevs = flag;
    }

    @Override
    public boolean isReturnStreetTypeAbbrevs() {
        return this.m_bStreetTypeAbbrevs;
    }

    @Override
    public boolean isStrictFirstPass() {
        return this.m_bStrictFirstPass;
    }

    @Override
    public void setStrictFirstPass(boolean flag) {
        this.m_bStrictFirstPass = flag;
    }

    @Override
    public boolean foundSacs() {
        return this.m_bFoundSacs;
    }

    @Override
    public void setFoundSacs(boolean flag) {
        this.m_bFoundSacs = flag;
    }

    @Override
    public AUS_IConstraints copy() {
        Constraints copyCoreConstraints = new Constraints(this.m_constraints);
        return AUS_Constraints.convertFromConstraints((IConstraints)copyCoreConstraints);
    }

    static {
        boolean bTemp = false;
        try {
            Properties dataProps = DataManagerSettingsProvider.getInstance().getSettingsForCountry("AUS");
            if (dataProps != null) {
                bTemp = "true".equalsIgnoreCase(dataProps.getProperty("DEFAULT_STREET_FRONTAGE"));
            }
        }
        catch (Throwable t) {
            bTemp = false;
        }
        m_bDefaultStreetFrontage = bTemp;
    }
}

