/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS;

import com.mapinfo.mapmarker.DictionaryUsagePreference;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.user.GeocodeConstraints;

public class AUS_GeocodeConstraints
extends GeocodeConstraints {
    public static final String GDA94 = "epsg:4283";
    public static final String AGD84 = "mapinfo:coordsys64";
    public static final int GEOCODE_TYPE_PID = 206;
    public static final String KEY_STREET_FRONTAGE_POINTS = "KEY_STREET_FRONTAGE";
    public static final String KEY_GNAF_ORIGINAL = "KEY_GNAF_ORIGINAL";
    public static final String KEY_POSTAL_CODE_OVERRIDE = "KEY_POSTAL_CODE_OVERRIDE";
    public static final String KEY_RETURN_STREET_TYPE_ABBREVS = "KEY_RETURN_STREET_TYPE_ABBREVS";

    public AUS_GeocodeConstraints() {
    }

    public AUS_GeocodeConstraints(GeocodeConstraints defaults) {
        super((IGeocodeConstraints)defaults);
    }

    public synchronized Object setProperty(String key, String value) {
        return this.setCustomString(key, value);
    }

    public String getProperty(String key) {
        String oval = this.getCustomString(key);
        String sval = oval instanceof String ? oval : null;
        return sval;
    }

    protected void init() {
        this.setGeocodeType(0);
        this.setClientCoordinateSystem(GDA94);
        this.setClientLocale("en_AU");
        this.setReturnCloseCandidatesOnly(false);
        this.setCornerOffset(12.0);
        this.setCornerOffsetUnits("m");
        this.setFallbackToGeographic(false);
        this.setFallbackToPostal(false);
        this.setMaxCandidates(3);
        this.setMaxRanges(0);
        this.setMaxRangeUnits(0);
        this.setMustMatchAddressNumber(false);
        this.setMustMatchArea1(false);
        this.setMustMatchArea2(false);
        this.setMustMatchArea3(false);
        this.setMustMatchArea4(false);
        this.setMustMatchInput(false);
        this.setMustMatchCountry(true);
        this.setMustMatchInput(false);
        this.setMustMatchMainAddress(false);
        this.setMustMatchPostalCode(false);
        this.setStreetOffset(10.0);
        this.setStreetOffsetUnits("m");
        this.setDictionaryUsage(DictionaryUsagePreference.AD_AND_UD);
        this.setReturnGNAFOriginal(false);
    }

    public void setDefaultValues() {
        this.init();
    }

    public boolean isMustMatchSuburb() {
        return this.isMustMatchArea3();
    }

    public boolean isMustMatchState() {
        return this.isMustMatchArea1();
    }

    public boolean isMustMatchStreet_Name() {
        return this.isMustMatchMainAddress();
    }

    public void setMustMatchSuburb(boolean bMatch) {
        this.setMustMatchArea3(bMatch);
    }

    public void setMustMatchState(boolean bMatch) {
        this.setMustMatchArea1(bMatch);
    }

    public void setMustMatchStreet_Name(boolean bMatch) {
        this.setMustMatchMainAddress(bMatch);
    }

    public void setReturnStreetFrontagePoints(boolean bFlag) {
        this.setCustomString(KEY_STREET_FRONTAGE_POINTS, String.valueOf(bFlag));
    }

    public boolean getReturnStreetFrontagePoints() {
        return "true".equalsIgnoreCase(this.getCustomString(KEY_STREET_FRONTAGE_POINTS, "false"));
    }

    public boolean getUsingDefaultStreetFrontagePoints() {
        return this.getCustomString(KEY_STREET_FRONTAGE_POINTS) == null;
    }

    public void setReturnGNAFOriginal(boolean bFlag) {
        this.setCustomString(KEY_GNAF_ORIGINAL, String.valueOf(bFlag));
    }

    public boolean returnGNAFOriginal() {
        return "true".equalsIgnoreCase(this.getCustomString(KEY_GNAF_ORIGINAL, "false"));
    }

    public void setPostalCodeOverride(boolean flag) {
        this.setCustomString(KEY_POSTAL_CODE_OVERRIDE, String.valueOf(flag));
    }

    public boolean usePostalCodeOverride() {
        return "true".equalsIgnoreCase(this.getCustomString(KEY_POSTAL_CODE_OVERRIDE, "false"));
    }

    public void setReturnStreetTypeAbbrevs(boolean flag) {
        this.setCustomString(KEY_RETURN_STREET_TYPE_ABBREVS, String.valueOf(flag));
    }

    public boolean isReturnStreetTypeAbbrevs() {
        return "true".equalsIgnoreCase(this.getCustomString(KEY_RETURN_STREET_TYPE_ABBREVS, "false"));
    }
}

