/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS;

import com.mapinfo.mapmarker.AUS.AUS_AddressGeocoder;
import com.mapinfo.mapmarker.AUS.AUS_BrowseHelper;
import com.mapinfo.mapmarker.AUS.AUS_CustomGeocoder;
import com.mapinfo.mapmarker.AUS.AUS_IntersectionHelper;
import com.mapinfo.mapmarker.AUS.AUS_LocalConstraintsHelper;
import com.mapinfo.mapmarker.AUS.AUS_MatchConstraintsConverter;
import com.mapinfo.mapmarker.AUS.AUS_Matcher;
import com.mapinfo.mapmarker.AUS.AUS_MatcherHandler;
import com.mapinfo.mapmarker.AUS.AUS_ParsedInputAddressHelper;
import com.mapinfo.mapmarker.AUS.AUS_ScoringHelper;
import com.mapinfo.mapmarker.AUS.AUS_StreetGeocoder;
import com.mapinfo.mapmarker.AUS.AUS_StreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_DataManager;
import com.mapinfo.mapmarker.AUS.filters.AlternateMatchGeographicFilter;
import com.mapinfo.mapmarker.AUS.filters.DuplicateGeographicFilter;
import com.mapinfo.mapmarker.AUS.filters.DuplicatePostCodeFilter;
import com.mapinfo.mapmarker.AUS.filters.HighScoreGeographicFilter;
import com.mapinfo.mapmarker.AUS.filters.PickBetterPostCodeGeographic;
import com.mapinfo.mapmarker.AUS.geography.AUS_GeographicMatcher;
import com.mapinfo.mapmarker.AUS.matcher.AUS_MatcherConstants;
import com.mapinfo.mapmarker.AUS.parser.AUS_IntersectionParser;
import com.mapinfo.mapmarker.AUS.parser.AUS_ParseHandler;
import com.mapinfo.mapmarker.AUS.parser.AUS_ParseHelper;
import com.mapinfo.mapmarker.AUS.parser.AUS_ParseRuleHandler;
import com.mapinfo.mapmarker.GeocodableAddressCreationException;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.IParsedInputAddressHelper;
import com.mapinfo.mapmarker.common.dp.IDataManager;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataManagerInitializationException;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.core.CoreHandler;
import com.mapinfo.mapmarker.core.address.IStreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.core.browse.CoreBrowseGeocoder;
import com.mapinfo.mapmarker.core.browse.IBrowseGeocoder;
import com.mapinfo.mapmarker.core.matcher.IMatchConstraintsConverter;
import com.mapinfo.mapmarker.utils.AddressUtils;
import java.util.Locale;

public class AUS_Handler
extends CoreHandler {
    private AUS_Handler() {
    }

    public static IHandler buildHandler(Address address) throws GeocodableAddressCreationException {
        AUS_Handler handler = null;
        try {
            handler = new AUS_Handler();
            handler.setInputAddress(AddressUtils.toUpperCaseAddress((Address)address, (Locale)Locale.ENGLISH));
            handler.setLocalConstraintsHelper(new AUS_LocalConstraintsHelper());
            handler.setDataManager((IDataManager)new AUS_DataManager());
            handler.setParseHandler(new AUS_ParseHandler());
            handler.setParseHelper(new AUS_ParseHelper());
            handler.setMatcherConstants(new AUS_MatcherConstants());
            handler.setMatcher(new AUS_Matcher());
            handler.setMatcherHandler(new AUS_MatcherHandler());
            handler.setMatchConstraintsConverter((IMatchConstraintsConverter)new AUS_MatchConstraintsConverter());
            handler.setScoringHelper(new AUS_ScoringHelper());
            handler.setStreetSingleAddressGeocoder((IStreetSingleAddressGeocoder)new AUS_StreetSingleAddressGeocoder((IHandler)handler));
            handler.setIntersectionParser(new AUS_IntersectionParser());
            handler.setIntersectionHelper(new AUS_IntersectionHelper());
            handler.setStreetGeocoder(new AUS_StreetGeocoder((IHandler)handler));
            handler.setGeographicMatcher(new AUS_GeographicMatcher());
            handler.setAddressGeocoder(new AUS_AddressGeocoder());
            handler.setGeographicCentroidFilterRules(new ICloseMatchFilterRule[]{new HighScoreGeographicFilter(), new DuplicateGeographicFilter(), new AlternateMatchGeographicFilter(), new PickBetterPostCodeGeographic()});
            handler.setPostalFilterRules(new ICloseMatchFilterRule[]{new DuplicatePostCodeFilter()});
            handler.setCustomGeocoder(new AUS_CustomGeocoder());
            AUS_ParseRuleHandler parse = new AUS_ParseRuleHandler();
            handler.setRuleHandler(parse);
            parse.addParsingRules((IHandler)handler);
            handler.setBrowseGeocoder((IBrowseGeocoder)new CoreBrowseGeocoder());
            handler.setBrowseHelper(new AUS_BrowseHelper());
            handler.setParsedInputAddressHelper((IParsedInputAddressHelper)new AUS_ParsedInputAddressHelper());
            handler.setGeocodePostalSupported(true);
            handler.setGeocodeGeographicSupported(true);
            handler.setGeocodeSupported(true);
            handler.setGeocodeCustomSupported(true);
            handler.setBrowseSupported(true);
        }
        catch (MMJEDataManagerInitializationException e) {
            throw new GeocodableAddressCreationException(2306, (Throwable)e);
        }
        return handler;
    }

    public static IHandler buildDataConstructionHandler(Address address) {
        AUS_Handler handler = null;
        handler = new AUS_Handler();
        handler.setInputAddress(address);
        handler.setParseHandler(new AUS_ParseHandler());
        handler.setParseHelper(new AUS_ParseHelper());
        handler.setMatcherConstants(new AUS_MatcherConstants());
        AUS_ParseRuleHandler parse = new AUS_ParseRuleHandler();
        handler.setRuleHandler(parse);
        handler.setStreetSingleAddressGeocoder((IStreetSingleAddressGeocoder)new AUS_StreetSingleAddressGeocoder((IHandler)handler));
        handler.setIntersectionParser(new AUS_IntersectionParser());
        handler.setGeographicMatcher(new AUS_GeographicMatcher());
        handler.setAddressGeocoder(new AUS_AddressGeocoder());
        handler.setCustomGeocoder(new AUS_CustomGeocoder());
        parse.addParsingRules((IHandler)handler);
        handler.setBrowseGeocoder((IBrowseGeocoder)new CoreBrowseGeocoder());
        handler.setBrowseHelper(new AUS_BrowseHelper());
        handler.setBrowseSupported(true);
        handler.setGeocodePostalSupported(true);
        handler.setGeocodeGeographicSupported(true);
        handler.setGeocodeCustomSupported(true);
        handler.setGeocodeSupported(true);
        return handler;
    }
}

