/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS;

import com.mapinfo.mapmarker.AUS.AUS_Constraints;
import com.mapinfo.mapmarker.AUS.AUS_Range;
import com.mapinfo.mapmarker.AUS.AUS_StreetCandidateAddress;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_Segment;
import com.mapinfo.mapmarker.AUS.utils.AUS_AddressUtils;
import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalBrowseAddress;
import com.mapinfo.mapmarker.common.Segment;

public class AUS_InternalBrowseAddress
extends InternalBrowseAddress {
    public AUS_InternalBrowseAddress(Address address) {
        super(address);
    }

    public CandidateAddress toCandidateAddress(Address parsed, IConstraints constraints) {
        AUS_StreetCandidateAddress savedStreet = null;
        if (((AUS_StreetCandidateAddress)this.getStreetCandidateAddress()).getFromGNAFData()) {
            savedStreet = (AUS_StreetCandidateAddress)this.getStreetCandidateAddress();
            this.setStreetCandidateAddress(savedStreet.createGNAFOutputAddress());
        }
        CandidateAddress cand = new CandidateAddress((Address)this);
        cand.setFormattedStreetAddress(AUS_AddressUtils.getFormattedStreetAddress((Address)this, false, true, ((AUS_StreetCandidateAddress)this.getStreetCandidateAddress()).getFromGNAFData(), ((AUS_Constraints)constraints).isReturnStreetTypeAbbrevs()));
        cand.setNumberOfReturnableRanges(-1);
        if (this.fromUserDictionary()) {
            cand.setFromUserDictionary();
        }
        int segmentCount = this.getSegmentCount();
        for (int i = 0; i < segmentCount; ++i) {
            int rightRangeCount;
            Segment segment = this.getSegmentAt(i);
            int leftRangeCount = segment.getRangeCount(0);
            if (leftRangeCount != 0) {
                for (int j = 0; j < leftRangeCount; ++j) {
                    AUS_Range leftRange = (AUS_Range)segment.getRangeAt(j, 0);
                    CandidateRange range = leftRange.toCandidateRange(null, 0, null, null, null, segment.getLeftAreaName1(), constraints.getMaxRangeUnits());
                    range.setLeftRightIndicator(1);
                    this.copySegmentInfoToRange(range, segment, 0);
                    cand.addCandidateRange(range);
                }
            } else if (this.makeEmptyRangeForSegment(segment, 0)) {
                CandidateRange range = new CandidateRange();
                range.setLowAddress("");
                range.setHighAddress("");
                this.copySegmentInfoToRange(range, segment, 0);
                range.setLeftRightIndicator(1);
                cand.addCandidateRange(range);
            }
            if ((rightRangeCount = segment.getRangeCount(1)) != 0) {
                for (int j = 0; j < rightRangeCount; ++j) {
                    AUS_Range rightRange = (AUS_Range)segment.getRangeAt(j, 1);
                    CandidateRange range = rightRange.toCandidateRange(null, 1, null, null, null, segment.getRightAreaName1(), constraints.getMaxRangeUnits());
                    this.copySegmentInfoToRange(range, segment, 1);
                    range.setLeftRightIndicator(2);
                    cand.addCandidateRange(range);
                }
                continue;
            }
            if (!this.makeEmptyRangeForSegment(segment, 1)) continue;
            CandidateRange range = new CandidateRange();
            range.setLowAddress("");
            range.setHighAddress("");
            this.copySegmentInfoToRange(range, segment, 1);
            range.setLeftRightIndicator(2);
            cand.addCandidateRange(range);
        }
        int foundRanges = cand.getNumberOfCandidateRanges();
        if (foundRanges > 0) {
            CandidateRange range = cand.getRangeAt(0);
            cand.setPlaceName(range.getPlaceName());
            cand.setAreaName1(range.getAreaName1());
            cand.setAreaName2(range.getAreaName2());
            cand.setAreaName3(range.getAreaName3());
            cand.setPostCode1(range.getPostalCode1());
        }
        if (savedStreet != null) {
            this.setStreetCandidateAddress(savedStreet);
        }
        AUS_AddressUtils.adjustCandidateStreetTypes((Address)cand, this.isGNAFCandidate(), ((AUS_Constraints)constraints).isReturnStreetTypeAbbrevs());
        cand.addKeyValueToAdditionalFields("StreetDataType", this.getVendorCode());
        return cand;
    }

    private boolean isGNAFCandidate() {
        return ((AUS_StreetCandidateAddress)this.getStreetCandidateAddress()).getFromGNAFData();
    }

    protected boolean makeEmptyRangeForSegment(Segment segment, int side) {
        if (this.isGNAFCandidate()) {
            return false;
        }
        return super.makeEmptyRangeForSegment(segment, side);
    }

    protected void copySegmentInfoToRange(CandidateRange range, Segment segment, int segmentSide) {
        super.copySegmentInfoToRange(range, segment, segmentSide);
        String meshBlock = ((AUS_Segment)segment).getMeshBlockId();
        if (meshBlock != null) {
            range.setAdditionalField("MESH_BLOCK_ID", (Object)meshBlock);
        }
        if (this.isGNAFCandidate() && ((AUS_Segment)segment).hasValidReliability()) {
            range.setAdditionalField("GNAF_RELIABILITY", (Object)String.valueOf(((AUS_Segment)segment).getReliability()));
        }
        if (((AUS_Segment)segment).hasValidReliability()) {
            range.setAdditionalField("GEOCONTAINMENT", (Object)(((AUS_Segment)segment).getGeoContainment() ? "YES" : "NO"));
            if (((AUS_Segment)segment).getGeoFeature() != null) {
                range.setAdditionalField("GEOFEATURE", (Object)((AUS_Segment)segment).getGeoFeature());
            }
        }
        if (((AUS_Segment)segment).getSA1() != null) {
            range.setAdditionalField("GNAF_SA1", (Object)((AUS_Segment)segment).getSA1());
        }
    }
}

