/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS;

import com.mapinfo.mapmarker.AUS.AUS_ParsedAddress;
import com.mapinfo.mapmarker.AUS.parser.AUS_ThoroughfareTypes;
import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.core.IScoringHelper;
import com.mapinfo.mapmarker.core.address.ICoreStreetGeocoder;
import com.mapinfo.mapmarker.core.address.IStreetGeocoder;
import com.mapinfo.mapmarker.core.address.IStreetIntersectionGeocoder;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AUS_IntersectionRetryManager {
    public void geocodeWithVariations(IConstraints constraints, int debugLevel, GeocodeResult geocodeResult, IStreetGeocoder streetGeocoder) throws MapMarkerInternalException, MMInternalFatalException {
        constraints.setCustomObject((Object)"KEY_AUS_ALTERNATE_SOUNDEX_CODES", (Object)new Integer(63));
        IHandler handler = constraints.getHandler();
        IScoringHelper scoringHandler = ((ICoreStreetGeocoder)handler).getScoringHelper();
        Address firstAddress = ((ICoreStreetGeocoder)handler).getFirstParsedAddress();
        Address secondAddress = ((ICoreStreetGeocoder)handler).getSecondParsedAddress();
        Collection firstVariations = this.getParseVariations(firstAddress, scoringHandler, constraints, handler);
        Collection secondVariations = this.getParseVariations(secondAddress, scoringHandler, constraints, handler);
        this.assignCandidates(firstVariations, constraints, debugLevel, streetGeocoder);
        this.assignCandidates(secondVariations, constraints, debugLevel, streetGeocoder);
        this.assignMatchResults(firstVariations, constraints, debugLevel, streetGeocoder);
        this.assignMatchResults(secondVariations, constraints, debugLevel, streetGeocoder);
        List firstCandidates = this.combine(firstVariations);
        List secondCandidates = this.combine(secondVariations);
        IStreetIntersectionGeocoder xsect = ((ICoreStreetGeocoder)handler).getStreetIntersectionGeocoder();
        List results = xsect.buildIntersectionCandidateList(firstCandidates, secondCandidates, handler);
        this.countCandidates(results, geocodeResult);
        this.countCloseMatches(results, geocodeResult);
        handler.setGeocodeResult(geocodeResult);
        handler.setMatchResults(results);
    }

    private void assignCandidates(Collection variations, IConstraints constraints, int debugLevel, IStreetGeocoder streetGeocoder) throws MapMarkerInternalException, MMInternalFatalException {
        for (ParseVariation variation : variations) {
            variation.assignCandidates(streetGeocoder.getStreetCandidates(variation.getSearchAddress(), variation.getScoreAddress(), constraints, debugLevel));
        }
    }

    private void assignMatchResults(Collection variations, IConstraints constraints, int debugLevel, IStreetGeocoder streetGeocoder) throws MapMarkerInternalException, MMInternalFatalException {
        for (ParseVariation variation : variations) {
            if (variation.getCandidates().getCandidates() == null || variation.getCandidates().getCandidates().isEmpty()) continue;
            variation.assignMatchResults(streetGeocoder.handleStreetMatching(variation.getScoreAddress(), variation.getCandidates(), constraints, debugLevel));
        }
    }

    private List combine(Collection variations) {
        LinkedList combined = new LinkedList();
        for (ParseVariation variation : variations) {
            if (variation.getMatchResults() == null) continue;
            combined.addAll(variation.getMatchResults());
        }
        return combined;
    }

    private Collection getParseVariations(Address original, IScoringHelper scoringHandler, IConstraints constraints, IHandler handler) {
        AUS_ParsedAddress address;
        AUS_ThoroughfareTypes.KeyInfo info;
        LinkedList<ParseVariation> variations = new LinkedList<ParseVariation>();
        variations.add(new ParseVariation(original, scoringHandler.makeScoringAddress(this.stripAddressNumber(original), constraints, handler)));
        if (!StringUtilities.isEmpty((String)original.getAddressNumber()) && StringUtilities.isEmpty((String)original.getPreThoroughfareType()) && StringUtilities.isEmpty((String)original.getPostThoroughfareType()) && StringUtilities.isEmpty((String)original.getPreAddress()) && (info = AUS_ThoroughfareTypes.lookupType(original.getMainAddress())) != null) {
            address = new AUS_ParsedAddress(original);
            address.setPostThoroughfareType(info.getPreferredTypeName());
            address.setMainAddress(address.getAddressNumber());
            address.setAddressNumber(null);
            variations.add(new ParseVariation((Address)address, scoringHandler.makeScoringAddress(this.stripAddressNumber((Address)address), constraints, handler)));
        }
        if (StringUtilities.isEmpty((String)original.getPreAddress()) && "THE".equals(original.getMainAddress()) && StringUtilities.isEmpty((String)original.getPreThoroughfareType()) && !StringUtilities.isEmpty((String)original.getPostThoroughfareType())) {
            AUS_ParsedAddress address2 = new AUS_ParsedAddress(original);
            address2.setPreAddress(address2.getMainAddress());
            address2.setMainAddress(AUS_ThoroughfareTypes.lookupProperName(address2.getPostThoroughfareType()));
            address2.setPostThoroughfareType(null);
            variations.add(new ParseVariation((Address)address2, scoringHandler.makeScoringAddress(this.stripAddressNumber((Address)address2), constraints, handler)));
        }
        if (!StringUtilities.isEmpty((String)original.getPostThoroughfareType()) && (info = AUS_ThoroughfareTypes.lookupType(original.getPostThoroughfareType())) != null) {
            address = new AUS_ParsedAddress(original);
            StringBuffer mainAddress = new StringBuffer(address.getMainAddress());
            mainAddress.append(' ');
            mainAddress.append(info.getProperTypeName());
            address.setMainAddress(mainAddress.toString());
            address.setPostThoroughfareType(null);
            variations.add(new ParseVariation((Address)address, scoringHandler.makeScoringAddress(this.stripAddressNumber((Address)address), constraints, handler)));
        }
        return variations;
    }

    private Address stripAddressNumber(Address original) {
        AUS_ParsedAddress result = new AUS_ParsedAddress(original);
        result.setAddressNumber("");
        return result;
    }

    private void countCandidates(List candidateList, GeocodeResult geocodeResult) {
        if (candidateList == null || candidateList.isEmpty()) {
            return;
        }
        geocodeResult.setNumberCandidates(candidateList.size());
    }

    private void countCloseMatches(List candidateList, GeocodeResult geocodeResult) {
        int closeMatchCount = 0;
        if (candidateList == null || candidateList.isEmpty()) {
            return;
        }
        Iterator candidateIterator = candidateList.iterator();
        boolean done = false;
        while (candidateIterator.hasNext() && !done) {
            ICandidate candidate = (ICandidate)candidateIterator.next();
            if (candidate.isCloseMatch()) {
                ++closeMatchCount;
                continue;
            }
            done = true;
        }
        geocodeResult.setNumberCloseCandidates(closeMatchCount);
    }

    private static class ParseVariation {
        private Address m_searchAddress;
        private ScoringAddress m_scoreAddress;
        private IRetrievedCandidates m_candidates;
        private List m_matchResults;

        private ParseVariation(Address searchAddress, ScoringAddress scoreAddress) {
            this.m_searchAddress = searchAddress;
            this.m_scoreAddress = scoreAddress;
        }

        private Address getSearchAddress() {
            return this.m_searchAddress;
        }

        private ScoringAddress getScoreAddress() {
            return this.m_scoreAddress;
        }

        private void assignCandidates(IRetrievedCandidates candidates) {
            this.m_candidates = candidates;
        }

        private IRetrievedCandidates getCandidates() {
            return this.m_candidates;
        }

        private void assignMatchResults(List matchResults) {
            this.m_matchResults = matchResults;
        }

        private List getMatchResults() {
            return this.m_matchResults;
        }
    }
}

