/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS;

import com.mapinfo.mapmarker.AUS.AUS_InternalCandidateAddress;
import com.mapinfo.mapmarker.AUS.matcher.AUS_MatcherPreferences;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.FieldScores;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.InternalMatcherConstants;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.core.matcher.CoreMatcherHandler;
import com.mapinfo.mapmarker.core.matcher.IMatchPreferences;
import com.mapinfo.mapmarker.core.matcher.IMatcherHandler;
import com.mapinfo.mapmarker.core.matcher.MatcherException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.List;

public class AUS_MatcherHandler
implements IMatcherHandler {
    private CoreMatcherHandler m_coreMatcherHandler = new CoreMatcherHandler();

    public double getMaximumAddressScore() {
        return this.m_coreMatcherHandler.getMaximumAddressScore();
    }

    public double getMaximumAdditionalFieldScore() {
        return this.m_coreMatcherHandler.getMaximumAdditionalFieldScore();
    }

    public void setMaximumAddressScore(double value) {
        this.m_coreMatcherHandler.setMaximumAddressScore(value);
    }

    public void setMaximumAdditionalFieldScore(double value) {
        this.m_coreMatcherHandler.setMaximumAdditionalFieldScore(value);
    }

    public void decideCloseMatch(IMatchPreferences preferences, InternalCandidateAddress candidate, InternalMatcherConstants constants, ScoringAddress scoringAddress) throws MatcherException {
        double an3score;
        boolean bSavedCombinedAdditionalFieldScore = false;
        double savedCombinedAdditionalFieldScore = 0.0;
        if (candidate instanceof AUS_InternalCandidateAddress && !((AUS_InternalCandidateAddress)candidate).fromGNAFDictionary() && !candidate.hasMatchingRange() && candidate.isPointHouseCandidate(null)) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (((AUS_MatcherPreferences)preferences).usePostalCodeOverride() && !StringUtilities.isEmpty((String)scoringAddress.getPostCode1()) && candidate.getPostCode1Score() == 1.0 && candidate.getCombinedAdditionalFieldScore() < constants.getAdditionalFieldsCutOff()) {
            savedCombinedAdditionalFieldScore = candidate.getCombinedAdditionalFieldScore();
            bSavedCombinedAdditionalFieldScore = true;
            candidate.setCombinedAdditionalFieldScore(constants.getAdditionalFieldsCutOff());
        }
        this.m_coreMatcherHandler.decideCloseMatch(preferences, candidate, constants, scoringAddress);
        if (bSavedCombinedAdditionalFieldScore) {
            candidate.setCombinedAdditionalFieldScore(savedCombinedAdditionalFieldScore);
        }
        if (!candidate.isCloseMatch()) {
            return;
        }
        if (preferences.getExactMatchStreetNameFields() && candidate.isMatchingFlagSet(4)) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (scoringAddress.getMainAddress() == null) {
            if (!candidate.hasMatchingRange() || candidate.getPlaceNameScore() < 0.67) {
                candidate.setCloseMatchFlag(false);
            }
            return;
        }
        AUS_MatcherPreferences ausPrefs = (AUS_MatcherPreferences)preferences;
        if (ausPrefs.isStrictFirstPass()) {
            ParsedNumber candNumber = candidate.getParsedAddressNumber();
            ParsedNumber scoringNumber = scoringAddress.getParsedAddressNumber();
            if (candNumber != null && scoringNumber != null) {
                String inputSuffix = scoringNumber.getAddressSuffix();
                String candSuffix = candNumber.getAddressSuffix();
                if (!StringUtilities.isEmpty((String)inputSuffix) && !inputSuffix.equals(candSuffix)) {
                    candidate.setCloseMatchFlag(false);
                    return;
                }
                String candPrefix = candNumber.getAddressPrefix();
                String inputPrefix = scoringNumber.getAddressPrefix();
                if (!StringUtilities.isEmpty((String)inputPrefix) && !inputPrefix.equals(candPrefix)) {
                    candidate.setCloseMatchFlag(false);
                }
            }
        }
        if (scoringAddress.getAreaName1() == null && scoringAddress.getAreaName2() == null && scoringAddress.getAreaName3() != null && scoringAddress.getAreaName4() == null && scoringAddress.getPostCode1() == null && ((an3score = candidate.getAreaName3Score()) < 0.7 || candidate.isMatchingFlagSet(64) && an3score < 0.8 || scoringAddress.getAreaName3().length() < 3 && an3score < 0.86)) {
            candidate.setCloseMatchFlag(false);
        }
    }

    public void scoreCandidate(InternalCandidateAddress candidate, ScoringAddress scoringAddress, InternalMatcherConstants constants) {
        double score = 0.0;
        double typeDelta = 0.0;
        candidate.computeScores(scoringAddress, constants.getCharsToIgnore());
        FieldScores matchedConstants = constants.getMatched();
        FieldScores blankConstants = constants.getBlank();
        if (!StringUtilities.isEmpty((String)scoringAddress.getMainAddress())) {
            score = scoringAddress.getParsedAddressNumber() != null ? (score += candidate.getAddressNumberScore() * matchedConstants.getAddressNumber()) : (score += candidate.getAddressNumberScore() * blankConstants.getAddressNumber());
            score = this.fieldExists(scoringAddress.getPreAddress()) || this.fieldExists(candidate.getPreAddress()) ? (score += matchedConstants.getPreAddress() * candidate.getPreAddressScore()) : (score += blankConstants.getPreAddress() * candidate.getPreAddressScore());
            score = this.fieldExists(scoringAddress.getMainAddress()) ? (score += matchedConstants.getMainAddress() * candidate.getMainAddressScore()) : (score += blankConstants.getMainAddress() * candidate.getMainAddressScore());
            score = this.fieldExists(scoringAddress.getPostAddress()) || this.fieldExists(candidate.getPostAddress()) ? (score += matchedConstants.getPostAddress() * candidate.getPostAddressScore()) : (score += blankConstants.getPostAddress() * candidate.getPostAddressScore());
            if (this.fieldExists(scoringAddress.getPreThoroughfareType()) || this.fieldExists(candidate.getPreThoroughfareType())) {
                score += matchedConstants.getPreThoroughfareType() * candidate.getPreThoroughfareTypeScore();
                if (!this.fieldExists(scoringAddress.getPreThoroughfareType())) {
                    typeDelta += matchedConstants.getPreThoroughfareType() - blankConstants.getPreThoroughfareType();
                }
            } else {
                score += blankConstants.getPreThoroughfareType() * candidate.getPreThoroughfareTypeScore();
            }
            if (this.fieldExists(scoringAddress.getPostThoroughfareType()) || this.fieldExists(candidate.getPostThoroughfareType())) {
                score += matchedConstants.getPostThoroughfareType() * candidate.getPostThoroughfareTypeScore();
                if (!this.fieldExists(scoringAddress.getPostThoroughfareType())) {
                    typeDelta += matchedConstants.getPostThoroughfareType() - blankConstants.getPostThoroughfareType();
                }
            } else {
                score += blankConstants.getPostThoroughfareType() * candidate.getPostThoroughfareTypeScore();
            }
            score = this.fieldExists(scoringAddress.getPreDirectional()) ? (score += matchedConstants.getPreDirectional() * candidate.getPreDirectionalScore()) : (score += blankConstants.getPreDirectional() * candidate.getPreDirectionalScore());
            score = this.fieldExists(scoringAddress.getPostDirectional()) ? (score += matchedConstants.getPostDirectional() * candidate.getPostDirectionalScore()) : (score += blankConstants.getPostDirectional() * candidate.getPostDirectionalScore());
            if (candidate.hasAdditionalFields()) {
                score += matchedConstants.getAdditionalFields() * candidate.getAdditionalParserFieldsScore();
            }
            candidate.setCombinedAddressScore(Math.min(score / (this.getMaximumAddressScore() + typeDelta), 1.0));
        } else {
            candidate.setCombinedAddressScore(candidate.getPlaceNameScore());
        }
        score = 0.0;
        score = this.fieldExists(scoringAddress.getPostCode1()) ? (score += matchedConstants.getPostalCode1() * candidate.getPostCode1Score()) : (score += blankConstants.getPostalCode1() * candidate.getPostCode1Score());
        score = this.fieldExists(scoringAddress.getPostCode2()) ? (score += matchedConstants.getPostalCode2() * candidate.getPostCode2Score()) : (score += blankConstants.getPostalCode2() * candidate.getPostCode2Score());
        score = this.fieldExists(scoringAddress.getAreaName1()) ? (score += matchedConstants.getAreaName1() * candidate.getAreaName1Score()) : (score += blankConstants.getAreaName1() * candidate.getAreaName1Score());
        score = this.fieldExists(scoringAddress.getAreaName2()) ? (score += matchedConstants.getAreaName2() * candidate.getAreaName2Score()) : (score += blankConstants.getAreaName2() * candidate.getAreaName2Score());
        score = this.fieldExists(scoringAddress.getAreaName3()) ? (score += matchedConstants.getAreaName3() * candidate.getAreaName3Score()) : (score += blankConstants.getAreaName3() * candidate.getAreaName3Score());
        score = this.fieldExists(scoringAddress.getAreaName4()) ? (score += matchedConstants.getAreaName4() * candidate.getAreaName4Score()) : (score += blankConstants.getAreaName4() * candidate.getAreaName4Score());
        candidate.setCombinedAdditionalFieldScore(score / this.getMaximumAdditionalFieldScore());
        candidate.buildInputMatchScore((Address)scoringAddress, matchedConstants);
    }

    public void computeMaximumAddressScore(Address parsedAddress, InternalMatcherConstants constants) {
        this.m_coreMatcherHandler.computeMaximumAddressScore(parsedAddress, constants);
        double maxScore = this.getMaximumAddressScore();
        FieldScores matchedConstants = constants.getMatched();
        FieldScores blankConstants = constants.getBlank();
        maxScore = !StringUtilities.isEmpty((String)parsedAddress.getPreDirectional()) ? (maxScore += matchedConstants.getPreDirectional()) : (maxScore += blankConstants.getPreDirectional());
        maxScore = !StringUtilities.isEmpty((String)parsedAddress.getPostDirectional()) ? (maxScore += matchedConstants.getPostDirectional()) : (maxScore += blankConstants.getPostDirectional());
        this.setMaximumAddressScore(maxScore);
    }

    public void computeMaximumAdditionalFieldScore(Address parsedAddress, InternalMatcherConstants constants) {
        this.m_coreMatcherHandler.computeMaximumAdditionalFieldScore(parsedAddress, constants);
    }

    public List removeMultipleSegmentsForStreet(List candidates, IConstraints constraints) {
        return this.m_coreMatcherHandler.removeMultipleSegmentsForStreet(candidates, constraints);
    }

    public boolean removeSecondCandidate(InternalCandidateAddress best, InternalCandidateAddress other) {
        return this.m_coreMatcherHandler.removeSecondCandidate(best, other);
    }

    private boolean fieldExists(String str) {
        return CoreMatcherHandler.fieldExists((String)str);
    }
}

