/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS;

import com.mapinfo.mapmarker.AUS.AUS_Constraints;
import com.mapinfo.mapmarker.AUS.AUS_GNAFInfoData;
import com.mapinfo.mapmarker.AUS.AUS_IConstraints;
import com.mapinfo.mapmarker.AUS.AUS_InternalCandidateAddress;
import com.mapinfo.mapmarker.AUS.AUS_Range;
import com.mapinfo.mapmarker.AUS.AUS_RangeUnit;
import com.mapinfo.mapmarker.AUS.AUS_ScoringAddress;
import com.mapinfo.mapmarker.AUS.AUS_StreetCandidateAddress;
import com.mapinfo.mapmarker.AUS.utils.AUS_AddressUtils;
import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashMap;

public class AUS_PIDInternalCandidate
implements ICandidate {
    private AUS_InternalCandidateAddress m_address;
    private boolean m_bIncludeUnit;
    private String m_levelType;
    private String m_levelNumber;

    public AUS_PIDInternalCandidate(AUS_InternalCandidateAddress address, boolean bIncludeUnit) {
        int segmentSide;
        this.m_address = address;
        this.m_bIncludeUnit = bIncludeUnit;
        HashMap additionFields = address.getAdditionalFields();
        additionFields.put("StreetDataType", address.getVendorCode());
        this.m_address.setAdditionalFields(additionFields);
        Segment segment = this.m_address.getSegment();
        int leftRanges = segment.getRangeCount(0);
        int n = segmentSide = leftRanges > 0 ? 0 : 1;
        if (segment.getRangeCount(segmentSide) > 0) {
            this.m_address.setSegmentSide(segmentSide);
            this.m_address.setMatchedRangeNumber(0);
            Range rng = segment.getRangeAt(0, segmentSide);
            if (rng == null) {
                return;
            }
            rng.setMatchedRangeNumber(rng.getParsedFrom());
            if (bIncludeUnit && rng.getRangeUnitCount() == 1) {
                rng.setMatchingRangeUnit(0);
                this.populateLevelInformation();
            }
        }
    }

    public boolean isCloseMatch() {
        return true;
    }

    public CandidateAddress toCandidateAddress(Address inputAddress, IConstraints constraints) throws MapMarkerInternalException {
        AUS_StreetCandidateAddress tempStreet = (AUS_StreetCandidateAddress)this.m_address.getStreetCandidateAddress();
        this.m_address.setStreetCandidateAddress(tempStreet.createGNAFOutputAddress());
        CandidateAddress candidate = new CandidateAddress((Address)this.m_address);
        candidate.setCloseMatch();
        candidate.setConfiguredDictionaryNumber(this.m_address.getDictionaryPriority() + 1);
        this.m_address.setGeocodedPoint(candidate, DebugLevel.getDebugLevel((int)1), constraints, this.m_address.loadResourceBundleForLocale(constraints.getClientLocale()));
        candidate.addKeyValueToAdditionalFields("RESULT_CODE", this.getGeoResult(candidate.getLocationPrecision()));
        candidate.addKeyValueToAdditionalFields("StreetDataType", this.m_address.getVendorCode());
        AUS_ScoringAddress scoring = new AUS_ScoringAddress((Address)this.m_address);
        scoring.setCharsToIgnore("");
        this.m_address.scoreAddressNumber(scoring);
        candidate.setFormattedStreetAddress(AUS_AddressUtils.getFormattedStreetAddress((Address)this.m_address, false, true, true, ((AUS_Constraints)constraints).isReturnStreetTypeAbbrevs()));
        candidate.setFormattedLocationAddress(this.m_address.getFormattedLocationAddress());
        AUS_GNAFInfoData gnafInfoData = this.m_address.getGNAFInfoData();
        if (gnafInfoData != null) {
            AUS_Range range;
            gnafInfoData.addInfoDataIntoAdditionalFields(candidate);
            if (StringUtilities.equalStrings((String)candidate.getAdditionalFieldForKey("LOT_NUMBER"), (String)candidate.getAddressNumber()) && this.m_address.hasMatchingRange() && (range = (AUS_Range)this.m_address.getSegment().getRangeAt(this.m_address.getMatchedRangeNumber(), this.m_address.getSegmentSide())).isHouseFromLotNumber()) {
                candidate.setAddressNumber((ParsedNumber)null);
            }
        }
        if (constraints.getMaxRanges() != 0) {
            int tempUnitCount = constraints.getMaxRangeUnits();
            constraints.setMaxRangeUnits(this.m_bIncludeUnit ? 1 : 0);
            this.addRanges(candidate, constraints);
            constraints.setMaxRangeUnits(tempUnitCount);
        }
        if (!StringUtilities.isEmpty((String)this.m_levelNumber)) {
            candidate.addKeyValueToAdditionalFields("LEVEL_NUMBER", this.m_levelNumber);
        }
        if (!StringUtilities.isEmpty((String)this.m_levelType)) {
            candidate.addKeyValueToAdditionalFields("LEVEL_TYPE", this.m_levelType);
        }
        candidate.setSourceStreetID(this.m_address.getStreetOffset());
        AUS_AddressUtils.adjustCandidateStreetTypes((Address)candidate, true, ((AUS_Constraints)constraints).isReturnStreetTypeAbbrevs());
        this.m_address.setStreetCandidateAddress(tempStreet);
        return candidate;
    }

    private void addRanges(CandidateAddress candidate, IConstraints constraints) {
        AUS_Range rng = (AUS_Range)this.m_address.getSegment().getRangeAt(this.m_address.getMatchedRangeNumber(), this.m_address.getSegmentSide());
        if (rng != null) {
            candidate.addCandidateRange(rng.toCandidateRange(this.m_address.getParsedAddressNumber(), this.m_address.getSegmentSide(), null, constraints, this.m_address.getGNAFOriginalCoordinates(rng.getRangeNumber(), (AUS_IConstraints)constraints), this.getAreaName1(), this.m_bIncludeUnit ? 1 : 0));
            candidate.setNumberOfReturnableRanges(1);
        }
    }

    private String getGeoResult(int locationPrecision) {
        switch (locationPrecision) {
            case 2: {
                return "S4G";
            }
            case 16: {
                return "S8G";
            }
            case 17: {
                return "S7G";
            }
            case 10: {
                return "SGG";
            }
        }
        return null;
    }

    public String getAreaName1() {
        return this.m_address.getAreaName1();
    }

    private void populateLevelInformation() {
        if (this.m_address.hasMatchingRange()) {
            int segSide = this.m_address.getSegmentSide();
            int rngNum = this.m_address.getMatchedRangeNumber();
            AUS_Range range = (AUS_Range)this.m_address.getSegment().getRangeAt(rngNum, segSide);
            if (range.hasMatchingRangeUnit()) {
                String levelNumber;
                int unitNum = range.getMatchingRangeUnit();
                AUS_RangeUnit unit = (AUS_RangeUnit)range.getRangeUnitAt(unitNum);
                if (!StringUtilities.isEmpty((String)unit.getLevelType())) {
                    this.m_levelType = AUS_AddressUtils.getFullLevelName(unit.getLevelType());
                }
                if (unit.getLevelNumber() != null && !StringUtilities.isEmpty((String)(levelNumber = unit.getLevelNumber().getCombinedAddressNumber()))) {
                    this.m_levelNumber = levelNumber;
                }
            }
        }
    }
}

