/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS;

import com.mapinfo.mapmarker.AUS.AUS_InternalPostOfficeCandidateAddress;
import com.mapinfo.mapmarker.AUS.AUS_ScoringAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AUS_POBoxMatcher {
    private static Comparator SORTER = new POComparator();
    private static final double PERFECT_SCORE = 1.0;

    public static void matchPOBox(List candidates, Address input, IConstraints constraints) {
        AUS_POBoxMatcher.scorePOBox(candidates, input, constraints);
        AUS_POBoxMatcher.filterPOBox(candidates, input);
    }

    private static void scorePOBox(List candidates, Address input, IConstraints constraints) {
        String charsToIgnore = constraints.getHandler().getMatcherConstants().getStreetMatcherConstants().getCharsToIgnore();
        AUS_ScoringAddress scoringAddress = new AUS_ScoringAddress(input);
        scoringAddress.setCharsToIgnore(charsToIgnore);
        for (int i = 0; i < candidates.size(); ++i) {
            AUS_InternalPostOfficeCandidateAddress cand = (AUS_InternalPostOfficeCandidateAddress)candidates.get(i);
            cand.score(scoringAddress, constraints);
        }
    }

    private static void filterPOBox(List candidates, Address input) {
        Collections.sort(candidates, SORTER);
        AUS_InternalPostOfficeCandidateAddress top = null;
        for (int i = 0; i < candidates.size(); ++i) {
            AUS_InternalPostOfficeCandidateAddress cand = (AUS_InternalPostOfficeCandidateAddress)candidates.get(i);
            if (top != null) {
                if (top.getAreaName1Score() > cand.getAreaName1Score() || top.getPostCodeScore() > cand.getPostCodeScore()) {
                    cand.setIsCloseMatch(false);
                }
                if (top.getAreaName1Score() != 1.0 || top.getPostCodeScore() != 1.0 || top.getAreaName3Score() != 1.0 || !(cand.getAreaName3Score() < 1.0)) continue;
                cand.setIsCloseMatch(false);
                continue;
            }
            top = cand;
        }
    }

    private static class POComparator
    implements Comparator {
        private POComparator() {
        }

        public int compare(Object o1, Object o2) {
            AUS_InternalPostOfficeCandidateAddress a1 = (AUS_InternalPostOfficeCandidateAddress)o1;
            AUS_InternalPostOfficeCandidateAddress a2 = (AUS_InternalPostOfficeCandidateAddress)o2;
            if (a1.getAreaName1Score() > a2.getAreaName1Score()) {
                return -1;
            }
            if (a2.getAreaName1Score() > a1.getAreaName1Score()) {
                return 1;
            }
            if (a1.getPostCodeScore() > a2.getPostCodeScore()) {
                return -1;
            }
            if (a2.getPostCodeScore() > a1.getPostCodeScore()) {
                return 1;
            }
            if (a1.getAreaName3Score() > a2.getAreaName3Score()) {
                return -1;
            }
            if (a2.getAreaName3Score() > a1.getAreaName3Score()) {
                return 1;
            }
            return 0;
        }
    }
}

