/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class AUS_ParsedAddress
extends AddressImpl {
    private String m_levelType;
    private ParsedNumber m_levelValue;
    private String m_POBoxNumber;

    public AUS_ParsedAddress() {
    }

    public AUS_ParsedAddress(Address addr) {
        super(addr);
        if (addr instanceof AUS_ParsedAddress) {
            AUS_ParsedAddress ausAddr = (AUS_ParsedAddress)addr;
            this.m_levelType = ausAddr.m_levelType;
            this.m_levelValue = ausAddr.m_levelValue;
            this.m_POBoxNumber = ausAddr.m_POBoxNumber;
        }
    }

    public void setLevelType(String levelType) {
        this.m_levelType = levelType;
    }

    public void setLevelValue(String levelValue) {
        this.m_levelValue = new ParsedNumber(levelValue);
    }

    public String getLevelType() {
        return this.m_levelType;
    }

    public ParsedNumber getLevelValue() {
        return this.m_levelValue;
    }

    public void setPOBoxInfo(String POBoxInfo) {
        String[] tokens = POBoxInfo.split(" ");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (!StringUtilities.hasNumeric((String)token)) continue;
            this.m_POBoxNumber = token;
            break;
        }
    }

    public String getPOBoxNumber() {
        return this.m_POBoxNumber;
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer("AUS_ParsedAddress:");
        buffer.append(lineSeparator);
        buffer.append(super.toString());
        buffer.append(lineSeparator);
        buffer.append("level type: ");
        buffer.append(this.m_levelType);
        buffer.append(lineSeparator);
        buffer.append("level_number: ");
        buffer.append(this.m_levelValue);
        buffer.append(lineSeparator);
        buffer.append("PO Box # ");
        buffer.append(this.m_POBoxNumber);
        buffer.append(lineSeparator);
        return buffer.toString();
    }
}

