/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS;

import com.mapinfo.mapmarker.AUS.AUS_Constraints;
import com.mapinfo.mapmarker.AUS.AUS_RangeUnit;
import com.mapinfo.mapmarker.AUS.AUS_ScoringAddress;
import com.mapinfo.mapmarker.AUS.parser.AUS_UnitType;
import com.mapinfo.mapmarker.AUS.parser.AUS_UnitTypes;
import com.mapinfo.mapmarker.AUS.utils.AUS_AddressUtils;
import com.mapinfo.mapmarker.AUS.utils.GNAFAddressClass;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.RangeUnit;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.utils.LongPoint;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Map;

public class AUS_Range
extends Range {
    private byte m_reliability = (byte)127;
    private byte m_confidence = (byte)-2;
    private byte m_geocodeLevel = 0;
    private int m_PID;
    private boolean m_fromGNAF;
    private boolean m_isNumberInRangeWasCalled;
    private boolean m_wasGNAFMatch;
    private boolean m_bSkipSpecificGNAF;
    private String m_UDOriginalLatitude;
    private String m_UDOriginalLongitude;
    private String m_lotNumber;
    private String m_lotPrefix;
    private String m_lotSuffix;
    private boolean m_bHouseFromLotNumber = false;
    private int m_primaryPID;
    private boolean m_bGeoContainment;
    private String m_geoFeature;
    private GNAFAddressClass m_addressClass;
    private String m_parcelID;

    public AUS_Range(boolean fromGNAF) {
        this.m_fromGNAF = fromGNAF;
    }

    public AUS_Range(String from, String to, boolean fromGNAF) {
        super(from, to);
        this.m_fromGNAF = fromGNAF;
    }

    public int isNumberInRange(ParsedNumber inputNumber) {
        this.m_wasGNAFMatch = false;
        this.m_isNumberInRangeWasCalled = true;
        if (this.fromGNAFDictionary()) {
            return this.isNumberInRangeGNAF(inputNumber);
        }
        String fullData = this.getParsedFrom().getCombinedAddressNumber();
        int indexOfDash = fullData.indexOf(45);
        if (indexOfDash < 0) {
            return super.isNumberInRange(inputNumber);
        }
        this.m_bSkipSpecificGNAF = true;
        return this.isNumberInRangeGNAF(inputNumber);
    }

    private int isNumberInRangeGNAF(ParsedNumber inputNumber) {
        if (inputNumber == null || inputNumber.isEmpty()) {
            return 0;
        }
        String fullData = this.getParsedFrom().getCombinedAddressNumber();
        int indexOfDash = fullData.indexOf(45);
        ParsedNumber firstPNData = null;
        ParsedNumber secondPNData = null;
        if (indexOfDash >= 0) {
            String firstPartData = fullData.substring(0, indexOfDash);
            firstPNData = firstPartData.length() > 0 ? new ParsedNumber(firstPartData) : null;
            String secondPartData = fullData.substring(indexOfDash + 1, fullData.length());
            secondPNData = secondPartData.length() > 0 ? new ParsedNumber(secondPartData) : null;
        } else {
            firstPNData = new ParsedNumber(fullData);
        }
        ParsedNumber firstPartInput = null;
        ParsedNumber secondPartInput = null;
        String fullInput = inputNumber.getCombinedAddressNumber();
        if (fullInput != null) {
            indexOfDash = fullInput.indexOf(45);
            if (indexOfDash >= 0) {
                String firstPart = fullInput.substring(0, indexOfDash);
                firstPartInput = firstPart.length() > 0 ? new ParsedNumber(firstPart) : null;
                String secondPart = fullInput.substring(indexOfDash + 1, fullInput.length());
                secondPartInput = secondPart.length() > 0 ? new ParsedNumber(secondPart) : null;
            } else {
                firstPartInput = new ParsedNumber(fullInput);
            }
        }
        int matchedFirstPart = 0;
        if (firstPartInput != null && (matchedFirstPart = this.checkGNAFPartialMatch(firstPartInput, firstPNData)) == 0) {
            matchedFirstPart = this.checkGNAFPartialMatch(firstPartInput, secondPNData);
        }
        int matchedSecondPart = 0;
        if (secondPartInput != null && (matchedSecondPart = this.checkGNAFPartialMatch(secondPartInput, firstPNData)) == 0) {
            matchedSecondPart = Math.max(matchedSecondPart, this.checkGNAFPartialMatch(secondPartInput, secondPNData));
        }
        if (matchedFirstPart != 0 && secondPartInput == null) {
            if (!this.m_bSkipSpecificGNAF) {
                this.m_wasGNAFMatch = true;
            }
            this.setMatchedRangeNumber(this.getLowNumber());
            return matchedFirstPart;
        }
        if (matchedFirstPart != 0 && secondPNData == null) {
            if (!this.m_bSkipSpecificGNAF) {
                this.m_wasGNAFMatch = true;
            }
            this.setMatchedRangeNumber(this.getLowNumber());
            return matchedFirstPart;
        }
        if (matchedSecondPart != 0 && secondPNData == null) {
            if (!this.m_bSkipSpecificGNAF) {
                this.m_wasGNAFMatch = true;
            }
            this.setMatchedRangeNumber(this.getLowNumber());
            return matchedSecondPart;
        }
        if (matchedFirstPart != 0 && matchedSecondPart != 0) {
            if (!this.m_bSkipSpecificGNAF) {
                this.m_wasGNAFMatch = true;
            }
            this.setMatchedRangeNumber(this.getLowNumber());
            return inputNumber.getNumFields();
        }
        if (matchedFirstPart != 0) {
            if (this.isWithinGNAF(secondPartInput, firstPNData, secondPNData)) {
                if (!this.m_bSkipSpecificGNAF) {
                    this.m_wasGNAFMatch = true;
                }
                this.setMatchedRangeNumber(this.getLowNumber());
                return inputNumber.getNumFields();
            }
            if (!this.m_bSkipSpecificGNAF) {
                this.m_wasGNAFMatch = false;
            }
            return matchedFirstPart;
        }
        if (matchedSecondPart != 0) {
            if (this.isWithinGNAF(firstPartInput, firstPNData, secondPNData)) {
                if (!this.m_bSkipSpecificGNAF) {
                    this.m_wasGNAFMatch = true;
                }
                this.setMatchedRangeNumber(this.getLowNumber());
                return inputNumber.getNumFields();
            }
            if (!this.m_bSkipSpecificGNAF) {
                this.m_wasGNAFMatch = false;
            }
            return matchedSecondPart;
        }
        this.m_wasGNAFMatch = false;
        return 0;
    }

    private boolean isWithinGNAF(ParsedNumber input, ParsedNumber low, ParsedNumber high) {
        if (low == null || high == null) {
            return false;
        }
        int rangeOddEven = -1;
        rangeOddEven = low.isRangeOddEvenBoth() == high.isRangeOddEvenBoth() ? low.isRangeOddEvenBoth() : 0;
        if (rangeOddEven != 0 && rangeOddEven != input.isRangeOddEvenBoth()) {
            return false;
        }
        return input.compareTo((Object)low) >= 0 && input.compareTo((Object)high) <= 0;
    }

    private int checkGNAFPartialMatch(ParsedNumber pnInput, ParsedNumber partialData) {
        int matchedCnt = 0;
        if (partialData != null && pnInput.getAddressNumberExists() && partialData.getAddressNumberExists() && pnInput.getAddressNumber() == partialData.getAddressNumber()) {
            ++matchedCnt;
            if (pnInput.hasAddressSuffix() && partialData.hasAddressSuffix()) {
                if (pnInput.getAddressSuffix().equals(partialData.getAddressSuffix())) {
                    ++matchedCnt;
                } else {
                    return 0;
                }
            }
            return matchedCnt;
        }
        return 0;
    }

    public boolean wasGNAFMatch() throws IllegalStateException {
        if (!this.m_isNumberInRangeWasCalled) {
            throw new IllegalStateException();
        }
        return this.m_wasGNAFMatch;
    }

    public void setReliability(byte reliability) {
        this.m_reliability = reliability;
    }

    public boolean hasValidReliability() {
        return this.m_reliability != 127;
    }

    public byte getReliability() {
        return this.m_reliability;
    }

    public void setConfidence(byte confidence) {
        this.m_confidence = confidence;
    }

    public boolean hasValidConfidence() {
        return this.m_confidence != -2;
    }

    public byte getConfidence() {
        return this.m_confidence;
    }

    public void setGeocodeLevel(byte geocodeLevel) {
        this.m_geocodeLevel = geocodeLevel;
    }

    public boolean hasValidGeocodeLevel() {
        return this.m_geocodeLevel != 0;
    }

    public byte getGeocodeLevel() {
        return this.m_geocodeLevel;
    }

    public void setPID(int PID) {
        this.m_PID = PID;
    }

    public int getPID() {
        return this.m_PID;
    }

    public boolean fromGNAFDictionary() {
        return this.m_fromGNAF;
    }

    public String getUnitValue(ParsedNumber inputUnitId) {
        if (this.hasMatchingRangeUnit()) {
            RangeUnit unit = this.getRangeUnitAt(this.getMatchingRangeUnit());
            if (unit != null) {
                return unit.getLowUnit();
            }
        } else if (inputUnitId != null && !inputUnitId.isEmpty()) {
            return super.getUnitValue(inputUnitId);
        }
        return null;
    }

    public void findMatchingRangeUnit(ParsedNumber unitNumber, String unitType) {
        throw new IllegalStateException("This method should not be used, instead use same method with scoringAddress parameter.");
    }

    public void findMatchingRangeUnit(ScoringAddress scoringAddress) {
        int numRangeUnits = this.getRangeUnitCount();
        if (numRangeUnits <= 0) {
            return;
        }
        RangeUnit bestUnit = null;
        for (int i = 0; i < numRangeUnits; ++i) {
            RangeUnit unit = this.getRangeUnitAt(i);
            if (!this.isBetterMatchingUnit(unit, bestUnit, scoringAddress)) continue;
            bestUnit = unit;
            this.setMatchingRangeUnit(i);
        }
    }

    private boolean isBetterMatchingUnit(RangeUnit unit, RangeUnit bestUnit, ScoringAddress scoringAddress) {
        int compareUnitResult = this.compareUnitMatch(bestUnit, unit, scoringAddress);
        if (compareUnitResult > 0) {
            return false;
        }
        if (scoringAddress.getParsedUnitValue() != null && !scoringAddress.getParsedUnitValue().isEmpty() && compareUnitResult < 0) {
            return true;
        }
        if (!StringUtilities.isEmpty((String)scoringAddress.getGenericField4()) && compareUnitResult < 0) {
            return true;
        }
        int compareLevelResult = this.compareLevelMatch((AUS_RangeUnit)bestUnit, (AUS_RangeUnit)unit, (AUS_ScoringAddress)scoringAddress);
        return compareLevelResult < 0;
    }

    private int compareLevelMatch(AUS_RangeUnit bestUnit, AUS_RangeUnit newUnit, AUS_ScoringAddress scoringAddress) {
        boolean newMatches = newUnit.matchesLevel(scoringAddress.getLevelType(), scoringAddress.getLevelValue());
        if (newMatches && bestUnit == null) {
            return -1;
        }
        if (!newMatches && bestUnit == null) {
            return 1;
        }
        boolean bestMatches = bestUnit.matchesLevel(scoringAddress.getLevelType(), scoringAddress.getLevelValue());
        if (bestMatches) {
            return newMatches ? 0 : 1;
        }
        return newMatches ? -1 : 0;
    }

    private int compareUnitMatch(RangeUnit bestUnit, RangeUnit newUnit, ScoringAddress scoringAddress) {
        ParsedNumber inputUnit = scoringAddress.getParsedUnitValue();
        String inputTypeString = scoringAddress.getUnitType();
        if (inputUnit == null || inputUnit.isEmpty()) {
            String gf4 = scoringAddress.getGenericField4();
            if (!StringUtilities.isEmpty((String)gf4)) {
                String testType = AUS_UnitTypes.findUnitTypeFromStart(gf4);
                if (testType == null) {
                    inputUnit = new ParsedNumber(gf4);
                    inputTypeString = null;
                } else {
                    inputTypeString = testType;
                    inputUnit = new ParsedNumber(gf4.substring(testType.length()));
                }
            } else {
                boolean bestMatches = bestUnit != null && StringUtilities.isEmpty((String)bestUnit.getLowUnit());
                boolean newMatches = StringUtilities.isEmpty((String)newUnit.getLowUnit());
                if (bestMatches) {
                    return newMatches ? 0 : 1;
                }
                return newMatches ? -1 : 1;
            }
        }
        AUS_UnitType scoringType = AUS_UnitTypes.getUnitType(inputTypeString);
        AUS_UnitType newType = AUS_UnitTypes.getUnitType(newUnit.getUnitType());
        boolean newUnitInRange = newUnit.isUnitInRange(inputUnit, null);
        if (StringUtilities.isEmpty((String)inputTypeString) || StringUtilities.equalStrings((String)inputTypeString, (String)newUnit.getUnitType()) || newType != null && scoringType != null && StringUtilities.equalStrings((String)newType.getAbbreviation(), (String)scoringType.getAbbreviation())) {
            newUnit.setTypeMatched();
        }
        if (newUnitInRange && bestUnit == null) {
            return -1;
        }
        if (!newUnitInRange) {
            return 1;
        }
        boolean bestUnitInRange = bestUnit.getParsedRangeScore().isInRange();
        if (bestUnitInRange && !newUnitInRange) {
            return 1;
        }
        if (newUnitInRange && !bestUnitInRange) {
            return -1;
        }
        if (!newUnitInRange) {
            return 0;
        }
        boolean bestAddsSuffix = bestUnit.getParsedRangeScore().isAddsSuffix();
        boolean newAddsSuffix = newUnit.getParsedRangeScore().isAddsSuffix();
        if (bestAddsSuffix && !newAddsSuffix) {
            return -1;
        }
        if (!bestAddsSuffix && newAddsSuffix) {
            return 1;
        }
        if (bestUnit.getNumberOfUnits() > newUnit.getNumberOfUnits()) {
            return -1;
        }
        if (newUnit.getNumberOfUnits() > bestUnit.getNumberOfUnits()) {
            return 1;
        }
        if (!bestUnit.getTypeMatched() && newUnit.getTypeMatched()) {
            return -1;
        }
        if (bestUnit.getTypeMatched() && !newUnit.getTypeMatched()) {
            return 1;
        }
        return 0;
    }

    public long computeOffsetFromRange(ParsedNumber inputNumber) {
        long result = super.computeOffsetFromRange(inputNumber);
        ParsedNumber parsedFrom = this.getParsedFrom();
        ParsedNumber parsedTo = this.getParsedTo();
        if (this.getDivisionFactor() == 1 && parsedFrom.equals((Object)parsedTo)) {
            long highOffset;
            long lowOffset;
            result = !inputNumber.hasNumberSeparator() && "-".equals(parsedFrom.getNumberSeparator()) ? ((lowOffset = new ParsedNumber(parsedFrom.getAddressNumber()).computeDifference(inputNumber, 2)) <= (highOffset = new ParsedNumber(parsedFrom.getSuffixNumber()).computeDifference(inputNumber, 2)) ? lowOffset : highOffset) : parsedFrom.computeDifference(inputNumber, 2);
            this.setRangeOffset(result);
        }
        return result;
    }

    public void setUDOriginalLatitude(String UDOriginalLatitude) {
        this.m_UDOriginalLatitude = UDOriginalLatitude;
    }

    public String getUDOriginalLatitude() {
        return this.m_UDOriginalLatitude;
    }

    public void setUDOriginalLongitude(String UDOriginalLongitude) {
        this.m_UDOriginalLongitude = UDOriginalLongitude;
    }

    public String getUDOriginalLongitude() {
        return this.m_UDOriginalLongitude;
    }

    public void setLotNumber(String lotNumber) {
        this.m_lotNumber = lotNumber;
    }

    public String getLotNumber() {
        return this.m_lotNumber;
    }

    public void setLotPrefix(String lotPrefix) {
        this.m_lotPrefix = lotPrefix;
    }

    public String getLotPrefix() {
        return this.m_lotPrefix;
    }

    public void setLotSuffix(String lotSuffix) {
        this.m_lotSuffix = lotSuffix;
    }

    public String getLotSuffix() {
        return this.m_lotSuffix;
    }

    public boolean isHouseFromLotNumber() {
        return this.m_bHouseFromLotNumber;
    }

    public void setHouseFromLotNumber(boolean b) {
        this.m_bHouseFromLotNumber = b;
    }

    public CandidateRange toCandidateRange(ParsedNumber inputHouseNumber, int segmentSide, ParsedNumber inputUnitNumber, IConstraints constraints) {
        throw new UnsupportedOperationException();
    }

    public CandidateRange toCandidateRange(ParsedNumber inputHouseNumber, int side, ParsedNumber inputUnitNumber, IConstraints constraints, LongPoint originalLocation, String areaName1, int maxRangeUnits) {
        if (constraints == null) {
            constraints = new AUS_Constraints();
            constraints.setMaxRangeUnits(maxRangeUnits);
        }
        if (maxRangeUnits != 0) {
            constraints.setMaxRangeUnits(0);
        }
        CandidateRange range = super.toCandidateRange(inputHouseNumber, side, inputUnitNumber, constraints);
        if (maxRangeUnits != 0) {
            constraints.setMaxRangeUnits(maxRangeUnits);
            range.setNumberOfReturnableRangeUnits(maxRangeUnits);
            this.populateCandidateRangeUnits(range, inputUnitNumber, areaName1);
        }
        Map additionalFields = range.getAdditionalFields();
        if (!StringUtilities.isEmpty((String)this.m_lotNumber)) {
            additionalFields.put("LOT_NUMBER", this.m_lotNumber);
        }
        if (this.m_bHouseFromLotNumber) {
            ParsedNumber number = new ParsedNumber(range.getLowAddress());
            range.setLowAddress("");
            range.setHighAddress("");
            range.setOddEvenIndicator(-1);
            additionalFields.put("LOT_NUMBER", number.getCombinedAddressNumber());
        }
        if (this.m_reliability != 127) {
            additionalFields.put("GNAF_RELIABILITY", String.valueOf(this.m_reliability));
        }
        if (this.m_PID != 0) {
            additionalFields.put("GNAF_PID", AUS_AddressUtils.buildGnafPIDString(String.valueOf(this.m_PID), areaName1));
        }
        if (this.m_primaryPID != 0) {
            additionalFields.put("GNAF_PRINCIPAL_PID", AUS_AddressUtils.buildGnafPIDString(String.valueOf(this.m_primaryPID), areaName1));
        }
        if (this.m_confidence != -2) {
            additionalFields.put("GNAF_CONFIDENCE", String.valueOf(this.m_confidence));
        }
        if (this.m_geocodeLevel != 0) {
            additionalFields.put("GNAF_GEOCODE_LEVEL", String.valueOf(this.m_geocodeLevel));
        }
        if (originalLocation != null) {
            AUS_AddressUtils.OriginalCoordinatesStrings strings = AUS_AddressUtils.createOriginalCoordinatesStrings(originalLocation);
            additionalFields.put("ORIGINAL_LONGITUDE", strings.getLongitude());
            additionalFields.put("ORIGINAL_LATITUDE", strings.getLatitude());
        }
        if (this.m_geoFeature != null) {
            additionalFields.put("GEOFEATURE", this.m_geoFeature);
        }
        if (this.m_fromGNAF && this.m_reliability != 127) {
            additionalFields.put("GEOCONTAINMENT", this.m_bGeoContainment ? "YES" : "NO");
        }
        if (this.m_addressClass != null) {
            additionalFields.put("GNAF_ADDRESS_CLASS", this.m_addressClass.getAddressClass());
        }
        if (this.m_parcelID != null) {
            additionalFields.put("GNAF_PARCEL_ID", this.m_parcelID);
        }
        return range;
    }

    private void populateCandidateRangeUnits(CandidateRange range, ParsedNumber inputUnitNumber, String areaName1) {
        int count = this.getRangeUnitCount();
        for (int i = 0; i < count; ++i) {
            range.addRangeUnit(((AUS_RangeUnit)this.getRangeUnitAt(i)).toCandidateRangeUnit(inputUnitNumber, areaName1));
        }
    }

    public void setPrimaryPID(int primaryPID) {
        this.m_primaryPID = primaryPID;
    }

    public int getPrimaryPID() {
        return this.m_primaryPID;
    }

    public void setGeoContainment() {
        this.m_bGeoContainment = true;
    }

    public boolean getGeoContainment() {
        return this.m_bGeoContainment;
    }

    public void setGeoFeature(String geoFeature) {
        this.m_geoFeature = geoFeature;
    }

    public String getGeoFeature() {
        return this.m_geoFeature;
    }

    public void setAddressClass(GNAFAddressClass addressClass) {
        this.m_addressClass = addressClass;
    }

    public GNAFAddressClass getAddressClass() {
        return this.m_addressClass;
    }

    public void setParcelID(String parcelID) {
        this.m_parcelID = parcelID;
    }

    public String getParcelID() {
        return this.m_parcelID;
    }
}

