/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS;

import com.mapinfo.mapmarker.AUS.AUS_ParsedAddress;
import com.mapinfo.mapmarker.AUS.parser.AUS_StreetPrefix;
import com.mapinfo.mapmarker.AUS.utils.AUS_StringUtilities;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class AUS_ScoringAddress
extends ScoringAddress {
    private static final StringScorer m_scorer = new StringScorer(false, Locale.ENGLISH, null, true);
    private final Map m_areaName3Cache;
    private String m_levelType;
    private ParsedNumber m_levelValue;

    public AUS_ScoringAddress(Address inputAddr) {
        super(inputAddr);
        Map map = this.m_areaName3Cache = inputAddr.getAreaName3() == null ? null : new HashMap();
        if (inputAddr instanceof AUS_ParsedAddress) {
            this.m_levelType = ((AUS_ParsedAddress)inputAddr).getLevelType();
            this.m_levelValue = ((AUS_ParsedAddress)inputAddr).getLevelValue();
        }
    }

    public StringScorer getStringScorer() {
        return m_scorer;
    }

    public double scoreAreaName3(String str) {
        return this.doScore(AUS_StringUtilities.standardize(str, true), this.getAreaName3(), this.m_areaName3Cache);
    }

    public String getLevelType() {
        return this.m_levelType;
    }

    public ParsedNumber getLevelValue() {
        return this.m_levelValue;
    }

    public double scorePreAddress(String str) {
        String preAdd = this.getPreAddress();
        if (!StringUtilities.isEmpty((String)preAdd) && !StringUtilities.isEmpty((String)str) && AUS_StreetPrefix.isSamePrefix(preAdd, str)) {
            return 1.0;
        }
        return super.scorePreAddress(str);
    }
}

