/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS;

import com.mapinfo.mapmarker.AUS.dp.binary.GNAFStreetInfo;
import com.mapinfo.mapmarker.AUS.parser.AUS_Directionals;
import com.mapinfo.mapmarker.AUS.parser.AUS_ThoroughfareTypes;
import com.mapinfo.mapmarker.AUS.utils.AUS_AddressUtils;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.utils.EN_StringUtilities;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class AUS_StreetCandidateAddress
extends StreetCandidateAddress {
    private static final String IGNORED_STRINGS = " ',-.()_";
    private final boolean m_bGNAFData;
    private final GNAFStreetInfo m_info;

    public AUS_StreetCandidateAddress(boolean bForGNAF) {
        this.setCountry("AUS");
        this.m_bGNAFData = bForGNAF;
        this.m_info = bForGNAF ? new GNAFStreetInfo() : null;
    }

    private AUS_StreetCandidateAddress(AUS_StreetCandidateAddress street) {
        super((Address)street);
        if (!street.getFromGNAFData()) {
            throw new IllegalArgumentException();
        }
        this.setCountry("AUS");
        this.m_bGNAFData = true;
        this.m_info = new GNAFStreetInfo();
    }

    public boolean getFromGNAFData() {
        return this.m_bGNAFData;
    }

    public GNAFStreetInfo getGNAFStreetInfo() {
        return this.m_info;
    }

    public AUS_StreetCandidateAddress createGNAFOutputAddress() {
        if (!this.m_bGNAFData) {
            throw new IllegalStateException();
        }
        AUS_StreetCandidateAddress output = new AUS_StreetCandidateAddress(this);
        output.flush();
        output.setCountry("AUS");
        Address address = AUS_AddressUtils.reconstructAddress((Address)this, this.m_info);
        output.setMainAddress(address.getMainAddress());
        output.setGenericField2(address.getGenericField2());
        output.setPostThoroughfareType(address.getPostThoroughfareType());
        output.setPostDirectional(address.getPostDirectional());
        if (address.getAdditionalFields().containsKey("STREET_TYPE_ABB")) {
            output.getAdditionalFields().put("STREET_TYPE_ABB", address.getAdditionalFields().get("STREET_TYPE_ABB"));
        }
        output.m_info.setOriginalMainAddress(address.getMainAddress());
        output.m_info.setStreetType(address.getPostThoroughfareType());
        output.m_info.setStreetSuffix(address.getGenericField2());
        output.m_info.setStreetTypeAbbreviation((String)address.getAdditionalFields().get("STREET_TYPE_ABB"));
        return output;
    }

    public void score(ScoringAddress input) {
        this.setCountryScore(input.scoreCountry(this.getCountry()));
        this.setGenericField1Score(input.scoreGenericField1(this.getGenericField1()));
        this.setGenericField2Score(input.scoreGenericField2(this.getGenericField2()));
        this.setGenericField3Score(input.scoreGenericField3(this.getGenericField3()));
        this.setGenericField4Score(input.scoreGenericField4(this.getGenericField4()));
        this.setPreAddressScore(input.scorePreAddress(this.getPreAddress()));
        this.scoreThoroughfareTypes(input);
        this.scoreDirectionals(input);
        this.scoreMainAddress(input);
        this.setPostAddressScore(input.scorePostAddress(this.getPostAddress()));
        this.setIsScored(true);
    }

    private void scoreMainAddress(ScoringAddress scoringAddress) {
        if (!this.fieldExists(scoringAddress.getMainAddress())) {
            this.setMainAddressScore(1.0);
            return;
        }
        double originalMainAddressScore = scoringAddress.scoreMainAddress(this.getMainAddress());
        this.setMainAddressScore(originalMainAddressScore);
        if (originalMainAddressScore != 1.0) {
            if (EN_StringUtilities.isOrdinal((String)scoringAddress.getMainAddress()) || StringUtilities.isNumeric((String)scoringAddress.getMainAddress())) {
                String inputNumericStreet = StringUtilities.removeCharsFromBack((String)scoringAddress.getMainAddress());
                String candidateNumericStreet = StringUtilities.removeCharsFromBack((String)this.getMainAddress());
                if (inputNumericStreet != null && candidateNumericStreet != null && inputNumericStreet.equals(candidateNumericStreet) && originalMainAddressScore < 0.95) {
                    this.setMainAddressScore(0.95);
                }
            } else {
                if (originalMainAddressScore < 0.97 && (scoringAddress.getMainAddress().indexOf("-") > 0 || this.getMainAddress().indexOf("-") > 0)) {
                    String currentMainAddress = scoringAddress.getMainAddress();
                    scoringAddress.setMainAddress(StringUtilities.replaceWith((String)currentMainAddress, (String)"-", (String)" "));
                    double noDashScore = scoringAddress.scoreMainAddress(StringUtilities.replaceWith((String)this.getMainAddress(), (String)"-", (String)" "));
                    scoringAddress.setMainAddress(currentMainAddress);
                    noDashScore *= 0.97;
                    if (noDashScore > originalMainAddressScore) {
                        this.setMainAddressScore(noDashScore);
                        originalMainAddressScore = noDashScore;
                    }
                }
                if (originalMainAddressScore < 0.95) {
                    String currentCharsToIgnore = scoringAddress.getCharsToIgnore();
                    scoringAddress.setCharsToIgnore(IGNORED_STRINGS);
                    double ignoreCharScore = scoringAddress.scoreMainAddress(this.getMainAddress());
                    ignoreCharScore *= 0.95;
                    scoringAddress.setCharsToIgnore(currentCharsToIgnore);
                    if (ignoreCharScore > originalMainAddressScore) {
                        this.setMainAddressScore(ignoreCharScore);
                    }
                }
                if (this.getMainAddressScore() < 0.85 && originalMainAddressScore >= 0.8 && originalMainAddressScore < 0.85 && scoringAddress.getMainAddress().length() > 4 && scoringAddress.getMainAddress().length() < 7 && scoringAddress.getMainAddress() != null) {
                    String charsToIgnore = scoringAddress.getCharsToIgnore();
                    scoringAddress.setCharsToIgnore("AEIOU");
                    double mainAddressScoreWithoutVowels = scoringAddress.scoreMainAddress(this.getMainAddress(), true);
                    scoringAddress.setCharsToIgnore(charsToIgnore);
                    if (mainAddressScoreWithoutVowels == 1.0) {
                        this.setMainAddressScore(0.95);
                    }
                }
            }
        }
    }

    private void scoreThoroughfareTypes(ScoringAddress input) {
        this.setPreThoroughfareTypeScore(this.scoreThroughfareType(input.getPreThoroughfareType(), this.getPreThoroughfareType()));
        this.setPostThoroughfareTypeScore(this.scoreThroughfareType(input.getPostThoroughfareType(), this.getPostThoroughfareType()));
    }

    private double scoreThroughfareType(String inTypeName, String candTypeName) {
        AUS_ThoroughfareTypes.KeyInfo candKeyInfo;
        if (StringUtilities.isEmpty((String)inTypeName)) {
            if (StringUtilities.isEmpty((String)candTypeName)) {
                return 1.0;
            }
            return 0.75;
        }
        if (StringUtilities.isEmpty((String)candTypeName)) {
            return 0.25;
        }
        AUS_ThoroughfareTypes.KeyInfo inKeyInfo = AUS_ThoroughfareTypes.lookupType(inTypeName);
        if (inKeyInfo == (candKeyInfo = AUS_ThoroughfareTypes.lookupType(candTypeName))) {
            return 1.0;
        }
        if (AUS_ThoroughfareTypes.isRelative(inKeyInfo, candKeyInfo)) {
            return 0.95;
        }
        return 0.0;
    }

    private void scoreDirectionals(ScoringAddress input) {
        AUS_Directionals.Directional inPreDir = AUS_Directionals.getDirectional(input.getPreDirectional());
        AUS_Directionals.Directional inPostDir = AUS_Directionals.getDirectional(input.getPostDirectional());
        AUS_Directionals.Directional candPreDir = AUS_Directionals.getDirectional(this.getPreDirectional());
        AUS_Directionals.Directional candPostDir = AUS_Directionals.getDirectional(this.getPostDirectional());
        double score = 0.0;
        if (inPreDir == null && inPostDir == null && candPreDir == null && candPostDir == null) {
            this.setPreDirectionalScore(1.0);
            this.setPostDirectionalScore(1.0);
            return;
        }
        if (inPreDir != null && candPreDir != null || inPostDir != null && candPostDir != null) {
            this.setPreDirectionalScore(this.compareDirectionals(inPreDir, candPreDir));
            this.setPostDirectionalScore(this.compareDirectionals(inPostDir, candPostDir));
        } else {
            if (inPreDir != null && candPostDir != null) {
                score = 1.0 + this.compareDirectionals(inPreDir, candPostDir);
            } else if (inPostDir != null && candPreDir != null) {
                score = 1.0 + this.compareDirectionals(inPostDir, candPreDir);
            }
            if (score == 2.0) {
                this.setPreDirectionalScore(1.0);
                this.setPostDirectionalScore(1.0);
                this.setMatchingFlag(4);
            } else {
                this.setPreDirectionalScore(this.compareDirectionals(inPreDir, candPreDir));
                this.setPostDirectionalScore(this.compareDirectionals(inPostDir, candPostDir));
            }
        }
    }

    private double compareDirectionals(AUS_Directionals.Directional inDir, AUS_Directionals.Directional candDir) {
        if (inDir == null && candDir == null) {
            return 1.0;
        }
        if (inDir == null || candDir == null) {
            return 0.5;
        }
        if (inDir.isSame(candDir)) {
            return 1.0;
        }
        if (inDir.isRelative(candDir)) {
            return 0.75;
        }
        return 0.0;
    }
}

