/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp;

import com.mapinfo.mapmarker.AUS.AUSLanguageSoundex;
import com.mapinfo.mapmarker.AUS.dp.IAUS_PostOfficeDataSourceRecord;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_PostOfficeRecord;
import com.mapinfo.mapmarker.AUS.dp.binary.MMJ_AUSPostOfficeRecord;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.AbstractDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiSoundexIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.ShortIndexKey;
import java.util.Properties;

public class AUS_PostOfficeDataSourceRecordConvertor
extends AbstractDataSourceRecordConvertor {
    private Soundex m_soundex = new AUSLanguageSoundex();

    public AUS_PostOfficeDataSourceRecordConvertor(Properties properties) {
        super(properties);
    }

    public Object convert(IDataSourceRecord sourceRecord) throws DataCreationException {
        if (sourceRecord == null) {
            return null;
        }
        IAUS_PostOfficeDataSourceRecord postOfficeSource = (IAUS_PostOfficeDataSourceRecord)sourceRecord;
        AUS_PostOfficeRecord postOfficeRecord = new AUS_PostOfficeRecord();
        try {
            if (postOfficeSource.hasPostCode1()) {
                postOfficeRecord.setPostCode(this.emptyToNull(postOfficeSource.getPostCode1()));
            }
            if (postOfficeSource.hasAreaName1()) {
                postOfficeRecord.setAreaName1(this.emptyToNull(postOfficeSource.getAreaName1()));
            }
            if (postOfficeSource.hasAreaName3()) {
                postOfficeRecord.setAreaName3(this.emptyToNull(postOfficeSource.getAreaName3()));
            }
            if (!postOfficeSource.hasCentroid()) {
                DataCreationLogger.getLogger().logInternalError("No centroid for: " + postOfficeRecord.getPostCode());
                return null;
            }
            postOfficeRecord.setLocation(postOfficeSource.getCentroid());
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(2001, (Throwable)DSEx);
        }
        MapMarkerIndexKey postalKey = this.makePostalKey(postOfficeRecord);
        MapMarkerIndexKey geoKey = this.makeGeoKey(postOfficeRecord);
        if (postalKey == null && geoKey == null) {
            DataCreationLogger.getLogger().logInternalError("Unable to make keys for: " + postOfficeRecord.getPostCode() + " -- " + postOfficeRecord.getAreaName1() + " -- " + postOfficeRecord.getAreaName3());
            return null;
        }
        return new MMJ_AUSPostOfficeRecord(postOfficeRecord, postalKey, geoKey);
    }

    private MapMarkerIndexKey makePostalKey(AUS_PostOfficeRecord record) {
        if (record.getPostCode() == null) {
            DataCreationLogger.getLogger().logInternalError("No postCode given for: " + record.getAreaName1() + " -- " + record.getAreaName3());
            return null;
        }
        try {
            short postCode = Short.parseShort(record.getPostCode());
            if (postCode != 0) {
                return new ShortIndexKey(postCode);
            }
            DataCreationLogger.getLogger().logInternalError("zero postcode!");
            return null;
        }
        catch (NumberFormatException NFEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to make short value from: " + record.getPostCode());
            return null;
        }
    }

    private MapMarkerIndexKey makeGeoKey(AUS_PostOfficeRecord record) {
        MiSoundexKey soundexKey = (MiSoundexKey)this.m_soundex.getSoundex(record.getAreaName3());
        if (soundexKey == null) {
            DataCreationLogger.getLogger().logInternalError("Unable to make soundex for: " + record.getAreaName3() + " for postCode " + record.getPostCode());
            return null;
        }
        return new MiSoundexIndexKey(soundexKey);
    }

    private String emptyToNull(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).length() == 0) {
            return null;
        }
        return str;
    }
}

