/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp;

import com.mapinfo.mapmarker.AUS.utils.AUS_AddressUtils;
import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.StreetDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.core.parser.IParser;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Properties;

public class AUS_StreetDataSourceRecordConvertor
extends StreetDataSourceRecordConvertorImpl {
    public AUS_StreetDataSourceRecordConvertor(Soundex soundex, Properties dataProperties, CollationKeyGenerator generator, IParser parser, Constraints parserConstraints) throws DataCreationException {
        super(soundex, dataProperties, generator, parser, parserConstraints);
    }

    protected MapMarkerIndexKey[] makeStreetBrowseKeys(Address address, int sac) {
        String standardPrefix;
        if (address.getPreAddress() == null || (standardPrefix = AUS_AddressUtils.getStandardPrefix(address.getPreAddress())) == null) {
            if (address.getPreAddress() != null) {
                DataCreationLogger.getLogger().logInternalError("Unable to standardize prefix: " + address.getPreAddress());
                DataCreationLogger.getLogger().logInternalError(address.toString());
            }
            return super.makeStreetBrowseKeys(address, sac);
        }
        String mainAddress = address.getMainAddress();
        MapMarkerIndexKey[] keys = new MapMarkerIndexKey[3];
        keys[0] = new MapMarkerBrowseMultiLevelIndexKey(sac, mainAddress.charAt(0), this.m_generator.getCollationKey(mainAddress));
        keys[1] = new MapMarkerBrowseMultiLevelIndexKey(sac, standardPrefix.charAt(0), this.m_generator.getCollationKey(standardPrefix));
        StringBuffer buffer = new StringBuffer();
        buffer.append(standardPrefix);
        buffer.append(' ');
        buffer.append(mainAddress);
        String combined = buffer.toString();
        keys[2] = new MapMarkerBrowseMultiLevelIndexKey(sac, combined.charAt(0), this.m_generator.getCollationKey(combined));
        return keys;
    }

    protected int getOddEven(IRangeDataSourceRecord input) throws DataSourceException {
        ParsedNumber from = new ParsedNumber(input.getFrom());
        ParsedNumber to = new ParsedNumber(input.getTo());
        int oddEvenBoth = 0;
        if (input.hasStatus()) {
            if (input.getStatus().toLowerCase().startsWith("e")) {
                oddEvenBoth = 2;
            } else if (input.getStatus().toLowerCase().startsWith("o")) {
                oddEvenBoth = 1;
            }
        }
        if (this.isRangeStatusValid(from, to, oddEvenBoth)) {
            return oddEvenBoth;
        }
        if (from.compareTo((Object)to) == 0) {
            return from.isRangeOddEvenBoth();
        }
        return 0;
    }

    private boolean isRangeStatusValid(ParsedNumber from, ParsedNumber to, int oddEvenBoth) {
        if (oddEvenBoth == 0) {
            return !from.equals((Object)to);
        }
        int fromOddEvenBoth = from.isRangeOddEvenBoth();
        return fromOddEvenBoth == to.isRangeOddEvenBoth() && fromOddEvenBoth == oddEvenBoth;
    }

    protected boolean isValidRange(String from, String to) {
        return this.stringExists(from) && this.stringExists(to);
    }

    protected boolean validateParse(Address parsed, Address inputAddress, IStreetDataSourceRecord input, boolean useAlternate, String houseNumber) throws DataSourceException {
        if (!super.validateParse(parsed, inputAddress, input, useAlternate, houseNumber)) {
            return false;
        }
        if (parsed == null || parsed.getMainAddress() == null) {
            return true;
        }
        if (houseNumber != null && StringUtilities.equalStrings((String)houseNumber, (String)parsed.getUnitValue())) {
            String newMainAddress = input.getMainAddress() + " UNIT 1A";
            DataCreationLogger.getLogger().logError("Replacing input street of: " + input.getMainAddress() + " with: " + newMainAddress);
            inputAddress.setMainAddress(this.makeMainAddressString(newMainAddress, houseNumber));
            return false;
        }
        return true;
    }
}

