/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.binary;

import com.mapinfo.mapmarker.AUS.dp.AUS_PostOfficeDataSourceRecordConvertor;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_PostOfficeDataItem;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_PostOfficeRecord;
import com.mapinfo.mapmarker.AUS.dp.binary.MMJ_AUSPostOfficeRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.DataFileMasks;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBinaryIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexFileItem;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexMultiValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MiSoundexIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MultiValueIndexFileConvertor;
import com.mapinfo.mapmarker.common.dp.binary.index.ShortIndexKey;
import com.mapinfo.mapmarker.utils.MiVersion;
import com.mapinfo.mapmarker.utils.RandomAccessDataStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;

public abstract class AUS_AbstractAuxillaryDataWriter {
    private static final String POSTOFFICE_BASE_NAME_KEY = "postOffice_outputFile";
    private static final String POSTIOFFICE_OUTPUT_DIR_KEY = "postOffice_outputFilePath";
    protected Properties m_properties;
    private MMJDataFileMetadata m_postOfficeMetadata;

    public AUS_AbstractAuxillaryDataWriter(Properties properties) {
        this.m_properties = properties;
    }

    protected String getProperty(String propertyName) {
        return this.m_properties.getProperty(propertyName);
    }

    protected abstract IDataSource getDataSource(Properties var1) throws DataCreationException;

    public void writePostOfficeFiles() throws DataCreationException {
        RandomAccessDataStream geoIndexStream;
        RandomAccessDataStream postalIndexStream;
        RandomAccessDataStream dataStream;
        IDataSource postOfficeDataSource = this.getDataSource(this.m_properties);
        Collection records = this.processDataSourceRecords(postOfficeDataSource);
        try {
            postOfficeDataSource.close();
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(2001, (Throwable)DSEx);
        }
        if (records.isEmpty()) {
            DataCreationLogger.getLogger().logError("Unable to get any postOffice records converted from data source.");
            throw new DataCreationException(2001, "No records converted");
        }
        try {
            dataStream = this.makePostOfficeDataFile();
            postalIndexStream = this.makePostOfficePostalTempIndexFile();
            geoIndexStream = this.makePostOfficeGeoTempIndexFile();
        }
        catch (IOException IOEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to make output file");
            DataCreationLogger.getLogger().logStackTrace((Throwable)IOEx);
            throw new DataCreationException(2001, (Throwable)IOEx);
        }
        for (MMJ_AUSPostOfficeRecord record : records) {
            try {
                long offset = this.writePostOfficeRecord(dataStream, record.getRecord());
                if (record.getPostalKey() != null) {
                    record.getPostalKey().write((DataOutput)postalIndexStream);
                    postalIndexStream.writeLong(offset);
                }
                if (record.getGeoKey() == null) continue;
                record.getGeoKey().write((DataOutput)geoIndexStream);
                geoIndexStream.writeLong(offset);
            }
            catch (IOException IOEx) {
                throw new DataCreationException(2001, (Throwable)IOEx);
            }
        }
        try {
            dataStream.close();
            postalIndexStream.close();
            geoIndexStream.close();
        }
        catch (IOException IOEx) {
            throw new DataCreationException(2001, (Throwable)IOEx);
        }
        AUS_PostOfficePostalIndexConvertor postalConvertor = new AUS_PostOfficePostalIndexConvertor(this.getPostOfficePostalTempIndexFileName(), this.getPostOfficePostalFinalIndexFileName());
        postalConvertor.convert();
        AUS_PostOfficeGeoIndexConvertor geoConvertor = new AUS_PostOfficeGeoIndexConvertor(this.getPostOfficeGeoTempIndexFileName(), this.getPostOfficeGeoFinalIndexFileName());
        geoConvertor.convert();
    }

    protected abstract IDataSourceRecord getNextDataSourceRecord(IDataSource var1) throws DataCreationException;

    protected Collection processDataSourceRecords(IDataSource source) throws DataCreationException {
        IDataSourceRecord record;
        LinkedList<Object> records = new LinkedList<Object>();
        AUS_PostOfficeDataSourceRecordConvertor recordConvertor = new AUS_PostOfficeDataSourceRecordConvertor(this.m_properties);
        while ((record = this.getNextDataSourceRecord(source)) != null) {
            Object o = recordConvertor.convert(record);
            if (o == null) continue;
            if (records.contains(o)) {
                DataCreationLogger.getLogger().logInternalError("Unable to add duplicate record:");
                DataCreationLogger.getLogger().logInternalError(((MMJ_AUSPostOfficeRecord)o).getRecord().toString());
                continue;
            }
            records.add(o);
        }
        return records;
    }

    private String getPostOfficeDataFileName() {
        return StringUtilities.appendToPath((String)this.getProperty(POSTIOFFICE_OUTPUT_DIR_KEY), (String)this.getProperty(POSTOFFICE_BASE_NAME_KEY), (String)"jdr");
    }

    private MMJDataFileMetadata getPostOfficeMetadata() {
        if (this.m_postOfficeMetadata == null) {
            this.m_postOfficeMetadata = new MMJDataFileMetadata();
            this.m_postOfficeMetadata.setCountry("AUS");
            this.m_postOfficeMetadata.setXPow10((byte)5);
            this.m_postOfficeMetadata.setYPow10((byte)5);
            this.m_postOfficeMetadata.setDataFileMasks(new DataFileMasks());
            MiVersion version = new MiVersion(14, 0, 0);
            this.m_postOfficeMetadata.setVersion(version);
        }
        return this.m_postOfficeMetadata;
    }

    private RandomAccessDataStream makePostOfficeDataFile() throws IOException {
        RandomAccessDataStream stream = new RandomAccessDataStream(new File(this.getPostOfficeDataFileName()));
        this.getPostOfficeMetadata().write((DataOutput)stream);
        return stream;
    }

    private String getPostOfficePostalTempIndexFileName() {
        return StringUtilities.appendToPath((String)this.getProperty(POSTIOFFICE_OUTPUT_DIR_KEY), (String)this.getProperty(POSTOFFICE_BASE_NAME_KEY), (String)"tpx");
    }

    private String getPostOfficePostalFinalIndexFileName() {
        return StringUtilities.appendToPath((String)this.getProperty(POSTIOFFICE_OUTPUT_DIR_KEY), (String)this.getProperty(POSTOFFICE_BASE_NAME_KEY), (String)"pdx");
    }

    private RandomAccessDataStream makePostOfficePostalTempIndexFile() throws IOException {
        return new RandomAccessDataStream(new File(this.getPostOfficePostalTempIndexFileName()));
    }

    private String getPostOfficeGeoTempIndexFileName() {
        return StringUtilities.appendToPath((String)this.getProperty(POSTIOFFICE_OUTPUT_DIR_KEY), (String)this.getProperty(POSTOFFICE_BASE_NAME_KEY), (String)"tgx");
    }

    private String getPostOfficeGeoFinalIndexFileName() {
        return StringUtilities.appendToPath((String)this.getProperty(POSTIOFFICE_OUTPUT_DIR_KEY), (String)this.getProperty(POSTOFFICE_BASE_NAME_KEY), (String)"gdx");
    }

    private RandomAccessDataStream makePostOfficeGeoTempIndexFile() throws IOException {
        return new RandomAccessDataStream(new File(this.getPostOfficeGeoTempIndexFileName()));
    }

    private long writePostOfficeRecord(RandomAccessDataStream stream, AUS_PostOfficeRecord record) throws IOException {
        long offset = stream.getFilePointer();
        new AUS_PostOfficeDataItem(record).write((DataOutput)stream, this.getPostOfficeMetadata());
        return offset;
    }

    private static class AUS_PostOfficeGeoIndexItem
    extends MapMarkerIndexFileItem {
        public AUS_PostOfficeGeoIndexItem() {
            super((MapMarkerIndexKey)new MiSoundexIndexKey(), (MapMarkerIndexValue)new MapMarkerIndexMultiValue());
        }

        public AUS_PostOfficeGeoIndexItem(MiSoundexIndexKey key, MapMarkerIndexMultiValue value) {
            super((MapMarkerIndexKey)key, (MapMarkerIndexValue)value);
        }
    }

    private static class AUS_PostOfficeGeoIndex
    extends MapMarkerBinaryIndexFile {
        private AUS_PostOfficeGeoIndex() {
        }

        public MapMarkerIndexFileItem getIndexItem() {
            return new AUS_PostOfficeGeoIndexItem();
        }

        public MapMarkerIndexFileItem getIndexItem(MapMarkerIndexKey key, MapMarkerIndexValue value) {
            return new AUS_PostOfficeGeoIndexItem((MiSoundexIndexKey)key, (MapMarkerIndexMultiValue)value);
        }

        public MapMarkerIndexFileMetadata getIndexMetadataType() {
            return new MapMarkerIndexFileMetadata();
        }
    }

    private static class AUS_PostOfficeGeoIndexConvertor
    extends MultiValueIndexFileConvertor {
        public AUS_PostOfficeGeoIndexConvertor(String oldIndexName, String newIndexName) {
            super(oldIndexName, newIndexName);
        }

        protected MapMarkerBinaryIndexFile getIndexFileType() {
            return new AUS_PostOfficeGeoIndex();
        }

        protected MapMarkerIndexKey getIndexKeyType() {
            return new MiSoundexIndexKey();
        }
    }

    private static class AUS_PostOfficePostalIndexItem
    extends MapMarkerIndexFileItem {
        public AUS_PostOfficePostalIndexItem() {
            super((MapMarkerIndexKey)new ShortIndexKey(), (MapMarkerIndexValue)new MapMarkerIndexMultiValue());
        }

        public AUS_PostOfficePostalIndexItem(ShortIndexKey key, MapMarkerIndexMultiValue value) {
            super((MapMarkerIndexKey)key, (MapMarkerIndexValue)value);
        }
    }

    private static class AUS_PostOfficePostalIndex
    extends MapMarkerBinaryIndexFile {
        private AUS_PostOfficePostalIndex() {
        }

        public MapMarkerIndexFileItem getIndexItem() {
            return new AUS_PostOfficePostalIndexItem();
        }

        public MapMarkerIndexFileItem getIndexItem(MapMarkerIndexKey key, MapMarkerIndexValue value) {
            return new AUS_PostOfficePostalIndexItem((ShortIndexKey)key, (MapMarkerIndexMultiValue)value);
        }

        public MapMarkerIndexFileMetadata getIndexMetadataType() {
            return new MapMarkerIndexFileMetadata();
        }
    }

    private static class AUS_PostOfficePostalIndexConvertor
    extends MultiValueIndexFileConvertor {
        public AUS_PostOfficePostalIndexConvertor(String oldIndexName, String newIndexName) {
            super(oldIndexName, newIndexName);
        }

        protected MapMarkerBinaryIndexFile getIndexFileType() {
            return new AUS_PostOfficePostalIndex();
        }

        protected MapMarkerIndexKey getIndexKeyType() {
            return new ShortIndexKey();
        }
    }
}

